/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class PatternDialog
extends DialogWrapper {
    private final TodoPattern myPattern;
    private final ComboBox<Icon> myIconComboBox;
    private final JBCheckBox myCaseSensitiveCheckBox;
    private final JBTextField myPatternStringField;
    private final ColorAndFontDescriptionPanel myColorAndFontDescriptionPanel;
    private final ColorAndFontDescription myColorAndFontDescription;
    private final JBCheckBox myUsedDefaultColorsCheckBox;
    private final int myPatternIndex;
    private final List<? extends TodoPattern> myExistingPatterns;

    PatternDialog(Component parent, TodoPattern pattern, int patternIndex, List<? extends TodoPattern> existingPatterns) {
        super(parent, true);
        this.myPatternIndex = patternIndex;
        this.myExistingPatterns = existingPatterns;
        this.setTitle(IdeBundle.message("title.add.todo.pattern", new Object[0]));
        this.setResizable(false);
        TodoAttributes attrs = pattern.getAttributes();
        this.myPattern = pattern;
        this.myIconComboBox = new ComboBox<Icon>(new Icon[]{AllIcons.General.TodoDefault, AllIcons.General.TodoQuestion, AllIcons.General.TodoImportant});
        this.myIconComboBox.setSelectedItem(attrs.getIcon());
        this.myIconComboBox.setRenderer(SimpleListCellRenderer.create((label2, value2, index) -> {
            label2.setIcon((Icon)value2);
            label2.setText(" ");
        }));
        this.myCaseSensitiveCheckBox = new JBCheckBox(IdeBundle.message("checkbox.case.sensitive", new Object[0]), pattern.isCaseSensitive());
        this.myPatternStringField = new JBTextField(pattern.getPatternString());
        this.myUsedDefaultColorsCheckBox = new JBCheckBox(IdeBundle.message("checkbox.todo.use.default.colors", new Object[0]));
        this.myUsedDefaultColorsCheckBox.setSelected(!attrs.shouldUseCustomTodoColor());
        this.myColorAndFontDescriptionPanel = new ColorAndFontDescriptionPanel();
        TextAttributes attributes = this.myPattern.getAttributes().getCustomizedTextAttributes();
        this.myColorAndFontDescription = new TextAttributesDescription("null", null, attributes, null, EditorColorsManager.getInstance().getGlobalScheme(), null, null){

            @Override
            public boolean isErrorStripeEnabled() {
                return true;
            }

            @Override
            public boolean isEditable() {
                return true;
            }
        };
        this.myColorAndFontDescriptionPanel.reset(this.myColorAndFontDescription);
        this.updateCustomColorsPanel();
        this.myUsedDefaultColorsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternDialog.this.updateCustomColorsPanel();
            }
        });
        this.init();
    }

    private void updateCustomColorsPanel() {
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.reset(this.myColorAndFontDescription);
        } else {
            this.myColorAndFontDescriptionPanel.resetDefault();
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myPatternStringField;
    }

    @Override
    protected void doOKAction() {
        this.myPattern.setPatternString(this.myPatternStringField.getText().trim());
        this.myPattern.setCaseSensitive(this.myCaseSensitiveCheckBox.isSelected());
        TodoAttributes attrs = this.myPattern.getAttributes();
        attrs.setIcon((Icon)this.myIconComboBox.getSelectedItem());
        attrs.setUseCustomTodoColor(this.useCustomTodoColor(), TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.apply(this.myColorAndFontDescription, null);
        }
        super.doOKAction();
    }

    @Override
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        String patternString = this.myPatternStringField.getText().trim();
        if (patternString.isEmpty()) {
            List<ValidationInfo> list2 = Collections.singletonList(new ValidationInfo(IdeBundle.message("error.pattern.should.be.specified", new Object[0]), this.myPatternStringField));
            if (list2 == null) {
                PatternDialog.$$$reportNull$$$0(0);
            }
            return list2;
        }
        for (int i = 0; i < this.myExistingPatterns.size(); ++i) {
            TodoPattern pattern = this.myExistingPatterns.get(i);
            if (this.myPatternIndex == i || !patternString.equals(pattern.getPatternString())) continue;
            List<ValidationInfo> list3 = Collections.singletonList(new ValidationInfo(IdeBundle.message("error.same.pattern.already.exists", new Object[0]), this.myPatternStringField));
            if (list3 == null) {
                PatternDialog.$$$reportNull$$$0(1);
            }
            return list3;
        }
        List<ValidationInfo> list4 = super.doValidateAll();
        if (list4 == null) {
            PatternDialog.$$$reportNull$$$0(2);
        }
        return list4;
    }

    private boolean useCustomTodoColor() {
        return !this.myUsedDefaultColorsCheckBox.isSelected();
    }

    @Override
    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message("label.todo.pattern", new Object[0]), (JComponent)this.myPatternStringField).addLabeledComponent(IdeBundle.message("label.todo.icon", new Object[0]), this.myIconComboBox).addComponent(this.myCaseSensitiveCheckBox).addComponent(this.myUsedDefaultColorsCheckBox).addComponent(this.myColorAndFontDescriptionPanel).getPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/configurable/PatternDialog", "doValidateAll"));
    }
}

