/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TodoTreeHelper {
    private final Project myProject;

    public static TodoTreeHelper getInstance(Project project2) {
        return ServiceManager.getService(project2, TodoTreeHelper.class);
    }

    public TodoTreeHelper(Project project2) {
        this.myProject = project2;
    }

    public void addPackagesToChildren(ArrayList<? super AbstractTreeNode<?>> children2, Module module2, TodoTreeBuilder builder2) {
        this.addDirsToChildren(this.collectContentRoots(module2), children2, builder2);
    }

    protected List<VirtualFile> collectContentRoots(Module module2) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        if (module2 == null) {
            ContainerUtil.addAll(roots, ProjectRootManager.getInstance(this.myProject).getContentRoots());
        } else {
            ContainerUtil.addAll(roots, ModuleRootManager.getInstance(module2).getContentRoots());
        }
        return roots;
    }

    protected void addDirsToChildren(List<? extends VirtualFile> roots, ArrayList<? super AbstractTreeNode<?>> children2, TodoTreeBuilder builder2) {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        for (VirtualFile virtualFile2 : roots) {
            TodoDirNode dirNode;
            Iterator<PsiFile> files2;
            PsiDirectory directory = psiManager.findDirectory(virtualFile2);
            if (directory == null || !(files2 = builder2.getFiles(directory)).hasNext() || children2.contains(dirNode = new TodoDirNode(this.myProject, directory, builder2))) continue;
            children2.add(dirNode);
        }
    }

    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, TodoTreeBuilder builder2, boolean isFlatten) {
        ArrayList children2 = new ArrayList();
        if (!isFlatten || !this.skipDirectory(psiDirectory)) {
            Iterator<PsiFile> iterator2 = builder2.getFiles(psiDirectory);
            block0: while (iterator2.hasNext()) {
                PsiFile psiFile = iterator2.next();
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                if (psiDirectory.equals(containingDirectory) && !children2.contains(todoFileNode)) {
                    children2.add(todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null && !this.skipDirectory(_dir)) {
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (parentDirectory != null && psiDirectory.equals(parentDirectory) && !children2.contains(todoDirNode)) {
                        children2.add(todoDirNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
            if (parentDirectory == null || !this.skipDirectory(parentDirectory) || !ProjectRootManager.getInstance(this.getProject()).getFileIndex().isInContent(parentDirectory.getVirtualFile())) {
                Iterator<PsiFile> iterator3 = builder2.getFiles(psiDirectory);
                while (iterator3.hasNext()) {
                    PsiFile psiFile = iterator3.next();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (psiDirectory.equals(psiFile.getContainingDirectory()) && !children2.contains(todoFileNode)) {
                        children2.add(todoFileNode);
                        continue;
                    }
                    PsiDirectory _dir = psiFile.getContainingDirectory();
                    if (_dir == null || this.skipDirectory(_dir)) continue;
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder2);
                    if (!PsiTreeUtil.isAncestor(psiDirectory, _dir, true) || children2.contains(todoDirNode) || builder2.isDirectoryEmpty(_dir)) continue;
                    children2.add(todoDirNode);
                }
            } else {
                Iterator<PsiFile> iterator4 = builder2.getFiles(psiDirectory);
                while (iterator4.hasNext()) {
                    PsiFile psiFile = iterator4.next();
                    PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder2, false);
                    if (!psiDirectory.equals(containingDirectory) || children2.contains(todoFileNode)) continue;
                    children2.add(todoFileNode);
                }
            }
        }
        Collections.sort(children2, TodoFileDirAndModuleComparator.INSTANCE);
        return children2;
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return false;
    }

    @Nullable
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoDirNode) {
            TodoDirNode descriptor2 = (TodoDirNode)userObject;
            return (PsiElement)descriptor2.getValue();
        }
        if (userObject instanceof TodoFileNode) {
            TodoFileNode descriptor3 = (TodoFileNode)userObject;
            return (PsiElement)descriptor3.getValue();
        }
        return null;
    }

    public boolean contains(ProjectViewNode node, Object element2) {
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }
}

