/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import com.intellij.util.text.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class AboutTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    @Override
    @NotNull
    public String getTitle() {
        return "About";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project2) {
        if (project2 == null) {
            AboutTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
        Calendar cal = appInfo.getBuildDate();
        String output = "Build version: ";
        output = output + appInfo.getFullApplicationName();
        String buildInfo = IdeBundle.message("about.box.build.number", appInfo.getBuild().asString());
        String buildDate = "";
        if (appInfo.getBuild().isSnapshot()) {
            buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
        }
        buildDate = buildDate + DateFormatUtil.formatAboutDialogDate(cal.getTime());
        output = output + ' ' + buildInfo + ' ' + buildDate;
        output = output + '\n';
        output = output + "Java version: ";
        Properties properties = System.getProperties();
        output = output + properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        output = output + properties.getProperty("os.arch", "");
        output = output + '\n';
        output = output + "Operating System: ";
        output = output + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")";
        output = output + '\n';
        output = output + "JVM version: ";
        output = output + properties.getProperty("java.vm.name", "unknown");
        output = output + ' ' + properties.getProperty("java.vendor", "unknown");
        output = output + '\n';
        output = output + "idea.config.path=" + PathManager.getConfigPath() + "\n";
        output = output + "idea.system.path=" + PathManager.getSystemPath() + "\n";
        output = output + "idea.plugins.path=" + PathManager.getPluginsPath() + "\n";
        String string = output = output + "idea.log.path=" + PathManager.getLogPath() + "\n";
        if (string == null) {
            AboutTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/troubleshooting/AboutTroubleInfoCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/troubleshooting/AboutTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

