/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.util.Matrix;
import com.intellij.util.Vector;

final class ColorBlindnessMatrix {
    private static final Matrix CORRECTION = Matrix.createIdentity(3);
    private static final Matrix RGB_LMS;
    private static final Matrix LMS_RGB;
    private static final Vector WHITE_BLUE;
    private static final Vector WHITE_RED;

    ColorBlindnessMatrix() {
    }

    private static Vector cross(Vector left, Vector right) {
        return Vector.create(left.get(1) * right.get(2) - left.get(2) * right.get(1), left.get(2) * right.get(0) - left.get(0) * right.get(2), left.get(0) * right.get(1) - left.get(1) * right.get(0));
    }

    private static Matrix calculate(Matrix simulation, Matrix correction) {
        Matrix matrix = simulation.multiply(RGB_LMS);
        if (correction == null) {
            correction = CORRECTION;
        }
        return LMS_RGB.multiply(matrix.plus(correction.multiply(RGB_LMS.minus(matrix))));
    }

    static /* synthetic */ Vector access$000() {
        return WHITE_BLUE;
    }

    static /* synthetic */ Vector access$200() {
        return WHITE_RED;
    }

    static {
        Matrix RGB_XYZ = Matrix.create(3, 0.4124, 0.2126, 0.0193, 0.3576, 0.7152, 0.1192, 0.1805, 0.0722, 0.9505);
        Matrix XYZ_LMS = Matrix.create(3, 0.7328, -0.7036, 0.003, 0.4296, 1.6975, 0.0136, -0.1624, 0.0061, 0.9834);
        RGB_LMS = RGB_XYZ.multiply(XYZ_LMS);
        LMS_RGB = RGB_LMS.inverse();
        Vector red = RGB_LMS.getRow(0);
        Vector blue = RGB_LMS.getRow(2);
        Vector white = Vector.create(1.0, 1.0, 1.0).multiply(RGB_LMS);
        WHITE_BLUE = ColorBlindnessMatrix.cross(white, blue);
        WHITE_RED = ColorBlindnessMatrix.cross(white, red);
    }

    static final class Tritanopia {
        private static final double V1 = -ColorBlindnessMatrix.access$200().get(0) / ColorBlindnessMatrix.access$200().get(2);
        private static final double V2 = -ColorBlindnessMatrix.access$200().get(1) / ColorBlindnessMatrix.access$200().get(2);
        private static final Matrix SIMULATION = Matrix.create(3, 1.0, 0.0, V1, 0.0, 1.0, V2, 0.0, 0.0, 0.0);
        private static final Matrix CORRECTION = Matrix.create(3, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.7, 0.7, 1.0);
        static final Matrix MATRIX = Tritanopia.calculate(CORRECTION);

        Tritanopia() {
        }

        static Matrix calculate(Matrix correction) {
            return ColorBlindnessMatrix.calculate(Tritanopia.SIMULATION, correction);
        }
    }

    static final class Deuteranopia {
        private static final double V1 = -ColorBlindnessMatrix.access$000().get(0) / ColorBlindnessMatrix.access$000().get(1);
        private static final double V2 = -ColorBlindnessMatrix.access$000().get(2) / ColorBlindnessMatrix.access$000().get(1);
        private static final Matrix SIMULATION = Matrix.create(3, 1.0, V1, 0.0, 0.0, 0.0, 0.0, 0.0, V2, 1.0);
        private static final Matrix CORRECTION = Matrix.create(3, 1.0, 0.0, 0.0, 0.7, 1.0, 0.7, 0.0, 0.0, 1.0);
        static final Matrix MATRIX = Deuteranopia.calculate(CORRECTION);

        Deuteranopia() {
        }

        static Matrix calculate(Matrix correction) {
            return ColorBlindnessMatrix.calculate(Deuteranopia.SIMULATION, correction);
        }
    }

    static final class Protanopia {
        private static final double V1 = -ColorBlindnessMatrix.access$000().get(1) / ColorBlindnessMatrix.access$000().get(0);
        private static final double V2 = -ColorBlindnessMatrix.access$000().get(2) / ColorBlindnessMatrix.access$000().get(0);
        private static final Matrix SIMULATION = Matrix.create(3, 0.0, 0.0, 0.0, V1, 1.0, 0.0, V2, 0.0, 1.0);
        private static final Matrix CORRECTION = Matrix.create(3, 1.0, 0.7, 0.7, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        static final Matrix MATRIX = Protanopia.calculate(CORRECTION);

        Protanopia() {
        }

        static Matrix calculate(Matrix correction) {
            return ColorBlindnessMatrix.calculate(Protanopia.SIMULATION, correction);
        }
    }
}

