/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import java.awt.image.ImageFilter;
import java.util.EnumMap;
import org.jetbrains.annotations.Nullable;

public class ColorBlindnessSupport {
    @Nullable
    public static ColorBlindnessSupport get(@Nullable ColorBlindness blindness) {
        return blindness == null ? null : (ColorBlindnessSupport)Lazy.MAP.get((Object)blindness);
    }

    @Nullable
    public ImageFilter getFilter() {
        return null;
    }

    private static final class Lazy {
        private static final EnumMap<ColorBlindness, ColorBlindnessSupport> MAP = Lazy.create();

        private Lazy() {
        }

        private static EnumMap<ColorBlindness, ColorBlindnessSupport> create() {
            EnumMap<ColorBlindness, ColorBlindnessSupport> map2 = new EnumMap<ColorBlindness, ColorBlindnessSupport>(ColorBlindness.class);
            Lazy.init(map2, ColorBlindness.protanopia, "com.intellij.protanopiaSupport");
            Lazy.init(map2, ColorBlindness.deuteranopia, "com.intellij.deuteranopiaSupport");
            Lazy.init(map2, ColorBlindness.tritanopia, "com.intellij.tritanopiaSupport");
            Lazy.init(map2, ColorBlindness.achromatopsia, "com.intellij.achromatopsiaSupport");
            if (map2.isEmpty()) {
                map2.put(ColorBlindness.deuteranopia, new ColorBlindnessSupport());
            }
            return map2;
        }

        private static void init(EnumMap<ColorBlindness, ColorBlindnessSupport> map2, ColorBlindness blindness, String extensionName) {
            ColorBlindnessSupport[] extensions2 = (ColorBlindnessSupport[])Extensions.getRootArea().getExtensionPoint(extensionName).getExtensions();
            ColorBlindnessSupport support = null;
            for (ColorBlindnessSupport ext : extensions2) {
                if (support != null) continue;
                support = ext;
            }
            if (support != null) {
                map2.put(blindness, support);
                Logger logger = Logger.getInstance(ColorBlindnessSupport.class);
                if (logger.isDebugEnabled()) {
                    logger.debug(Lazy.toString("use", blindness, support));
                }
                for (ColorBlindnessSupport ext : extensions2) {
                    if (support == ext) continue;
                    logger.warn(Lazy.toString("ignore", blindness, ext));
                }
            }
        }

        private static String toString(String prefix, ColorBlindness blindness, ColorBlindnessSupport support) {
            return prefix + " " + blindness.name() + " from " + support.getClass();
        }
    }
}

