/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorConverter;
import com.intellij.util.Matrix;
import com.intellij.util.Vector;

final class MatrixConverter
extends ColorConverter {
    private final Double myWeight;
    private final Matrix myMatrix;

    MatrixConverter(Matrix matrix) {
        this(null, matrix);
    }

    MatrixConverter(Double weight2, Matrix matrix) {
        if (!(weight2 == null || 0.0 < weight2 && weight2 < 1.0)) {
            throw new IllegalArgumentException("unsupported weight");
        }
        int rows = matrix.getRows();
        if (rows != 3 && rows != 4) {
            throw new IllegalArgumentException("unsupported rows");
        }
        int columns = matrix.getColumns();
        if (columns != 3 && columns != 4) {
            throw new IllegalArgumentException("unsupported columns");
        }
        this.myWeight = weight2;
        this.myMatrix = matrix;
    }

    @Override
    public int convert(int red, int green, int blue, int alpha) {
        Vector vector = this.myMatrix.getRows() == 4 ? Vector.create(red, green, blue, alpha) : Vector.create(red, green, blue);
        Vector result2 = vector.multiply(this.myMatrix);
        if (this.myWeight != null) {
            if (vector.getSize() != result2.getSize()) {
                vector = result2.getSize() == 4 ? Vector.create(red, green, blue, alpha) : Vector.create(red, green, blue);
            }
            vector = vector.multiply(1.0 - this.myWeight);
            result2 = result2.multiply(this.myWeight).plus(vector);
        }
        red = (int)result2.get(0);
        green = (int)result2.get(1);
        blue = (int)result2.get(2);
        if (result2.getSize() == 4) {
            alpha = (int)result2.get(3);
        }
        return super.convert(red, green, blue, alpha);
    }
}

