/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.ColorBlindnessMatrix;
import com.intellij.ide.ui.ColorConverter;
import com.intellij.ide.ui.MatrixConverter;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;

final class MatrixFilter
extends RGBImageFilter {
    public static final ImageFilter protanopia = MatrixFilter.forProtanopia(null);
    public static final ImageFilter deuteranopia = MatrixFilter.forDeuteranopia(null);
    public static final ImageFilter tritanopia = MatrixFilter.forTritanopia(null);
    private final String myName;
    private final ColorConverter myConverter;

    public static ImageFilter get(ColorBlindness blindness) {
        if (blindness == ColorBlindness.protanopia) {
            return protanopia;
        }
        if (blindness == ColorBlindness.deuteranopia) {
            return deuteranopia;
        }
        if (blindness == ColorBlindness.tritanopia) {
            return tritanopia;
        }
        return null;
    }

    public static ImageFilter forProtanopia(Double weight2) {
        return new MatrixFilter("Protanopia (correction matrix)", new MatrixConverter(weight2, ColorBlindnessMatrix.Protanopia.MATRIX));
    }

    public static ImageFilter forDeuteranopia(Double weight2) {
        return new MatrixFilter("Deuteranopia (correction matrix)", new MatrixConverter(weight2, ColorBlindnessMatrix.Deuteranopia.MATRIX));
    }

    public static ImageFilter forTritanopia(Double weight2) {
        return new MatrixFilter("Tritanopia (correction matrix)", new MatrixConverter(weight2, ColorBlindnessMatrix.Tritanopia.MATRIX));
    }

    private MatrixFilter(String name, ColorConverter converter) {
        this.myName = name;
        this.myConverter = converter;
    }

    public String toString() {
        return this.myName;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        return this.myConverter.convert(rgb);
    }
}

