/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.ProjectTopHitCache;
import com.intellij.ide.ui.TopHitCache;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class OptionsTopHitProvider
implements OptionsSearchTopHitProvider,
SearchTopHitProvider {
    @VisibleForTesting
    public static final ExtensionPointName<OptionsSearchTopHitProvider.ProjectLevelProvider> PROJECT_LEVEL_EP = new ExtensionPointName("com.intellij.search.projectOptionsTopHitProvider");

    @Deprecated
    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    @NotNull
    private static Collection<OptionDescription> getCachedOptions(@NotNull OptionsSearchTopHitProvider provider, @Nullable Project project2, @Nullable PluginDescriptor pluginDescriptor) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        TopHitCache cache = project2 == null || provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? TopHitCache.getInstance() : ProjectTopHitCache.getInstance(project2);
        Collection<OptionDescription> collection = cache.getCachedOptions(provider, project2, pluginDescriptor);
        if (collection == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    public final void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project2) {
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(2);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(3);
        }
        OptionsTopHitProvider.consumeTopHits(this, pattern, collector, project2);
    }

    static void consumeTopHits(@NotNull OptionsSearchTopHitProvider provider, @NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project2) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(5);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(6);
        }
        if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
            return;
        }
        List<String> parts = StringUtil.split(pattern, " ");
        if (!parts.isEmpty()) {
            OptionsTopHitProvider.doConsumeTopHits(provider, pattern, parts.get(0), collector, project2);
        }
    }

    private static void doConsumeTopHits(@NotNull OptionsSearchTopHitProvider provider, @NotNull String pattern, @NotNull String id2, @NotNull Consumer<Object> collector, @Nullable Project project2) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(8);
        }
        if (id2 == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(9);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(10);
        }
        if (provider.getId().startsWith(id2) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id2.length()).trim();
            OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider, new WordPrefixMatcher(pattern), collector, project2);
        }
    }

    private static void consumeTopHitsForApplicableProvider(@NotNull OptionsSearchTopHitProvider provider, @NotNull Matcher matcher, @NotNull Consumer<Object> collector, @Nullable Project project2) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(12);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(13);
        }
        for (OptionDescription option2 : OptionsTopHitProvider.getCachedOptions(provider, project2, null)) {
            if (!matcher.matches(option2.getOption())) continue;
            collector.accept(option2);
        }
    }

    @Nullable
    private static String checkPattern(@NotNull String pattern) {
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(14);
        }
        if (!pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator())) {
            return null;
        }
        pattern = pattern.substring(1);
        return pattern;
    }

    @Override
    @NotNull
    public abstract String getId();

    public static String messageApp(@PropertyKey(resourceBundle="messages.ApplicationBundle") String property) {
        return StringUtil.stripHtml(ApplicationBundle.message(property, new Object[0]), false);
    }

    public static String messageIde(@PropertyKey(resourceBundle="messages.IdeBundle") String property) {
        return StringUtil.stripHtml(IdeBundle.message(property, new Object[0]), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/OptionsTopHitProvider";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOptions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "consumeTopHits";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doConsumeTopHits";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "consumeTopHitsForApplicableProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Activity
    extends PreloadingActivity
    implements StartupActivity.DumbAware {
        Activity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        @Override
        public void preload(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Activity.$$$reportNull$$$0(0);
            }
            Activity.cacheAll(indicator, null);
        }

        @Override
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                Activity.$$$reportNull$$$0(1);
            }
            NonUrgentExecutor.getInstance().execute(() -> {
                if (project2.isDisposed()) {
                    return;
                }
                Activity.cacheAll(null, project2);
                StartUpPerformanceService.getInstance().lastOptionTopHitProviderFinishedForProject(project2);
            });
        }

        private static void cacheAll(@Nullable ProgressIndicator indicator, @Nullable Project project2) {
            String name = project2 == null ? "application" : "project";
            com.intellij.diagnostic.Activity activity = StartUpMeasurer.startActivity("cache options in " + name);
            SearchTopHitProvider.EP_NAME.processWithPluginDescriptor((provider, pluginDescriptor) -> {
                if (provider instanceof OptionsSearchTopHitProvider && (project2 == null || !(provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider))) {
                    Activity.cache((OptionsSearchTopHitProvider)((Object)provider), indicator, project2, pluginDescriptor);
                }
            });
            if (project2 != null) {
                PROJECT_LEVEL_EP.processWithPluginDescriptor((provider, pluginDescriptor) -> {
                    if (indicator != null) {
                        indicator.checkCanceled();
                    }
                    OptionsTopHitProvider.getCachedOptions(provider, project2, pluginDescriptor);
                });
            }
            activity.end();
        }

        private static void cache(@NotNull OptionsSearchTopHitProvider provider, @Nullable ProgressIndicator indicator, @Nullable Project project2, @Nullable PluginDescriptor pluginDescriptor) {
            if (provider == null) {
                Activity.$$$reportNull$$$0(2);
            }
            if (!provider.preloadNeeded()) {
                return;
            }
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            if (project2 != null && project2.isDisposed()) {
                return;
            }
            OptionsTopHitProvider.getCachedOptions(provider, project2, pluginDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$Activity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preload";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cache";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ProjectLevelProvidersAdapter
    implements SearchTopHitProvider {
        @Override
        public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project2) {
            if (pattern == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(0);
            }
            if (collector == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(1);
            }
            if (project2 == null) {
                return;
            }
            if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
                return;
            }
            List<String> parts = StringUtil.split(pattern, " ");
            if (parts.isEmpty()) {
                return;
            }
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.doConsumeTopHits(provider, pattern, parts.get(0), collector, project2);
            }
        }

        public void consumeAllTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project2) {
            if (pattern == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(2);
            }
            if (collector == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(3);
            }
            WordPrefixMatcher matcher = new WordPrefixMatcher(pattern);
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider, matcher, collector, project2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$ProjectLevelProvidersAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeTopHits";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeAllTopHits";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

