/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class PublicFieldBasedOptionDescription
extends BooleanOptionDescription {
    private static final Logger LOG = Logger.getInstance(PublicFieldBasedOptionDescription.class);
    private final String myFieldName;

    public PublicFieldBasedOptionDescription(String option2, String configurableId, String fieldName) {
        super(option2, configurableId);
        this.myFieldName = fieldName;
    }

    @NotNull
    public abstract Object getInstance();

    protected void fireUpdated() {
    }

    @Override
    public boolean isOptionEnabled() {
        Object instance2 = this.getInstance();
        try {
            return instance2.getClass().getField(this.myFieldName).getBoolean(instance2);
        }
        catch (Exception exception) {
            LOG.error(String.format("Boolean field '%s' not found in %s", this.myFieldName, instance2), exception);
            return false;
        }
    }

    @Override
    public void setOptionState(boolean enabled) {
        Object instance2 = this.getInstance();
        try {
            instance2.getClass().getField(this.myFieldName).setBoolean(instance2, enabled);
        }
        catch (Exception exception) {
            LOG.error(String.format("Boolean field '%s' not found in %s", this.myFieldName, instance2), exception);
        }
        this.fireUpdated();
    }
}

