/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class PublicMethodBasedOptionDescription
extends BooleanOptionDescription {
    private static final Logger LOG = Logger.getInstance(PublicMethodBasedOptionDescription.class);
    private final String myGetterName;
    private final String mySetterName;

    public PublicMethodBasedOptionDescription(String option2, String configurableId, String getterName, String setterName) {
        super(option2, configurableId);
        this.myGetterName = getterName;
        this.mySetterName = setterName;
    }

    @NotNull
    public abstract Object getInstance();

    protected void fireUpdated() {
    }

    @Override
    public boolean isOptionEnabled() {
        Object instance2 = this.getInstance();
        try {
            return (Boolean)instance2.getClass().getMethod(this.myGetterName, new Class[0]).invoke(instance2, new Object[0]);
        }
        catch (Exception exception) {
            LOG.error(String.format("Boolean getter '%s' not found in %s", this.myGetterName, instance2), exception);
            return false;
        }
    }

    @Override
    public void setOptionState(boolean enabled) {
        Object instance2 = this.getInstance();
        try {
            instance2.getClass().getMethod(this.mySetterName, Boolean.TYPE).invoke(instance2, enabled);
        }
        catch (Exception exception) {
            LOG.error(String.format("Boolean setter '%s' not found in %s", this.mySetterName, instance2), exception);
        }
        this.fireUpdated();
    }
}

