/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Changeable;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class RegistryBooleanOptionDescriptor
extends BooleanOptionDescription
implements Changeable {
    protected final String myKey;

    public RegistryBooleanOptionDescriptor(String option2, String registryKey) {
        super(option2, null);
        this.myKey = registryKey;
    }

    @Override
    public boolean isOptionEnabled() {
        return Registry.is(this.myKey);
    }

    @Override
    public void setOptionState(boolean enabled) {
        Registry.get(this.myKey).setValue(enabled);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            RegistryBooleanOptionDescriptor.suggestRestartIfNecessary(null);
        }
    }

    @Override
    public boolean hasChanged() {
        return Registry.get(this.myKey).isChangedFromDefault();
    }

    public static void suggestRestartIfNecessary(@Nullable JComponent parentComponent) {
        if (Registry.getInstance().isRestartNeeded()) {
            RegistryBooleanOptionDescriptor.suggestRestart(parentComponent);
        }
    }

    public static void suggestRestart(@Nullable JComponent parentComponent) {
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        String title = "Restart Required";
        String message = ApplicationNamesInfo.getInstance().getFullProductName() + " must be restarted for the changes to take effect";
        String action2 = app.isRestartCapable() ? "Restart" : "Shutdown";
        String okText = action2 + " Now";
        String cancelText = action2 + " Later";
        int result2 = parentComponent != null ? Messages.showOkCancelDialog(parentComponent, message, title, okText, cancelText, Messages.getQuestionIcon()) : Messages.showOkCancelDialog(message, title, okText, cancelText, Messages.getQuestionIcon());
        if (result2 == 0) {
            ApplicationManager.getApplication().invokeLater(() -> app.restart(true), ModalityState.NON_MODAL);
        }
    }
}

