/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.Changeable;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class RegistryTextOptionDescriptor
extends OptionDescription
implements Changeable {
    private final RegistryValue myValue;

    public RegistryTextOptionDescriptor(RegistryValue value2) {
        super(value2.getKey());
        this.myValue = value2;
    }

    @Override
    public boolean hasChanged() {
        return this.myValue.isChangedFromDefault();
    }

    @Override
    public String getOption() {
        return this.myValue.getKey();
    }

    @Override
    public String getValue() {
        return this.myValue.asString();
    }

    @Override
    public boolean hasExternalEditor() {
        return true;
    }

    @Override
    public void invokeInternalEditor() {
        if (this.myValue.getKey().contains("color") && ColorUtil.fromHex(this.myValue.asString(), null) != null) {
            Color color = ColorChooser.chooseColor(IdeFrameImpl.getActiveFrame(), "Change Color For '" + this.myValue.getKey() + "'", ColorUtil.fromHex(this.myValue.asString()));
            if (color != null) {
                this.myValue.setValue(ColorUtil.toHex(color));
            }
        } else {
            String s = Messages.showInputDialog((Project)null, "Enter new value for '" + this.myValue.getKey() + "'", "Change Registry Value", null, this.myValue.asString(), (InputValidator)new InputValidatorEx(){

                @Override
                @Nullable
                public String getErrorText(String inputString) {
                    return this.canClose(inputString) ? null : "Should not be empty";
                }

                @Override
                public boolean checkInput(String inputString) {
                    return this.canClose(inputString);
                }

                @Override
                public boolean canClose(String inputString) {
                    return !StringUtil.isEmpty(inputString);
                }
            });
            if (s != null) {
                this.myValue.setValue(s);
            }
        }
    }
}

