/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;

public class ToolOptionDescription
extends BooleanOptionDescription {
    private final Project myProject;
    private final String myShortName;

    public ToolOptionDescription(InspectionToolWrapper<?, ?> tool, Project project2) {
        super(tool.getGroupDisplayName() + ": " + tool.getDisplayName(), "Errors");
        this.myShortName = tool.getShortName();
        this.myProject = project2;
    }

    @Override
    public boolean isOptionEnabled() {
        return this.getCurrentProfile().isToolEnabled(HighlightDisplayKey.find(this.myShortName));
    }

    private InspectionProfileImpl getCurrentProfile() {
        return InspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
    }

    @Override
    public void setOptionState(boolean enabled) {
        InspectionProfileImpl.setToolEnabled(enabled, this.getCurrentProfile(), this.myShortName, this.myProject);
        DaemonCodeAnalyzer.getInstance(this.myProject).restart();
    }
}

