/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopHitCache
implements Disposable {
    protected final ConcurrentMap<Class<?>, Collection<OptionDescription>> map = ContainerUtil.newConcurrentMap();

    public static TopHitCache getInstance() {
        return ServiceManager.getService(TopHitCache.class);
    }

    @Override
    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.map.values().forEach(TopHitCache::dispose);
        this.map.clear();
    }

    private static void dispose(Collection<? extends OptionDescription> options) {
        if (options != null) {
            options.forEach(TopHitCache::dispose);
        }
    }

    private static void dispose(OptionDescription option2) {
        if (option2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Object)option2));
        }
    }

    public void invalidateCachedOptions(Class<? extends OptionsSearchTopHitProvider.ApplicationLevelProvider> providerClass) {
        Collection removed = (Collection)this.map.remove(providerClass);
        if (removed != null) {
            TopHitCache.dispose(removed);
        }
    }

    public Collection<OptionDescription> getCachedOptions(@NotNull OptionsSearchTopHitProvider provider, @Nullable Project project2, @Nullable PluginDescriptor pluginDescriptor) {
        Class<?> clazz;
        Collection<OptionDescription> result2;
        if (provider == null) {
            TopHitCache.$$$reportNull$$$0(0);
        }
        if ((result2 = (Collection<OptionDescription>)this.map.get(clazz = provider.getClass())) != null) {
            return result2;
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        result2 = provider instanceof OptionsSearchTopHitProvider.ProjectLevelProvider ? ((OptionsSearchTopHitProvider.ProjectLevelProvider)provider).getOptions(project2) : (provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? ((OptionsSearchTopHitProvider.ApplicationLevelProvider)provider).getOptions() : ((OptionsTopHitProvider)provider).getOptions(project2));
        ActivityCategory category = project2 == null ? ActivityCategory.APP_OPTIONS_TOP_HIT_PROVIDER : ActivityCategory.PROJECT_OPTIONS_TOP_HIT_PROVIDER;
        StartUpMeasurer.addCompletedActivity(startTime, clazz, category, pluginDescriptor == null ? null : pluginDescriptor.getPluginId().getIdString());
        Collection<OptionDescription> prevValue = this.map.putIfAbsent(clazz, result2);
        return prevValue == null ? result2 : prevValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/ui/TopHitCache", "getCachedOptions"));
    }
}

