/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UITheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIThemeProvider
implements PluginAware {
    public static final ExtensionPointName<UIThemeProvider> EP_NAME = ExtensionPointName.create("com.intellij.themeProvider");
    private PluginDescriptor myPluginDescriptor;
    @Attribute(value="path")
    @RequiredElement
    public String path;
    @Attribute(value="id")
    @RequiredElement
    public String id;

    @Nullable
    public UITheme createTheme() {
        try {
            ClassLoader classLoader = this.myPluginDescriptor.getPluginClassLoader();
            InputStream stream = classLoader.getResourceAsStream(this.path);
            if (stream == null) {
                Logger.getInstance(this.getClass()).warn("Cannot find theme resource: " + this.path + " (classLoader=" + classLoader + ", pluginDescriptor=" + this.myPluginDescriptor + ")");
                return null;
            }
            return UITheme.loadFromJson(stream, this.id, classLoader);
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn("error loading UITheme '" + this.path + "', pluginDescriptor=" + this.myPluginDescriptor, e);
            return null;
        }
    }

    @Override
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            UIThemeProvider.$$$reportNull$$$0(0);
        }
        this.myPluginDescriptor = pluginDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/ui/UIThemeProvider", "setPluginDescriptor"));
    }
}

