/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import java.awt.image.RGBImageFilter;

abstract class WeightFilter
extends RGBImageFilter {
    private final String myName;
    private final Double myWeight;

    WeightFilter(String name, Double weight2) {
        if (weight2 != null) {
            if (weight2 < 0.0 || 1.0 < weight2) {
                throw new IllegalArgumentException("weight " + weight2 + " out of [0..1]");
            }
            name = name + " weight: " + weight2;
        }
        this.myName = name;
        this.myWeight = weight2;
        this.canFilterIndexColorModel = true;
    }

    public String toString() {
        return this.myName;
    }

    @Override
    public final int filterRGB(int x, int y, int rgb) {
        return 0xFF000000 & rgb | this.toRGB(0xFF & rgb >> 16, 0xFF & rgb >> 8, 0xFF & rgb);
    }

    abstract int toRGB(int var1, int var2, int var3);

    final int toRGB(int srcR, int srcG, int srcB, double dstR, double dstG, double dstB) {
        if (Double.isNaN(dstR)) {
            dstR = 0.0;
        }
        if (Double.isNaN(dstG)) {
            dstG = 0.0;
        }
        if (Double.isNaN(dstB)) {
            dstB = 0.0;
        }
        if (this.myWeight != null) {
            dstR = dstR * this.myWeight + (double)srcR * (1.0 - this.myWeight);
            dstG = dstG * this.myWeight + (double)srcG * (1.0 - this.myWeight);
            dstB = dstB * this.myWeight + (double)srcB * (1.0 - this.myWeight);
        }
        srcR = (int)dstR;
        srcG = (int)dstG;
        srcB = (int)dstB;
        return srcR << 16 | srcG << 8 | srcB;
    }

    static double fix(double value2) {
        return Double.isNaN(value2) || value2 < 0.0 ? 0.0 : (value2 > 255.0 ? 255.0 : value2);
    }
}

