/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.LafProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.MenuArrowIcon;
import com.intellij.ide.ui.laf.PluggableLafInfo;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@State(name="LafManager", storages={@Storage(value="laf.xml", roamingType=RoamingType.PER_OS)})
public final class LafManagerImpl
extends LafManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(LafManager.class);
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";
    @NonNls
    private static final String ATTRIBUTE_THEME_NAME = "themeId";
    private static final String DEFAULT_LIGHT_THEME_ID = "JetBrainsLightTheme";
    private static final String DARCULA_EDITOR_THEME_KEY = "Darcula.SavedEditorTheme";
    private static final String DEFAULT_EDITOR_THEME_KEY = "Default.SavedEditorTheme";
    @NonNls
    private static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    @PropertyKey(resourceBundle="messages.IdeBundle")
    @NonNls
    private static final String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private final EventDispatcher<LafManagerListener> myEventDispatcher = EventDispatcher.create(LafManagerListener.class);
    private final SynchronizedClearableLazy<List<UIManager.LookAndFeelInfo>> myLaFs = new SynchronizedClearableLazy(() -> {
        Activity activity = StartUpMeasurer.startActivity("compute LaF list");
        List<UIManager.LookAndFeelInfo> infos = this.computeLafList();
        activity.end();
        return infos;
    });
    private final UIManager.LookAndFeelInfo myDefaultLightTheme = LafManagerImpl.getDefaultLightTheme();
    private final UIManager.LookAndFeelInfo myDefaultDarkTheme = new DarculaLookAndFeelInfo();
    private final UIDefaults ourDefaults = (UIDefaults)UIManager.getDefaults().clone();
    private UIManager.LookAndFeelInfo myCurrentLaf;
    private final Map<LafManager.LafReference, HashMap<String, Object>> myStoredDefaults = new HashMap<LafManager.LafReference, HashMap<String, Object>>();
    public static final String WINDOW_ALPHA = "Window.alpha";
    private static final Map<String, String> ourLafClassesAliases = new HashMap<String, String>();
    private static final Map<String, Integer> lafNameOrder = new HashMap<String, Integer>();
    private CollectionComboBoxModel<LafManager.LafReference> myLafComboBoxModel;
    private boolean myFirstSetup = true;
    private boolean myUpdatingPlugin = false;
    private final Set<String> myThemesInUpdatedPlugin = new HashSet<String>();
    private static LafManagerImpl ourTestInstance;

    private static UIManager.LookAndFeelInfo getDefaultLightTheme() {
        for (UIThemeProvider provider : UIThemeProvider.EP_NAME.getExtensionList()) {
            UITheme theme;
            if (!DEFAULT_LIGHT_THEME_ID.equals(provider.id) || (theme = provider.createTheme()) == null) continue;
            return new UIThemeBasedLookAndFeelInfo(theme);
        }
        LOG.error("Can't load JetBrainsLightTheme");
        return new IntelliJLookAndFeelInfo();
    }

    @NotNull
    private List<UIManager.LookAndFeelInfo> computeLafList() {
        ArrayList<UIManager.LookAndFeelInfo> lafList = new ArrayList<UIManager.LookAndFeelInfo>();
        lafList.add(this.myDefaultLightTheme);
        lafList.add(this.myDefaultDarkTheme);
        if (!SystemInfo.isMac) {
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                String name = laf.getName();
                if ("Metal".equalsIgnoreCase(name) || "CDE/Motif".equalsIgnoreCase(name) || "Nimbus".equalsIgnoreCase(name) || name.startsWith("Windows") || "GTK+".equalsIgnoreCase(name) || name.startsWith("JGoodies")) continue;
                lafList.add(laf);
            }
        }
        LafProvider.EP_NAME.forEachExtensionSafe(provider -> lafList.add(provider.getLookAndFeelInfo()));
        UIThemeProvider.EP_NAME.forEachExtensionSafe(provider -> {
            UITheme theme;
            if (!DEFAULT_LIGHT_THEME_ID.equals(provider.id) && (theme = provider.createTheme()) != null) {
                lafList.add(new UIThemeBasedLookAndFeelInfo(theme));
            }
        });
        LafManagerImpl.sortThemes(lafList);
        ArrayList<UIManager.LookAndFeelInfo> arrayList = lafList;
        if (arrayList == null) {
            LafManagerImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void sortThemes(@NotNull List<UIManager.LookAndFeelInfo> list2) {
        if (list2 == null) {
            LafManagerImpl.$$$reportNull$$$0(1);
        }
        list2.sort((t1, t2) -> {
            String n2;
            String n1 = t1.getName();
            if (Objects.equals(n1, n2 = t2.getName())) {
                return 0;
            }
            Integer o1 = lafNameOrder.get(n1);
            Integer o2 = lafNameOrder.get(n2);
            if (o1 != null && o2 != null) {
                return o1 - o2;
            }
            if (o1 != null) {
                return -1;
            }
            if (o2 != null) {
                return 1;
            }
            return n1.compareToIgnoreCase(n2);
        });
    }

    @Override
    public void addLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.addListener(listener2);
    }

    @Override
    public void addLafManagerListener(@NotNull LafManagerListener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(3);
        }
        if (disposable2 == null) {
            LafManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(LafManagerListener.TOPIC, listener2);
    }

    @Override
    public void removeLafManagerListener(@NotNull LafManagerListener listener2) {
        if (listener2 == null) {
            LafManagerImpl.$$$reportNull$$$0(5);
        }
        this.myEventDispatcher.removeListener(listener2);
    }

    @Override
    public void initializeComponent() {
        UIManager.LookAndFeelInfo laf;
        if (this.myCurrentLaf != null && !(this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) && (laf = this.findLaf(this.myCurrentLaf.getClassName())) != null) {
            boolean needUninstall = StartupUiUtil.isUnderDarcula();
            this.setCurrentLookAndFeel(laf);
            this.updateWizardLAF(needUninstall);
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && !((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).isInitialised()) {
            this.setCurrentLookAndFeel(this.myCurrentLaf);
        }
        this.updateUI();
        UIThemeProvider.EP_NAME.addExtensionPointListener(new UIThemeEPListener(), (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                LafManagerImpl.this.myUpdatingPlugin = isUpdate;
            }

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                LafManagerImpl.this.myThemesInUpdatedPlugin.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void updateWizardLAF(boolean wasUnderDarcula) {
        if (WelcomeWizardUtil.getWizardLAF() == null) {
            return;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            DarculaInstaller.install();
        } else if (wasUnderDarcula) {
            DarculaInstaller.uninstall();
        }
        WelcomeWizardUtil.setWizardLAF(null);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            LafManagerImpl.$$$reportNull$$$0(6);
        }
        UIManager.LookAndFeelInfo laf = null;
        Element lafElement = element2.getChild(ELEMENT_LAF);
        if (lafElement != null) {
            laf = this.findLaf(lafElement.getAttributeValue(ATTRIBUTE_CLASS_NAME), lafElement.getAttributeValue(ATTRIBUTE_THEME_NAME));
        }
        if (laf == null) {
            laf = this.getDefaultLaf();
        }
        this.myCurrentLaf = laf;
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(String lafClassName, String themeId) {
        if (lafClassName != null && ourLafClassesAliases.containsKey(lafClassName)) {
            lafClassName = ourLafClassesAliases.get(lafClassName);
        }
        if (themeId != null) {
            for (UIManager.LookAndFeelInfo l : (List)this.myLaFs.getValue()) {
                if (!(l instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)l).getTheme().getId().equals(themeId)) continue;
                return l;
            }
        }
        if (lafClassName != null) {
            return this.findLaf(lafClassName);
        }
        return null;
    }

    @Override
    public void noStateLoaded() {
        this.myCurrentLaf = this.getDefaultLaf();
    }

    @Override
    public Element getState() {
        String className;
        Element element2 = new Element("state");
        UIManager.LookAndFeelInfo laf = this.myCurrentLaf;
        if (laf instanceof TempUIThemeBasedLookAndFeelInfo) {
            laf = ((TempUIThemeBasedLookAndFeelInfo)laf).getPreviousLaf();
        }
        if (laf != null && (className = laf.getClassName()) != null) {
            Element child2 = new Element(ELEMENT_LAF);
            child2.setAttribute(ATTRIBUTE_CLASS_NAME, className);
            if (laf instanceof UIThemeBasedLookAndFeelInfo) {
                child2.setAttribute(ATTRIBUTE_THEME_NAME, ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId());
            }
            element2.addContent(child2);
        }
        return element2;
    }

    @Override
    public UIManager.LookAndFeelInfo @NotNull [] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = ((List)this.myLaFs.getValue()).toArray(new UIManager.LookAndFeelInfo[0]);
        if (lookAndFeelInfoArray == null) {
            LafManagerImpl.$$$reportNull$$$0(7);
        }
        return lookAndFeelInfoArray;
    }

    @Override
    public CollectionComboBoxModel<LafManager.LafReference> getLafComboBoxModel() {
        if (this.myLafComboBoxModel == null) {
            this.myLafComboBoxModel = new CollectionComboBoxModel<LafManager.LafReference>(this.getLafReferences());
        }
        return this.myLafComboBoxModel;
    }

    private List<LafManager.LafReference> getLafReferences() {
        return ContainerUtil.map((Collection)this.myLaFs.getValue(), LafManagerImpl::createLafReference);
    }

    @NotNull
    private static LafManager.LafReference createLafReference(UIManager.LookAndFeelInfo laf) {
        String themeId = null;
        if (laf instanceof UIThemeBasedLookAndFeelInfo) {
            themeId = ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getId();
        }
        return new LafManager.LafReference(laf.getName(), laf.getClassName(), themeId);
    }

    @Override
    public UIManager.LookAndFeelInfo findLaf(LafManager.LafReference reference2) {
        return this.findLaf(reference2.getClassName(), reference2.getThemeId());
    }

    @Override
    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    @Override
    public LafManager.LafReference getCurrentLookAndFeelReference() {
        return LafManagerImpl.createLafReference(this.myCurrentLaf);
    }

    public UIManager.LookAndFeelInfo getDefaultLaf() {
        String defaultLafName;
        UIManager.LookAndFeelInfo laf;
        String appLafName;
        UIManager.LookAndFeelInfo laf2;
        String wizardLafName = WelcomeWizardUtil.getWizardLAF();
        if (wizardLafName != null) {
            UIManager.LookAndFeelInfo laf3 = this.findLaf(wizardLafName);
            if (laf3 != null) {
                return laf3;
            }
            LOG.error("Could not find wizard L&F: " + wizardLafName);
        }
        if (SystemInfo.isMac) {
            String className = IntelliJLaf.class.getName();
            laf2 = this.findLaf(className);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find OS X L&F: " + className);
        }
        if ((appLafName = WelcomeWizardUtil.getDefaultLAF()) != null) {
            laf2 = this.findLaf(appLafName);
            if (laf2 != null) {
                return laf2;
            }
            LOG.error("Could not find app L&F: " + appLafName);
        }
        if ((laf = this.findLaf(defaultLafName = IntelliJLaf.class.getName())) != null) {
            return laf;
        }
        throw new IllegalStateException("No default L&F found: " + defaultLafName);
    }

    @Nullable
    private UIManager.LookAndFeelInfo findLaf(@NotNull String className) {
        if (className == null) {
            LafManagerImpl.$$$reportNull$$$0(8);
        }
        if (this.myDefaultLightTheme.getClassName().equals(className)) {
            return this.myDefaultLightTheme;
        }
        if (this.myDefaultDarkTheme.getClassName().equals(className)) {
            return this.myDefaultDarkTheme;
        }
        for (UIManager.LookAndFeelInfo l : (List)this.myLaFs.getValue()) {
            if (l instanceof UIThemeBasedLookAndFeelInfo || !Comparing.equal(l.getClassName(), className)) continue;
            return l;
        }
        return null;
    }

    @Override
    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean lockEditorScheme) {
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(9);
        }
        this.setLookAndFeelImpl(lookAndFeelInfo, lockEditorScheme, false);
    }

    private void setLookAndFeelImpl(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo, boolean lockEditorScheme, boolean processChangeSynchronously) {
        LookAndFeel laf;
        if (lookAndFeelInfo == null) {
            LafManagerImpl.$$$reportNull$$$0(10);
        }
        UIManager.LookAndFeelInfo oldLaf = this.myCurrentLaf;
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo) {
            ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).dispose();
        }
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        UIManager.getDefaults().clear();
        UIManager.getDefaults().putAll(this.ourDefaults);
        if ("idea.laf.classname".equals(lookAndFeelInfo.getClassName())) {
            laf = new IdeaLaf();
            MetalLookAndFeel.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                Messages.showMessageDialog(IdeBundle.message("error.cannot.set.look.and.feel", lookAndFeelInfo.getName(), e.getMessage()), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
                return;
            }
        }
        if (DarculaLookAndFeelInfo.CLASS_NAME.equals(lookAndFeelInfo.getClassName())) {
            laf = new DarculaLaf();
            try {
                UIManager.setLookAndFeel(laf);
                AppUIUtil.updateForDarcula(true);
            }
            catch (Exception e) {
                Messages.showMessageDialog(IdeBundle.message("error.cannot.set.look.and.feel", lookAndFeelInfo.getName(), e.getMessage()), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
                return;
            }
        }
        try {
            if (lookAndFeelInfo instanceof PluggableLafInfo) {
                laf = ((PluggableLafInfo)lookAndFeelInfo).createLookAndFeel();
            } else {
                laf = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
                if (laf instanceof MetalLookAndFeel) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                } else if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo && laf instanceof UserDataHolder) {
                    UserDataHolder userDataHolder = (UserDataHolder)((Object)laf);
                    userDataHolder.putUserData(UIUtil.LAF_WITH_THEME_KEY, Boolean.TRUE);
                }
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            Messages.showMessageDialog(IdeBundle.message("error.cannot.set.look.and.feel", lookAndFeelInfo.getName(), e.getMessage()), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
            return;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo) {
            try {
                ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).installTheme(UIManager.getLookAndFeelDefaults(), lockEditorScheme);
            }
            catch (Exception e) {
                Messages.showMessageDialog(IdeBundle.message("error.cannot.set.look.and.feel", lookAndFeelInfo.getName(), e.getMessage()), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
                return;
            }
        }
        if (SystemInfo.isMacOSYosemite) {
            LafManagerImpl.installMacOSXFonts(UIManager.getLookAndFeelDefaults());
        }
        this.myCurrentLaf = ObjectUtils.chooseNotNull(lookAndFeelInfo, this.findLaf(lookAndFeelInfo.getClassName()));
        if (!this.myFirstSetup && !lockEditorScheme) {
            if (processChangeSynchronously) {
                this.updateEditorSchemeIfNecessary(oldLaf, true);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.updateEditorSchemeIfNecessary(oldLaf, false));
            }
        }
        this.myFirstSetup = false;
    }

    private void updateEditorSchemeIfNecessary(UIManager.LookAndFeelInfo oldLaf, boolean processChangeSynchronously) {
        if (oldLaf instanceof TempUIThemeBasedLookAndFeelInfo || this.myCurrentLaf instanceof TempUIThemeBasedLookAndFeelInfo) {
            return;
        }
        if (this.myCurrentLaf instanceof UIThemeBasedLookAndFeelInfo && ((UIThemeBasedLookAndFeelInfo)this.myCurrentLaf).getTheme().getEditorSchemeName() != null) {
            return;
        }
        boolean dark = StartupUiUtil.isUnderDarcula();
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme current2 = colorsManager.getGlobalScheme();
        boolean wasUITheme = oldLaf instanceof UIThemeBasedLookAndFeelInfo;
        if (dark != ColorUtil.isDark(current2.getDefaultBackground()) || wasUITheme) {
            EditorColorsScheme scheme;
            String targetScheme = dark ? "Darcula" : "Default";
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String savedEditorThemeKey = dark ? DARCULA_EDITOR_THEME_KEY : DEFAULT_EDITOR_THEME_KEY;
            String toSavedEditorThemeKey = dark ? DEFAULT_EDITOR_THEME_KEY : DARCULA_EDITOR_THEME_KEY;
            String themeName = properties.getValue(savedEditorThemeKey);
            if (themeName != null && colorsManager.getScheme(themeName) != null) {
                targetScheme = themeName;
            }
            if (!wasUITheme) {
                properties.setValue(toSavedEditorThemeKey, current2.getName(), dark ? "Default" : "Darcula");
            }
            if ((scheme = colorsManager.getScheme(targetScheme)) != null) {
                ((EditorColorsManagerImpl)colorsManager).setGlobalScheme(scheme, processChangeSynchronously);
            }
        }
        UISettings.getShadowInstance().fireUISettingsChanged();
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void updateForDarcula(boolean isDarcula) {
        AppUIUtil.updateForDarcula(isDarcula);
    }

    @Override
    public void updateUI() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        LafManagerImpl.fixPopupWeight();
        LafManagerImpl.fixMenuIssues(uiDefaults);
        LafManagerImpl.initInputMapDefaults(uiDefaults);
        uiDefaults.put("Button.defaultButtonFollowsFocus", Boolean.FALSE);
        uiDefaults.put("Balloon.error.textInsets", new JBInsets(3, 8, 3, 8).asUIResource());
        LafManagerImpl.patchFileChooserStrings(uiDefaults);
        this.patchLafFonts(uiDefaults);
        LafManagerImpl.patchListUI(uiDefaults);
        LafManagerImpl.patchTreeUI(uiDefaults);
        LafManagerImpl.patchHiDPI(uiDefaults);
        this.fixMacOSDarkThemeDecorations();
        uiDefaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope(false));
        uiDefaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, (Object)UIUtil.getLcdContrastValue());
        uiDefaults.put(RenderingHints.KEY_FRACTIONALMETRICS, UISettings.FORCE_USE_FRACTIONAL_METRICS ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        for (Frame frame : Frame.getFrames()) {
            LafManagerImpl.updateUI(frame);
        }
        ApplicationManager.getApplication().getMessageBus().syncPublisher(LafManagerListener.TOPIC).lookAndFeelChanged(this);
        this.myEventDispatcher.getMulticaster().lookAndFeelChanged(this);
    }

    private void fixMacOSDarkThemeDecorations() {
        if (!SystemInfo.isMacOSMojave) {
            return;
        }
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size, @JdkConstants.FontStyle int style) {
        Map<TextAttribute, Integer> attributes;
        Font font;
        if (SystemInfo.isMacOSElCapitan && !StartupUiUtil.isDialogFont(font = new Font(SystemInfo.isMacOSCatalina ? ".AppleSystemUIFont" : ".SF NS Text", style, size).deriveFont(attributes = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON)))) {
            return new FontUIResource(font);
        }
        return new FontUIResource(yosemite, style, size);
    }

    public static void installMacOSXFonts(UIDefaults defaults) {
        String face = "Helvetica Neue";
        FontUIResource uiFont = LafManagerImpl.getFont("Helvetica Neue", 13, 0);
        LafManagerImpl.initFontDefaults(defaults, uiFont);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value2;
            if (!(key instanceof String) || !StringUtil.endsWithIgnoreCase((String)key, "font") || !((value2 = defaults.get(key)) instanceof FontUIResource) || !(font = (FontUIResource)value2).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, LafManagerImpl.getFont("Helvetica Neue", font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = LafManagerImpl.getFont("Helvetica Neue", 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = LafManagerImpl.getFont("Helvetica Neue", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = LafManagerImpl.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    private static void patchBorder(UIDefaults defaults, String key) {
        if (defaults.getBorder(key) == null) {
            defaults.put(key, JBUI.Borders.empty(1, 0).asUIResource());
        }
    }

    private static void patchListUI(UIDefaults defaults) {
        LafManagerImpl.patchBorder(defaults, "List.border");
    }

    private static void patchTreeUI(UIDefaults defaults) {
        LafManagerImpl.patchBorder(defaults, "Tree.border");
        defaults.put("TreeUI", "com.intellij.ui.tree.ui.DefaultTreeUI");
        defaults.put("Tree.repaintWholeRow", (Object)true);
        if (LafManagerImpl.isUnsupported(defaults.getIcon("Tree.collapsedIcon"))) {
            defaults.put("Tree.collapsedIcon", LafIconLookup.getIcon("treeCollapsed"));
            defaults.put("Tree.collapsedSelectedIcon", LafIconLookup.getSelectedIcon("treeCollapsed"));
        }
        if (LafManagerImpl.isUnsupported(defaults.getIcon("Tree.expandedIcon"))) {
            defaults.put("Tree.expandedIcon", LafIconLookup.getIcon("treeExpanded"));
            defaults.put("Tree.expandedSelectedIcon", LafIconLookup.getSelectedIcon("treeExpanded"));
        }
    }

    private static boolean isUnsupported(@Nullable Icon icon2) {
        String name = icon2 == null ? null : icon2.getClass().getName();
        return name == null || name.startsWith("javax.swing.plaf.") || name.startsWith("com.sun.java.swing.plaf.");
    }

    private static void patchHiDPI(UIDefaults defaults) {
        Object prevScaleVal = defaults.get("hidpi.scaleFactor");
        float prevScale = prevScaleVal != null ? ((Float)prevScaleVal).floatValue() : 1.0f;
        float prevRowHeightScale = prevScaleVal != null || SystemInfo.isMac || SystemInfo.isWindows ? prevScale : JBUIScale.getFontScale(12.0f);
        LafManagerImpl.patchRowHeight(defaults, "List.rowHeight", prevRowHeightScale);
        LafManagerImpl.patchRowHeight(defaults, "Table.rowHeight", prevRowHeightScale);
        LafManagerImpl.patchRowHeight(defaults, "Tree.rowHeight", prevRowHeightScale);
        if (prevScale == JBUIScale.scale(1.0f) && prevScaleVal != null) {
            return;
        }
        List<String> myIntKeys = Arrays.asList("Tree.leftChildIndent", "Tree.rightChildIndent", "SettingsTree.rowHeight");
        List<String> myDimensionKeys = Arrays.asList("Slider.horizontalSize", "Slider.verticalSize", "Slider.minimumHorizontalSize", "Slider.minimumVerticalSize");
        for (Map.Entry entry : defaults.entrySet()) {
            Object value2 = entry.getValue();
            String key = entry.getKey().toString();
            if (value2 instanceof Dimension) {
                if (!(value2 instanceof UIResource) && !myDimensionKeys.contains(key)) continue;
                entry.setValue(JBUI.size((Dimension)value2).asUIResource());
                continue;
            }
            if (value2 instanceof Insets) {
                if (!(value2 instanceof UIResource)) continue;
                entry.setValue(JBUI.insets((Insets)value2).asUIResource());
                continue;
            }
            if (!(value2 instanceof Integer) || !key.endsWith(".maxGutterIconWidth") && !myIntKeys.contains(key)) continue;
            int normValue = (int)((float)((Integer)value2).intValue() / prevScale);
            entry.setValue(JBUIScale.scale(normValue));
        }
        defaults.put("hidpi.scaleFactor", Float.valueOf(JBUIScale.scale(1.0f)));
    }

    private static void patchRowHeight(UIDefaults defaults, String key, float prevScale) {
        int rowHeight;
        Object value2 = defaults.get(key);
        int n = rowHeight = value2 instanceof Integer ? (Integer)value2 : 0;
        if (rowHeight <= 0) {
            LOG.warn(key + " = " + value2 + " in " + UIManager.getLookAndFeel().getName() + "; it may lead to performance degradation");
        }
        if (!SystemInfo.isMac && !SystemInfo.isWindows && Registry.is("linux.row.height.disabled")) {
            rowHeight = 0;
        }
        defaults.put(key, (Object)(rowHeight <= 0 ? 0 : JBUIScale.scale((int)((float)rowHeight / prevScale))));
    }

    private static void fixMenuIssues(@NotNull UIDefaults uiDefaults) {
        if (uiDefaults == null) {
            LafManagerImpl.$$$reportNull$$$0(11);
        }
        uiDefaults.put("Menu.arrowIcon", new DefaultMenuArrowIcon());
        uiDefaults.put("MenuItem.background", UIManager.getColor("Menu.background"));
    }

    private static void fixPopupWeight() {
        int popupWeight = 1;
        String property = System.getProperty("idea.popup.weight");
        if (property != null) {
            property = StringUtil.toLowerCase(property).trim();
        }
        if (SystemInfo.isMacOSLeopard) {
            popupWeight = 2;
        } else if (property == null) {
            if (SystemInfo.isWindows) {
                popupWeight = 2;
            }
        } else if ("light".equals(property)) {
            popupWeight = 0;
        } else if ("heavy".equals(property)) {
            popupWeight = 2;
        } else if (!"medium".equals(property)) {
            LOG.error("Illegal value of property \"idea.popup.weight\": " + property);
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        if (!(factory instanceof OurPopupFactory)) {
            factory = new OurPopupFactory(factory);
            PopupFactory.setSharedInstance(factory);
        }
        PopupUtil.setPopupType(factory, popupWeight);
    }

    private static void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key : ourFileChooserTextKeys) {
                defaults.put(key, IdeBundle.message(key, new Object[0]));
            }
        }
    }

    private void patchLafFonts(UIDefaults uiDefaults) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            this.storeOriginalFontDefaults(uiDefaults);
            LafManagerImpl.initFontDefaults(uiDefaults, UIUtil.getFontWithFallback(uiSettings.getFontFace(), 0, uiSettings.getFontSize()));
            JBUIScale.setUserScaleFactor(JBUIScale.getFontScale(uiSettings.getFontSize()));
        } else {
            this.restoreOriginalFontDefaults(uiDefaults);
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        LafManager.LafReference lf = this.myCurrentLaf == null ? null : this.getCurrentLookAndFeelReference();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : ourPatchableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
        JBUIScale.setUserScaleFactor(JBUIScale.getFontScale(JBFont.label().getSize()));
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        LafManager.LafReference lf = this.myCurrentLaf == null ? null : this.getCurrentLookAndFeelReference();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap();
            for (String resource : ourPatchableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private static void updateUI(Window window) {
        Window[] children2;
        IJSwingUtilities.updateComponentTreeUI(window);
        for (Window w : children2 = window.getOwnedWindows()) {
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }

    @Override
    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    private static void repaintUI(Window window) {
        Window[] children2;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children2 = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 65), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 65), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 130), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 130), "cut-to-clipboard");
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    public static void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        if (defaults == null) {
            LafManagerImpl.$$$reportNull$$$0(12);
        }
        if (uiFont == null) {
            LafManagerImpl.$$$reportNull$$$0(13);
        }
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        if (!SystemInfo.isMac) {
            defaults.put("PasswordField.font", monoFont);
        }
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    public static LafManagerImpl getTestInstance() {
        if (ourTestInstance == null) {
            ourTestInstance = new LafManagerImpl();
        }
        return ourTestInstance;
    }

    static {
        ourLafClassesAliases.put("idea.dark.laf.classname", DarculaLookAndFeelInfo.CLASS_NAME);
        lafNameOrder.put("IntelliJ Light", 0);
        lafNameOrder.put("macOS Light", 1);
        lafNameOrder.put("Windows 10 Light", 1);
        lafNameOrder.put("Darcula", 2);
        lafNameOrder.put("High contrast", 3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookAndFeelInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiDefaults";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLafList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledLookAndFeels";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sortThemes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLafManagerListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeLafManagerListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLaf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLookAndFeel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setLookAndFeelImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixMenuIssues";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initFontDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LafProviderEPListener
    implements ExtensionPointListener<LafProvider> {
        private LafProviderEPListener() {
        }

        @Override
        public void extensionAdded(@NotNull LafProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension == null) {
                LafProviderEPListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                LafProviderEPListener.$$$reportNull$$$0(1);
            }
            PluggableLafInfo newLaf = extension.getLookAndFeelInfo();
            List lafList = (List)LafManagerImpl.this.myLaFs.getValue();
            for (UIManager.LookAndFeelInfo lafInfo : lafList) {
                if (!lafInfo.getName().equals(newLaf.getName()) || !lafInfo.getClassName().equals(newLaf.getClassName())) continue;
                return;
            }
            ArrayList<PluggableLafInfo> newLaFs = new ArrayList<PluggableLafInfo>(lafList.size() + 1);
            newLaFs.addAll(lafList);
            newLaFs.add(newLaf);
            LafManagerImpl.sortThemes(newLaFs);
            LafManagerImpl.this.myLaFs.setValue(newLaFs);
            if (LafManagerImpl.this.myLafComboBoxModel != null) {
                LafManagerImpl.this.myLafComboBoxModel.replaceAll(LafManagerImpl.this.getLafReferences());
            }
            if (!LafManagerImpl.this.myThemesInUpdatedPlugin.contains(newLaf.getName())) {
                LafManagerImpl.this.setCurrentLookAndFeel(newLaf);
                if (LafManagerImpl.this.myLafComboBoxModel != null) {
                    LafManagerImpl.this.myLafComboBoxModel.setSelectedItem(newLaf);
                }
                JBColor.setDark(newLaf.isDark());
                LafManagerImpl.this.updateUI();
            }
        }

        @Override
        public void extensionRemoved(@NotNull LafProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension == null) {
                LafProviderEPListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                LafProviderEPListener.$$$reportNull$$$0(3);
            }
            UIManager.LookAndFeelInfo switchLafTo = null;
            ArrayList<UIManager.LookAndFeelInfo> list2 = new ArrayList<UIManager.LookAndFeelInfo>();
            PluggableLafInfo removedLafInfo = extension.getLookAndFeelInfo();
            for (UIManager.LookAndFeelInfo lafInfo : LafManagerImpl.this.getInstalledLookAndFeels()) {
                PluggableLafInfo pluggableLafInfo;
                if (lafInfo instanceof PluggableLafInfo && StringUtil.equals((pluggableLafInfo = (PluggableLafInfo)lafInfo).getName(), removedLafInfo.getName()) && StringUtil.equals(pluggableLafInfo.getClassName(), removedLafInfo.getClassName())) {
                    if (lafInfo == LafManagerImpl.this.getCurrentLookAndFeel()) {
                        switchLafTo = pluggableLafInfo.isDark() ? LafManagerImpl.this.myDefaultDarkTheme : LafManagerImpl.this.myDefaultLightTheme;
                        continue;
                    }
                    if (!LafManagerImpl.this.myUpdatingPlugin) continue;
                    LafManagerImpl.this.myThemesInUpdatedPlugin.add(pluggableLafInfo.getName());
                    continue;
                }
                list2.add(lafInfo);
            }
            LafManagerImpl.this.myLaFs.setValue(list2);
            if (LafManagerImpl.this.myLafComboBoxModel != null) {
                LafManagerImpl.this.myLafComboBoxModel.replaceAll(LafManagerImpl.this.getLafReferences());
            }
            if (switchLafTo != null) {
                LafManagerImpl.this.setLookAndFeelImpl(switchLafTo, false, true);
                if (LafManagerImpl.this.myLafComboBoxModel != null) {
                    LafManagerImpl.this.myLafComboBoxModel.setSelectedItem(switchLafTo);
                }
                JBColor.setDark(switchLafTo == LafManagerImpl.this.myDefaultDarkTheme);
                LafManagerImpl.this.updateUI();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$LafProviderEPListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class UIThemeEPListener
    implements ExtensionPointListener<UIThemeProvider> {
        private UIThemeEPListener() {
        }

        @Override
        public void extensionAdded(@NotNull UIThemeProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
            if (provider == null) {
                UIThemeEPListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                UIThemeEPListener.$$$reportNull$$$0(1);
            }
            for (UIManager.LookAndFeelInfo feel : LafManagerImpl.this.getInstalledLookAndFeels()) {
                if (!(feel instanceof UIThemeBasedLookAndFeelInfo) || !((UIThemeBasedLookAndFeelInfo)feel).getTheme().getId().equals(provider.id)) continue;
                return;
            }
            UITheme theme = provider.createTheme();
            if (theme == null) {
                return;
            }
            ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).handleThemeAdded(theme);
            List lafList = (List)LafManagerImpl.this.myLaFs.getValue();
            ArrayList<UIThemeBasedLookAndFeelInfo> newLaFs = new ArrayList<UIThemeBasedLookAndFeelInfo>(lafList.size() + 1);
            newLaFs.addAll(lafList);
            UIThemeBasedLookAndFeelInfo newTheme = new UIThemeBasedLookAndFeelInfo(theme);
            newLaFs.add(newTheme);
            LafManagerImpl.sortThemes(newLaFs);
            LafManagerImpl.this.myLaFs.setValue(newLaFs);
            if (LafManagerImpl.this.myLafComboBoxModel != null) {
                LafManagerImpl.this.myLafComboBoxModel.replaceAll(LafManagerImpl.this.getLafReferences());
            }
            if (!LafManagerImpl.this.myThemesInUpdatedPlugin.contains(theme.getId())) {
                LafManagerImpl.this.setCurrentLookAndFeel(newTheme);
                if (LafManagerImpl.this.myLafComboBoxModel != null) {
                    LafManagerImpl.this.myLafComboBoxModel.setSelectedItem(LafManagerImpl.createLafReference(newTheme));
                }
                JBColor.setDark(newTheme.getTheme().isDark());
                LafManagerImpl.this.updateUI();
            }
        }

        @Override
        public void extensionRemoved(@NotNull UIThemeProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
            if (provider == null) {
                UIThemeEPListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                UIThemeEPListener.$$$reportNull$$$0(3);
            }
            UIManager.LookAndFeelInfo switchLafTo = null;
            ArrayList<UIManager.LookAndFeelInfo> list2 = new ArrayList<UIManager.LookAndFeelInfo>();
            for (UIManager.LookAndFeelInfo lookAndFeel : LafManagerImpl.this.getInstalledLookAndFeels()) {
                UITheme theme;
                if (lookAndFeel instanceof UIThemeBasedLookAndFeelInfo && (theme = ((UIThemeBasedLookAndFeelInfo)lookAndFeel).getTheme()).getId().equals(provider.id)) {
                    if (lookAndFeel == LafManagerImpl.this.getCurrentLookAndFeel()) {
                        switchLafTo = theme.isDark() ? LafManagerImpl.this.myDefaultDarkTheme : LafManagerImpl.this.myDefaultLightTheme;
                    } else if (LafManagerImpl.this.myUpdatingPlugin) {
                        LafManagerImpl.this.myThemesInUpdatedPlugin.add(theme.getId());
                    }
                    ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).handleThemeRemoved(theme);
                    continue;
                }
                list2.add(lookAndFeel);
            }
            LafManagerImpl.this.myLaFs.setValue(list2);
            if (LafManagerImpl.this.myLafComboBoxModel != null) {
                LafManagerImpl.this.myLafComboBoxModel.replaceAll(LafManagerImpl.this.getLafReferences());
            }
            if (switchLafTo != null) {
                LafManagerImpl.this.setLookAndFeelImpl(switchLafTo, false, true);
                if (LafManagerImpl.this.myLafComboBoxModel != null) {
                    LafManagerImpl.this.myLafComboBoxModel.setSelectedItem(LafManagerImpl.createLafReference(switchLafTo));
                }
                JBColor.setDark(switchLafTo == LafManagerImpl.this.myDefaultDarkTheme);
                LafManagerImpl.this.updateUI();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/laf/LafManagerImpl$UIThemeEPListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultMenuArrowIcon
    extends MenuArrowIcon {
        private static final BooleanSupplier dark = () -> ColorUtil.isDark(UIManager.getColor("MenuItem.selectionBackground"));

        private DefaultMenuArrowIcon() {
            super(AllIcons.Icons.Ide.NextStep, dark.getAsBoolean() ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep, IconLoader.getDisabledIcon(AllIcons.Icons.Ide.NextStep));
        }
    }

    private static class OurPopupFactory
    extends PopupFactory {
        public static final int WEIGHT_LIGHT = 0;
        public static final int WEIGHT_MEDIUM = 1;
        public static final int WEIGHT_HEAVY = 2;
        private final PopupFactory myDelegate;

        OurPopupFactory(PopupFactory delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int x, int y) {
            boolean isHeavyWeightPopup;
            Point point = OurPopupFactory.fixPopupLocation(contents, x, y);
            int popupType = PopupUtil.getPopupType(this);
            if (popupType == 2 && OurHeavyWeightPopup.isEnabled()) {
                return new OurHeavyWeightPopup(owner, contents, point.x, point.y);
            }
            if (popupType >= 0) {
                PopupUtil.setPopupType(this.myDelegate, popupType);
            }
            Popup popup2 = this.myDelegate.getPopup(owner, contents, point.x, point.y);
            final Window window = ComponentUtil.getWindow(contents);
            final String cleanupKey = "LafManagerImpl.rootPaneCleanup";
            boolean bl = isHeavyWeightPopup = window instanceof RootPaneContainer && window != ComponentUtil.getWindow(owner);
            if (isHeavyWeightPopup) {
                UIUtil.markAsTypeAheadAware(window);
                window.setMinimumSize(null);
            }
            if (isHeavyWeightPopup && ((RootPaneContainer)((Object)window)).getRootPane().getClientProperty(cleanupKey) == null) {
                final JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                rootPane.setGlassPane(new IdeGlassPaneImpl(rootPane, false));
                rootPane.putClientProperty(LafManagerImpl.WINDOW_ALPHA, Float.valueOf(1.0f));
                rootPane.putClientProperty(cleanupKey, cleanupKey);
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        if (PopupUtil.getPopupContainerFor(rootPane) != null) {
                            window.removeWindowListener(this);
                            rootPane.putClientProperty(cleanupKey, null);
                        }
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        window.removeWindowListener(this);
                        rootPane.putClientProperty(cleanupKey, null);
                        DialogWrapper.cleanupRootPane(rootPane);
                        DialogWrapper.cleanupWindowListeners(window);
                    }
                });
            }
            return popup2;
        }

        private static Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo info;
            if (!(contents instanceof JToolTip)) {
                return new Point(x, y);
            }
            try {
                info = MouseInfo.getPointerInfo();
            }
            catch (InternalError e) {
                return new Point(x, y);
            }
            int deltaY = 0;
            if (info != null) {
                Point mouse = info.getLocation();
                deltaY = mouse.y - y;
            }
            Dimension size = contents.getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y), size);
            ScreenUtil.moveRectangleToFitTheScreen(rec);
            if (rec.y < y) {
                rec.y += deltaY;
            }
            return rec.getLocation();
        }
    }
}

