/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.util.SVGLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class UIThemeBasedLookAndFeelInfo
extends UIManager.LookAndFeelInfo {
    private static final String RELAUNCH_PROPERTY = "UITheme.relaunch";
    private final UITheme myTheme;
    private boolean myInitialised;

    public UIThemeBasedLookAndFeelInfo(UITheme theme) {
        super(theme.getName(), theme.isDark() ? DarculaLaf.class.getName() : IntelliJLaf.class.getName());
        this.myTheme = theme;
    }

    public UITheme getTheme() {
        return this.myTheme;
    }

    public void installTheme(UIDefaults defaults, boolean lockEditorScheme) {
        SVGLoader.SvgElementColorPatcherProvider colorPatcher;
        this.myTheme.applyProperties(defaults);
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.installPathPatcher(patcher);
        }
        if ((colorPatcher = this.myTheme.getColorPatcher()) != null) {
            SVGLoader.setColorPatcherProvider(colorPatcher);
        }
        this.installBackgroundImage();
        if (!lockEditorScheme) {
            this.installEditorScheme();
        }
        this.myInitialised = true;
    }

    public boolean isInitialised() {
        return this.myInitialised;
    }

    protected void installEditorScheme() {
        String name = this.myTheme.getEditorSchemeName();
        if (name != null) {
            EditorColorsManager cm = EditorColorsManager.getInstance();
            EditorColorsScheme scheme = cm.getScheme(name);
            if (scheme != null) {
                cm.setGlobalScheme(scheme);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                String themeName = this.myTheme.getEditorSchemeName();
                if (StringUtil.isNotEmpty(themeName)) {
                    EditorColorsScheme scheme;
                    EditorColorsManager cm = EditorColorsManager.getInstance();
                    EditorColorsScheme globalScheme = cm.getGlobalScheme();
                    PropertiesComponent properties = PropertiesComponent.getInstance();
                    EditorColorsScheme baseScheme = cm.getScheme(SchemeManager.getBaseName(globalScheme));
                    if (!properties.getBoolean(RELAUNCH_PROPERTY) && !SchemeManager.getBaseName(globalScheme).equals(themeName) && "Default".equals(baseScheme.getName()) && (scheme = cm.getScheme(themeName)) != null) {
                        cm.setGlobalScheme(scheme);
                    }
                    properties.setValue(RELAUNCH_PROPERTY, true);
                }
            });
        }
    }

    private void installBackgroundImage() {
        block27: {
            try {
                Object path2;
                Map<String, Object> background = this.myTheme.getBackground();
                if (background == null || !((path2 = background.get("image")) instanceof String)) break block27;
                File tmpImage = FileUtil.createTempFile("ijBackgroundImage", path2.toString().substring(((String)path2).lastIndexOf(".")), true);
                URL resource = this.myTheme.getProviderClassLoader().getResource((String)path2);
                if (resource != null) {
                    try (InputStream input = this.myTheme.getProviderClassLoader().getResourceAsStream((String)path2);
                         FileOutputStream output = new FileOutputStream(tmpImage);){
                        FileUtil.copy(input, output);
                    }
                    String image = tmpImage.getPath();
                    Object transparency = background.get("transparency");
                    String alpha = String.valueOf(transparency instanceof Integer ? (Integer)transparency : 15);
                    String fill = UIThemeBasedLookAndFeelInfo.parseEnumValue(background.get("fill"), IdeBackgroundUtil.Fill.SCALE);
                    String anchor2 = UIThemeBasedLookAndFeelInfo.parseEnumValue(background.get("anchor"), IdeBackgroundUtil.Anchor.CENTER);
                    String spec = StringUtil.join(new String[]{image, alpha, fill, anchor2}, ",");
                    String currentSpec = PropertiesComponent.getInstance().getValue("idea.background.editor");
                    PropertiesComponent.getInstance().setValue("old.idea.background.editor", currentSpec);
                    PropertiesComponent.getInstance().setValue("idea.background.editor", spec);
                    IdeBackgroundUtil.repaintAllWindows();
                    break block27;
                }
                throw new IllegalArgumentException("Can't load background: " + path2);
            }
            catch (IOException e) {
                Logger.getInstance(this.getClass()).error(e);
            }
        }
    }

    private static <T extends Enum<T>> String parseEnumValue(Object value2, T defaultValue) {
        if (value2 instanceof String) {
            String name = StringUtil.toUpperCase((String)value2);
            for (Enum t : (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!t.name().equals(name)) continue;
                return StringUtil.toLowerCase(value2.toString());
            }
        }
        return StringUtil.toLowerCase(defaultValue.name());
    }

    public void dispose() {
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.removePathPatcher(patcher);
        }
        SVGLoader.setColorPatcherProvider(null);
        PropertiesComponent propertyManager = PropertiesComponent.getInstance();
        String value2 = propertyManager.getValue("old.idea.background.editor");
        propertyManager.unsetValue("old.idea.background.editor");
        if (value2 == null) {
            if (this.myTheme.getBackground() != null) {
                propertyManager.unsetValue("idea.background.editor");
            }
        } else {
            propertyManager.setValue("idea.background.editor", value2);
        }
    }
}

