/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboPopup;

public class DarculaPopupMenuBorder
extends AbstractBorder
implements UIResource {
    private static final JBInsets DEFAULT_INSETS = JBUI.insets(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(JBColor.namedColor("Menu.borderColor", new JBColor(Gray.xCD, Gray.x51)));
            g2.fill(DarculaPopupMenuBorder.getBorderShape(c, new Rectangle(x, y, width, height)));
        }
        finally {
            g2.dispose();
        }
    }

    private static Shape getBorderShape(Component c, Rectangle rect) {
        Path2D.Float border = new Path2D.Float(0);
        if (DarculaPopupMenuBorder.isComboPopup(c) && ((BasicComboPopup)c).getClientProperty("JComboBox.isCellEditor") == Boolean.TRUE) {
            JBInsets.removeFrom(rect, (Insets)JBInsets.create(0, 1));
        }
        border.append(rect, false);
        Rectangle innerRect = new Rectangle(rect);
        JBInsets.removeFrom(innerRect, (Insets)JBUI.insets(JBUI.getInt("PopupMenu.borderWidth", 1)));
        border.append(innerRect, false);
        return border;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaPopupMenuBorder.isComboPopup(c)) {
            return JBInsets.create(1, 2).asUIResource();
        }
        return JBUI.insets("PopupMenu.borderInsets", DEFAULT_INSETS).asUIResource();
    }

    protected static boolean isComboPopup(Component c) {
        return "ComboPopup.popup".equals(c.getName()) && c instanceof BasicComboPopup;
    }
}

