/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarculaTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTextFieldUI();
    }

    @Override
    protected int getMinimumHeight(int textHeight) {
        Insets i = this.getComponent().getInsets();
        JTextComponent c = this.getComponent();
        int minHeight = (DarculaUIUtil.isCompact(c) ? DarculaUIUtil.COMPACT_HEIGHT.get() : DarculaUIUtil.MINIMUM_HEIGHT.get()) + i.top + i.bottom;
        return DarculaEditorTextFieldBorder.isComboBoxEditor(c) || ComponentUtil.getParentOfType(JSpinner.class, c) != null ? textHeight : minHeight;
    }

    @Override
    protected int getClearIconPreferredSpace() {
        return super.getClearIconPreferredSpace() - this.getClearIconGap();
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            Container parent = component2.getParent();
            if (parent != null && component2.isOpaque()) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
            }
            if (component2.getBorder() instanceof DarculaTextBorder && !DarculaUIUtil.isTableCellEditor(component2)) {
                this.paintDarculaBackground(g, component2);
            } else if (component2.isOpaque()) {
                super.paintBackground(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintDarculaBackground(Graphics g, JTextComponent component2) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(component2.getSize());
        JBInsets.removeFrom(r, DarculaUIUtil.paddings());
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            if (component2.isEnabled() && component2.isEditable()) {
                float arc = DarculaTextFieldUI.isSearchField(component2) ? DarculaUIUtil.COMPONENT_ARC.getFloat() : 0.0f;
                float bw = this.bw();
                g2.setColor(component2.getBackground());
                g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Insets getDefaultMargins() {
        JTextComponent c = this.getComponent();
        return DarculaUIUtil.isCompact(c) || DarculaUIUtil.isTableCellEditor(c) ? JBInsets.create(0, 3) : JBInsets.create(2, 6);
    }

    protected float bw() {
        return DarculaUIUtil.BW.getFloat();
    }
}

