/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithPopupHandlerUI
extends BasicTextFieldUI
implements Condition {
    private static final String DOCUMENT = "document";
    private static final String MONOSPACED = "monospaced";
    private static final String VARIANT = "JTextField.variant";
    private static final String POPUP = "JTextField.Search.FindPopup";
    private static final String INPLACE_HISTORY = "JTextField.Search.InplaceHistory";
    private static final String ON_CLEAR = "JTextField.Search.CancelAction";
    private static final Map<AttributedCharacterIterator.Attribute, Integer> DISABLE_KERNING = Collections.singletonMap(TextAttribute.KERNING, null);
    protected final LinkedHashMap<String, IconHolder> icons = new LinkedHashMap();
    private final Handler handler = new Handler();
    private boolean monospaced;
    private Object variant;
    private int cursor;

    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        return clickable ? AllIcons.Actions.SearchWithHistory : AllIcons.Actions.Search;
    }

    protected int getSearchIconPreferredSpace() {
        Icon icon2 = this.getSearchIcon(true, true);
        return icon2 == null ? 0 : icon2.getIconWidth() + this.getSearchIconGap();
    }

    protected int getSearchIconGap() {
        return JBUIScale.scale(2);
    }

    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        return !clickable ? null : (hovered ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
    }

    protected int getClearIconPreferredSpace() {
        Icon icon2 = this.getClearIcon(true, true);
        return icon2 == null ? 0 : icon2.getIconWidth() + this.getClearIconGap();
    }

    protected int getClearIconGap() {
        return JBUIScale.scale(2);
    }

    protected boolean hasText() {
        JTextComponent component2 = this.getComponent();
        return component2 != null && !StringUtil.isEmpty(component2.getText());
    }

    private void updateIconsLayout(Rectangle bounds2) {
        JTextComponent c = this.getComponent();
        JBInsets margin = ComponentUtil.getParentOfType(JComboBox.class, c) != null || ComponentUtil.getParentOfType(JSpinner.class, c) != null || UIUtil.isClientPropertyTrue(c, "TextFieldWithoutMargins") ? JBUI.emptyInsets() : this.getDefaultMargins();
        JBInsets.removeFrom(bounds2, c.getInsets());
        JBInsets.removeFrom(bounds2, (Insets)margin);
        for (IconHolder holder : this.icons.values()) {
            int gap = holder.extension.getIconGap();
            if (holder.extension.isIconBeforeText()) {
                int offset = holder.extension.getAfterIconOffset();
                holder.bounds.x = bounds2.x;
                int extensionWidth = holder.bounds.width + gap + offset;
                bounds2.x += extensionWidth;
                bounds2.width -= extensionWidth;
                margin.left += extensionWidth;
            } else {
                holder.bounds.x = bounds2.x + bounds2.width - holder.bounds.width;
                int extensionWidth = holder.bounds.width + gap;
                bounds2.width -= extensionWidth;
                margin.right += extensionWidth;
            }
            int top = (bounds2.height - holder.bounds.height) / 2;
            if (top > gap) {
                boolean multiline;
                JTextComponent component2 = this.getComponent();
                boolean bl = multiline = component2 != null && !Boolean.TRUE.equals(component2.getDocument().getProperty("filterNewlines"));
                if (multiline) {
                    top = gap;
                }
            }
            holder.bounds.y = bounds2.y + top;
        }
        c.setMargin(margin);
    }

    protected SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(0);
        }
        return null;
    }

    protected void showSearchPopup() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SystemInfo.isMacOSCatalina) {
            JTextComponent component2 = this.getComponent();
            component2.setFont(TextFieldWithPopupHandlerUI.disableKerning(component2.getFont()));
        }
    }

    @NotNull
    private static Font disableKerning(@NotNull Font oldFont) {
        if (oldFont == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(1);
        }
        Font newFont = oldFont.deriveFont(DISABLE_KERNING);
        Font font = oldFont instanceof UIResource ? new FontUIResource(newFont) : newFont;
        if (font == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(2);
        }
        return font;
    }

    @Override
    protected void installListeners() {
        JTextComponent component2 = this.getComponent();
        this.handler.installListener(component2.getDocument());
        component2.addPropertyChangeListener(this.handler);
        component2.addMouseMotionListener(this.handler);
        component2.addMouseListener(this.handler);
        component2.addFocusListener(this.handler);
        this.setVariant(component2.getClientProperty(VARIANT));
        this.setMonospaced(component2.getClientProperty(MONOSPACED));
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent component2 = this.getComponent();
        component2.removeFocusListener(this.handler);
        component2.removeMouseListener(this.handler);
        component2.removeMouseMotionListener(this.handler);
        component2.removePropertyChangeListener(this.handler);
        this.handler.uninstallListener(component2.getDocument());
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    protected Caret createCaret() {
        return new MouseDragAwareCaret();
    }

    public boolean value(Object o) {
        MouseEvent me;
        if (o instanceof MouseEvent && this.getActionUnder((me = (MouseEvent)o).getPoint()) != null) {
            if (me.getID() == 500) {
                SwingUtilities.invokeLater(() -> this.handler.mouseClicked(me));
            }
            return true;
        }
        return false;
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && "search".equals(((JTextField)c).getClientProperty(VARIANT));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return TextFieldWithPopupHandlerUI.isSearchField(c) && ((JTextField)c).getClientProperty(POPUP) instanceof JPopupMenu;
    }

    @Nullable
    public static AbstractAction getNewLineAction(Component c) {
        if (!TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return null;
        }
        Object action2 = ((JTextField)c).getClientProperty("JTextField.Search.NewLineAction");
        return action2 instanceof AbstractAction ? (AbstractAction)action2 : null;
    }

    @NotNull
    public Point getExtensionIconLocation(@NotNull String extensionName) {
        IconHolder iconHolder;
        if (extensionName == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(3);
        }
        if ((iconHolder = this.icons.get(extensionName)) == null) {
            throw new IllegalArgumentException("The " + extensionName + " extension does not exist in this text field");
        }
        Point point = iconHolder.bounds.getLocation();
        if (point == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(4);
        }
        return point;
    }

    @NotNull
    public Rectangle getExtensionIconBounds(@NotNull ExtendableTextComponent.Extension extension) {
        if (extension == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(5);
        }
        for (IconHolder holder : this.icons.values()) {
            if (holder.extension != extension) continue;
            return new Rectangle(holder.bounds);
        }
        throw new IllegalArgumentException("The " + extension + " extension does not exist in this text field");
    }

    @Override
    public String getToolTipText(JTextComponent component2, Point point) {
        if (!this.icons.isEmpty() && component2 != null && component2.isEnabled()) {
            for (IconHolder holder : this.icons.values()) {
                if (!holder.bounds.contains(point)) continue;
                return holder.extension.getTooltip();
            }
        }
        return super.getToolTipText(component2, point);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        if (size != null) {
            this.updatePreferredSize(c, size);
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (size != null) {
            int columns;
            JTextComponent component2 = this.getComponent();
            int n = columns = component2 instanceof JTextField ? ((JTextField)component2).getColumns() : 0;
            if (columns != 0) {
                Insets insets = component2.getInsets();
                FontMetrics fm = component2.getFontMetrics(component2.getFont());
                size.width = columns * fm.charWidth('m') + insets.left + insets.right;
            }
            this.updatePreferredSize(component2, size);
        }
        return size;
    }

    protected void updatePreferredSize(JComponent c, Dimension size) {
        if (!TextFieldWithPopupHandlerUI.isUnderComboBox(c)) {
            JBInsets.addTo(size, this.getDefaultMargins());
            size.width += this.icons.values().stream().mapToInt(h -> h.extension.getPreferredSpace()).sum();
            size.height = Math.max(size.height, this.getMinimumHeight(size.height));
            size.width = Math.max(size.width, DarculaUIUtil.MINIMUM_WIDTH.get());
        }
    }

    private static boolean isUnderComboBox(JComponent c) {
        Container parent = c.getParent();
        return parent instanceof JComboBox || parent != null && parent.getParent() instanceof JComboBox;
    }

    protected int getMinimumHeight(int textHeight) {
        return 0;
    }

    protected Insets getDefaultMargins() {
        return JBUI.emptyInsets();
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        JTextComponent c = this.getComponent();
        Rectangle bounds2 = new Rectangle(c.getSize());
        this.updateIconsLayout(bounds2);
        return bounds2;
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent component2 = this.getComponent();
        if (!component2.isOpaque()) {
            this.paintBackground(g);
        }
        Shape clip = g.getClip();
        super.paintSafely(g);
        if (!this.icons.isEmpty()) {
            g.setClip(clip);
            for (IconHolder holder : this.icons.values()) {
                if (holder.icon == null) continue;
                holder.icon.paintIcon(component2, g, holder.bounds.x, holder.bounds.y);
            }
        }
    }

    @Override
    public int viewToModel(JTextComponent tc, Point pt, Position.Bias[] biasReturn) {
        return this.icons.values().stream().anyMatch(p -> p.bounds.contains(pt)) ? -1 : super.viewToModel(tc, pt, biasReturn);
    }

    private void repaint(boolean invalid) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            if (invalid) {
                component2.revalidate();
            }
            component2.repaint();
        }
    }

    private void updateIcon(IconHolder holder) {
        Icon icon2;
        if (holder != null && holder.icon != (icon2 = holder.extension.getIcon(holder.hovered))) {
            this.repaint(holder.setIcon(icon2));
        }
    }

    private void handleMouse(MouseEvent event, boolean run2) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            Runnable action2;
            IconHolder result2 = this.getIconHolder(component2, event.getX(), event.getY());
            Runnable runnable2 = action2 = result2 == null ? null : result2.extension.getActionOnClick();
            if (action2 == null) {
                this.setCursor(2);
            } else {
                this.setCursor(12);
                if (run2) {
                    action2.run();
                    event.consume();
                }
            }
        }
    }

    @Nullable
    private IconHolder getIconHolder(@NotNull JTextComponent component2, int x, int y) {
        if (component2 == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(6);
        }
        boolean invalid = false;
        boolean repaint = false;
        IconHolder result2 = null;
        for (IconHolder holder : this.icons.values()) {
            Icon icon2;
            boolean bl = holder.hovered = component2.isEnabled() && holder.bounds.contains(x, y);
            if (holder.hovered) {
                result2 = holder;
            }
            if (holder.icon == (icon2 = holder.extension.getIcon(holder.hovered))) continue;
            if (holder.setIcon(icon2)) {
                invalid = true;
            }
            repaint = true;
        }
        if (repaint) {
            this.repaint(invalid);
        }
        return result2;
    }

    private void setCursor(int cursor) {
        if (this.cursor != cursor) {
            this.cursor = cursor;
            JTextComponent component2 = this.getComponent();
            if (component2 != null) {
                component2.setCursor(Cursor.getPredefinedCursor(cursor));
            }
        }
    }

    private void setVariant(Object variant) {
        if (!Objects.equals(this.variant, variant)) {
            this.variant = variant;
            this.icons.clear();
            if ("extendable".equals(variant)) {
                JTextComponent component2 = this.getComponent();
                if (component2 instanceof ExtendableTextComponent) {
                    ExtendableTextComponent field = (ExtendableTextComponent)((Object)component2);
                    for (ExtendableTextComponent.Extension extension : field.getExtensions()) {
                        if (extension == null) continue;
                        this.addExtension(extension);
                    }
                }
            } else if ("search".equals(variant)) {
                Object extension = this.getComponent().getClientProperty("search.extension");
                if (extension instanceof ExtendableTextComponent.Extension) {
                    this.addExtension((ExtendableTextComponent.Extension)extension);
                }
                this.addExtension(new SearchExtension());
                this.addExtension(new ClearExtension());
            }
        }
        this.updateIconsLayout(new Rectangle(this.getComponent().getSize()));
    }

    protected void addExtension(ExtendableTextComponent.Extension extension) {
        this.icons.put(extension.toString(), new IconHolder(extension));
    }

    private void setMonospaced(Object value2) {
        boolean monospaced = Boolean.TRUE.equals(value2);
        if (this.monospaced != monospaced) {
            Font font;
            this.monospaced = monospaced;
            JTextComponent component2 = this.getComponent();
            if (component2 != null && ((font = component2.getFont()) == null || font instanceof UIResource)) {
                font = UIManager.getFont(this.getPropertyPrefix() + ".font");
                component2.setFont(!monospaced ? (!SystemInfo.isMacOSCatalina ? font : TextFieldWithPopupHandlerUI.disableKerning(font)) : new FontUIResource(MONOSPACED, font.getStyle(), font.getSize()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFont";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "disableKerning";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionIconLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "disableKerning";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIconLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIconBounds";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIconHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MouseDragAwareCaret
    extends MarginAwareCaret {
        MouseDragAwareCaret() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getID() == 506 && !this.isMultiline(this.getComponent())) {
                boolean consumed = e.isConsumed();
                e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers() | e.getModifiersEx(), e.getX(), this.getComponent().getHeight() / 2, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (consumed) {
                    e.consume();
                }
            }
            super.mouseDragged(e);
        }

        public boolean isMultiline(JTextComponent component2) {
            return component2.getText().contains("\n") || component2 instanceof JTextArea && ((JTextArea)component2).getLineWrap();
        }
    }

    public static class MarginAwareCaret
    extends BasicTextUI.BasicCaret {
        @Override
        protected void adjustVisibility(Rectangle r) {
            Insets m = this.getComponent().getMargin();
            r.x -= m.left;
            r.width += m.left;
            super.adjustVisibility(r);
        }
    }

    private class ClearExtension
    implements ExtendableTextComponent.Extension {
        private ClearExtension() {
        }

        @Override
        public Icon getIcon(boolean hovered) {
            return TextFieldWithPopupHandlerUI.this.getClearIcon(hovered, TextFieldWithPopupHandlerUI.this.hasText());
        }

        @Override
        public int getPreferredSpace() {
            Icon icon2 = TextFieldWithPopupHandlerUI.this.getClearIcon(false, true);
            return icon2 != null ? this.getIconGap() + icon2.getIconWidth() : 0;
        }

        @Override
        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getClearIconGap();
        }

        @Override
        public Runnable getActionOnClick() {
            JTextComponent component2 = TextFieldWithPopupHandlerUI.this.getComponent();
            return component2 == null ? null : () -> {
                component2.setText(null);
                Object property = component2.getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                if (property instanceof ActionListener) {
                    ActionListener listener2 = (ActionListener)property;
                    listener2.actionPerformed(new ActionEvent(component2, 1001, "clear"));
                }
            };
        }

        public String toString() {
            return "clear";
        }
    }

    private final class SearchExtension
    implements ExtendableTextComponent.Extension {
        private final PopupState myPopupState = new PopupState();
        private Rectangle bounds;

        private SearchExtension() {
        }

        @Override
        public Icon getIcon(boolean hovered) {
            return TextFieldWithPopupHandlerUI.this.getSearchIcon(hovered, null != this.getActionOnClick());
        }

        @Override
        public int getAfterIconOffset() {
            Integer gap = (Integer)TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty("JTextField.Search.Gap");
            return gap == null ? 0 : gap;
        }

        @Override
        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getSearchIconGap();
        }

        @Override
        public boolean isIconBeforeText() {
            return true;
        }

        @Override
        public Runnable getActionOnClick() {
            JTextComponent component2 = TextFieldWithPopupHandlerUI.this.getComponent();
            Object property = component2 == null ? null : component2.getClientProperty(TextFieldWithPopupHandlerUI.POPUP);
            JPopupMenu popup2 = property instanceof JPopupMenu ? (JPopupMenu)property : null;
            return popup2 == null ? null : () -> {
                if (this.myPopupState.isRecentlyHidden()) {
                    return;
                }
                Rectangle editor = TextFieldWithPopupHandlerUI.this.getVisibleEditorRect();
                if (editor != null) {
                    popup2.addPopupMenuListener(this.myPopupState);
                    popup2.show(component2, this.bounds.x, editor.y + editor.height);
                }
            };
        }

        @Override
        public String getTooltip() {
            String prefix = null;
            if (UIUtil.getClientProperty((Object)TextFieldWithPopupHandlerUI.this.getComponent(), TextFieldWithPopupHandlerUI.INPLACE_HISTORY) != null) {
                prefix = "Recent Search";
            }
            if (this.getActionOnClick() != null) {
                prefix = "Search History";
            }
            return prefix == null ? null : prefix + " (" + KeymapUtil.getFirstKeyboardShortcutText("ShowSearchHistory") + ")";
        }

        public String toString() {
            return "search";
        }
    }

    public static final class IconHolder {
        public final Rectangle bounds = new Rectangle();
        public final ExtendableTextComponent.Extension extension;
        public boolean hovered;
        public Icon icon;

        private IconHolder(ExtendableTextComponent.Extension extension) {
            this.extension = extension;
            if (extension instanceof SearchExtension) {
                SearchExtension se = (SearchExtension)extension;
                se.bounds = this.bounds;
            }
            this.setIcon(extension.getIcon(false));
        }

        private boolean setIcon(Icon icon2) {
            int height;
            this.icon = icon2;
            int width = icon2 == null ? 0 : icon2.getIconWidth();
            int n = height = icon2 == null ? 0 : icon2.getIconHeight();
            if (this.bounds.width == width && this.bounds.height == height) {
                return false;
            }
            this.bounds.width = width;
            this.bounds.height = height;
            return true;
        }

        public boolean isClickable() {
            return null != this.extension.getActionOnClick();
        }
    }

    private final class Handler
    extends MouseAdapter
    implements DocumentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void installListener(Document document) {
            if (document != null) {
                document.addDocumentListener(this);
            }
        }

        private void uninstallListener(Document document) {
            if (document != null) {
                document.removeDocumentListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (TextFieldWithPopupHandlerUI.DOCUMENT.equals(event.getPropertyName())) {
                if (event.getOldValue() instanceof Document) {
                    this.uninstallListener((Document)event.getOldValue());
                }
                if (event.getNewValue() instanceof Document) {
                    this.installListener((Document)event.getNewValue());
                }
            } else if (TextFieldWithPopupHandlerUI.MONOSPACED.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setMonospaced(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.VARIANT.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setVariant(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.POPUP.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.updateIcon(TextFieldWithPopupHandlerUI.this.icons.get("search"));
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void focusLost(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                for (IconHolder holder : TextFieldWithPopupHandlerUI.this.icons.values()) {
                    TextFieldWithPopupHandlerUI.this.updateIcon(holder);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            } else if (TextFieldWithPopupHandlerUI.this.getComponent() != null && TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent())) {
                SearchAction action2 = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint());
                if (action2 == SearchAction.POPUP && !TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(TextFieldWithPopupHandlerUI.this.getComponent())) {
                    action2 = null;
                }
                TextFieldWithPopupHandlerUI.this.setCursor(action2 != null ? 12 : 2);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchAction action2;
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, true);
            } else if (TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent()) && (action2 = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint())) != null) {
                switch (action2) {
                    case POPUP: {
                        TextFieldWithPopupHandlerUI.this.showSearchPopup();
                        break;
                    }
                    case CLEAR: {
                        Object listener2 = TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                        if (listener2 instanceof ActionListener) {
                            ((ActionListener)listener2).actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        }
                        TextFieldWithPopupHandlerUI.this.getComponent().setText("");
                        break;
                    }
                    case NEWLINE: {
                        AbstractAction newLineAction = TextFieldWithPopupHandlerUI.getNewLineAction(TextFieldWithPopupHandlerUI.this.getComponent());
                        if (newLineAction == null) break;
                        newLineAction.actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        break;
                    }
                }
                e.consume();
            }
        }
    }

    public static enum SearchAction {
        POPUP,
        CLEAR,
        NEWLINE;

    }
}

