/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2020.2")
public class MacIntelliJComboBoxBorder
extends MacIntelliJTextBorder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            boolean focused = this.isFocused(c);
            if (!DarculaUIUtil.isTableCellEditor(c)) {
                g2.translate(x, y);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                Shape clip = g2.getClip();
                Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
                area.intersect(new Area(clip));
                g2.setClip(area);
                float arc = this.isRound(c) ? ARC.getFloat() : 0.0f;
                float bw = BW.getFloat();
                float lw = MacIntelliJComboBoxBorder.LW(g2);
                Path2D.Float border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Double(bw, bw, (float)width - bw * 2.0f, (float)height - bw * 2.0f, arc, arc), false);
                border.append(new RoundRectangle2D.Double(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
                g2.setColor(Gray.xBC);
                g2.fill(border);
                g2.setClip(clip);
                this.clipForBorder(c, g2, width, height);
                Object op = ((JComponent)c).getClientProperty("JComponent.outline");
                if (c.isEnabled() && op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, this.isSymmetric(), focused, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else if (focused) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, this.isSymmetric(), true, DarculaUIUtil.Outline.focus);
                }
            } else {
                DarculaUIUtil.paintCellEditorBorder(g2, c, new Rectangle(x, y, width, height), focused);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets(DarculaUIUtil.isTableCellEditor(c) ? 2 : 3).asUIResource();
    }

    @Override
    protected boolean isFocused(Component c) {
        if (c instanceof JComboBox) {
            JComboBox comboBox2 = (JComboBox)c;
            if (!comboBox2.isEnabled()) {
                return false;
            }
            if (comboBox2.isEditable()) {
                ComboBoxEditor ed = comboBox2.getEditor();
                Component editorComponent = ed.getEditorComponent();
                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                return focused != null && editorComponent != null && SwingUtilities.isDescendingFrom(focused, editorComponent);
            }
            return comboBox2.hasFocus();
        }
        return false;
    }

    boolean isRound(Component c) {
        return c instanceof JComboBox && !((JComboBox)c).isEditable();
    }

    @Override
    protected void clipForBorder(Component c, Graphics2D g2, int width, int height) {
        float lw = MacIntelliJComboBoxBorder.LW(g2);
        float bw = BW.getFloat();
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        RectangularShape innerShape = this.isRound(c) ? new RoundRectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f, bw + lw, bw + lw) : new Rectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f);
        area.subtract(new Area(innerShape));
        Area clip = new Area(g2.getClip());
        area.intersect(clip);
        g2.setClip(area);
    }

    @Override
    protected boolean isSymmetric() {
        return false;
    }
}

