/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.newItemPopup;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public class NewItemSimplePopupPanel
extends JBPanel
implements Disposable {
    protected final ExtendableTextField myTextField = this.createTextField();
    private JBPopup myErrorPopup;
    protected RelativePoint myErrorShowPoint;
    protected Consumer<? super InputEvent> myApplyAction;

    public NewItemSimplePopupPanel() {
        super(new BorderLayout());
        this.add((Component)this.myTextField, "North");
        this.myErrorShowPoint = new RelativePoint(this.myTextField, new Point(0, this.myTextField.getHeight()));
    }

    public void setApplyAction(@NotNull Consumer<? super InputEvent> applyAction) {
        if (applyAction == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(0);
        }
        this.myApplyAction = applyAction;
    }

    public void setError(String error) {
        this.myTextField.putClientProperty("JComponent.outline", error != null ? "error" : null);
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose(this.myErrorPopup);
        }
        if (error == null) {
            return;
        }
        ComponentPopupBuilder popupBuilder = ComponentValidator.createPopupBuilder(new ValidationInfo(error, this.myTextField), errorHint -> {
            Insets insets = this.myTextField.getInsets();
            Dimension hintSize = errorHint.getPreferredSize();
            Point point = new Point(0, insets.top - JBUIScale.scale(6) - hintSize.height);
            this.myErrorShowPoint = new RelativePoint(this.myTextField, point);
        }).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).addUserData("SIMPLE_WINDOW");
        this.myErrorPopup = popupBuilder.createPopup();
        this.myErrorPopup.show(this.myErrorShowPoint);
    }

    @Override
    public void dispose() {
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose(this.myErrorPopup);
        }
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    @NotNull
    protected ExtendableTextField createTextField() {
        ExtendableTextField res2 = new ExtendableTextField();
        Dimension minSize = res2.getMinimumSize();
        Dimension prefSize = res2.getPreferredSize();
        minSize.height = JBUIScale.scale(28);
        prefSize.height = JBUIScale.scale(28);
        res2.setMinimumSize(minSize);
        res2.setPreferredSize(prefSize);
        res2.setColumns(30);
        Border border = JBUI.Borders.customLine(JBUI.CurrentTheme.NewClassDialog.bordersColor(), 1, 0, 0, 0);
        ErrorBorder errorBorder = new ErrorBorder(res2.getBorder());
        res2.setBorder(JBUI.Borders.merge(border, errorBorder, false));
        res2.setBackground(JBUI.CurrentTheme.NewClassDialog.searchFieldBackground());
        res2.putClientProperty("StatusVisibleFunction", field -> field.getText().isEmpty());
        res2.getEmptyText().setText(IdeBundle.message("action.create.new.class.name.field", new Object[0]));
        res2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && NewItemSimplePopupPanel.this.myApplyAction != null) {
                    NewItemSimplePopupPanel.this.myApplyAction.consume(e);
                }
            }
        });
        res2.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                NewItemSimplePopupPanel.this.setError(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel$2", "textChanged"));
            }
        });
        ExtendableTextField extendableTextField = res2;
        if (extendableTextField == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(1);
        }
        return extendableTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setApplyAction";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorBorder
    implements Border {
        private final Border errorDelegateBorder;

        private ErrorBorder(Border delegate) {
            this.errorDelegateBorder = delegate;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (ErrorBorder.checkError(c)) {
                this.errorDelegateBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return ErrorBorder.checkError(c) ? this.errorDelegateBorder.getBorderInsets(c) : JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static boolean checkError(Component c) {
            Object outlineObj = ((JComponent)c).getClientProperty("JComponent.outline");
            if (outlineObj == null) {
                return false;
            }
            DarculaUIUtil.Outline outline = outlineObj instanceof DarculaUIUtil.Outline ? (DarculaUIUtil.Outline)((Object)outlineObj) : DarculaUIUtil.Outline.valueOf(outlineObj.toString());
            return outline == DarculaUIUtil.Outline.error || outline == DarculaUIUtil.Outline.warning;
        }
    }
}

