/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.openapi.util.Comparing;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OptionDescription
implements Comparable<OptionDescription> {
    private final String myOption;
    private final String myHit;
    private final String myPath;
    private final String myConfigurableId;
    private final String myGroupName;

    public OptionDescription(String hit) {
        this(null, hit, null);
    }

    public OptionDescription(String option2, String hit, String path2) {
        this(option2, null, hit, path2);
    }

    public OptionDescription(String option2, String configurableId, String hit, String path2) {
        this(option2, configurableId, hit, path2, null);
    }

    public OptionDescription(String option2, String configurableId, String hit, String path2, String groupName) {
        this.myOption = option2;
        this.myHit = hit;
        this.myPath = path2;
        this.myConfigurableId = configurableId;
        this.myGroupName = groupName;
    }

    public String getOption() {
        return this.myOption;
    }

    @Nullable
    public String getHit() {
        return this.myHit;
    }

    @Nullable
    public String getPath() {
        return this.myPath;
    }

    public String getConfigurableId() {
        return this.myConfigurableId;
    }

    public String getGroupName() {
        return this.myGroupName;
    }

    public String getValue() {
        return null;
    }

    public boolean hasExternalEditor() {
        return false;
    }

    public void invokeInternalEditor() {
    }

    public String toString() {
        return this.myHit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionDescription that = (OptionDescription)o;
        if (!Objects.equals(this.myConfigurableId, that.myConfigurableId)) {
            return false;
        }
        if (!Objects.equals(this.myHit, that.myHit)) {
            return false;
        }
        if (!Objects.equals(this.myOption, that.myOption)) {
            return false;
        }
        return Objects.equals(this.myPath, that.myPath);
    }

    public int hashCode() {
        int result2 = this.myOption != null ? this.myOption.hashCode() : 0;
        result2 = 31 * result2 + (this.myHit != null ? this.myHit.hashCode() : 0);
        result2 = 31 * result2 + (this.myPath != null ? this.myPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myConfigurableId != null ? this.myConfigurableId.hashCode() : 0);
        return result2;
    }

    @Override
    public int compareTo(OptionDescription o) {
        if (Comparing.strEqual(this.myHit, o.getHit())) {
            return this.myOption != null ? this.myOption.compareTo(o.getOption()) : 0;
        }
        if (this.myHit != null && o.getHit() != null) {
            return this.myHit.compareTo(o.getHit());
        }
        return 0;
    }
}

