/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowseFilesListener
implements ActionListener {
    public static final FileChooserDescriptor SINGLE_DIRECTORY_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFolderDescriptor();
    public static final FileChooserDescriptor SINGLE_FILE_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
    private final JTextField myTextField;
    private final String myTitle;
    private final String myDescription;
    protected final FileChooserDescriptor myChooserDescriptor;

    public BrowseFilesListener(JTextField textField2, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nls(capitalization=Nls.Capitalization.Sentence) String description, FileChooserDescriptor chooserDescriptor) {
        this.myTextField = textField2;
        this.myTitle = title;
        this.myDescription = description;
        this.myChooserDescriptor = chooserDescriptor;
    }

    @Nullable
    protected VirtualFile getFileToSelect() {
        String path2 = this.myTextField.getText().trim().replace(File.separatorChar, '/');
        if (path2.length() > 0) {
            File file2;
            for (file2 = new File(path2); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
            }
            if (file2 != null) {
                return LocalFileSystem.getInstance().findFileByIoFile(file2);
            }
        }
        return null;
    }

    protected void doSetText(@NotNull String path2) {
        if (path2 == null) {
            BrowseFilesListener.$$$reportNull$$$0(0);
        }
        this.myTextField.setText(path2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VirtualFile fileToSelect = this.getFileToSelect();
        this.myChooserDescriptor.setTitle(this.myTitle);
        this.myChooserDescriptor.setDescription(this.myDescription);
        FileChooser.chooseFiles(this.myChooserDescriptor, null, fileToSelect, files2 -> this.doSetText(FileUtil.toSystemDependentName(((VirtualFile)files2.get(0)).getPath())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/util/BrowseFilesListener", "doSetText"));
    }
}

