/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteHandler {
    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, Project project2) {
        DeleteHandler.deletePsiElement(elementsToDelete, project2, true);
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project2, boolean needConfirmation) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        final PsiElement[] elements2 = PsiTreeUtil.filterAncestors(elementsToDelete);
        boolean safeDeleteApplicable = Arrays.stream(elements2).allMatch(SafeDeleteProcessor::validElement);
        boolean dumb = DumbService.getInstance(project2).isDumb();
        if (safeDeleteApplicable && !dumb) {
            final Ref<Boolean> exit = Ref.create(false);
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project2, elements2, new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively(project2, Arrays.asList(elements2), true)) {
                        return;
                    }
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project2, () -> {
                        exit.set(true);
                        dialog2.close(0);
                    }, elements2, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true);
                    processor2.run();
                }
            }){

                @Override
                protected boolean isDelete() {
                    return true;
                }
            };
            if (needConfirmation) {
                dialog2.setTitle(RefactoringBundle.message("delete.title"));
                if (!dialog2.showAndGet() || exit.get().booleanValue()) {
                    return;
                }
            }
        } else {
            int result2;
            String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message("prompt.delete.elements", new Object[0]), elements2);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory) || PsiUtilBase.isSymLink((PsiDirectory)psiElement)) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements2.length == 1 ? warningMessage + IdeBundle.message("warning.delete.all.files.and.subdirectories", directoryName) : warningMessage + IdeBundle.message("warning.delete.all.files.and.subdirectories.in.the.selected.directory", new Object[0]);
            }
            if (safeDeleteApplicable) {
                warningMessage = warningMessage + "\n\nWarning:\n  Safe delete is not available while " + ApplicationNamesInfo.getInstance().getFullProductName() + " updates indices,\n  no usages will be checked.";
            }
            if (needConfirmation && (result2 = Messages.showOkCancelDialog(project2, warningMessage, IdeBundle.message("title.delete", new Object[0]), ApplicationBundle.message("button.delete", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        DeleteHandler.deleteInCommand(project2, elements2);
    }

    private static boolean makeWritable(Project project2, PsiElement[] elements2) {
        SmartList<PsiElement> directories = new SmartList<PsiElement>();
        for (PsiElement e : elements2) {
            if (!(e instanceof PsiFileSystemItem) || e.getParent() == null) continue;
            directories.add(e.getParent());
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project2, Arrays.asList(elements2), directories, false);
    }

    private static void deleteInCommand(Project project2, PsiElement[] elements2) {
        CommandProcessor.getInstance().executeCommand(project2, () -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project2);
            List<SmartPsiElementPointer> pointers2 = ContainerUtil.map(elements2, smartPointerManager::createSmartPsiElementPointer);
            if (!DeleteHandler.makeWritable(project2, elements2)) {
                return;
            }
            DataContext context = DataManager.getInstance().getDataContext();
            if (CommonDataKeys.EDITOR.getData(context) == null) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
            }
            if (Stream.of(elements2).allMatch(DeleteHandler::isLocalFile)) {
                DeleteHandler.doDeleteFiles(project2, elements2);
            } else {
                for (SmartPsiElementPointer pointer : pointers2) {
                    Object elementToDelete = pointer.getElement();
                    if (elementToDelete == null) continue;
                    DeleteHandler.doDelete(project2, elementToDelete);
                }
            }
        }), RefactoringBundle.message("safe.delete.command", RefactoringUIUtil.calculatePsiElementDescriptionList(elements2)), null);
    }

    private static boolean isLocalFile(PsiElement e) {
        VirtualFile file2;
        return e instanceof PsiFileSystemItem && (file2 = ((PsiFileSystemItem)e).getVirtualFile()) != null && file2.isInLocalFileSystem();
    }

    private static boolean clearFileReadOnlyFlags(Project project2, PsiElement elementToDelete) {
        VirtualFile virtualFile2;
        PsiFile file2;
        if (elementToDelete instanceof PsiDirectory) {
            VirtualFile virtualFile3 = ((PsiDirectory)elementToDelete).getVirtualFile();
            if (virtualFile3.isInLocalFileSystem() && !virtualFile3.is(VFileProperty.SYMLINK)) {
                ArrayList readOnlyFiles = new ArrayList();
                CommonRefactoringUtil.collectReadOnlyFiles(virtualFile3, readOnlyFiles);
                if (!readOnlyFiles.isEmpty()) {
                    VirtualFile file3;
                    String message = IdeBundle.message("prompt.directory.contains.read.only.files", virtualFile3.getPresentableUrl());
                    int _result = Messages.showYesNoDialog(project2, message, IdeBundle.message("title.delete", new Object[0]), Messages.getQuestionIcon());
                    if (_result != 0) {
                        return false;
                    }
                    boolean success = true;
                    Iterator iterator2 = readOnlyFiles.iterator();
                    while (iterator2.hasNext() && (success = DeleteHandler.clearReadOnlyFlag(file3 = (VirtualFile)iterator2.next(), project2))) {
                    }
                    if (!success) {
                        return false;
                    }
                }
            }
        } else if (!(elementToDelete.isWritable() || elementToDelete instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)elementToDelete) || (file2 = elementToDelete.getContainingFile()) == null || !(virtualFile2 = file2.getVirtualFile()).isInLocalFileSystem())) {
            int _result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(project2, virtualFile2).setTitle(IdeBundle.message("title.delete", new Object[0]))).appendMessage(" " + IdeBundle.message("prompt.delete.it.anyway", new Object[0]))).askYesNo();
            if (_result != 0) {
                return false;
            }
            boolean success = DeleteHandler.clearReadOnlyFlag(virtualFile2, project2);
            if (!success) {
                return false;
            }
        }
        return true;
    }

    private static void doDelete(Project project2, PsiElement element2) {
        if (!DeleteHandler.clearFileReadOnlyFlags(project2, element2)) {
            return;
        }
        try {
            element2.checkDelete();
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog(project2, e.getMessage(), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                element2.delete();
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog(project2, e.getMessage(), CommonBundle.getErrorTitle(), Messages.getErrorIcon()));
            }
        });
    }

    private static void doDeleteFiles(Project project2, PsiElement[] fileElements) {
        for (PsiElement file2 : fileElements) {
            if (DeleteHandler.clearFileReadOnlyFlags(project2, file2)) continue;
            return;
        }
        LocalFilesDeleteTask task2 = new LocalFilesDeleteTask(project2, fileElements);
        ProgressManager.getInstance().run(task2);
        if (task2.error != null) {
            Messages.showMessageDialog(project2, task2.error.getMessage(), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
        }
        if (task2.aborted != null) {
            VfsUtil.markDirtyAndRefresh(true, true, false, task2.aborted);
        }
        if (!task2.processed.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PsiElement fileElement : task2.processed) {
                    try {
                        fileElement.delete();
                    }
                    catch (IncorrectOperationException e) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog(project2, e.getMessage(), CommonBundle.getErrorTitle(), Messages.getErrorIcon()));
                    }
                }
            });
        }
    }

    private static boolean clearReadOnlyFlag(VirtualFile virtualFile2, Project project2) {
        boolean[] success = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action2 = () -> {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute(virtualFile2, false);
                    success[0] = true;
                }
                catch (IOException e1) {
                    Messages.showMessageDialog(project2, e1.getMessage(), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, "", null);
        return success[0];
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements2) {
        if (elements2 == null || elements2.length == 0) {
            return false;
        }
        for (PsiElement element2 : elements2) {
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element2);
            if (virtualFile2 == null || virtualFile2 instanceof LightVirtualFile) {
                return false;
            }
            if (WritingAccessProvider.isPotentiallyWritable(virtualFile2, element2.getProject())) continue;
            return false;
        }
        return true;
    }

    private static class LocalFilesDeleteTask
    extends Task.Modal {
        private final PsiElement[] myFileElements;
        List<PsiElement> processed = new ArrayList<PsiElement>();
        VirtualFile aborted = null;
        IOException error = null;

        LocalFilesDeleteTask(Project project2, PsiElement[] fileElements) {
            super(project2, IdeBundle.message("progress.deleting", new Object[0]), true);
            this.myFileElements = fileElements;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                LocalFilesDeleteTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            try {
                for (PsiElement e : this.myFileElements) {
                    if (!indicator.isCanceled()) {
                        VirtualFile file2;
                        this.aborted = file2 = ((PsiFileSystemItem)e).getVirtualFile();
                        final Path path2 = Paths.get(file2.getPath(), new String[0]);
                        indicator.setText(path2.toString());
                        Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                if (SystemInfo.isWindows && attrs.isOther()) {
                                    this.visitFile(dir, (BasicFileAttributes)null);
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file2, @Nullable BasicFileAttributes attrs) throws IOException {
                                indicator.setText2(path2.relativize(file2).toString());
                                Files.delete(file2);
                                return indicator.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                return this.visitFile(dir, (BasicFileAttributes)null);
                            }
                        });
                        if (indicator.isCanceled()) continue;
                        this.processed.add(e);
                        this.aborted = null;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error = e;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/DeleteHandler$LocalFilesDeleteTask", "run"));
        }
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        @Override
        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
                return false;
            }
            PsiElement[] elements2 = DefaultDeleteProvider.getPsiElements(dataContext);
            return DeleteHandler.shouldEnableDeleteAction(elements2);
        }

        private static PsiElement @Nullable [] getPsiElements(DataContext dataContext) {
            PsiElement[] elements2 = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            if (elements2 == null) {
                PsiElement data2 = CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (data2 != null) {
                    elements2 = new PsiElement[]{data2};
                } else {
                    PsiFile data1 = CommonDataKeys.PSI_FILE.getData(dataContext);
                    if (data1 != null) {
                        elements2 = new PsiElement[]{data1};
                    }
                }
            }
            return elements2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteElement(@NotNull DataContext dataContext) {
            PsiElement[] elements2;
            if (dataContext == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((elements2 = DefaultDeleteProvider.getPsiElements(dataContext)) == null) {
                return;
            }
            Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message("progress.deleting", new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements2, project2);
            }
            finally {
                a.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/util/DeleteHandler$DefaultDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

