/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteNameDescriptionLocation;
import com.intellij.ide.util.DeleteTypeDescriptionLocation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FactoryMap;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class DeleteUtil {
    private DeleteUtil() {
    }

    public static String generateWarningMessage(String messageTemplate, PsiElement[] elements2) {
        if (elements2.length == 1) {
            String name = ElementDescriptionUtil.getElementDescription(elements2[0], DeleteNameDescriptionLocation.INSTANCE);
            String type = ElementDescriptionUtil.getElementDescription(elements2[0], DeleteTypeDescriptionLocation.SINGULAR);
            return MessageFormat.format(messageTemplate, type + (StringUtil.isEmptyOrSpaces(name) ? "" : " \"" + name + "\""));
        }
        Map<String, Integer> countMap = FactoryMap.create(key -> 0);
        HashMap<String, String> pluralToSingular = new HashMap<String, String>();
        int directoryCount = 0;
        String containerType = null;
        for (PsiElement elementToDelete : elements2) {
            String type = ElementDescriptionUtil.getElementDescription(elementToDelete, DeleteTypeDescriptionLocation.PLURAL);
            pluralToSingular.put(type, ElementDescriptionUtil.getElementDescription(elementToDelete, DeleteTypeDescriptionLocation.SINGULAR));
            int oldCount = countMap.get(type);
            countMap.put(type, oldCount + 1);
            if (!(elementToDelete instanceof PsiDirectoryContainer)) continue;
            containerType = type;
            directoryCount += ((PsiDirectoryContainer)elementToDelete).getDirectories().length;
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            if (buffer.length() > 0 && buffer.length() > 0) {
                buffer.append(" ").append(IdeBundle.message("prompt.delete.and", new Object[0])).append(" ");
            }
            int count = entry.getValue();
            buffer.append(count).append(" ");
            if (count == 1) {
                buffer.append((String)pluralToSingular.get(entry.getKey()));
            } else {
                buffer.append(entry.getKey());
            }
            if (!entry.getKey().equals(containerType)) continue;
            buffer.append(" ").append(IdeBundle.message("prompt.delete.directory.paren", directoryCount));
        }
        return MessageFormat.format(messageTemplate, buffer.toString());
    }
}

