/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ExportToFileUtil {
    private static final Logger LOG = Logger.getInstance(ExportToFileUtil.class);

    public static void exportTextToFile(Project project2, String fileName, String textToExport) {
        String prepend = "";
        File file2 = new File(fileName);
        if (file2.exists()) {
            int result2 = Messages.showYesNoCancelDialog(project2, IdeBundle.message("error.text.file.already.exists", fileName), IdeBundle.message("dialog.title.export.to.file", new Object[0]), IdeBundle.message("action.overwrite", new Object[0]), IdeBundle.message("action.append", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getWarningIcon());
            if (result2 != 1 && result2 != 0) {
                return;
            }
            if (result2 == 1) {
                char[] buf = new char[(int)file2.length()];
                try (FileReader reader = new FileReader(fileName);){
                    reader.read(buf, 0, (int)file2.length());
                    prepend = new String(buf) + SystemProperties.getLineSeparator();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try (FileWriter writer = new FileWriter(fileName);){
            writer.write(prepend + textToExport);
        }
        catch (IOException e) {
            Messages.showMessageDialog(project2, IdeBundle.message("error.writing.to.file", fileName), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
        }
    }

    public static class ExportDialogBase
    extends DialogWrapper {
        private final Project myProject;
        private final ExporterToTextFile myExporter;
        protected Editor myTextArea;
        protected TextFieldWithBrowseButton myTfFile;
        private ChangeListener myListener;

        public ExportDialogBase(Project project2, ExporterToTextFile exporter) {
            super(project2, true);
            this.myProject = project2;
            this.myExporter = exporter;
            this.myTfFile = new TextFieldWithBrowseButton();
            this.myTfFile.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), this.myProject){

                @Override
                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    if (chosenFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String res2 = super.chosenFileToResultingText(chosenFile);
                    if (chosenFile.isDirectory()) {
                        res2 = res2 + File.separator + PathUtil.getFileName(myExporter.getDefaultFilePath());
                    }
                    String string = res2;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "chosenFile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "chosenFileToResultingText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "chosenFileToResultingText";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            this.setTitle(IdeBundle.message("title.export.preview", new Object[0]));
            this.setOKButtonText(IdeBundle.message("button.save", new Object[0]));
            this.init();
            try {
                this.myListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        this.initText();
                    }
                };
                this.myExporter.addSettingsChangedListener(this.myListener);
            }
            catch (TooManyListenersException e) {
                LOG.error(e);
            }
            this.initText();
        }

        @Override
        public void dispose() {
            this.myExporter.removeSettingsChangedListener(this.myListener);
            EditorFactory.getInstance().releaseEditor(this.myTextArea);
            super.dispose();
        }

        private void initText() {
            this.myTextArea.getDocument().setText(this.myExporter.getReportText());
        }

        @Override
        protected JComponent createCenterPanel() {
            Document document = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(true);
            ((DocumentImpl)document).setAcceptSlashR(true);
            this.myTextArea = EditorFactory.getInstance().createEditor(document, this.myProject, FileTypes.PLAIN_TEXT, true);
            EditorSettings settings = this.myTextArea.getSettings();
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setFoldingOutlineShown(false);
            settings.setRightMarginShown(false);
            settings.setAdditionalLinesCount(0);
            settings.setAdditionalColumnsCount(0);
            settings.setAdditionalPageAtBottom(false);
            EditorEx editorEx = (EditorEx)this.myTextArea;
            editorEx.setBackgroundColor(UIUtil.getInactiveTextFieldBackgroundColor());
            editorEx.setColorsScheme(EditorColorsManager.getInstance().getSchemeForCurrentUITheme());
            this.myTextArea.getComponent().setPreferredSize(new Dimension(700, 400));
            return this.myTextArea.getComponent();
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel filePanel = this.createFilePanel();
            JComponent settingsPanel = this.myExporter.getSettingsEditor();
            if (settingsPanel == null) {
                return filePanel;
            }
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)filePanel, "North");
            northPanel.add((Component)settingsPanel, "Center");
            return northPanel;
        }

        protected JPanel createFilePanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.fill = 2;
            JLabel promptLabel = new JLabel(IdeBundle.message("editbox.export.to.file", new Object[0]));
            gbConstraints.weightx = 0.0;
            panel2.add((Component)promptLabel, gbConstraints);
            gbConstraints.weightx = 1.0;
            panel2.add((Component)this.myTfFile, gbConstraints);
            String defaultFilePath = this.myExporter.getDefaultFilePath();
            defaultFilePath = !new File(defaultFilePath).isAbsolute() ? PathMacroManager.getInstance(this.myProject).collapsePath(defaultFilePath).replace('/', File.separatorChar) : defaultFilePath.replace('/', File.separatorChar);
            this.myTfFile.setText(defaultFilePath);
            panel2.setBorder(JBUI.Borders.emptyBottom(5));
            return panel2;
        }

        public String getText() {
            return this.myTextArea.getDocument().getText();
        }

        public void setFileName(String s) {
            this.myTfFile.setText(s);
        }

        public String getFileName() {
            return this.myTfFile.getText();
        }

        @Override
        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), new CopyToClipboardAction(), this.getCancelAction()};
            if (actionArray == null) {
                ExportDialogBase.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        @Override
        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.util.ExportDialog";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase", "createActions"));
        }

        protected class CopyToClipboardAction
        extends AbstractAction {
            public CopyToClipboardAction() {
                super(IdeBundle.message("button.copy", new Object[0]));
                this.putValue("ShortDescription", IdeBundle.message("description.copy.text.to.clipboard", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = StringUtil.convertLineSeparators(ExportDialogBase.this.getText());
                CopyPasteManager.getInstance().setContents(new StringSelection(s));
            }
        }
    }
}

