/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.ide.util.TreeStructureActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FileStructurePopup
implements Disposable,
TreeActionsOwner {
    private static final Logger LOG = Logger.getInstance(FileStructurePopup.class);
    private static final String NARROW_DOWN_PROPERTY_KEY = "FileStructurePopup.narrowDown";
    private final Project myProject;
    private final FileEditor myFileEditor;
    private final StructureViewModel myTreeModelWrapper;
    private final StructureViewModel myTreeModel;
    private final TreeStructureActionsOwner myTreeActionsOwner;
    private JBPopup myPopup;
    private String myTitle;
    private final Tree myTree;
    private final SmartTreeStructure myTreeStructure;
    private final FilteringTreeStructure myFilteringStructure;
    private final AsyncTreeModel myAsyncTreeModel;
    private final StructureTreeModel myStructureTreeModel;
    private final TreeSpeedSearch mySpeedSearch;
    private final Object myInitialElement;
    private final Map<Class, JBCheckBox> myCheckBoxes;
    private final List<JBCheckBox> myAutoClicked;
    private String myTestSearchFilter;
    private final ActionCallback myTreeHasBuilt;
    private final List<Pair<String, JBCheckBox>> myTriggeredCheckboxes;
    private final TreeExpander myTreeExpander;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean myCanClose;
    private boolean myDisposed;

    @Deprecated
    public FileStructurePopup(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureView structureView, boolean applySortAndFilter) {
        if (project2 == null) {
            FileStructurePopup.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            FileStructurePopup.$$$reportNull$$$0(1);
        }
        if (structureView == null) {
            FileStructurePopup.$$$reportNull$$$0(2);
        }
        this(project2, fileEditor, ViewStructureAction.createStructureViewModel(project2, fileEditor, structureView));
        Disposer.register(this, structureView);
    }

    public FileStructurePopup(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureViewModel treeModel) {
        if (project2 == null) {
            FileStructurePopup.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            FileStructurePopup.$$$reportNull$$$0(4);
        }
        if (treeModel == null) {
            FileStructurePopup.$$$reportNull$$$0(5);
        }
        this.myCheckBoxes = new HashMap<Class, JBCheckBox>();
        this.myAutoClicked = new ArrayList<JBCheckBox>();
        this.myTreeHasBuilt = new ActionCallback();
        this.myTriggeredCheckboxes = new ArrayList<Pair<String, JBCheckBox>>();
        this.myCanClose = true;
        this.myProject = project2;
        this.myFileEditor = fileEditor;
        this.myTreeModel = treeModel;
        DaemonCodeAnalyzer.getInstance(this.myProject).disableUpdateByTimer(this);
        IdeFocusManager.getInstance(this.myProject).typeAheadUntil(this.myTreeHasBuilt, "FileStructurePopup");
        this.myTreeActionsOwner = new TreeStructureActionsOwner(this.myTreeModel);
        this.myTreeActionsOwner.setActionIncluded(Sorter.ALPHA_SORTER, true);
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this.myTreeActionsOwner);
        Disposer.register(this, this.myTreeModelWrapper);
        this.myTreeStructure = new SmartTreeStructure(project2, this.myTreeModelWrapper){

            @Override
            public void rebuildTree() {
                if (!ApplicationManager.getApplication().isUnitTestMode() && FileStructurePopup.this.myPopup.isDisposed()) {
                    return;
                }
                ProgressManager.getInstance().computePrioritized(() -> {
                    super.rebuildTree();
                    FileStructurePopup.this.myFilteringStructure.rebuild();
                    return null;
                });
            }

            @Override
            public boolean isToBuildChildrenInBackground(@NotNull Object element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.getRootElement() == element2;
            }

            @Override
            @NotNull
            protected TreeElementWrapper createTree() {
                TreeElementWrapper treeElementWrapper = StructureViewComponent.createWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
                if (treeElementWrapper == null) {
                    1.$$$reportNull$$$0(1);
                }
                return treeElementWrapper;
            }

            @NonNls
            public String toString() {
                return "structure view tree structure(model=" + FileStructurePopup.this.myTreeModelWrapper + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/FileStructurePopup$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTree";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isToBuildChildrenInBackground";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        FileStructurePopupFilter filter2 = new FileStructurePopupFilter();
        this.myFilteringStructure = new FilteringTreeStructure(filter2, this.myTreeStructure, false);
        this.myStructureTreeModel = new StructureTreeModel<FilteringTreeStructure>(this.myFilteringStructure, this);
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)this.myStructureTreeModel, this);
        this.myAsyncTreeModel.setRootImmediately(this.myStructureTreeModel.getRootImmediately());
        this.myTree = new MyTree(this.myAsyncTreeModel);
        StructureViewComponent.registerAutoExpandListener(this.myTree, this.myTreeModel);
        ModelListener modelListener2 = () -> this.rebuild(false);
        this.myTreeModel.addModelListener(modelListener2);
        Disposer.register(this, () -> this.myTreeModel.removeModelListener(modelListener2));
        this.myTree.setCellRenderer(new NodeRenderer());
        this.myProject.getMessageBus().connect(this).subscribe(UISettingsListener.TOPIC, o -> this.rebuild(false));
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                String s;
                if (support == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) != null && !FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.showPopup(s);
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent component2) {
                JBIterable<Pair> pairs = JBIterable.of(FileStructurePopup.this.myTree.getSelectionPaths()).filterMap(TreeUtil::getLastUserObject).filter(FilteringTreeStructure.FilteringNode.class).filterMap(o -> o.getDelegate() instanceof PsiElement ? Pair.create(o, (PsiElement)o.getDelegate()) : null).collect();
                if (pairs.isEmpty()) {
                    return null;
                }
                Set psiSelection = pairs.map(Functions.pairSecond()).toSet();
                String text2 = StringUtil.join(pairs, pair -> {
                    PsiElement psi = (PsiElement)pair.second;
                    String defaultPresentation = ((FilteringTreeStructure.FilteringNode)pair.first).getPresentation().getPresentableText();
                    if (psi == null) {
                        return defaultPresentation;
                    }
                    for (PsiElement p = psi.getParent(); p != null; p = p.getParent()) {
                        if (!psiSelection.contains(p)) continue;
                        return null;
                    }
                    return ObjectUtils.chooseNotNull(psi.getText(), defaultPresentation);
                }, "\n");
                String htmlText = "<body>\n" + text2 + "\n</body>";
                return new TextTransferable(XmlStringUtil.wrapInHtml(htmlText), text2);
            }

            @Override
            public int getSourceActions(JComponent component2) {
                return 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/ide/util/FileStructurePopup$2", "importData"));
            }
        });
        this.mySpeedSearch = new MyTreeSpeedSearch();
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, true){

            @Override
            @NotNull
            protected MinusculeMatcher createMatcher(@NotNull String pattern) {
                if (pattern == null) {
                    3.$$$reportNull$$$0(0);
                }
                MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern).withSeparators(" ()").build();
                if (minusculeMatcher == null) {
                    3.$$$reportNull$$$0(1);
                }
                return minusculeMatcher;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/FileStructurePopup$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMatcher";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createMatcher";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myTreeExpander = new DefaultTreeExpander(this.myTree);
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this.myTree);
        this.myInitialElement = this.myTreeModel.getCurrentEditorElement();
        TreeUtil.installActions(this.myTree);
    }

    public void show() {
        JComponent panel2 = this.createCenterPanel();
        MnemonicHelper.init(panel2);
        this.myTree.addTreeSelectionListener(__ -> {
            PopupUpdateProcessor updateProcessor;
            if (this.myPopup.isVisible() && (updateProcessor = this.myPopup.getUserData(PopupUpdateProcessor.class)) != null) {
                AbstractTreeNode node = this.getSelectedNode();
                updateProcessor.updatePopup(node);
            }
        });
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(panel2, this.myTree).setTitle(this.myTitle).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelOnOtherWindowOpen(true).setCancelKeyEnabled(false).setDimensionServiceKey(this.myProject, FileStructurePopup.getDimensionServiceKey(), true).setCancelCallback(() -> this.myCanClose).setNormalWindowLevel(true).createPopup();
        Disposer.register(this.myPopup, this);
        Disposer.register(this.myPopup, () -> {
            if (!this.myTreeHasBuilt.isDone()) {
                this.myTreeHasBuilt.setRejected();
            }
        });
        this.myTree.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
        ((AbstractPopup)this.myPopup).setShowHints(true);
        IdeFocusManager.getInstance(this.myProject).requestFocus(this.myTree, true);
        this.rebuildAndSelect(false, this.myInitialElement).onProcessed(path2 -> UIUtil.invokeLaterIfNeeded(() -> {
            TreeUtil.ensureSelection(this.myTree);
            this.myTreeHasBuilt.setDone();
            this.installUpdater();
        }));
    }

    private void installUpdater() {
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myPopup.isDisposed()) {
            return;
        }
        final Alarm alarm2 = new Alarm(Alarm.ThreadToUse.SWING_THREAD, this.myPopup);
        alarm2.addRequest(new Runnable(){
            String filter = "";

            @Override
            public void run() {
                alarm2.cancelAllRequests();
                String prefix = FileStructurePopup.this.mySpeedSearch.getEnteredPrefix();
                FileStructurePopup.this.myTree.getEmptyText().setText(StringUtil.isEmpty(prefix) ? "Structure is empty" : "'" + prefix + "' not found");
                if (prefix == null) {
                    prefix = "";
                }
                if (!this.filter.equals(prefix)) {
                    boolean isBackspace = prefix.length() < this.filter.length();
                    this.filter = prefix;
                    FileStructurePopup.this.rebuild(true).onProcessed(ignore -> UIUtil.invokeLaterIfNeeded(() -> {
                        if (FileStructurePopup.this.isDisposed()) {
                            return;
                        }
                        TreeUtil.promiseExpandAll(FileStructurePopup.this.myTree);
                        if (isBackspace && FileStructurePopup.this.handleBackspace(this.filter)) {
                            return;
                        }
                        if (FileStructurePopup.this.myFilteringStructure.getRootElement().getChildren().length == 0) {
                            for (JBCheckBox box : FileStructurePopup.this.myCheckBoxes.values()) {
                                if (box.isSelected()) continue;
                                FileStructurePopup.this.myAutoClicked.add(box);
                                FileStructurePopup.this.myTriggeredCheckboxes.add(0, Pair.create(this.filter, box));
                                box.doClick();
                                this.filter = "";
                                break;
                            }
                        }
                    }));
                }
                if (!alarm2.isDisposed()) {
                    alarm2.addRequest((Runnable)this, 300);
                }
            }
        }, 300);
    }

    private boolean handleBackspace(String filter2) {
        Pair<String, JBCheckBox> next;
        boolean clicked = false;
        Iterator<Pair<String, JBCheckBox>> iterator2 = this.myTriggeredCheckboxes.iterator();
        while (iterator2.hasNext() && (next = iterator2.next()).getFirst().length() >= filter2.length()) {
            iterator2.remove();
            next.getSecond().doClick();
            clicked = true;
        }
        return clicked;
    }

    @NotNull
    public Promise<TreePath> select(final Object element2) {
        final int[] stage = new int[]{1, 0};
        final TreePath[] deepestPath = new TreePath[]{null};
        final TreeVisitor visitor = path2 -> {
            Object last = path2.getLastPathComponent();
            Object userObject = StructureViewComponent.unwrapNavigatable(last);
            Object value2 = StructureViewComponent.unwrapValue(last);
            if (Comparing.equal(value2, element2) || userObject instanceof AbstractTreeNode && ((AbstractTreeNode)userObject).canRepresent(element2)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (value2 instanceof PsiElement && element2 instanceof PsiElement) {
                if (PsiTreeUtil.isAncestor((PsiElement)value2, (PsiElement)element2, true)) {
                    int count = path2.getPathCount();
                    if (stage[1] == 0 || stage[1] < count) {
                        stage[1] = count;
                        deepestPath[0] = path2;
                    }
                } else if (stage[0] != 3) {
                    stage[0] = 2;
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
            }
            return TreeVisitor.Action.CONTINUE;
        };
        final Function<TreePath, Promise> action2 = path2 -> {
            this.myTree.expandPath((TreePath)path2);
            TreeUtil.selectPath(this.myTree, path2);
            TreeUtil.ensureSelection(this.myTree);
            return Promises.resolvedPromise((Object)path2);
        };
        Function<TreePath, Promise<TreePath>> fallback = new Function<TreePath, Promise<TreePath>>(){

            @Override
            public Promise<TreePath> fun(TreePath path2) {
                Object minChild;
                TreePath adjusted;
                if (path2 == null && stage[0] == 2) {
                    stage[0] = 3;
                    return FileStructurePopup.this.myAsyncTreeModel.accept(visitor).thenAsync(this);
                }
                TreePath treePath = adjusted = path2 == null ? deepestPath[0] : path2;
                if (path2 == null && adjusted != null && element2 instanceof PsiElement && (minChild = FileStructurePopup.findClosestPsiElement((PsiElement)element2, adjusted, FileStructurePopup.this.myAsyncTreeModel)) != null) {
                    adjusted = adjusted.pathByAddingChild(minChild);
                }
                return adjusted == null ? Promises.rejectedPromise() : (Promise)action2.fun(adjusted);
            }
        };
        Promise<TreePath> promise2 = this.myAsyncTreeModel.accept(visitor).thenAsync(fallback);
        if (promise2 == null) {
            FileStructurePopup.$$$reportNull$$$0(6);
        }
        return promise2;
    }

    public AsyncPromise<Void> rebuildAndUpdate() {
        AsyncPromise result2 = new AsyncPromise();
        TreeVisitor visitor = path2 -> {
            AbstractTreeNode node = TreeUtil.getLastUserObject(AbstractTreeNode.class, path2);
            if (node != null) {
                node.update();
            }
            return TreeVisitor.Action.CONTINUE;
        };
        this.rebuild(false).onProcessed(ignore1 -> this.myAsyncTreeModel.accept(visitor).onProcessed(ignore2 -> result2.setResult(null)));
        return result2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }

    private static boolean isShouldNarrowDown() {
        return PropertiesComponent.getInstance().getBoolean(NARROW_DOWN_PROPERTY_KEY, true);
    }

    @NonNls
    protected static String getDimensionServiceKey() {
        return "StructurePopup";
    }

    @Nullable
    public PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModelWrapper.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        if (psiFile != null && this.myFileEditor instanceof TextEditor) {
            return psiFile.getViewProvider().findElementAt(((TextEditor)this.myFileEditor).getEditor().getCaretModel().getOffset());
        }
        return null;
    }

    public JComponent createCenterPanel() {
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        ArrayList<FileStructureNodeProvider> fileStructureNodeProviders = new ArrayList<FileStructureNodeProvider>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter2 : this.myTreeModel.getFilters()) {
                if (!(filter2 instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter2;
                this.myTreeActionsOwner.setActionIncluded(fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
            if (this.myTreeModel instanceof ProvidingTreeModel) {
                for (NodeProvider provider : ((ProvidingTreeModel)((Object)this.myTreeModel)).getNodeProviders()) {
                    if (!(provider instanceof FileStructureNodeProvider)) continue;
                    fileStructureNodeProviders.add((FileStructureNodeProvider)provider);
                }
            }
        }
        int checkBoxCount = fileStructureNodeProviders.size() + fileStructureFilters.size();
        final JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setPreferredSize(JBUI.size(540, 500));
        JPanel chkPanel = new JPanel(new GridLayout(0, checkBoxCount > 0 && checkBoxCount % 4 == 0 ? checkBoxCount / 2 : 3, JBUIScale.scale(10), 0));
        chkPanel.setOpaque(false);
        Shortcut[] F4 = ActionManager.getInstance().getAction("EditSource").getShortcutSet().getShortcuts();
        Shortcut[] ENTER = CustomShortcutSet.fromString("ENTER").getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet(ArrayUtil.mergeArrays(F4, ENTER));
        new DumbAwareAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                boolean succeeded;
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (succeeded = FileStructurePopup.this.navigateSelectedElement()) {
                    this.unregisterCustomShortcutSet(panel2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/FileStructurePopup$6", "actionPerformed"));
            }
        }.registerCustomShortcutSet(shortcutSet, panel2);
        DumbAwareAction.create(e -> {
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
                this.mySpeedSearch.hidePopup();
            } else {
                this.myPopup.cancel();
            }
        }).registerCustomShortcutSet(CustomShortcutSet.fromString("ESCAPE"), this.myTree);
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                TreePath path2;
                Rectangle bounds2;
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                Rectangle rectangle = bounds2 = (path2 = FileStructurePopup.this.myTree.getClosestPathForLocation(e.getX(), e.getY())) == null ? null : FileStructurePopup.this.myTree.getPathBounds(path2);
                if (bounds2 == null || bounds2.x > e.getX() || bounds2.y > e.getY() || bounds2.y + bounds2.height < e.getY()) {
                    return false;
                }
                FileStructurePopup.this.navigateSelectedElement();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/FileStructurePopup$7", "onClick"));
            }
        }.installOn(this.myTree);
        for (FileStructureFilter filter3 : fileStructureFilters) {
            this.addCheckbox(chkPanel, filter3);
        }
        for (FileStructureNodeProvider provider : fileStructureNodeProviders) {
            this.addCheckbox(chkPanel, provider);
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)chkPanel, "West");
        topPanel.add((Component)this.createSettingsButton(), "East");
        topPanel.setBackground(JBUI.CurrentTheme.Popup.toolbarPanelColor());
        Dimension prefSize = topPanel.getPreferredSize();
        prefSize.height = JBUI.CurrentTheme.Popup.toolbarHeight();
        topPanel.setPreferredSize(prefSize);
        topPanel.setBorder(JBUI.Borders.emptyLeft(10));
        panel2.add((Component)topPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder(JBUI.CurrentTheme.Popup.toolbarBorderColor(), 10));
        panel2.add((Component)scrollPane, "Center");
        DataManager.registerDataProvider(panel2, dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myFileEditor;
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId) && this.myFileEditor instanceof TextEditor) {
                return ((TextEditor)this.myFileEditor).getEditor();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return this.getSelectedElements().filter(PsiElement.class).first();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                return PsiUtilCore.toPsiElementArray(this.getSelectedElements().filter(PsiElement.class).toList());
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getSelectedElements().filter(Navigatable.class).first();
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                List<Navigatable> result2 = this.getSelectedElements().filter(Navigatable.class).toList();
                return result2.isEmpty() ? null : result2.toArray(new Navigatable[0]);
            }
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                return this.myPopup;
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this.myCopyPasteDelegator.getCopyProvider();
            }
            if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                return this.myTreeExpander;
            }
            return null;
        });
        panel2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        });
        return panel2;
    }

    @NotNull
    private JBIterable<Object> getSelectedElements() {
        JBIterable<Object> jBIterable = JBIterable.of(this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent()));
        if (jBIterable == null) {
            FileStructurePopup.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    private JComponent createSettingsButton() {
        final JLabel label2 = new JLabel(AllIcons.General.GearPlain);
        label2.setBorder(JBUI.Borders.empty(0, 4));
        label2.setHorizontalAlignment(4);
        label2.setVerticalAlignment(0);
        final List<AnAction> sorters = this.createSorters();
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    9.$$$reportNull$$$0(0);
                }
                DefaultActionGroup group = new DefaultActionGroup();
                if (!sorters.isEmpty()) {
                    group.addAll(sorters);
                    group.addSeparator();
                }
                group.add(new ToggleAction(IdeBundle.message("checkbox.narrow.down.on.typing", new Object[0])){

                    @Override
                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return FileStructurePopup.isShouldNarrowDown();
                    }

                    @Override
                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        PropertiesComponent.getInstance().setValue(FileStructurePopup.NARROW_DOWN_PROPERTY_KEY, Boolean.toString(state));
                        if (FileStructurePopup.this.mySpeedSearch.isPopupActive() && !StringUtil.isEmpty(FileStructurePopup.this.mySpeedSearch.getEnteredPrefix())) {
                            FileStructurePopup.this.rebuild(true);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$9$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setSelected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                DataManager dataManager = DataManager.getInstance();
                ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, group, dataManager.getDataContext(label2), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                popup2.addListener(new JBPopupListener(){

                    @Override
                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        FileStructurePopup.this.myCanClose = true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/FileStructurePopup$9$2", "onClosed"));
                    }
                });
                FileStructurePopup.this.myCanClose = false;
                popup2.showUnderneathOf(label2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/FileStructurePopup$9", "onClick"));
            }
        }.installOn(label2);
        JLabel jLabel = label2;
        if (jLabel == null) {
            FileStructurePopup.$$$reportNull$$$0(8);
        }
        return jLabel;
    }

    private List<AnAction> createSorters() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        for (Sorter sorter : this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            actions.add(new MyTreeActionWrapper(sorter));
        }
        return actions;
    }

    @Nullable
    private static Object findClosestPsiElement(@NotNull PsiElement element2, @NotNull TreePath adjusted, @NotNull TreeModel treeModel) {
        TextRange range2;
        if (element2 == null) {
            FileStructurePopup.$$$reportNull$$$0(9);
        }
        if (adjusted == null) {
            FileStructurePopup.$$$reportNull$$$0(10);
        }
        if (treeModel == null) {
            FileStructurePopup.$$$reportNull$$$0(11);
        }
        if ((range2 = element2.getTextRange()) == null) {
            return null;
        }
        Object parent = adjusted.getLastPathComponent();
        int minDistance = 0;
        Object minChild = null;
        int count = treeModel.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            TextRange r;
            Object child2 = treeModel.getChild(parent, i);
            Object value2 = StructureViewComponent.unwrapValue(child2);
            if (value2 instanceof StubBasedPsiElement && ((StubBasedPsiElement)value2).getStub() != null) continue;
            TextRange textRange = r = value2 instanceof PsiElement ? ((PsiElement)value2).getTextRange() : null;
            if (r == null) continue;
            int distance2 = TextRangeUtil.getDistance(range2, r);
            if (minChild != null && distance2 >= minDistance) continue;
            minDistance = distance2;
            minChild = child2;
        }
        return minChild;
    }

    @Nullable
    private AbstractTreeNode getSelectedNode() {
        TreePath path2 = this.myTree.getSelectionPath();
        Object o = StructureViewComponent.unwrapNavigatable(path2 == null ? null : path2.getLastPathComponent());
        return o instanceof AbstractTreeNode ? (AbstractTreeNode)o : null;
    }

    private boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (ApplicationManager.getApplication().isInternal()) {
            String enteredPrefix = this.mySpeedSearch.getEnteredPrefix();
            String itemText = FileStructurePopup.getSpeedSearchText(selectedNode);
            if (StringUtil.isNotEmpty(enteredPrefix) && StringUtil.isNotEmpty(itemText)) {
                LOG.info("Chosen in file structure popup by prefix '" + enteredPrefix + "': '" + itemText + "'");
            }
        }
        Ref succeeded = new Ref();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            if (selectedNode != null) {
                if (selectedNode.canNavigateToSource()) {
                    selectedNode.navigate(true);
                    this.myPopup.cancel();
                    succeeded.set(true);
                } else {
                    succeeded.set(false);
                }
            } else {
                succeeded.set(false);
            }
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        }, "Navigate", null);
        return (Boolean)succeeded.get();
    }

    private void addCheckbox(JPanel panel2, TreeAction action2) {
        String text2;
        String string = action2 instanceof FileStructureFilter ? ((FileStructureFilter)action2).getCheckBoxText() : (text2 = action2 instanceof FileStructureNodeProvider ? ((FileStructureNodeProvider)action2).getCheckBoxText() : null);
        if (text2 == null) {
            return;
        }
        Shortcut[] shortcuts = FileStructurePopup.extractShortcutFor(action2);
        JBCheckBox checkBox2 = new JBCheckBox();
        checkBox2.setOpaque(false);
        UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, checkBox2);
        boolean selected2 = FileStructurePopup.getDefaultValue(action2);
        checkBox2.setSelected(selected2);
        boolean isRevertedStructureFilter = action2 instanceof FileStructureFilter && ((FileStructureFilter)action2).isReverted();
        this.myTreeActionsOwner.setActionIncluded(action2, isRevertedStructureFilter != selected2);
        checkBox2.addActionListener(actionEvent -> {
            this.logFileStructureCheckboxClick(action2);
            boolean state = checkBox2.isSelected();
            if (!this.myAutoClicked.contains(checkBox2)) {
                FileStructurePopup.saveState(action2, state);
            }
            this.myTreeActionsOwner.setActionIncluded(action2, isRevertedStructureFilter != state);
            this.rebuild(false).onProcessed(ignore -> {
                if (this.mySpeedSearch.isPopupActive()) {
                    this.mySpeedSearch.refreshSelection();
                }
            });
        });
        checkBox2.setFocusable(false);
        if (shortcuts.length > 0) {
            text2 = text2 + " (" + KeymapUtil.getShortcutText(shortcuts[0]) + ")";
            DumbAwareAction.create(e -> checkBox2.doClick()).registerCustomShortcutSet(new CustomShortcutSet(shortcuts), this.myTree);
        }
        checkBox2.setText(text2);
        panel2.add(checkBox2);
        this.myCheckBoxes.put(action2.getClass(), checkBox2);
    }

    private void logFileStructureCheckboxClick(TreeAction action2) {
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        Language language2 = null;
        FileType fileType = this.myFileEditor.getFile().getFileType();
        if (fileType instanceof LanguageFileType) {
            language2 = ((LanguageFileType)fileType).getLanguage();
        }
        FeatureUsageData data2 = new FeatureUsageData().addProject(this.myProject).addPluginInfo(pluginInfo).addPlace("FileStructurePopup").addCurrentFile(language2).addData("class", action2.getClass().getName()).addData("action_id", action2.getClass().getName());
        FUCounterUsageLogger.getInstance().logEvent("actions", "action.invoked", data2);
    }

    @NotNull
    private Promise<Void> rebuild(boolean refilterOnly) {
        Object selection = JBIterable.of(this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent())).first();
        Promise<Void> promise2 = this.rebuildAndSelect(refilterOnly, selection).then(o -> null);
        if (promise2 == null) {
            FileStructurePopup.$$$reportNull$$$0(12);
        }
        return promise2;
    }

    @NotNull
    private Promise<TreePath> rebuildAndSelect(boolean refilterOnly, Object selection) {
        AsyncPromise result2 = new AsyncPromise();
        this.myStructureTreeModel.getInvoker().invoke(() -> {
            if (refilterOnly) {
                this.myFilteringStructure.refilter();
                this.myStructureTreeModel.invalidate().onSuccess(res2 -> (selection == null ? this.myAsyncTreeModel.accept(o -> TreeVisitor.Action.CONTINUE) : this.select(selection)).onError(ignore2 -> result2.setError("rejected")).onSuccess(p -> UIUtil.invokeLaterIfNeeded(() -> {
                    TreeUtil.expand(this.getTree(), this.myTreeModel instanceof StructureViewCompositeModel ? 3 : 2);
                    TreeUtil.ensureSelection(this.myTree);
                    this.mySpeedSearch.refreshSelection();
                    result2.setResult(p);
                })));
            } else {
                this.myTreeStructure.rebuildTree();
                this.myStructureTreeModel.invalidate().onSuccess(res2 -> this.rebuildAndSelect(true, selection).processed((Promise<TreePath>)result2));
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            FileStructurePopup.$$$reportNull$$$0(13);
        }
        return asyncPromise;
    }

    static Shortcut @NotNull [] extractShortcutFor(@NotNull TreeAction action2) {
        if (action2 == null) {
            FileStructurePopup.$$$reportNull$$$0(14);
        }
        if (action2 instanceof ActionShortcutProvider) {
            String actionId = ((ActionShortcutProvider)((Object)action2)).getActionIdForShortcut();
            Shortcut[] shortcutArray = KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts();
            if (shortcutArray == null) {
                FileStructurePopup.$$$reportNull$$$0(15);
            }
            return shortcutArray;
        }
        Shortcut[] shortcutArray = action2 instanceof FileStructureFilter ? ((FileStructureFilter)action2).getShortcut() : ((FileStructureNodeProvider)action2).getShortcut();
        if (shortcutArray == null) {
            FileStructurePopup.$$$reportNull$$$0(16);
        }
        return shortcutArray;
    }

    private static boolean getDefaultValue(TreeAction action2) {
        String propertyName = action2 instanceof PropertyOwner ? ((PropertyOwner)((Object)action2)).getPropertyName() : action2.getName();
        return PropertiesComponent.getInstance().getBoolean(TreeStructureUtil.getPropertyName(propertyName), Sorter.ALPHA_SORTER.equals(action2));
    }

    private static void saveState(TreeAction action2, boolean state) {
        String propertyName = action2 instanceof PropertyOwner ? ((PropertyOwner)((Object)action2)).getPropertyName() : action2.getName();
        PropertiesComponent.getInstance().setValue(TreeStructureUtil.getPropertyName(propertyName), state, Sorter.ALPHA_SORTER.equals(action2));
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            FileStructurePopup.$$$reportNull$$$0(17);
        }
        return tree;
    }

    public TreeSpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    public void setSearchFilterForTests(String filter2) {
        this.myTestSearchFilter = filter2;
    }

    public void setTreeActionState(Class<? extends TreeAction> action2, boolean state) {
        JBCheckBox checkBox2 = this.myCheckBoxes.get(action2);
        if (checkBox2 != null) {
            checkBox2.setSelected(state);
            for (ActionListener listener2 : checkBox2.getActionListeners()) {
                listener2.actionPerformed(new ActionEvent(this, 1, ""));
            }
        }
    }

    @Nullable
    public static String getSpeedSearchText(Object object) {
        String text2 = String.valueOf(object);
        Object value2 = StructureViewComponent.unwrapWrapper(object);
        if (text2 != null) {
            String locationString;
            if (value2 instanceof PsiTreeElementBase && ((PsiTreeElementBase)value2).isSearchInLocationString() && !StringUtil.isEmpty(locationString = ((PsiTreeElementBase)value2).getLocationString())) {
                String locationPrefix = null;
                String locationSuffix = null;
                if (value2 instanceof LocationPresentation) {
                    locationPrefix = ((LocationPresentation)value2).getLocationPrefix();
                    locationSuffix = ((LocationPresentation)value2).getLocationSuffix();
                }
                return text2 + StringUtil.notNullize(locationPrefix, " (") + locationString + StringUtil.notNullize(locationSuffix, ")");
            }
            return text2;
        }
        if (value2 instanceof TreeElement) {
            return ReadAction.compute(() -> ((TreeElement)value2).getPresentation().getPresentableText());
        }
        return null;
    }

    @Override
    public void setActionActive(String name, boolean state) {
    }

    @Override
    public boolean isActionActive(String name) {
        return false;
    }

    @Nullable
    private String getSearchPrefix() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myTestSearchFilter;
        }
        return this.mySpeedSearch != null && !StringUtil.isEmpty(this.mySpeedSearch.getEnteredPrefix()) ? this.mySpeedSearch.getEnteredPrefix() : null;
    }

    @Nullable
    private static SpeedSearchObjectWithWeight find(@NotNull PsiElement element2, @NotNull List<? extends SpeedSearchObjectWithWeight> objects, @NotNull BiPredicate<? super PsiElement, ? super TreePath> predicate) {
        if (element2 == null) {
            FileStructurePopup.$$$reportNull$$$0(18);
        }
        if (objects == null) {
            FileStructurePopup.$$$reportNull$$$0(19);
        }
        if (predicate == null) {
            FileStructurePopup.$$$reportNull$$$0(20);
        }
        return (SpeedSearchObjectWithWeight)((Object)ContainerUtil.find(objects, object -> predicate.test(element2, ObjectUtils.tryCast(object.node, TreePath.class))));
    }

    private static boolean isElement(@NotNull PsiElement element2, @Nullable TreePath path2) {
        if (element2 == null) {
            FileStructurePopup.$$$reportNull$$$0(21);
        }
        return element2.equals(StructureViewComponent.unwrapValue(TreeUtil.getLastUserObject(FilteringTreeStructure.FilteringNode.class, path2)));
    }

    private static boolean isParent(@NotNull PsiElement parent, @Nullable TreePath path2) {
        if (parent == null) {
            FileStructurePopup.$$$reportNull$$$0(22);
        }
        return path2 != null && FileStructurePopup.isElement(parent, path2.getParentPath());
    }

    private static boolean isAncestor(@NotNull PsiElement ancestor, @Nullable TreePath path2) {
        if (ancestor == null) {
            FileStructurePopup.$$$reportNull$$$0(23);
        }
        while (path2 != null) {
            if (FileStructurePopup.isElement(ancestor, path2)) {
                return true;
            }
            path2 = path2.getParentPath();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureView";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/FileStructurePopup";
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjusted";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/FileStructurePopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsButton";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuild";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildAndSelect";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractShortcutFor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClosestPsiElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractShortcutFor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isParent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyTree
    extends DnDAwareTree
    implements PlaceProvider<String> {
        MyTree(TreeModel treeModel) {
            super(treeModel);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            HintUpdateSupply.installHintUpdateSupply(this, o -> {
                Object value2 = StructureViewComponent.unwrapValue(o);
                return value2 instanceof PsiElement ? (PsiElement)value2 : null;
            });
        }

        @Override
        public String getPlace() {
            return "StructureViewPopup";
        }
    }

    private class MyTreeSpeedSearch
    extends TreeSpeedSearch {
        MyTreeSpeedSearch() {
            super(FileStructurePopup.this.myTree, (? super TreePath path2) -> FileStructurePopup.getSpeedSearchText(TreeUtil.getLastUserObject(path2)), true);
        }

        @Override
        protected Point getComponentLocationOnScreen() {
            return FileStructurePopup.this.myPopup.getContent().getLocationOnScreen();
        }

        @Override
        protected Rectangle getComponentVisibleRect() {
            return FileStructurePopup.this.myPopup.getContent().getVisibleRect();
        }

        @Override
        public Object findElement(String s) {
            List<SpeedSearchObjectWithWeight> elements2 = SpeedSearchObjectWithWeight.findElement(s, this);
            SpeedSearchObjectWithWeight best = ContainerUtil.getFirstItem(elements2);
            if (best == null) {
                return null;
            }
            if (FileStructurePopup.this.myInitialElement instanceof PsiElement) {
                SpeedSearchObjectWithWeight bestSibling;
                PsiElement initial = (PsiElement)FileStructurePopup.this.myInitialElement;
                SpeedSearchObjectWithWeight bestForParent = FileStructurePopup.find(initial, elements2, (x$0, x$1) -> FileStructurePopup.isParent(x$0, x$1));
                if (bestForParent != null) {
                    return bestForParent.node;
                }
                PsiElement parent = initial.getParent();
                if (parent != null && (bestSibling = FileStructurePopup.find(parent, elements2, (x$0, x$1) -> FileStructurePopup.isParent(x$0, x$1))) != null) {
                    return bestSibling.node;
                }
                SpeedSearchObjectWithWeight bestForAncestor = FileStructurePopup.find(initial, elements2, (x$0, x$1) -> FileStructurePopup.isAncestor(x$0, x$1));
                if (bestForAncestor != null) {
                    return bestForAncestor.node;
                }
            }
            return best.node;
        }
    }

    private class FileStructurePopupFilter
    implements ElementFilter {
        private String myLastFilter;
        private final Set<Object> myVisibleParents = new HashSet<Object>();
        private final boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();

        private FileStructurePopupFilter() {
        }

        public boolean shouldBeShowing(Object value2) {
            if (!FileStructurePopup.isShouldNarrowDown()) {
                return true;
            }
            String filter2 = FileStructurePopup.this.getSearchPrefix();
            if (!StringUtil.equals(this.myLastFilter, filter2)) {
                this.myVisibleParents.clear();
                this.myLastFilter = filter2;
            }
            if (filter2 != null) {
                if (this.myVisibleParents.contains(value2)) {
                    return true;
                }
                String text2 = FileStructurePopup.getSpeedSearchText(value2);
                if (text2 == null) {
                    return false;
                }
                if (this.matches(filter2, text2)) {
                    Object o = value2;
                    while (o instanceof FilteringTreeStructure.FilteringNode && (o = ((FilteringTreeStructure.FilteringNode)o).getParent()) != null) {
                        this.myVisibleParents.add(o);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        private boolean matches(@NotNull String filter2, @NotNull String text2) {
            if (filter2 == null) {
                FileStructurePopupFilter.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                FileStructurePopupFilter.$$$reportNull$$$0(1);
            }
            return (this.isUnitTest || FileStructurePopup.this.mySpeedSearch.isPopupActive()) && StringUtil.isNotEmpty(filter2) && FileStructurePopup.this.mySpeedSearch.getComparator().matchingFragments(filter2, text2) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/util/FileStructurePopup$FileStructurePopupFilter";
            objectArray[2] = "matches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTreeActionWrapper
    extends TreeActionWrapper {
        private final TreeAction myAction;

        MyTreeActionWrapper(TreeAction action2) {
            super(action2, FileStructurePopup.this.myTreeActionsOwner);
            this.myAction = action2;
            FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(action2, FileStructurePopup.getDefaultValue(action2));
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyTreeActionWrapper.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setIcon(null);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyTreeActionWrapper.$$$reportNull$$$0(1);
            }
            boolean actionState = TreeModelWrapper.shouldRevert(this.myAction) != state;
            FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(this.myAction, actionState);
            FileStructurePopup.saveState(this.myAction, state);
            FileStructurePopup.this.rebuild(false).onProcessed(ignore -> {
                if (FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.refreshSelection();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$MyTreeActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

