/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer {
    private static final Logger LOG = Logger.getInstance(PsiElementListCellRenderer.class);
    private static final String LEFT = "West";
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
    private boolean myFocusBorderEnabled = Registry.is("psi.element.list.cell.renderer.focus.border.enabled");
    protected int myRightComponentWidth;

    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    @Nullable
    protected static Color getBackgroundColor(@Nullable Object value2) {
        PsiElement psiElement = NavigationItemListCellRenderer.getPsiElement(value2);
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiElement);
        Color fileColor = virtualFile2 == null ? null : VfsPresentationUtil.getFileBackgroundColor(psiElement.getProject(), virtualFile2);
        return fileColor != null ? fileColor : UIUtil.getListBackground();
    }

    @Nullable
    protected TextAttributes getNavigationItemAttributes(Object value2) {
        TextAttributes attributes = null;
        if (value2 instanceof NavigationItem) {
            TextAttributesKey attributesKey = null;
            ItemPresentation presentation = ((NavigationItem)value2).getPresentation();
            if (presentation instanceof ColoredItemPresentation) {
                attributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
            }
            if (attributesKey != null) {
                attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            }
        }
        return attributes;
    }

    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        this.myRightComponentWidth = 0;
        DefaultListCellRenderer rightRenderer = this.getRightCellRenderer(value2);
        Component rightCellRendererComponent = null;
        JPanel spacer = null;
        if (rightRenderer != null) {
            rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            this.add(rightCellRendererComponent, "East");
            spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)spacer, "Center");
            this.myRightComponentWidth = rightCellRendererComponent.getPreferredSize().width;
            this.myRightComponentWidth += spacer.getPreferredSize().width;
        }
        LeftRenderer leftRenderer = new LeftRenderer(null, value2 == null ? new ItemMatchers(null, null) : this.getItemMatchers(list2, value2));
        Component leftCellRendererComponent = leftRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
        this.add(leftCellRendererComponent, LEFT);
        Color bg = isSelected ? UIUtil.getListSelectionBackground(true) : leftCellRendererComponent.getBackground();
        this.setBackground(bg);
        if (rightCellRendererComponent != null) {
            rightCellRendererComponent.setBackground(bg);
        }
        if (spacer != null) {
            spacer.setBackground(bg);
        }
        return this;
    }

    @NotNull
    protected ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value2) {
        if (list2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(1);
        }
        return new ItemMatchers(MatcherHolder.getAssociatedMatcher(list2), null);
    }

    protected void setFocusBorderEnabled(boolean enabled) {
        this.myFocusBorderEnabled = enabled;
    }

    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
        return false;
    }

    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            return PsiElementListCellRenderer.getModuleRenderer(value2);
        }
        return null;
    }

    private static DefaultListCellRenderer getModuleRenderer(Object value2) {
        DefaultListCellRenderer renderer = ModuleRendererFactory.findInstance(value2).getModuleRenderer();
        if (renderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return renderer;
    }

    public abstract String getElementText(T var1);

    @Nullable
    protected abstract String getContainerText(T var1, String var2);

    @Nullable
    protected String getContainerTextForLeftComponent(T element2, String name, int maxWidth, FontMetrics fm) {
        return this.getContainerText(element2, name);
    }

    @Iconable.IconFlags
    protected abstract int getIconFlags();

    protected Icon getIcon(PsiElement element2) {
        return element2.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(this::getComparingObject);
    }

    @NotNull
    public Comparable getComparingObject(T element2) {
        Comparable comparable = (Comparable)((Object)ReadAction.compute(() -> {
            String elementText = this.getElementText(element2);
            String containerText = this.getContainerText(element2, elementText);
            DefaultListCellRenderer moduleRenderer = PsiElementListCellRenderer.getModuleRenderer(element2);
            return (containerText == null ? elementText : elementText + " " + containerText) + (moduleRenderer != null ? moduleRenderer.getText() : "");
        }));
        if (comparable == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(2);
        }
        return comparable;
    }

    @Deprecated
    public void installSpeedSearch(PopupChooserBuilder<?> builder2) {
        this.installSpeedSearch((IPopupChooserBuilder)builder2);
    }

    @Deprecated
    public void installSpeedSearch(PopupChooserBuilder<?> builder2, boolean includeContainerText) {
        this.installSpeedSearch((IPopupChooserBuilder)builder2, includeContainerText);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2) {
        this.installSpeedSearch(builder2, false);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2, boolean includeContainerText) {
        builder2.setNamerForFiltering(o -> {
            if (o instanceof PsiElement) {
                String elementText = this.getElementText((PsiElement)o);
                if (includeContainerText) {
                    return elementText + " " + this.getContainerText((PsiElement)o, elementText);
                }
                return elementText;
            }
            return o.toString();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItemMatchers";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        private final String myModuleName;
        private final ItemMatchers myMatchers;

        LeftRenderer(@NotNull String moduleName, ItemMatchers matchers) {
            if (matchers == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            this.myModuleName = moduleName;
            this.myMatchers = matchers;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                LeftRenderer.$$$reportNull$$$0(1);
            }
            Color bgColor = UIUtil.getListBackground();
            Color color = list2.getForeground();
            this.setPaintFocusBorder(hasFocus && UIUtil.isToUseDottedCellBorder() && PsiElementListCellRenderer.this.myFocusBorderEnabled);
            PsiElement target2 = NavigationItemListCellRenderer.getPsiElement(value2);
            VirtualFile vFile = PsiUtilCore.getVirtualFile(target2);
            boolean isProblemFile = false;
            if (vFile != null) {
                Project project2 = target2.getProject();
                isProblemFile = WolfTheProblemSolver.getInstance(project2).isProblemFile(vFile);
                FileStatus status = FileStatusManager.getInstance(project2).getStatus(vFile);
                color = status.getColor();
                Color fileBgColor = VfsPresentationUtil.getFileBackgroundColor(project2, vFile);
                Color color2 = bgColor = fileBgColor == null ? bgColor : fileBgColor;
            }
            if (value2 instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                PsiElement element2 = (PsiElement)value2;
                String name = ((PsiElement)value2).isValid() ? PsiElementListCellRenderer.this.getElementText(element2) : "INVALID";
                TextAttributes attributes = element2.isValid() ? PsiElementListCellRenderer.this.getNavigationItemAttributes(value2) : null;
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                if (name == null) {
                    LOG.error("Null name for PSI element " + element2.getClass() + " (by " + PsiElementListCellRenderer.this + ")");
                    name = "Unknown";
                }
                SpeedSearchUtil.appendColoredFragmentForMatcher(name, this, nameAttributes, this.myMatchers.nameMatcher, bgColor, selected2);
                if (!element2.isValid()) {
                    this.append(" Invalid", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element2));
                FontMetrics fm = list2.getFontMetrics(list2.getFont());
                int maxWidth = list2.getWidth() - fm.stringWidth(name) - (this.myModuleName != null ? fm.stringWidth(this.myModuleName + "        ") : 0) - 16 - PsiElementListCellRenderer.this.myRightComponentWidth - 20;
                String containerText = PsiElementListCellRenderer.this.getContainerTextForLeftComponent(element2, name, maxWidth, fm);
                if (containerText != null) {
                    this.appendLocationText(selected2, bgColor, isProblemFile, containerText);
                }
            } else if (!PsiElementListCellRenderer.this.customizeNonPsiElementLeftRenderer(this, list2, value2, index, selected2, hasFocus)) {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value2 == null ? "" : value2.toString(), new SimpleTextAttributes(0, list2.getForeground()));
            }
            this.setBackground(selected2 ? UIUtil.getListSelectionBackground(true) : bgColor);
        }

        private void appendLocationText(boolean selected2, Color bgColor, boolean isProblemFile, String containerText) {
            SimpleTextAttributes locationAttrs = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            if (isProblemFile) {
                SimpleTextAttributes wavedAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)new SimpleTextAttributes(8, UIUtil.getInactiveTextColor(), (Color)JBColor.RED), (SimpleTextAttributes)locationAttrs);
                Matcher matcher = CONTAINER_PATTERN.matcher(containerText);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    SpeedSearchUtil.appendColoredFragmentForMatcher(" " + ObjectUtils.notNull(prefix, ""), this, locationAttrs, this.myMatchers.locationMatcher, bgColor, selected2);
                    String strippedContainerText = matcher.group(2);
                    SpeedSearchUtil.appendColoredFragmentForMatcher(ObjectUtils.notNull(strippedContainerText, ""), this, wavedAttributes, this.myMatchers.locationMatcher, bgColor, selected2);
                    String suffix = matcher.group(3);
                    if (suffix != null) {
                        SpeedSearchUtil.appendColoredFragmentForMatcher(suffix, this, locationAttrs, this.myMatchers.locationMatcher, bgColor, selected2);
                    }
                    return;
                }
                locationAttrs = wavedAttributes;
            }
            SpeedSearchUtil.appendColoredFragmentForMatcher(" " + containerText, this, locationAttrs, this.myMatchers.locationMatcher, bgColor, selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$LeftRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ItemMatchers {
        @Nullable
        public final com.intellij.util.text.Matcher nameMatcher;
        @Nullable
        final com.intellij.util.text.Matcher locationMatcher;

        public ItemMatchers(@Nullable com.intellij.util.text.Matcher nameMatcher, @Nullable com.intellij.util.text.Matcher locationMatcher) {
            this.nameMatcher = nameMatcher;
            this.locationMatcher = locationMatcher;
        }
    }

    private class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        private MyAccessibleContext() {
            super(PsiElementListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            LayoutManager lm = PsiElementListCellRenderer.this.getLayout();
            assert (lm instanceof BorderLayout);
            Component leftCellRendererComp = ((BorderLayout)lm).getLayoutComponent(PsiElementListCellRenderer.LEFT);
            return leftCellRendererComp instanceof Accessible ? leftCellRendererComp.getAccessibleContext().getAccessibleName() : super.getAccessibleName();
        }
    }
}

