/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementModuleRenderer
extends DefaultListCellRenderer {
    private String myText;

    @Override
    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list2, (Object)null, index, isSelected, cellHasFocus);
        this.customizeCellRenderer(value2, isSelected);
        return listCellRendererComponent;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    private void customizeCellRenderer(Object value2, boolean selected2) {
        PsiElement element2;
        this.myText = "";
        if (value2 instanceof PsiElement && (element2 = (PsiElement)value2).isValid()) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(element2.getProject()).getFileIndex();
            VirtualFile vFile = PsiUtilCore.getVirtualFile(element2);
            if (vFile != null && fileIndex.isInLibrary(vFile)) {
                this.showLibraryLocation(fileIndex, vFile);
            } else {
                Module module2 = ModuleUtilCore.findModuleForPsiElement(element2);
                if (module2 != null) {
                    this.showProjectLocation(vFile, module2, fileIndex);
                }
            }
        }
        this.setText(this.myText);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(4);
        this.setBackground(selected2 ? UIUtil.getListSelectionBackground(true) : UIUtil.getListBackground());
        this.setForeground(selected2 ? UIUtil.getListSelectionForeground() : UIUtil.getInactiveTextColor());
    }

    private void showProjectLocation(@Nullable VirtualFile vFile, @NotNull Module module2, @NotNull ProjectFileIndex fileIndex) {
        String path2;
        boolean inTestSource;
        if (module2 == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(1);
        }
        boolean bl = inTestSource = vFile != null && fileIndex.isInTestSourceContent(vFile);
        this.myText = Registry.is("ide.show.folder.name.instead.of.module.name") ? (StringUtil.isEmpty(path2 = ModuleUtilCore.getModuleDirPath(module2)) ? module2.getName() : new File(path2).getName()) : module2.getName();
        if (inTestSource) {
            this.setIcon(AllIcons.Nodes.TestSourceFolder);
        } else {
            this.setIcon(ModuleType.get(module2).getIcon());
        }
    }

    private void showLibraryLocation(ProjectFileIndex fileIndex, VirtualFile vFile) {
        this.setIcon(AllIcons.Nodes.PpLibFolder);
        for (OrderEntry order : fileIndex.getOrderEntriesForFile(vFile)) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            this.myText = this.getPresentableName(order, vFile);
            break;
        }
        if (StringUtil.isEmpty(this.myText) && Registry.is("index.run.configuration.jre")) {
            for (Sdk sdk2 : ProjectJdkTable.getInstance().getAllJdks()) {
                Set roots = StreamEx.of((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)).append((Object[])sdk2.getRootProvider().getFiles(OrderRootType.SOURCES)).toSet();
                if (!VfsUtilCore.isUnder(vFile, roots)) continue;
                this.myText = "< " + sdk2.getName() + " >";
                break;
            }
        }
        this.myText = this.myText.substring(this.myText.lastIndexOf(File.separatorChar) + 1);
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
        if (jar != null && !this.myText.equals(jar.getName())) {
            this.myText = this.myText + " (" + jar.getName() + ")";
        }
    }

    protected String getPresentableName(OrderEntry order, VirtualFile vFile) {
        return order.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileIndex";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/PsiElementModuleRenderer";
        objectArray[2] = "showProjectLocation";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

