/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameInScopeItemProvider {
    private static final Logger LOG = Logger.getInstance(DefaultChooseByNameItemProvider.class);
    private static final String UNIVERSAL_SEPARATOR = "\u0000";
    private final SmartPsiElementPointer<PsiElement> myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance(context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(3);
        }
        return this.filterElementsWithWeights(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, res2 -> consumer.process(res2.getItem()));
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(7);
        }
        return this.filterElementsWithWeights(base, parameters, indicator, res2 -> consumer.process(res2.getItem()));
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(8);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(11);
        }
        return this.filterElementsWithWeights(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, consumer);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(12);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(15);
        }
        return ProgressManager.getInstance().computePrioritized(() -> DefaultChooseByNameItemProvider.filterElements((ChooseByNameViewModel)base, indicator, this.myContext == null ? null : this.myContext.getElement(), () -> base.getNames(parameters.isSearchInLibraries()), consumer, parameters));
    }

    public static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @NotNull Processor<Object> consumer) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(16);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(19);
        }
        return DefaultChooseByNameItemProvider.filterElements(base, indicator, context, null, (? super FoundItemDescriptor<?> res2) -> consumer.process(res2.getItem()), DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere));
    }

    private static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @Nullable Supplier<String[]> allNamesProducer, @NotNull Processor<? super FoundItemDescriptor<?>> consumer, @NotNull FindSymbolParameters parameters) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(23);
        }
        boolean everywhere = parameters.isSearchInLibraries();
        String pattern = parameters.getCompletePattern();
        if (base.getProject() != null) {
            base.getProject().putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        boolean preferStartMatches = !pattern.startsWith("*");
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getSortedNamesForAllWildcards(base, parameters, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        return DefaultChooseByNameItemProvider.processByNames(base, everywhere, indicator, context, consumer, namesList, parameters);
    }

    @NotNull
    private static List<MatchResult> getSortedNamesForAllWildcards(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        String matchingPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(24);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(26);
        }
        if ((matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            List<MatchResult> list2 = Collections.emptyList();
            if (list2 == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(27);
            }
            return list2;
        }
        List<MatchResult> result2 = DefaultChooseByNameItemProvider.getSortedNames(base, parameters, indicator, allNamesProducer, matchingPattern, preferStartMatches);
        if (!namePattern.contains("*")) {
            List<MatchResult> list3 = result2;
            if (list3 == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(28);
            }
            return list3;
        }
        HashSet<String> allNames = new HashSet<String>(ContainerUtil.map(result2, mr -> mr.elementName));
        for (int i = 1; i < namePattern.length() - 1; ++i) {
            if (namePattern.charAt(i) != '*') continue;
            List<MatchResult> namesForSuffix = DefaultChooseByNameItemProvider.getSortedNames(base, parameters, indicator, allNamesProducer, DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern.substring(i + 1)), preferStartMatches);
            for (MatchResult mr2 : namesForSuffix) {
                if (!allNames.add(mr2.elementName)) continue;
                result2.add(mr2);
            }
        }
        List<MatchResult> list4 = result2;
        if (list4 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(29);
        }
        return list4;
    }

    @NotNull
    private static List<MatchResult> getSortedNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(30);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(31);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(32);
        }
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getAllNames(base, parameters, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        String pattern = parameters.getCompletePattern();
        long started = System.currentTimeMillis();
        namesList.sort(Comparator.comparing(mr -> !pattern.equalsIgnoreCase(mr.elementName)).thenComparing(mr -> !namePattern.equalsIgnoreCase(mr.elementName)).thenComparing(Comparator.naturalOrder()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + namesList.size());
        }
        List<MatchResult> list2 = namesList;
        if (list2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(33);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static List<MatchResult> getAllNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, @NotNull String namePattern, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(34);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(35);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(36);
        }
        if (namePattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(37);
        }
        ArrayList namesList = new ArrayList();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        ChooseByNameModel model = base.getModel();
        if (model instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            long started = System.currentTimeMillis();
            String fullPattern = parameters.getCompletePattern();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern, preferStartMatches);
            ((ChooseByNameModelEx)model).processNames(sequence -> {
                indicator.checkCanceled();
                MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, fullPattern, matcher, sequence);
                if (result2 != null) {
                    collect.consume(result2);
                    return true;
                }
                return false;
            }, parameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + ((CollectConsumer)collect).getResult().size());
            }
        } else {
            if (allNamesProducer == null) {
                throw new IllegalArgumentException("Need to specify allNamesProducer when using a model which isn't a ChooseByNameModelEx");
            }
            String[] names2 = allNamesProducer.get();
            long started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, namePattern, indicator, collect, preferStartMatches);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names2.length);
            }
        }
        SynchronizedCollectConsumer synchronizedCollectConsumer = collect;
        // MONITORENTER : synchronizedCollectConsumer
        ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>(namesList);
        // MONITOREXIT : synchronizedCollectConsumer
        if (arrayList != null) return arrayList;
        DefaultChooseByNameItemProvider.$$$reportNull$$$0(38);
        return arrayList;
    }

    @NotNull
    private static FindSymbolParameters createParameters(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere) {
        ChooseByNameModel model;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(39);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(40);
        }
        IdFilter idFilter = (model = base.getModel()) instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getIdFilter(everywhere) : null;
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.getProject(), everywhere);
        return new FindSymbolParameters(pattern, DefaultChooseByNameItemProvider.getNamePattern(base, pattern), searchScope, idFilter);
    }

    private static boolean processByNames(@NotNull ChooseByNameViewModel base, boolean everywhere, @NotNull ProgressIndicator indicator, final @Nullable PsiElement context, @NotNull Processor<? super FoundItemDescriptor<?>> consumer, @NotNull List<? extends MatchResult> namesList, @NotNull FindSymbolParameters parameters) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(41);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(42);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(43);
        }
        if (namesList == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(44);
        }
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(45);
        }
        SmartList<Pair<Object, MatchResult>> sameNameElements = new SmartList<Pair<Object, MatchResult>>();
        final ChooseByNameModel model = base.getModel();
        Comparator<Pair<Object, MatchResult>> weightComparator = new Comparator<Pair<Object, MatchResult>>(){
            final Comparator<Object> modelComparator;
            {
                this.modelComparator = model instanceof Comparator ? (Comparator)((Object)model) : new PathProximityComparator(context);
            }

            @Override
            public int compare(Pair<Object, MatchResult> o1, Pair<Object, MatchResult> o2) {
                int result2 = this.modelComparator.compare(o1.first, o2.first);
                return result2 != 0 ? result2 : ((MatchResult)o1.second).compareTo((MatchResult)o2.second);
            }
        };
        MinusculeMatcher fullMatcher = DefaultChooseByNameItemProvider.getFullMatcher(parameters, base);
        for (MatchResult matchResult : namesList) {
            Object[] elements2;
            indicator.checkCanceled();
            String name = matchResult.elementName;
            Object[] objectArray = elements2 = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getElementsByName(name, parameters, indicator) : model.getElementsByName(name, everywhere, DefaultChooseByNameItemProvider.getNamePattern(base, parameters.getCompletePattern()));
            if (elements2.length > 1) {
                sameNameElements.clear();
                for (Object element2 : elements2) {
                    indicator.checkCanceled();
                    MatchResult qualifiedResult = DefaultChooseByNameItemProvider.matchQualifiedName(model, fullMatcher, element2);
                    if (qualifiedResult == null) continue;
                    sameNameElements.add(Pair.create(element2, qualifiedResult));
                }
                sameNameElements.sort(weightComparator);
                List<FoundItemDescriptor> processedItems = ContainerUtil.map(sameNameElements, p -> new FoundItemDescriptor(p.first, result2.matchingDegree));
                if (ContainerUtil.process(processedItems, consumer)) continue;
                return false;
            }
            if (elements2.length != 1 || DefaultChooseByNameItemProvider.matchQualifiedName(model, fullMatcher, elements2[0]) == null || consumer.process(new FoundItemDescriptor<Object>(elements2[0], matchResult.matchingDegree))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected PathProximityComparator getPathProximityComparator() {
        return new PathProximityComparator(this.myContext == null ? null : this.myContext.getElement());
    }

    @NotNull
    private static MinusculeMatcher getFullMatcher(@NotNull FindSymbolParameters parameters, @NotNull ChooseByNameViewModel base) {
        if (parameters == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(46);
        }
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(47);
        }
        String fullRawPattern = DefaultChooseByNameItemProvider.buildFullPattern(base, parameters.getCompletePattern());
        String fullNamePattern = DefaultChooseByNameItemProvider.buildFullPattern(base, base.transformPattern(parameters.getCompletePattern()));
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcherWithFallback(fullRawPattern, fullNamePattern, NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(48);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String buildFullPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(49);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(50);
        }
        String fullPattern = "*" + DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        for (String separator : base.getModel().getSeparators()) {
            fullPattern = StringUtil.replace(fullPattern, separator, "*\u0000*");
        }
        String string = fullPattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(52);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(53);
        }
        String transformedPattern = base.transformPattern(pattern);
        return DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        if (model == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(54);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(55);
        }
        String[] separators = model.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        String string = pattern.substring(lastSeparatorOccurrence);
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(56);
        }
        return string;
    }

    @Nullable
    private static MatchResult matchQualifiedName(@NotNull ChooseByNameModel model, @NotNull MinusculeMatcher fullMatcher, @NotNull Object element2) {
        String fullName;
        if (model == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(57);
        }
        if (fullMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(58);
        }
        if (element2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(59);
        }
        if ((fullName = model.getFullName(element2)) == null) {
            return null;
        }
        for (String separator : model.getSeparators()) {
            fullName = StringUtil.replace(fullName, separator, UNIVERSAL_SEPARATOR);
        }
        return DefaultChooseByNameItemProvider.matchName(fullMatcher, fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names2, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(60);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(61);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(62);
        }
        boolean preferStartMatches = pattern.startsWith("*");
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            List<String> list2 = Collections.emptyList();
            if (list2 != null) return list2;
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(63);
            return list2;
        }
        ArrayList<String> filtered2 = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), result2 -> {
            List list2 = filtered2;
            synchronized (list2) {
                filtered2.add(result2.elementName);
            }
        }, preferStartMatches);
        ArrayList<String> arrayList2 = filtered2;
        // MONITORENTER : arrayList2
        ArrayList<String> arrayList = filtered2;
        // MONITOREXIT : arrayList2
        if (arrayList != null) return arrayList;
        DefaultChooseByNameItemProvider.$$$reportNull$$$0(64);
        return arrayList;
    }

    private static void processNamesByPattern(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<? super MatchResult> consumer, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(65);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(66);
        }
        if (consumer == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(67);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(68);
        }
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern, preferStartMatches);
        Processor<String> processor2 = name -> {
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer.consume(result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names2), indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String convertToMatchingPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(69);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(70);
        }
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern));
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String trimmedPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(71);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(72);
        }
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        if (model == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(74);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(75);
        }
        if (model instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model).removeModelSpecificMarkup(pattern);
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(76);
        }
        return string;
    }

    @Nullable
    protected static MatchResult matches(@NotNull ChooseByNameViewModel base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(77);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(78);
        }
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(79);
        }
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)((Object)base.getModel())).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info(e);
                return null;
            }
        }
        return DefaultChooseByNameItemProvider.matchName(matcher, name);
    }

    @Nullable
    private static MatchResult matchName(@NotNull MinusculeMatcher matcher, @NotNull String name) {
        FList<TextRange> fragments;
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(80);
        }
        if (name == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(81);
        }
        return (fragments = matcher.matchingFragments(name)) != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch(fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern, boolean preferStartMatches) {
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(82);
        }
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher(pattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE);
        if (preferStartMatches) {
            builder2 = builder2.preferringStartMatches();
        }
        MinusculeMatcher minusculeMatcher = builder2.build();
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(83);
        }
        return minusculeMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 38: 
            case 48: 
            case 51: 
            case 56: 
            case 63: 
            case 64: 
            case 73: 
            case 76: 
            case 83: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 38: 
            case 48: 
            case 51: 
            case 56: 
            case 63: 
            case 64: 
            case 73: 
            case 76: 
            case 83: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 9: 
            case 17: 
            case 40: 
            case 50: 
            case 53: 
            case 55: 
            case 61: 
            case 66: 
            case 70: 
            case 72: 
            case 75: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 21: 
            case 26: 
            case 32: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 43: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 13: 
            case 23: 
            case 25: 
            case 31: 
            case 35: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 38: 
            case 48: 
            case 51: 
            case 56: 
            case 63: 
            case 64: 
            case 73: 
            case 76: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesList";
                break;
            }
            case 54: 
            case 57: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMatcher";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNamesForAllWildcards";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNames";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullMatcher";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFullPattern";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePattern";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatternMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsWithWeights";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSortedNamesForAllWildcards";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 38: 
            case 48: 
            case 51: 
            case 56: 
            case 63: 
            case 64: 
            case 73: 
            case 76: 
            case 83: {
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSortedNames";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAllNames";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createParameters";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processByNames";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getFullMatcher";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "buildFullPattern";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getNamePattern";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "matchQualifiedName";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processNamesByPattern";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "convertToMatchingPattern";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "matchName";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "buildPatternMatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 38: 
            case 48: 
            case 51: 
            case 56: 
            case 63: 
            case 64: 
            case 73: 
            case 76: 
            case 83: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

