/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GotoActionItemProvider
implements ChooseByNameItemProvider {
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final GotoActionModel myModel;
    private final NotNullLazyValue<Map<String, ApplyIntentionAction>> myIntentions;
    private static final Logger LOG = Logger.getInstance(GotoActionItemProvider.class);

    public GotoActionItemProvider(GotoActionModel model) {
        this.myModel = model;
        this.myIntentions = NotNullLazyValue.createValue(() -> ReadAction.compute(() -> this.myModel.getAvailableIntentions()));
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names2, @NotNull String pattern) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(1);
        }
        if (names2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(2);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(5);
        }
        if (cancelled == null) {
            GotoActionItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            GotoActionItemProvider.$$$reportNull$$$0(7);
        }
        return this.filterElements(pattern, value2 -> {
            if (!everywhere && value2.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)value2.value).isAvailable()) {
                return true;
            }
            return consumer.process(value2);
        });
    }

    public boolean filterElements(@NotNull String pattern, @NotNull Processor<? super GotoActionModel.MatchedValue> consumer) {
        DataContext dataContext;
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            GotoActionItemProvider.$$$reportNull$$$0(9);
        }
        if (!this.processAbbreviations(pattern, consumer, dataContext = DataManager.getInstance().getDataContext(this.myModel.getContextComponent()))) {
            return false;
        }
        if (!this.processActions(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processTopHits(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processIntentions(pattern, consumer, dataContext)) {
            return false;
        }
        return this.processOptions(pattern, consumer, dataContext);
    }

    private boolean processAbbreviations(@NotNull String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext context) {
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(10);
        }
        List<String> actionIds = AbbreviationManager.getInstance().findActions(pattern);
        JBIterable<GotoActionModel.MatchedValue> wrappers = JBIterable.from(actionIds).filterMap(this.myActionManager::getAction).transform(action2 -> {
            GotoActionModel.ActionWrapper wrapper2 = this.wrapAnAction((AnAction)action2, context);
            return new GotoActionModel.MatchedValue(wrapper2, pattern){

                @Override
                @NotNull
                public String getValueText() {
                    String string = this.pattern;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionItemProvider$1", "getValueText"));
                }
            };
        });
        return GotoActionItemProvider.processItems(pattern, wrappers, consumer);
    }

    private boolean processTopHits(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        CollectConsumer<Object> collector = new CollectConsumer<Object>();
        String commandAccelerator = SearchTopHitProvider.getTopHitAccelerator();
        for (SearchTopHitProvider provider : SearchTopHitProvider.EP_NAME.getExtensions()) {
            if (provider instanceof OptionsTopHitProvider.CoveredByToggleActions) continue;
            if (provider instanceof OptionsSearchTopHitProvider && !StringUtil.startsWith(pattern, commandAccelerator)) {
                String prefix = commandAccelerator + ((OptionsSearchTopHitProvider)((Object)provider)).getId() + " ";
                provider.consumeTopHits(prefix + pattern, collector, project2);
            } else if (project2 != null && provider instanceof OptionsTopHitProvider.ProjectLevelProvidersAdapter) {
                ((OptionsTopHitProvider.ProjectLevelProvidersAdapter)provider).consumeAllTopHits(pattern, collector, project2);
            }
            provider.consumeTopHits(pattern, collector, project2);
        }
        Collection result2 = collector.getResult();
        JBIterable<Object> wrappers = JBIterable.from(result2).transform(object -> object instanceof AnAction ? this.wrapAnAction((AnAction)object, dataContext) : object);
        return GotoActionItemProvider.processItems(pattern, wrappers, consumer);
    }

    private boolean processOptions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Map<String, String> map2 = this.myModel.getConfigurablesNames();
        SearchableOptionsRegistrarImpl registrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        ArrayList<Object> options = new ArrayList<Object>();
        Set<String> words = registrar.getProcessedWords(pattern);
        Set<Object> optionDescriptions = null;
        String actionManagerName = this.myActionManager.getComponentName();
        boolean filterOutInspections = Registry.is("go.to.action.filter.out.inspections", true);
        for (String string : words) {
            Set<OptionDescription> set = registrar.getAcceptableDescriptions(string);
            if (set != null) {
                set.removeIf(description -> actionManagerName.equals(description.getPath()) || filterOutInspections && "Inspections".equals(description.getGroupName()));
                if (set.isEmpty()) continue;
                if (optionDescriptions == null) {
                    optionDescriptions = set;
                    continue;
                }
                optionDescriptions.retainAll(set);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (!StringUtil.isEmptyOrSpaces(pattern)) {
            Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
            if (optionDescriptions == null) {
                optionDescriptions = new THashSet();
            }
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (!matcher.matches(entry.getValue())) continue;
                optionDescriptions.add(new OptionDescription(null, entry.getKey(), entry.getValue(), null, entry.getValue()));
            }
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator2 = optionDescriptions.iterator();
            while (iterator2.hasNext()) {
                OptionDescription optionDescription = (OptionDescription)iterator2.next();
                String hit = optionDescription.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator2.remove();
            }
            for (OptionDescription optionDescription : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : ActionFromOptionDescriptorProvider.EP.getExtensions()) {
                    AnAction action2 = converter.provide(optionDescription);
                    if (action2 == null) continue;
                    options.add(new GotoActionModel.ActionWrapper(action2, null, GotoActionModel.MatchMode.NAME, dataContext, this.myModel));
                }
                options.add(optionDescription);
            }
        }
        return GotoActionItemProvider.processItems(pattern, JBIterable.from(options), consumer);
    }

    private boolean processActions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
        JBIterable<Object> actions = JBIterable.from(ids).filterMap(this.myActionManager::getAction);
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        QuickActionProvider provider = dataContext.getData(QuickActionProvider.KEY);
        if (provider != null) {
            actions = actions.append((AnAction)((Object)provider.getActions(true)));
        }
        JBIterable<GotoActionModel.ActionWrapper> actionWrappers = actions.unique().filterMap(action2 -> {
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, matcher, (AnAction)action2);
            if (mode == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper((AnAction)action2, this.myModel.getGroupMapping((AnAction)action2), mode, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, actionWrappers, consumer);
    }

    @NotNull
    static Matcher buildMatcher(String pattern) {
        Matcher matcher = pattern.contains(" ") ? new WordPrefixMatcher(pattern) : NameUtil.buildMatcher("*" + pattern, NameUtil.MatchingCaseSensitivity.NONE);
        if (matcher == null) {
            GotoActionItemProvider.$$$reportNull$$$0(11);
        }
        return matcher;
    }

    private boolean processIntentions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        Map<String, ApplyIntentionAction> intentionMap = this.myIntentions.getValue();
        JBIterable<GotoActionModel.ActionWrapper> intentions = JBIterable.from(intentionMap.keySet()).filterMap(intentionText -> {
            ApplyIntentionAction intentionAction = (ApplyIntentionAction)intentionMap.get(intentionText);
            if (this.myModel.actionMatches(pattern, matcher, intentionAction) == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            GotoActionModel.GroupMapping groupMapping = GotoActionModel.GroupMapping.createFromText(intentionText);
            return new GotoActionModel.ActionWrapper(intentionAction, groupMapping, GotoActionModel.MatchMode.INTENTION, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, intentions, consumer);
    }

    @NotNull
    private GotoActionModel.ActionWrapper wrapAnAction(@NotNull AnAction action2, DataContext dataContext) {
        if (action2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(12);
        }
        return new GotoActionModel.ActionWrapper(action2, this.myModel.getGroupMapping(action2), GotoActionModel.MatchMode.NAME, dataContext, this.myModel);
    }

    private static boolean processItems(String pattern, JBIterable<?> items, Processor<? super GotoActionModel.MatchedValue> consumer) {
        ArrayList<GotoActionModel.MatchedValue> matched = ContainerUtil.newArrayList(items.map(o -> o instanceof GotoActionModel.MatchedValue ? (GotoActionModel.MatchedValue)o : new GotoActionModel.MatchedValue(o, pattern)));
        try {
            Collections.sort(matched, (o1, o2) -> o1.compareWeights((GotoActionModel.MatchedValue)o2));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Comparison method violates its general contract with pattern '" + pattern + "'", e);
        }
        return ContainerUtil.process(matched, consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapAnAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

