/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCustomizer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileModel
extends FilteringGotoByModel<FileType>
implements DumbAware,
Comparator<Object> {
    private final int myMaxSize;

    public GotoFileModel(@NotNull Project project2) {
        if (project2 == null) {
            GotoFileModel.$$$reportNull$$$0(0);
        }
        super(project2, ChooseByNameContributor.FILE_EP_NAME.getExtensionList());
        this.myMaxSize = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : WindowManagerEx.getInstanceEx().getFrame((Project)project2).getSize().width;
    }

    public boolean isSlashlessMatchingEnabled() {
        return true;
    }

    @Override
    @NotNull
    public ChooseByNameItemProvider getItemProvider(@Nullable PsiElement context) {
        for (GotoFileCustomizer customizer : GotoFileCustomizer.EP_NAME.getExtensionList()) {
            GotoFileItemProvider provider = customizer.createItemProvider(this.myProject, context, this);
            if (provider == null) continue;
            GotoFileItemProvider gotoFileItemProvider = provider;
            if (gotoFileItemProvider == null) {
                GotoFileModel.$$$reportNull$$$0(1);
            }
            return gotoFileItemProvider;
        }
        return new GotoFileItemProvider(this.myProject, context, this);
    }

    @Override
    protected boolean acceptItem(NavigationItem item) {
        if (item instanceof PsiFile) {
            PsiFile file2 = (PsiFile)item;
            Collection types = this.getFilterItems();
            if (types != null) {
                if (types.contains(file2.getFileType())) {
                    return true;
                }
                VirtualFile vFile = file2.getVirtualFile();
                return vFile != null && types.contains(vFile.getFileType());
            }
            return true;
        }
        return super.acceptItem(item);
    }

    @Override
    @Nullable
    protected FileType filterValueFor(NavigationItem item) {
        return item instanceof PsiFile ? ((PsiFile)item).getFileType() : null;
    }

    @Override
    public String getPromptText() {
        return IdeBundle.message("prompt.gotofile.enter.file.name", new Object[0]);
    }

    @Override
    public String getCheckBoxName() {
        if (NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            return null;
        }
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.files", new Object[0]);
    }

    @Override
    @NotNull
    public String getNotInMessage() {
        return "";
    }

    @Override
    @NotNull
    public String getNotFoundMessage() {
        String string = IdeBundle.message("label.no.files.found", new Object[0]);
        if (string == null) {
            GotoFileModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.myProject);
        return propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries") && propertiesComponent.isTrueValue("GoToFile.includeJavaFiles");
    }

    @Override
    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance(this.myProject);
        if (propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries")) {
            propertiesComponent.setValue("GoToFile.includeJavaFiles", Boolean.toString(state));
        }
    }

    @Override
    @NotNull
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize){

            @Override
            @NotNull
            protected PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value2) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value2);
                if (!(value2 instanceof PsiFileSystemItem)) {
                    PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
                    if (itemMatchers == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return itemMatchers;
                }
                PsiElementListCellRenderer.ItemMatchers itemMatchers = GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value2, GotoFileModel.this);
                if (itemMatchers == null) {
                    1.$$$reportNull$$$0(3);
                }
                return itemMatchers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileModel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileModel$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemMatchers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemMatchers";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return false;
    }

    @Override
    @Nullable
    public String getFullName(@NotNull Object element2) {
        if (element2 == null) {
            GotoFileModel.$$$reportNull$$$0(3);
        }
        return element2 instanceof PsiFileSystemItem ? this.getFullName(((PsiFileSystemItem)element2).getVirtualFile()) : this.getElementName(element2);
    }

    @Nullable
    public String getFullName(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            GotoFileModel.$$$reportNull$$$0(4);
        }
        return (root = this.getTopLevelRoot(file2)) != null ? GotoFileCellRenderer.getRelativePathFromRoot(file2, root) : GotoFileCellRenderer.getRelativePath(file2, this.myProject);
    }

    @Nullable
    public VirtualFile getTopLevelRoot(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            GotoFileModel.$$$reportNull$$$0(5);
        }
        return (root = this.getContentRoot(file2)) == null ? null : JBIterable.generate(root, r -> this.getContentRoot(r.getParent())).last();
    }

    private VirtualFile getContentRoot(@Nullable VirtualFile file2) {
        return file2 == null ? null : GotoFileCellRenderer.getAnyRoot(file2, this.myProject);
    }

    @Override
    public String @NotNull [] getSeparators() {
        String[] stringArray = new String[]{"/", "\\"};
        if (stringArray == null) {
            GotoFileModel.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    public boolean willOpenEditor() {
        return true;
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileModel.$$$reportNull$$$0(7);
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            String string = pattern.substring(0, pattern.length() - 1);
            if (string == null) {
                GotoFileModel.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            GotoFileModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return 0;
    }

    @NotNull
    public static PsiElementListCellRenderer.ItemMatchers convertToFileItemMatchers(@NotNull PsiElementListCellRenderer.ItemMatchers defaultMatchers, @NotNull PsiFileSystemItem value2, @NotNull GotoFileModel model) {
        if (defaultMatchers == null) {
            GotoFileModel.$$$reportNull$$$0(10);
        }
        if (value2 == null) {
            GotoFileModel.$$$reportNull$$$0(11);
        }
        if (model == null) {
            GotoFileModel.$$$reportNull$$$0(12);
        }
        String shortName = model.getElementName(value2);
        String fullName = model.getFullName(value2);
        if (shortName != null && fullName != null && defaultMatchers.nameMatcher instanceof MinusculeMatcher) {
            String sanitized = GotoFileItemProvider.getSanitizedPattern(((MinusculeMatcher)defaultMatchers.nameMatcher).getPattern(), model);
            for (int i = sanitized.lastIndexOf(47) + 1; i < sanitized.length() - 1; ++i) {
                MinusculeMatcher nameMatcher = NameUtil.buildMatcher("*" + sanitized.substring(i), NameUtil.MatchingCaseSensitivity.NONE);
                if (!nameMatcher.matches(shortName)) continue;
                String locationPattern = FileUtil.toSystemDependentName(StringUtil.trimEnd(sanitized.substring(0, i), "/"));
                return new PsiElementListCellRenderer.ItemMatchers(nameMatcher, GotoFileItemProvider.getQualifiedNameMatcher(locationPattern));
            }
        }
        PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
        if (itemMatchers == null) {
            GotoFileModel.$$$reportNull$$$0(13);
        }
        return itemMatchers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMatchers";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFileItemMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertToFileItemMatchers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

