/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class ExistingModuleLoader
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(ExistingModuleLoader.class);

    public static ExistingModuleLoader setUpLoader(String moduleFilePath) {
        ExistingModuleLoader moduleLoader = new ExistingModuleLoader();
        moduleLoader.setModuleFilePath(moduleFilePath);
        int startIndex = moduleFilePath.lastIndexOf(47);
        int endIndex = moduleFilePath.lastIndexOf(".");
        if (startIndex >= 0 && endIndex > startIndex + 1) {
            String name = moduleFilePath.substring(startIndex + 1, endIndex);
            moduleLoader.setName(name);
        }
        return moduleLoader;
    }

    @Override
    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            ExistingModuleLoader.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(this.getName() != null);
        String moduleFilePath = this.getModuleFilePath();
        LOG.assertTrue(moduleFilePath != null);
        LOG.assertTrue(new File(moduleFilePath).exists());
        Module module2 = moduleModel.loadModule(moduleFilePath);
        if (module2 == null) {
            ExistingModuleLoader.$$$reportNull$$$0(1);
        }
        return module2;
    }

    public ModuleType getModuleType() {
        return null;
    }

    @Override
    public boolean validate(Project current2, Project dest) {
        block7: {
            if (this.getName() == null) {
                return false;
            }
            String moduleFilePath = this.getModuleFilePath();
            if (moduleFilePath == null) {
                return false;
            }
            Path file2 = Paths.get(moduleFilePath, new String[0]);
            if (Files.exists(file2, new LinkOption[0])) {
                try {
                    boolean ok;
                    ConversionResult result2 = ConversionService.getInstance().convertModule(dest, file2);
                    if (result2.openingIsCanceled()) {
                        return false;
                    }
                    Element root = JDOMUtil.load(file2);
                    Set<String> usedMacros = PathMacrosCollector.getMacroNames(root);
                    usedMacros.remove("$MODULE_DIR$");
                    usedMacros.removeAll(PathMacros.getInstance().getAllMacroNames());
                    if (usedMacros.size() > 0 && !(ok = ProjectMacrosUtil.showMacrosConfigurationDialog(current2, usedMacros))) {
                        return false;
                    }
                    break block7;
                }
                catch (IOException | JDOMException e) {
                    Messages.showMessageDialog(e.getMessage(), IdeBundle.message("title.error.reading.file", new Object[0]), Messages.getErrorIcon());
                    return false;
                }
            }
            Messages.showErrorDialog(current2, IdeBundle.message("title.module.file.does.not.exist", moduleFilePath), CommonBundle.getErrorTitle());
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/ExistingModuleLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/ExistingModuleLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

