/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import org.jetbrains.annotations.Nullable;

public class EditScopesDialog
extends SettingsDialog {
    private NamedScope mySelectedScope;
    private final Project myProject;
    private final ScopeChooserConfigurable myConfigurable;
    private final boolean myCheckShared;

    public EditScopesDialog(Project project2, ScopeChooserConfigurable configurable2, boolean checkShared) {
        super(project2, "scopes", (Configurable)configurable2, true, false);
        this.myProject = project2;
        this.myConfigurable = configurable2;
        this.myCheckShared = checkShared;
    }

    @Override
    public void doOKAction() {
        String newName;
        Project project2;
        DependencyValidationManager manager;
        NamedScope scope;
        Object selectedObject = this.myConfigurable.getSelectedObject();
        this.mySelectedScope = selectedObject instanceof NamedScope ? (NamedScope)selectedObject : null;
        super.doOKAction();
        if (this.myCheckShared && this.mySelectedScope != null && (scope = (manager = DependencyValidationManager.getInstance(project2 = this.myProject)).getScope(this.mySelectedScope.getName())) == null && Messages.showYesNoDialog(IdeBundle.message("scope.unable.to.save.scope.message", new Object[0]), IdeBundle.message("scope.unable.to.save.scope.title", new Object[0]), Messages.getErrorIcon()) == 0 && (newName = Messages.showInputDialog(project2, IdeBundle.message("add.scope.name.label", new Object[0]), IdeBundle.message("scopes.save.dialog.title.shared", new Object[0]), Messages.getQuestionIcon(), this.mySelectedScope.getName(), new InputValidator(){

            @Override
            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0 && manager.getScope(inputString) == null;
            }

            @Override
            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        })) != null) {
            PackageSet packageSet = this.mySelectedScope.getValue();
            this.mySelectedScope = scope = new NamedScope(newName, manager.getIcon(), packageSet != null ? packageSet.createCopy() : null);
            manager.addScope(this.mySelectedScope);
        }
    }

    public static EditScopesDialog showDialog(Project project2, @Nullable String scopeToSelect) {
        return EditScopesDialog.showDialog(project2, scopeToSelect, false);
    }

    public static EditScopesDialog showDialog(Project project2, @Nullable String scopeToSelect, boolean checkShared) {
        ScopeChooserConfigurable configurable2 = new ScopeChooserConfigurable(project2);
        EditScopesDialog dialog2 = new EditScopesDialog(project2, configurable2, checkShared);
        if (scopeToSelect != null) {
            configurable2.selectNodeInTree(scopeToSelect);
        }
        dialog2.show();
        return dialog2;
    }

    public NamedScope getSelectedScope() {
        return this.mySelectedScope;
    }
}

