/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    public static final int OPT_LIBRARIES = 1;
    public static final int OPT_SEARCH_RESULTS = 2;
    public static final int OPT_FROM_SELECTION = 4;
    public static final int OPT_USAGE_VIEW = 8;
    public static final int OPT_EMPTY_SCOPES = 16;
    private Project myProject;
    private int myOptions = 12;
    private Condition<? super ScopeDescriptor> myScopeFilter;
    private BrowseListener myBrowseListener = null;

    public ScopeChooserCombo() {
        super(new MyComboBox());
    }

    public ScopeChooserCombo(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project2, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project2, String preselect) {
        this.init(project2, false, true, preselect);
    }

    public void init(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.init(project2, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project2, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, Object selection, @Nullable Condition<? super ScopeDescriptor> scopeFilter) {
        if (this.myProject != null) {
            throw new IllegalStateException("scope chooser combo already initialized");
        }
        this.myOptions = BitUtil.set(this.myOptions, 1, suggestSearchInLibs);
        this.myOptions = BitUtil.set(this.myOptions, 2, prevSearchWholeFiles);
        this.myProject = project2;
        NamedScopesHolder.ScopeListener scopeListener2 = () -> {
            SearchScope selectedScope = this.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(selectedScope);
        };
        this.myScopeFilter = scopeFilter;
        NamedScopeManager.getInstance(project2).addScopeListener(scopeListener2, this);
        DependencyValidationManager.getInstance(project2).addScopeListener(scopeListener2, this);
        this.addActionListener(this::handleScopeChooserAction);
        JComboBox combo = this.getComboBox();
        ((ComboBox)combo).setMinimumAndPreferredWidth(JBUIScale.scale(300));
        ((ComboBoxWithWidePopup)combo).setRenderer(ScopeChooserCombo.createDefaultRenderer());
        ((ComboBox)combo).setSwingPopup(false);
        this.rebuildModelAndSelectScopeOnSuccess(selection);
    }

    @NotNull
    public static ListCellRenderer<ScopeDescriptor> createDefaultRenderer() {
        return new MyRenderer();
    }

    @Override
    public ComboBox<ScopeDescriptor> getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    public void setBrowseListener(BrowseListener browseListener) {
        this.myBrowseListener = browseListener;
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.myOptions = BitUtil.set(this.myOptions, 4, currentSelection);
    }

    public void setUsageView(boolean usageView) {
        this.myOptions = BitUtil.set(this.myOptions, 8, usageView);
    }

    public void selectItem(@Nullable Object selection) {
        if (selection == null) {
            return;
        }
        JComboBox combo = this.getComboBox();
        DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScopeDescriptor descriptor2 = (ScopeDescriptor)model.getElementAt(i);
            if ((!(selection instanceof String) || !selection.equals(descriptor2.getDisplayName())) && (!(selection instanceof SearchScope) || !descriptor2.scopeEquals((SearchScope)selection))) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }

    private void handleScopeChooserAction(ActionEvent ignore) {
        EditScopesDialog dlg;
        String selection = this.getSelectedScopeName();
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onBeforeBrowseStarted();
        }
        if ((dlg = EditScopesDialog.showDialog(this.myProject, selection)).isOK()) {
            NamedScope namedScope = dlg.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(namedScope == null ? null : namedScope.getName());
        }
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onAfterBrowseFinished();
        }
    }

    public static boolean processScopes(@NotNull Project project2, @NotNull DataContext dataContext, int options, @NotNull Processor<? super ScopeDescriptor> processor2) {
        if (project2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            ScopeChooserCombo.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(2);
        }
        List<SearchScope> predefinedScopes = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project2, dataContext, BitUtil.isSet(options, 1), BitUtil.isSet(options, 2), BitUtil.isSet(options, 4), BitUtil.isSet(options, 8), BitUtil.isSet(options, 16));
        for (SearchScope searchScope : predefinedScopes) {
            if (processor2.process(new ScopeDescriptor(searchScope))) continue;
            return false;
        }
        for (ScopeDescriptorProvider provider : ScopeDescriptorProvider.EP_NAME.getExtensionList()) {
            ScopeDescriptor[] scopeDescriptorArray = provider.getScopeDescriptors(project2);
            int n = scopeDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                ScopeDescriptor descriptor2 = scopeDescriptorArray[i];
                if (processor2.process(descriptor2)) continue;
                return false;
            }
        }
        Comparator comparator2 = (o1, o2) -> {
            int w2;
            int w1 = o1 instanceof WeighedItem ? ((WeighedItem)((Object)o1)).getWeight() : Integer.MAX_VALUE;
            int n = w2 = o2 instanceof WeighedItem ? ((WeighedItem)((Object)o2)).getWeight() : Integer.MAX_VALUE;
            if (w1 == w2) {
                return StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
            }
            return w1 - w2;
        };
        for (SearchScopeProvider each : SearchScopeProvider.EP_NAME.getExtensions()) {
            List<SearchScope> scopes;
            if (StringUtil.isEmpty(each.getDisplayName()) || (scopes = each.getSearchScopes(project2, dataContext)).isEmpty()) continue;
            if (!processor2.process(new ScopeSeparator(each.getDisplayName()))) {
                return false;
            }
            for (SearchScope scope : ContainerUtil.sorted(scopes, comparator2)) {
                if (processor2.process(new ScopeDescriptor(scope))) continue;
                return false;
            }
        }
        return true;
    }

    private void rebuildModelAndSelectScopeOnSuccess(@Nullable Object selection) {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Promise<DataContext> promise2 = DataManager.getInstance().getDataContextFromFocusAsync();
        promise2.onSuccess(c -> {
            ScopeChooserCombo.processScopes(this.myProject, c, this.myOptions, descriptor2 -> {
                if (this.myScopeFilter == null || this.myScopeFilter.value((ScopeDescriptor)descriptor2)) {
                    model.addElement(descriptor2);
                }
                return true;
            });
            this.getComboBox().setModel(model);
            this.selectItem(selection);
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    public void setShowEmptyScopes(boolean showEmptyScopes) {
        this.myOptions = BitUtil.set(this.myOptions, 16, showEmptyScopes);
    }

    @Nullable
    public SearchScope getSelectedScope() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        return item == null ? null : item.getScope();
    }

    @Nullable
    public String getSelectedScopeName() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        return item == null ? null : item.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
        objectArray[2] = "processScopes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyComboBox
    extends ComboBox {
        private MyComboBox() {
        }

        @Override
        public void setSelectedItem(Object item) {
            if (!(item instanceof ScopeSeparator)) {
                super.setSelectedItem(item);
            }
        }

        @Override
        public void setSelectedIndex(int anIndex) {
            Object item = this.getItemAt(anIndex);
            if (!(item instanceof ScopeSeparator)) {
                super.setSelectedIndex(anIndex);
            }
        }
    }

    public static interface BrowseListener {
        public void onBeforeBrowseStarted();

        public void onAfterBrowseFinished();
    }

    private static class MyRenderer
    extends SimpleListCellRenderer<ScopeDescriptor> {
        final TitledSeparator separator = new TitledSeparator();

        private MyRenderer() {
        }

        @Override
        public void customize(@NotNull JList<? extends ScopeDescriptor> list2, ScopeDescriptor value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                return;
            }
            this.setIcon(value2.getIcon());
            this.setText(value2.getDisplayName());
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value2, int index, boolean selected2, boolean hasFocus) {
            if (value2 instanceof ScopeSeparator) {
                this.separator.setText(value2.getDisplayName());
                this.separator.setBorder(index == -1 ? null : new JBEmptyBorder(4, 2, 4, 0));
                return this.separator;
            }
            return super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$MyRenderer", "customize"));
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        final String text;

        ScopeSeparator(@NotNull String text2) {
            if (text2 == null) {
                ScopeSeparator.$$$reportNull$$$0(0);
            }
            super(null);
            this.text = text2;
        }

        @Override
        public String getDisplayName() {
            return this.text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$ScopeSeparator", "<init>"));
        }
    }
}

