/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeConfigurable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String SCOPE_CHOOSER_CONFIGURABLE_UI_KEY = "ScopeChooserConfigurable.UI";
    public static final String PROJECT_SCOPES = "project.scopes";
    private final NamedScopesHolder myLocalScopesManager;
    private final NamedScopesHolder mySharedScopesManager;
    private final Project myProject;

    public ScopeChooserConfigurable(Project project2) {
        super(new ScopeChooserConfigurableState());
        this.myLocalScopesManager = NamedScopeManager.getInstance(project2);
        this.mySharedScopesManager = DependencyValidationManager.getInstance(project2);
        this.myProject = project2;
        this.initTree();
    }

    @Override
    protected String getComponentStateKey() {
        return SCOPE_CHOOSER_CONFIGURABLE_UI_KEY;
    }

    @Override
    protected Dimension getPanelPreferredSize() {
        return JBUI.size(400, 200);
    }

    @Override
    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance(this.myProject);
    }

    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add(new MyAddAction(fromPopup));
        result2.add(new MasterDetailsComponent.MyDeleteAction(this, ScopeChooserConfigurable.forAll(o -> {
            if (o instanceof MasterDetailsComponent.MyNode) {
                NamedConfigurable namedConfigurable = ((MasterDetailsComponent.MyNode)o).getConfigurable();
                Object editableObject = namedConfigurable != null ? namedConfigurable.getEditableObject() : null;
                return editableObject instanceof NamedScope;
            }
            return false;
        })));
        result2.add(new MyCopyAction());
        result2.add(new MySaveAsAction());
        result2.add(new MyMoveAction(ExecutionBundle.message("move.up.action.name", new Object[0]), IconUtil.getMoveUpIcon(), -1));
        result2.add(new MyMoveAction(ExecutionBundle.message("move.down.action.name", new Object[0]), IconUtil.getMoveDownIcon(), 1));
        return result2;
    }

    @Override
    public void reset() {
        this.myRoot.removeAllChildren();
        this.loadScopes(this.mySharedScopesManager);
        this.loadScopes(this.myLocalScopesManager);
        this.loadComponentState();
        List<String> order = this.getScopesState().myOrder;
        TreeUtil.sortRecursively(this.myRoot, (o1, o2) -> {
            int idx1 = order.indexOf(o1.getDisplayName());
            int idx2 = order.indexOf(o2.getDisplayName());
            return idx1 - idx2;
        });
        if (this.getScopesState().myOrder.size() != this.myRoot.getChildCount()) {
            this.loadStateOrder();
        }
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(ProjectBundle.message("rename.message.prefix.scope", new Object[0]), ProjectBundle.message("rename.scope.title", new Object[0]), ScopeConfigurable.class);
        this.checkForPredefinedNames();
        super.apply();
        this.processScopes();
        this.loadStateOrder();
    }

    private void checkForPredefinedNames() throws ConfigurationException {
        HashSet<String> predefinedScopes = new HashSet<String>();
        for (NamedScope scope : CustomScopesAggregator.getAllCustomScopes(this.myProject)) {
            predefinedScopes.add(scope.getName());
        }
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            NamedConfigurable scopeConfigurable = node.getConfigurable();
            String name = scopeConfigurable.getDisplayName();
            if (!predefinedScopes.contains(name)) continue;
            this.selectNodeInTree(node);
            throw new ConfigurationException("Scope name equals to predefined one", ProjectBundle.message("rename.scope.title", new Object[0]));
        }
    }

    public ScopeChooserConfigurableState getScopesState() {
        return (ScopeChooserConfigurableState)this.myState;
    }

    @Override
    public boolean isModified() {
        List<String> order = this.getScopesState().myOrder;
        if (this.myRoot.getChildCount() != order.size()) {
            return true;
        }
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            ScopeConfigurable scopeConfigurable = (ScopeConfigurable)node.getConfigurable();
            NamedScope namedScope = scopeConfigurable.getEditableObject();
            if (order.size() <= i) {
                return true;
            }
            String name = order.get(i);
            if (!Comparing.strEqual(name, namedScope.getName())) {
                return true;
            }
            if (!this.isInitialized(scopeConfigurable)) continue;
            NamedScopesHolder holder = scopeConfigurable.getHolder();
            NamedScope scope = holder.getScope(name);
            if (scope == null) {
                return true;
            }
            if (!scopeConfigurable.isModified()) continue;
            return true;
        }
        return false;
    }

    private void processScopes() {
        ArrayList<NamedScope> localScopes = new ArrayList<NamedScope>();
        ArrayList<NamedScope> sharedScopes = new ArrayList<NamedScope>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            ScopeConfigurable scopeConfigurable = (ScopeConfigurable)node.getConfigurable();
            NamedScope namedScope = scopeConfigurable.getScope();
            if (scopeConfigurable.getHolder() == this.myLocalScopesManager) {
                localScopes.add(namedScope);
                continue;
            }
            sharedScopes.add(namedScope);
        }
        this.myLocalScopesManager.setScopes(localScopes.toArray(NamedScope.EMPTY_ARRAY));
        this.mySharedScopesManager.setScopes(sharedScopes.toArray(NamedScope.EMPTY_ARRAY));
    }

    private void loadStateOrder() {
        List<String> order = this.getScopesState().myOrder;
        order.clear();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            order.add(((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getDisplayName());
        }
    }

    private void loadScopes(NamedScopesHolder holder) {
        NamedScope[] scopes;
        for (NamedScope scope : scopes = holder.getScopes()) {
            if (this.isPredefinedScope(scope)) continue;
            this.myRoot.add(new MasterDetailsComponent.MyNode(new ScopeConfigurable(scope, holder == this.mySharedScopesManager, this.myProject, this.TREE_UPDATER)));
        }
    }

    private boolean isPredefinedScope(NamedScope scope) {
        return ScopeChooserConfigurable.getPredefinedScopes(this.myProject).contains(scope);
    }

    private static Collection<NamedScope> getPredefinedScopes(Project project2) {
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.addAll(NamedScopeManager.getInstance(project2).getPredefinedScopes());
        result2.addAll(DependencyValidationManager.getInstance(project2).getPredefinedScopes());
        return result2;
    }

    @Override
    protected void initTree() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MasterDetailsComponent.MyNode node;
                NamedConfigurable namedConfigurable;
                TreePath path2 = e.getOldLeadSelectionPath();
                if (path2 != null && (namedConfigurable = (node = (MasterDetailsComponent.MyNode)path2.getLastPathComponent()).getConfigurable()) instanceof ScopeConfigurable) {
                    ((ScopeConfigurable)namedConfigurable).cancelCurrentProgress();
                }
            }
        });
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
        this.myTree.getEmptyText().setText(IdeBundle.message("scopes.no.scoped", new Object[0]));
    }

    @Override
    protected boolean wasObjectStored(Object editableObject) {
        if (editableObject instanceof NamedScope) {
            NamedScope scope = (NamedScope)editableObject;
            String scopeName = scope.getName();
            return this.myLocalScopesManager.getScope(scopeName) != null || this.mySharedScopesManager.getScope(scopeName) != null;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message("scopes.display.name", new Object[0]);
    }

    @Override
    @NotNull
    @NonNls
    public String getHelpTopic() {
        return PROJECT_SCOPES;
    }

    @Override
    protected void updateSelection(@Nullable NamedConfigurable configurable2) {
        super.updateSelection(configurable2);
        if (configurable2 instanceof ScopeConfigurable) {
            ((ScopeConfigurable)configurable2).restoreCanceledProgress();
        }
    }

    @Override
    @Nullable
    protected String getEmptySelectionString() {
        return IdeBundle.message("scope.chooser.select.scope.text", new Object[0]);
    }

    private String createUniqueName() {
        String str = InspectionsBundle.message("inspection.profile.unnamed", new Object[0]);
        HashSet treeScopes = new HashSet();
        this.obtainCurrentScopes(treeScopes);
        if (!treeScopes.contains(str)) {
            return str;
        }
        int i = 1;
        while (treeScopes.contains(str + i)) {
            ++i;
        }
        return str + i;
    }

    private void obtainCurrentScopes(HashSet<? super String> scopes) {
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            NamedScope scope = (NamedScope)node.getConfigurable().getEditableObject();
            scopes.add(scope.getName());
        }
    }

    private void addNewScope(NamedScope scope, boolean isLocal) {
        MasterDetailsComponent.MyNode nodeToAdd = new MasterDetailsComponent.MyNode(new ScopeConfigurable(scope, !isLocal, this.myProject, this.TREE_UPDATER));
        this.myRoot.add(nodeToAdd);
        ((DefaultTreeModel)this.myTree.getModel()).reload(this.myRoot);
        this.selectNodeInTree(nodeToAdd);
    }

    private void createScope(boolean isLocal, String title, PackageSet set) {
        final NamedScopesHolder holder = isLocal ? this.myLocalScopesManager : this.mySharedScopesManager;
        String newName = Messages.showInputDialog(this.myTree, IdeBundle.message("add.scope.name.label", new Object[0]), title, Messages.getInformationIcon(), this.createUniqueName(), new InputValidator(){

            @Override
            public boolean checkInput(String inputString) {
                for (NamedScope scope : holder.getPredefinedScopes()) {
                    if (!Comparing.strEqual(scope.getName(), inputString.trim())) continue;
                    return false;
                }
                return inputString.trim().length() > 0;
            }

            @Override
            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newName != null) {
            this.addNewScope(holder.createScope(newName, set), isLocal);
        }
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            ScopeChooserConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable", "getId"));
    }

    public static class ScopeChooserConfigurableState
    extends MasterDetailsState {
        @XCollection(propertyElementName="order", elementName="scope", valueAttributeName="name")
        public List<String> myOrder = new ArrayList<String>();
    }

    private class MySaveAsAction
    extends AnAction {
        MySaveAsAction() {
            super(ExecutionBundle.messagePointer("action.name.save.as.configuration", new Object[0]), ExecutionBundle.messagePointer("action.name.save.as.configuration", new Object[0]), AllIcons.Actions.Menu_saveall);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            ScopeConfigurable scopeConfigurable;
            PackageSet set;
            MasterDetailsComponent.MyNode node;
            NamedConfigurable configurable2;
            TreePath selectionPath;
            if (e == null) {
                MySaveAsAction.$$$reportNull$$$0(0);
            }
            if ((selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath()) != null && (configurable2 = (node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof ScopeConfigurable && (set = (scopeConfigurable = (ScopeConfigurable)configurable2).getEditableObject().getValue()) != null) {
                if (scopeConfigurable.getHolder() == ScopeChooserConfigurable.this.mySharedScopesManager) {
                    ScopeChooserConfigurable.this.createScope(true, IdeBundle.message("scopes.save.dialog.title.local", new Object[0]), set.createCopy());
                } else {
                    ScopeChooserConfigurable.this.createScope(false, IdeBundle.message("scopes.save.dialog.title.shared", new Object[0]), set.createCopy());
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySaveAsAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ScopeChooserConfigurable.this.getSelectedObject() instanceof NamedScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MySaveAsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCopyAction
    extends AnAction {
        MyCopyAction() {
            super(ExecutionBundle.message("copy.configuration.action.name", new Object[0]), ExecutionBundle.message("copy.configuration.action.name", new Object[0]), COPY_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), ScopeChooserConfigurable.this.myTree);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            NamedScope scope;
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(0);
            }
            if ((scope = (NamedScope)ScopeChooserConfigurable.this.getSelectedObject()) != null) {
                ScopeConfigurable configurable2 = (ScopeConfigurable)((MasterDetailsComponent.MyNode)ScopeChooserConfigurable.this.myTree.getSelectionPath().getLastPathComponent()).getConfigurable();
                NamedScopesHolder holder = configurable2.getHolder();
                PackageSet set = scope.getValue();
                ScopeChooserConfigurable.this.addNewScope(holder.createScope(ScopeChooserConfigurable.this.createUniqueName(), set == null ? null : set.createCopy()), holder == ScopeChooserConfigurable.this.myLocalScopesManager);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ScopeChooserConfigurable.this.getSelectedObject() instanceof NamedScope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyCopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMoveAction
    extends AnAction {
        private final int myDirection;

        protected MyMoveAction(String text2, Icon icon2, int direction) {
            super(text2, text2, icon2);
            ShortcutSet shortcutSet = direction < 0 ? CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.UP) : CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.DOWN);
            this.registerCustomShortcutSet(shortcutSet, ScopeChooserConfigurable.this.myTree);
            this.myDirection = direction;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyMoveAction.$$$reportNull$$$0(0);
            }
            TreeUtil.moveSelectedRow(ScopeChooserConfigurable.this.myTree, this.myDirection);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode treeNode;
            if (e == null) {
                MyMoveAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null && (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof ScopeConfigurable) {
                if (this.myDirection < 0) {
                    presentation.setEnabled(treeNode.getPreviousSibling() != null);
                } else {
                    presentation.setEnabled(treeNode.getNextSibling() != null);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyMoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAddAction
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection,
    DumbAware {
        private AnAction[] myChildren;
        private final boolean myFromPopup;

        MyAddAction(boolean fromPopup) {
            super(IdeBundle.message("add.scope.popup.title", new Object[0]), true);
            this.myFromPopup = fromPopup;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.ADD), ScopeChooserConfigurable.this.myTree);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAddAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (this.myFromPopup) {
                this.setPopup(false);
            }
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myChildren == null) {
                this.myChildren = new AnAction[2];
                this.myChildren[0] = new DumbAwareAction(IdeBundle.message("add.local.scope.action.text", new Object[0]), IdeBundle.message("add.local.scope.action.text", new Object[0]), ScopeChooserConfigurable.this.myLocalScopesManager.getIcon()){

                    @Override
                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ScopeChooserConfigurable.this.createScope(true, IdeBundle.message("add.scope.dialog.title", new Object[0]), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction$1", "actionPerformed"));
                    }
                };
                this.myChildren[1] = new DumbAwareAction(IdeBundle.message("add.shared.scope.action.text", new Object[0]), IdeBundle.message("add.shared.scope.action.text", new Object[0]), ScopeChooserConfigurable.this.mySharedScopesManager.getIcon()){

                    @Override
                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        ScopeChooserConfigurable.this.createScope(false, IdeBundle.message("add.scope.dialog.title", new Object[0]), null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction$2", "actionPerformed"));
                    }
                };
            }
            if (this.myFromPopup) {
                AnAction action2 = this.myChildren[this.getDefaultIndex()];
                action2.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
                AnAction[] anActionArray = new AnAction[]{action2};
                if (anActionArray == null) {
                    MyAddAction.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }
            if (this.myChildren == null) {
                MyAddAction.$$$reportNull$$$0(2);
            }
            return this.myChildren;
        }

        @Override
        public ActionGroup getActionGroup() {
            return this;
        }

        @Override
        public int getDefaultIndex() {
            TreePath selectionPath = ScopeChooserConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
                Object editableObject = node.getConfigurable().getEditableObject();
                if (editableObject instanceof NamedScope) {
                    editableObject = ((MasterDetailsComponent.MyNode)node.getParent()).getConfigurable().getEditableObject();
                }
                if (editableObject instanceof NamedScopeManager) {
                    return 0;
                }
                if (editableObject instanceof DependencyValidationManager) {
                    return 1;
                }
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserConfigurable$MyAddAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

