/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SelectionRequest;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.ide.util.treeView.UpdaterTreeState;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.MutualMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.treeStructure.AlwaysExpandedTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.LockToken;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2020.3")
public class AbstractTreeUi {
    private static final Logger LOG = Logger.getInstance(AbstractTreeBuilder.class);
    protected JTree myTree;
    private DefaultTreeModel myTreeModel;
    private AbstractTreeStructure myTreeStructure;
    private AbstractTreeUpdater myUpdater;
    private Comparator<? super NodeDescriptor<?>> myNodeDescriptorComparator;
    private final Comparator<TreeNode> myNodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode n1, TreeNode n2) {
            if (AbstractTreeUi.isLoadingNode(n1) && AbstractTreeUi.isLoadingNode(n2)) {
                return 0;
            }
            if (AbstractTreeUi.isLoadingNode(n1)) {
                return -1;
            }
            if (AbstractTreeUi.isLoadingNode(n2)) {
                return 1;
            }
            NodeDescriptor nodeDescriptor1 = AbstractTreeUi.getDescriptorFrom(n1);
            NodeDescriptor nodeDescriptor2 = AbstractTreeUi.getDescriptorFrom(n2);
            if (nodeDescriptor1 == null && nodeDescriptor2 == null) {
                return 0;
            }
            if (nodeDescriptor1 == null) {
                return -1;
            }
            if (nodeDescriptor2 == null) {
                return 1;
            }
            return AbstractTreeUi.this.myNodeDescriptorComparator != null ? AbstractTreeUi.this.myNodeDescriptorComparator.compare(nodeDescriptor1, nodeDescriptor2) : nodeDescriptor1.getIndex() - nodeDescriptor2.getIndex();
        }
    };
    long myOwnComparatorStamp;
    private long myLastComparatorStamp;
    private DefaultMutableTreeNode myRootNode;
    private final Map<Object, Object> myElementToNodeMap = new HashMap<Object, Object>();
    private final Set<DefaultMutableTreeNode> myUnbuiltNodes = new HashSet<DefaultMutableTreeNode>();
    private TreeExpansionListener myExpansionListener;
    private MySelectionListener mySelectionListener;
    private final QueueProcessor<Runnable> myWorker = new QueueProcessor(runnable2 -> {
        runnable2.run();
        TimeoutUtil.sleep(1L);
    });
    private final Set<Runnable> myActiveWorkerTasks = new HashSet<Runnable>();
    private ProgressIndicator myProgress;
    private AbstractTreeNode<Object> TREE_NODE_WRAPPER;
    private boolean myRootNodeWasQueuedToInitialize;
    private boolean myRootNodeInitialized;
    private final Map<Object, List<NodeAction>> myNodeActions = new HashMap<Object, List<NodeAction>>();
    private boolean myUpdateFromRootRequested;
    private boolean myWasEverShown;
    private boolean myUpdateIfInactive;
    private final Map<Object, UpdateInfo> myLoadedInBackground = new HashMap<Object, UpdateInfo>();
    private final Map<Object, List<NodeAction>> myNodeChildrenActions = new HashMap<Object, List<NodeAction>>();
    private long myClearOnHideDelay = -1L;
    private volatile long ourUi2Countdown;
    private final Set<Runnable> myDeferredSelections = new HashSet<Runnable>();
    private final Set<Runnable> myDeferredExpansions = new HashSet<Runnable>();
    private boolean myCanProcessDeferredSelections;
    private UpdaterTreeState myUpdaterState;
    private AbstractTreeBuilder myBuilder;
    private final Set<DefaultMutableTreeNode> myUpdatingChildren = new THashSet<DefaultMutableTreeNode>();
    private boolean myCanYield;
    private final List<TreeUpdatePass> myYieldingPasses = new ArrayList<TreeUpdatePass>();
    private boolean myYieldingNow;
    private final Set<DefaultMutableTreeNode> myPendingNodeActions = new HashSet<DefaultMutableTreeNode>();
    private final Set<Runnable> myYieldingDoneRunnables = new HashSet<Runnable>();
    private final Alarm myBusyAlarm = new Alarm();
    private final Runnable myWaiterForReady = new TreeRunnable("AbstractTreeUi.myWaiterForReady"){

        @Override
        public void perform() {
            AbstractTreeUi.this.maybeSetBusyAndScheduleWaiterForReady(false, null);
        }
    };
    private final RegistryValue myYieldingUpdate = Registry.get("ide.tree.yieldingUiUpdate");
    private final RegistryValue myShowBusyIndicator = Registry.get("ide.tree.showBusyIndicator");
    private final RegistryValue myWaitForReadyTime = Registry.get("ide.tree.waitForReadyTimeout");
    private boolean myWasEverIndexNotReady;
    private boolean myShowing;
    private final FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            AbstractTreeUi.this.maybeReady();
        }
    };
    private final Set<DefaultMutableTreeNode> myNotForSmartExpand = new HashSet<DefaultMutableTreeNode>();
    private TreePath myRequestedExpand;
    private TreePath mySilentExpand;
    private TreePath mySilentSelect;
    private final ActionCallback myInitialized = new ActionCallback();
    private final BusyObject.Impl myBusyObject = new BusyObject.Impl(){

        public boolean isReady() {
            return AbstractTreeUi.this.isReady(true);
        }

        protected void onReadyWasSent() {
            AbstractTreeUi.this.removeActivity();
        }
    };
    private boolean myPassThroughMode;
    private final Set<Object> myAutoExpandRoots = new HashSet<Object>();
    private final RegistryValue myAutoExpandDepth = Registry.get("ide.tree.autoExpandMaxDepth");
    private final Set<DefaultMutableTreeNode> myWillBeExpanded = new HashSet<DefaultMutableTreeNode>();
    private SimpleTimerTask myCleanupTask;
    private final AtomicBoolean myCancelRequest = new AtomicBoolean();
    private final ReentrantLock myStateLock = new ReentrantLock();
    private final AtomicBoolean myResettingToReadyNow = new AtomicBoolean();
    private final Map<Progressive, ProgressIndicator> myBatchIndicators = new HashMap<Progressive, ProgressIndicator>();
    private final Map<Progressive, ActionCallback> myBatchCallbacks = new HashMap<Progressive, ActionCallback>();
    private final Map<DefaultMutableTreeNode, DefaultMutableTreeNode> myCancelledBuild = new WeakHashMap<DefaultMutableTreeNode, DefaultMutableTreeNode>();
    private boolean mySelectionIsAdjusted;
    private boolean myReleaseRequested;
    private boolean mySelectionIsBeingAdjusted;
    private final Set<Object> myRevalidatedObjects = new HashSet<Object>();
    private final Set<Runnable> myUserRunnables = new HashSet<Runnable>();
    private UiActivityMonitor myActivityMonitor;
    @NonNls
    private UiActivity myActivityId;

    public String toString() {
        return "AbstractTreeUi: builder = " + this.myBuilder;
    }

    protected void init(@NotNull AbstractTreeBuilder builder2, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator2, boolean updateIfInactive) {
        if (builder2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            AbstractTreeUi.$$$reportNull$$$0(1);
        }
        if (treeModel == null) {
            AbstractTreeUi.$$$reportNull$$$0(2);
        }
        this.myBuilder = builder2;
        this.myTree = tree;
        this.myTreeModel = treeModel;
        this.myActivityMonitor = UiActivityMonitor.getInstance();
        this.myActivityId = new UiActivity.AsyncBgOperation("TreeUi " + this);
        this.addModelListenerToDiagnoseAccessOutsideEdt();
        this.TREE_NODE_WRAPPER = AbstractTreeBuilder.createSearchingTreeNodeWrapper();
        this.myTree.setModel(this.myTreeModel);
        this.setRootNode((DefaultMutableTreeNode)treeModel.getRoot());
        this.myTreeStructure = treeStructure;
        this.myNodeDescriptorComparator = comparator2;
        this.myUpdateIfInactive = updateIfInactive;
        UIUtil.invokeLaterIfNeeded(new TreeRunnable("AbstractTreeUi.init"){

            @Override
            public void perform() {
                if (!AbstractTreeUi.this.wasRootNodeInitialized() && AbstractTreeUi.this.myRootNode.getChildCount() == 0) {
                    AbstractTreeUi.this.insertLoadingNode(AbstractTreeUi.this.myRootNode, true);
                }
            }
        });
        this.myExpansionListener = new MyExpansionListener();
        this.myTree.addTreeExpansionListener(this.myExpansionListener);
        this.mySelectionListener = new MySelectionListener();
        this.myTree.addTreeSelectionListener(this.mySelectionListener);
        this.setUpdater(this.getBuilder().createUpdater());
        this.myProgress = this.getBuilder().createProgressIndicator();
        Disposer.register(this.getBuilder(), this.getUpdater());
        if (this.myProgress != null) {
            Disposer.register(this.getBuilder(), () -> this.myProgress.cancel());
        }
        UiNotifyConnector uiNotify = new UiNotifyConnector(tree, new Activatable(){

            @Override
            public void showNotify() {
                AbstractTreeUi.this.myShowing = true;
                AbstractTreeUi.this.myWasEverShown = true;
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.activate(true);
                }
            }

            @Override
            public void hideNotify() {
                AbstractTreeUi.this.myShowing = false;
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.deactivate();
                }
            }
        });
        Disposer.register(this.getBuilder(), uiNotify);
        this.myTree.addFocusListener(this.myFocusListener);
    }

    private boolean isNodeActionsPending() {
        return !this.myNodeActions.isEmpty() || !this.myNodeChildrenActions.isEmpty();
    }

    private void clearNodeActions() {
        this.myNodeActions.clear();
        this.myNodeChildrenActions.clear();
    }

    private void maybeSetBusyAndScheduleWaiterForReady(boolean forcedBusy, @Nullable Object element2) {
        if (!this.myShowBusyIndicator.asBoolean()) {
            return;
        }
        boolean canUpdateBusyState = false;
        if (forcedBusy) {
            if (this.canYield() || this.isToBuildChildrenInBackground(element2)) {
                canUpdateBusyState = true;
            }
        } else {
            canUpdateBusyState = true;
        }
        if (!canUpdateBusyState) {
            return;
        }
        if (this.myTree instanceof Tree) {
            boolean isBusy;
            Tree tree = (Tree)this.myTree;
            boolean bl = isBusy = !this.isReady(true) || forcedBusy;
            if (isBusy && tree.isShowing()) {
                tree.setPaintBusy(true);
                this.myBusyAlarm.cancelAllRequests();
                this.myBusyAlarm.addRequest(this.myWaiterForReady, this.myWaitForReadyTime.asInteger());
            } else {
                tree.setPaintBusy(false);
            }
        }
    }

    private void setHoldSize(boolean holdSize) {
        if (this.myTree instanceof Tree) {
            Tree tree = (Tree)this.myTree;
            tree.setHoldSize(holdSize);
        }
    }

    private void cleanUpAll() {
        long now = System.currentTimeMillis();
        long timeToCleanup = this.ourUi2Countdown;
        if (timeToCleanup != 0L && now >= timeToCleanup) {
            this.ourUi2Countdown = 0L;
            TreeRunnable runnable2 = new TreeRunnable("AbstractTreeUi.cleanUpAll"){

                @Override
                public void perform() {
                    if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                        return;
                    }
                    AbstractTreeUi.this.myCleanupTask = null;
                    AbstractTreeUi.this.getBuilder().cleanUp();
                }
            };
            if (this.isPassthroughMode()) {
                runnable2.run();
            } else {
                this.invokeLaterIfNeeded(false, runnable2);
            }
        }
    }

    void doCleanUp() {
        TreeRunnable cleanup = new TreeRunnable("AbstractTreeUi.doCleanUp"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.canInitiateNewActivity()) {
                    AbstractTreeUi.this.cleanUpNow();
                }
            }
        };
        if (this.isPassthroughMode()) {
            cleanup.run();
        } else {
            this.invokeLaterIfNeeded(false, cleanup);
        }
    }

    void invokeLaterIfNeeded(boolean forceEdt, final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(3);
        }
        TreeRunnable actual = new TreeRunnable("AbstractTreeUi.invokeLaterIfNeeded"){

            @Override
            public void perform() {
                if (!AbstractTreeUi.this.isReleased()) {
                    runnable2.run();
                }
            }
        };
        if (this.isPassthroughMode() || !forceEdt && !AbstractTreeUi.isEdt() && !this.isTreeShowing() && !this.myWasEverShown) {
            actual.run();
        } else {
            UIUtil.invokeLaterIfNeeded(actual);
        }
    }

    public void activate(boolean byShowing) {
        this.cancelCurrentCleanupTask();
        this.myCanProcessDeferredSelections = true;
        this.ourUi2Countdown = 0L;
        if (!this.myWasEverShown || this.myUpdateFromRootRequested || this.myUpdateIfInactive) {
            this.getBuilder().updateFromRoot();
        }
        this.getUpdater().showNotify();
        this.myWasEverShown |= byShowing;
    }

    private void cancelCurrentCleanupTask() {
        if (this.myCleanupTask != null) {
            this.myCleanupTask.cancel();
            this.myCleanupTask = null;
        }
    }

    void deactivate() {
        this.getUpdater().hideNotify();
        this.myBusyAlarm.cancelAllRequests();
        if (!this.myWasEverShown) {
            return;
        }
        if (this.myProgress != null && this.myProgress.isRunning()) {
            this.myProgress.cancel();
        }
        if (!this.isReady()) {
            this.cancelUpdate();
            this.myUpdateFromRootRequested = true;
        }
        if (this.getClearOnHideDelay() >= 0L) {
            this.ourUi2Countdown = System.currentTimeMillis() + this.getClearOnHideDelay();
            this.scheduleCleanUpAll();
        }
    }

    private void scheduleCleanUpAll() {
        this.cancelCurrentCleanupTask();
        this.myCleanupTask = SimpleTimer.getInstance().setUp((Runnable)new TreeRunnable("AbstractTreeUi.scheduleCleanUpAll"){

            @Override
            public void perform() {
                AbstractTreeUi.this.cleanUpAll();
            }
        }, this.getClearOnHideDelay());
    }

    void requestRelease() {
        this.myReleaseRequested = true;
        this.cancelUpdate().doWhenDone(new TreeRunnable("AbstractTreeUi.requestRelease: on done"){

            @Override
            public void perform() {
                AbstractTreeUi.this.releaseNow();
            }
        });
    }

    public ProgressIndicator getProgress() {
        return this.myProgress;
    }

    private void releaseNow() {
        try (LockToken ignored = this.acquireLock();){
            this.myTree.removeTreeExpansionListener(this.myExpansionListener);
            this.myTree.removeTreeSelectionListener(this.mySelectionListener);
            this.myTree.removeFocusListener(this.myFocusListener);
            this.disposeNode(this.getRootNode());
            this.myElementToNodeMap.clear();
            this.getUpdater().cancelAllRequests();
            this.myWorker.clear();
            this.clearWorkerTasks();
            this.TREE_NODE_WRAPPER.setValue(null);
            if (this.myProgress != null) {
                this.myProgress.cancel();
            }
            this.cancelCurrentCleanupTask();
            this.myTree = null;
            this.setUpdater(null);
            this.myTreeStructure = null;
            this.myBuilder.releaseUi();
            this.myBuilder = null;
            this.clearNodeActions();
            this.myDeferredSelections.clear();
            this.myDeferredExpansions.clear();
            this.myYieldingDoneRunnables.clear();
        }
    }

    public boolean isReleased() {
        return this.myBuilder == null;
    }

    void doExpandNodeChildren(final @NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(4);
        }
        if (!this.myUnbuiltNodes.contains(node)) {
            return;
        }
        if (this.isLoadedInBackground(this.getElementFor(node))) {
            return;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        structure.asyncCommit().doWhenDone(new TreeRunnable("AbstractTreeUi.doExpandNodeChildren"){

            @Override
            public void perform() {
                AbstractTreeUi.this.addSubtreeToUpdate(node);
                AbstractTreeUpdater updater2 = AbstractTreeUi.this.getUpdater();
                if (updater2 != null) {
                    updater2.performUpdate();
                }
            }
        });
    }

    public final AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public final JTree getTree() {
        return this.myTree;
    }

    @Nullable
    private static NodeDescriptor getDescriptorFrom(Object node) {
        Object userObject;
        if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof NodeDescriptor) {
            return (NodeDescriptor)userObject;
        }
        return null;
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForElement(@NotNull Object element2, boolean validateAgainstStructure) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(5);
        }
        DefaultMutableTreeNode result2 = null;
        if (validateAgainstStructure) {
            DefaultMutableTreeNode node;
            int index = 0;
            while ((node = this.findNode(element2, index)) != null) {
                if (this.isNodeValidForElement(element2, node)) {
                    result2 = node;
                    break;
                }
                ++index;
            }
        } else {
            result2 = this.getFirstNode(element2);
        }
        if (result2 != null && !this.isNodeInStructure(result2)) {
            this.disposeNode(result2);
            result2 = null;
        }
        return result2;
    }

    private boolean isNodeInStructure(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(6);
        }
        return TreeUtil.isAncestor(this.getRootNode(), node) && this.getRootNode() == this.myTreeModel.getRoot();
    }

    private boolean isNodeValidForElement(@NotNull Object element2, @NotNull DefaultMutableTreeNode node) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(7);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(8);
        }
        return this.isSameHierarchy(element2, node) || this.isValidChildOfParent(element2, node);
    }

    private boolean isValidChildOfParent(@NotNull Object element2, @NotNull DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent;
        Object parentElement;
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(9);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(10);
        }
        if (!this.isInStructure(parentElement = this.getElementFor(parent = (DefaultMutableTreeNode)node.getParent()))) {
            return false;
        }
        if (parent instanceof ElementNode) {
            return ((ElementNode)parent).isValidChild(element2);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child2 = parent.getChildAt(i);
            Object eachElement = this.getElementFor(child2);
            if (!element2.equals(eachElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameHierarchy(@NotNull Object element2, @NotNull DefaultMutableTreeNode node) {
        boolean valid;
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(11);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(12);
        }
        Object eachParent = element2;
        DefaultMutableTreeNode eachParentNode = node;
        while (true) {
            if (eachParent == null) {
                valid = eachParentNode == null;
                break;
            }
            if (!eachParent.equals(this.getElementFor(eachParentNode))) {
                valid = false;
                break;
            }
            eachParent = this.getTreeStructure().getParentElement(eachParent);
            eachParentNode = (DefaultMutableTreeNode)eachParentNode.getParent();
        }
        return valid;
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForPath(Object @NotNull [] path2) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(13);
        }
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path2) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null) break;
        }
        return node;
    }

    final void buildNodeForElement(@NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(14);
        }
        this.getUpdater().performUpdate();
        DefaultMutableTreeNode node = this.getNodeForElement(element2, false);
        if (node == null) {
            ArrayList<Object> elements2 = new ArrayList<Object>();
            while ((element2 = this.getTreeStructure().getParentElement(element2)) != null) {
                elements2.add(0, element2);
            }
            for (Object e : elements2) {
                node = this.getNodeForElement(e, false);
                if (node == null) continue;
                this.expand(node, true);
            }
        }
    }

    public final void buildNodeForPath(Object @NotNull [] path2) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(15);
        }
        this.getUpdater().performUpdate();
        DefaultMutableTreeNode node = null;
        for (Object pathElement : path2) {
            DefaultMutableTreeNode defaultMutableTreeNode = node = node == null ? this.getFirstNode(pathElement) : this.findNodeForChildElement(node, pathElement);
            if (node == null || node == path2[path2.length - 1]) continue;
            this.expand(node, true);
        }
    }

    public final void setNodeDescriptorComparator(Comparator<? super NodeDescriptor<?>> nodeDescriptorComparator) {
        this.myNodeDescriptorComparator = nodeDescriptorComparator;
        this.myLastComparatorStamp = -1L;
        this.getBuilder().queueUpdateFrom(this.getTreeStructure().getRootElement(), true);
    }

    @NotNull
    protected AbstractTreeBuilder getBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            AbstractTreeUi.$$$reportNull$$$0(16);
        }
        return abstractTreeBuilder;
    }

    protected final void initRootNode() {
        if (this.myUpdateIfInactive) {
            this.activate(false);
        } else {
            this.myUpdateFromRootRequested = true;
        }
    }

    private boolean initRootNodeNowIfNeeded(final @NotNull TreeUpdatePass pass) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(17);
        }
        boolean wasCleanedUp = false;
        if (this.myRootNodeWasQueuedToInitialize) {
            Object currentRoot;
            Object root = this.getTreeStructure().getRootElement();
            if (Comparing.equal(root, currentRoot = this.getElementFor(this.myRootNode))) {
                return false;
            }
            Object rootAgain = this.getTreeStructure().getRootElement();
            if (root != rootAgain && !root.equals(rootAgain)) assert (false) : "getRootElement() if called twice must return either root1 == root2 or root1.equals(root2)";
            this.cleanUpNow();
            wasCleanedUp = true;
        }
        if (this.myRootNodeWasQueuedToInitialize) {
            return true;
        }
        this.myRootNodeWasQueuedToInitialize = true;
        final Object rootElement = this.getTreeStructure().getRootElement();
        this.addNodeAction(rootElement, false, node -> this.processDeferredActions());
        final Ref<Object> rootDescriptor = new Ref<Object>(null);
        boolean bgLoading = this.isToBuildChildrenInBackground(rootElement);
        TreeRunnable build2 = new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: build"){

            @Override
            public void perform() {
                rootDescriptor.set(AbstractTreeUi.this.getTreeStructure().createDescriptor(rootElement, null));
                AbstractTreeUi.this.getRootNode().setUserObject(rootDescriptor.get());
                AbstractTreeUi.this.update((NodeDescriptor)rootDescriptor.get(), true);
                pass.addToUpdated((NodeDescriptor)rootDescriptor.get());
            }
        };
        TreeRunnable update2 = new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: update"){

            @Override
            public void perform() {
                Object fromDescriptor = AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)rootDescriptor.get());
                if (!AbstractTreeUi.isNodeNull(fromDescriptor)) {
                    AbstractTreeUi.this.createMapping(fromDescriptor, AbstractTreeUi.this.getRootNode());
                }
                AbstractTreeUi.this.insertLoadingNode(AbstractTreeUi.this.getRootNode(), true);
                boolean willUpdate = false;
                if (!rootDescriptor.isNull() && AbstractTreeUi.this.isAutoExpand((NodeDescriptor)rootDescriptor.get())) {
                    willUpdate = AbstractTreeUi.this.myUnbuiltNodes.contains(AbstractTreeUi.this.getRootNode());
                    AbstractTreeUi.this.expand(AbstractTreeUi.this.getRootNode(), true);
                }
                ActionCallback callback2 = willUpdate ? ActionCallback.DONE : AbstractTreeUi.this.updateNodeChildren(AbstractTreeUi.this.getRootNode(), pass, null, false, false, false, true, true);
                callback2.doWhenDone(new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: on done updateNodeChildren"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.getRootNode().getChildCount() == 0) {
                            AbstractTreeUi.this.myTreeModel.nodeChanged(AbstractTreeUi.this.getRootNode());
                        }
                    }
                });
            }
        };
        if (bgLoading) {
            this.queueToBackground(build2, update2).onSuccess((Consumer<Void>)new TreeRunnable.TreeConsumer<Void>("AbstractTreeUi.initRootNodeNowIfNeeded: on processed queueToBackground"){

                @Override
                public void perform() {
                    AbstractTreeUi.this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.initRootNodeNowIfNeeded: on processed queueToBackground later"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.myRootNodeInitialized = true;
                            AbstractTreeUi.this.processNodeActionsIfReady(AbstractTreeUi.this.myRootNode);
                        }
                    });
                }
            });
        } else {
            build2.run();
            update2.run();
            this.myRootNodeInitialized = true;
            this.processNodeActionsIfReady(this.myRootNode);
        }
        return wasCleanedUp;
    }

    private boolean isAutoExpand(@NotNull NodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(18);
        }
        return this.isAutoExpand(descriptor2, true);
    }

    private boolean isAutoExpand(@NotNull NodeDescriptor descriptor2, boolean validate2) {
        if (descriptor2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(19);
        }
        if (this.isAlwaysExpandedTree()) {
            return false;
        }
        boolean autoExpand = this.getBuilder().isAutoExpandNode(descriptor2);
        Object element2 = this.getElementFromDescriptor(descriptor2);
        if (validate2 && element2 != null) {
            autoExpand = this.validateAutoExpand(autoExpand, element2);
        }
        if (!autoExpand && !this.myTree.isRootVisible() && element2 != null && element2.equals(this.getTreeStructure().getRootElement())) {
            return true;
        }
        return autoExpand;
    }

    private boolean validateAutoExpand(boolean autoExpand, @NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(20);
        }
        if (autoExpand) {
            int distance2 = this.getDistanceToAutoExpandRoot(element2);
            if (distance2 < 0) {
                this.myAutoExpandRoots.add(element2);
            } else if (distance2 >= this.myAutoExpandDepth.asInteger() - 1) {
                autoExpand = false;
            }
            if (autoExpand) {
                DefaultMutableTreeNode node = this.getNodeForElement(element2, false);
                autoExpand = node != null && this.isInVisibleAutoExpandChain(node);
            }
        }
        return autoExpand;
    }

    private boolean isInVisibleAutoExpandChain(@NotNull DefaultMutableTreeNode child2) {
        if (child2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(21);
        }
        for (TreeNode eachParent = child2; eachParent != null; eachParent = eachParent.getParent()) {
            if (this.myRootNode == eachParent) {
                return true;
            }
            NodeDescriptor eachDescriptor = AbstractTreeUi.getDescriptorFrom(eachParent);
            if (eachDescriptor != null && this.isAutoExpand(eachDescriptor, false)) continue;
            TreePath path2 = AbstractTreeUi.getPathFor(eachParent);
            return this.myWillBeExpanded.contains(path2.getLastPathComponent()) || this.myTree.isExpanded(path2) && this.myTree.isVisible(path2);
        }
        return false;
    }

    private int getDistanceToAutoExpandRoot(@NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(22);
        }
        int distance2 = 0;
        Object eachParent = element2;
        while (eachParent != null && !this.myAutoExpandRoots.contains(eachParent)) {
            eachParent = this.getTreeStructure().getParentElement(eachParent);
            ++distance2;
        }
        return eachParent != null ? distance2 : -1;
    }

    private boolean isAutoExpand(@NotNull DefaultMutableTreeNode node) {
        NodeDescriptor descriptor2;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(23);
        }
        return (descriptor2 = AbstractTreeUi.getDescriptorFrom(node)) != null && this.isAutoExpand(descriptor2);
    }

    private boolean isAlwaysExpandedTree() {
        return this.myTree instanceof AlwaysExpandedTree && ((AlwaysExpandedTree)((Object)this.myTree)).isAlwaysExpanded();
    }

    @NotNull
    private Promise<Boolean> update(final @NotNull NodeDescriptor nodeDescriptor, boolean now) {
        Promise promise2;
        if (nodeDescriptor == null) {
            AbstractTreeUi.$$$reportNull$$$0(24);
        }
        if (now || this.isPassthroughMode()) {
            promise2 = Promises.resolvedPromise((Object)this.update(nodeDescriptor));
        } else {
            final AsyncPromise result2 = new AsyncPromise();
            promise2 = result2;
            boolean bgLoading = this.isToBuildInBackground(nodeDescriptor);
            boolean edt = AbstractTreeUi.isEdt();
            if (bgLoading) {
                if (edt) {
                    final AtomicBoolean changes2 = new AtomicBoolean();
                    this.queueToBackground(new TreeRunnable("AbstractTreeUi.update: build"){

                        @Override
                        public void perform() {
                            changes2.set(AbstractTreeUi.this.update(nodeDescriptor));
                        }
                    }, new TreeRunnable("AbstractTreeUi.update: post"){

                        @Override
                        public void perform() {
                            result2.setResult((Object)changes2.get());
                        }
                    });
                } else {
                    result2.setResult((Object)this.update(nodeDescriptor));
                }
            } else if (edt || !this.myWasEverShown) {
                result2.setResult((Object)this.update(nodeDescriptor));
            } else {
                this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.update: later"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.execute(new TreeRunnable("AbstractTreeUi.update: later execute"){

                            @Override
                            public void perform() {
                                result2.setResult((Object)AbstractTreeUi.this.update(nodeDescriptor));
                            }
                        });
                    }
                });
            }
        }
        promise2.onSuccess(changes -> {
            if (!changes.booleanValue()) {
                return;
            }
            this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.update: on done result"){

                @Override
                public void perform() {
                    TreePath path2;
                    DefaultMutableTreeNode node;
                    Object element2 = nodeDescriptor.getElement();
                    DefaultMutableTreeNode defaultMutableTreeNode = node = element2 == null ? null : AbstractTreeUi.this.getNodeForElement(element2, false);
                    if (node != null && AbstractTreeUi.this.myTree.isVisible(path2 = AbstractTreeUi.getPathFor(node))) {
                        AbstractTreeUi.this.updateNodeImageAndPosition(node);
                    }
                }
            });
        });
        Promise promise3 = promise2;
        if (promise3 == null) {
            AbstractTreeUi.$$$reportNull$$$0(25);
        }
        return promise3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean update(final @NotNull NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor == null) {
            AbstractTreeUi.$$$reportNull$$$0(26);
        }
        try {
            Throwable throwable;
            LockToken ignored;
            while (true) {
                block21: {
                    ignored = this.attemptLock();
                    throwable = null;
                    if (ignored != null) break;
                    if (this.myProgress != null && this.myProgress.isRunning()) {
                        this.myProgress.cancel();
                    }
                    if (ignored == null) continue;
                    if (throwable == null) break block21;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                ignored.close();
            }
            try {
                final AtomicBoolean update2 = new AtomicBoolean();
                this.execute(new TreeRunnable("AbstractTreeUi.update"){

                    @Override
                    public void perform() {
                        nodeDescriptor.setUpdateCount(nodeDescriptor.getUpdateCount() + 1L);
                        update2.set(AbstractTreeUi.this.getBuilder().updateNodeDescriptor(nodeDescriptor));
                    }
                });
                boolean bl = update2.get();
                return bl;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (IndexNotReadyException e) {
            this.warnOnIndexNotReady(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.info(e);
            return false;
        }
    }

    public void assertIsDispatchThread() {
        if (this.isPassthroughMode()) {
            return;
        }
        if ((this.isTreeShowing() || this.myWasEverShown) && !AbstractTreeUi.isEdt()) {
            LOG.error("Must be in event-dispatch thread");
        }
    }

    private static boolean isEdt() {
        return SwingUtilities.isEventDispatchThread();
    }

    private boolean isTreeShowing() {
        return this.myShowing;
    }

    private void assertNotDispatchThread() {
        if (this.isPassthroughMode()) {
            return;
        }
        if (AbstractTreeUi.isEdt()) {
            LOG.error("Must not be in event-dispatch thread");
        }
    }

    private void processDeferredActions() {
        AbstractTreeUi.processDeferredActions(this.myDeferredSelections);
        AbstractTreeUi.processDeferredActions(this.myDeferredExpansions);
    }

    private static void processDeferredActions(@NotNull Set<Runnable> actions) {
        if (actions == null) {
            AbstractTreeUi.$$$reportNull$$$0(27);
        }
        Runnable[] runnables = actions.toArray(new Runnable[0]);
        actions.clear();
        for (Runnable runnable2 : runnables) {
            runnable2.run();
        }
    }

    @NotNull
    public ActionCallback queueUpdate(Object element2) {
        ActionCallback actionCallback = this.queueUpdate(element2, true);
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(28);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback queueUpdate(Object fromElement, boolean updateStructure) {
        ActionCallback actionCallback;
        block8: {
            this.assertIsDispatchThread();
            if (this.getUpdater() != null) break block8;
            ActionCallback actionCallback2 = ActionCallback.REJECTED;
            if (actionCallback2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(29);
            }
            return actionCallback2;
        }
        try {
            final ActionCallback result2 = new ActionCallback();
            DefaultMutableTreeNode nodeToUpdate = null;
            boolean updateElementStructure = updateStructure;
            Object element2 = fromElement;
            while (element2 != null) {
                DefaultMutableTreeNode node = this.getFirstNode(element2);
                if (node != null) {
                    nodeToUpdate = node;
                    break;
                }
                updateElementStructure = true;
                element2 = this.getTreeStructure().getParentElement(element2);
            }
            this.addSubtreeToUpdate(nodeToUpdate != null ? nodeToUpdate : this.getRootNode(), new TreeRunnable("AbstractTreeUi.queueUpdate"){

                @Override
                public void perform() {
                    result2.setDone();
                }
            }, updateElementStructure);
            actionCallback = result2;
        }
        catch (ProcessCanceledException e) {
            ActionCallback actionCallback3 = ActionCallback.REJECTED;
            if (actionCallback3 == null) {
                AbstractTreeUi.$$$reportNull$$$0(31);
            }
            return actionCallback3;
        }
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(30);
        }
        return actionCallback;
    }

    public void doUpdateFromRoot() {
        this.updateSubtree(this.getRootNode(), false);
    }

    public final void updateSubtree(@NotNull DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(32);
        }
        this.updateSubtree(new TreeUpdatePass(node), canSmartExpand);
    }

    private void updateSubtree(@NotNull TreeUpdatePass pass, boolean canSmartExpand) {
        AbstractTreeUpdater updater2;
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(33);
        }
        if ((updater2 = this.getUpdater()) != null) {
            updater2.addSubtreeToUpdate(pass);
        } else {
            this.updateSubtreeNow(pass, canSmartExpand);
        }
    }

    final void updateSubtreeNow(@NotNull TreeUpdatePass pass, boolean canSmartExpand) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(34);
        }
        this.maybeSetBusyAndScheduleWaiterForReady(true, this.getElementFor(pass.getNode()));
        this.setHoldSize(true);
        boolean consumed = this.initRootNodeNowIfNeeded(pass);
        if (consumed) {
            return;
        }
        DefaultMutableTreeNode node = pass.getNode();
        NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor2 == null) {
            return;
        }
        if (pass.isUpdateStructure()) {
            boolean invisible;
            this.setUpdaterState(new UpdaterTreeState(this)).beforeSubtreeUpdate();
            boolean forceUpdate = true;
            TreePath path2 = AbstractTreeUi.getPathFor(node);
            boolean bl = invisible = !this.myTree.isExpanded(path2) && (path2.getParentPath() == null || !this.myTree.isExpanded(path2.getParentPath()));
            if (invisible && this.myUnbuiltNodes.contains(node)) {
                forceUpdate = false;
            }
            this.updateNodeChildren(node, pass, null, false, canSmartExpand, forceUpdate, false, pass.isUpdateChildren());
        } else {
            this.updateRow(0, pass);
        }
    }

    private void updateRow(final int row, final @NotNull TreeUpdatePass pass) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(35);
        }
        LOG.debug("updateRow: ", row, " - ", pass);
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.updateRow"){

            @Override
            public void perform() {
                NodeDescriptor descriptor2;
                if (row >= AbstractTreeUi.this.getTree().getRowCount()) {
                    return;
                }
                TreePath path2 = AbstractTreeUi.this.getTree().getPathForRow(row);
                if (path2 != null && (descriptor2 = AbstractTreeUi.getDescriptorFrom(path2.getLastPathComponent())) != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
                    AbstractTreeUi.this.maybeYield(() -> AbstractTreeUi.this.update(descriptor2, false).onSuccess(new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.updateRow: inner"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.updateRow(row + 1, pass);
                        }
                    }), pass, node);
                }
            }
        });
    }

    boolean isToBuildChildrenInBackground(Object element2) {
        AbstractTreeStructure structure = this.getTreeStructure();
        return element2 != null && structure.isToBuildChildrenInBackground(element2);
    }

    private boolean isToBuildInBackground(NodeDescriptor descriptor2) {
        return this.isToBuildChildrenInBackground(this.getElementFromDescriptor(descriptor2));
    }

    @NotNull
    private UpdaterTreeState setUpdaterState(@NotNull UpdaterTreeState state) {
        if (state == null) {
            AbstractTreeUi.$$$reportNull$$$0(36);
        }
        if (state.equals(this.myUpdaterState)) {
            UpdaterTreeState updaterTreeState = state;
            if (updaterTreeState == null) {
                AbstractTreeUi.$$$reportNull$$$0(37);
            }
            return updaterTreeState;
        }
        UpdaterTreeState oldState = this.myUpdaterState;
        if (oldState == null) {
            this.myUpdaterState = state;
            UpdaterTreeState updaterTreeState = state;
            if (updaterTreeState == null) {
                AbstractTreeUi.$$$reportNull$$$0(38);
            }
            return updaterTreeState;
        }
        oldState.addAll(state);
        UpdaterTreeState updaterTreeState = oldState;
        if (updaterTreeState == null) {
            AbstractTreeUi.$$$reportNull$$$0(39);
        }
        return updaterTreeState;
    }

    void doUpdateNode(@NotNull DefaultMutableTreeNode node) {
        NodeDescriptor descriptor2;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(40);
        }
        if ((descriptor2 = AbstractTreeUi.getDescriptorFrom(node)) == null) {
            return;
        }
        Object prevElement = this.getElementFromDescriptor(descriptor2);
        if (prevElement == null) {
            return;
        }
        this.update(descriptor2, false).onSuccess(changes -> {
            if (!this.isValid(descriptor2) && this.isInStructure(prevElement)) {
                Object toUpdate = ObjectUtils.notNull(this.getTreeStructure().getParentElement(prevElement), this.getTreeStructure().getRootElement());
                this.getUpdater().addSubtreeToUpdateByElement(toUpdate);
                return;
            }
            if (changes.booleanValue()) {
                this.updateNodeImageAndPosition(node);
            }
        });
    }

    public Object getElementFromDescriptor(NodeDescriptor descriptor2) {
        return this.getBuilder().getTreeStructureElement(descriptor2);
    }

    @NotNull
    private ActionCallback updateNodeChildren(final @NotNull DefaultMutableTreeNode node, final @NotNull TreeUpdatePass pass, final @Nullable LoadedChildren loadedChildren, final boolean forcedNow, final boolean toSmartExpand, final boolean forceUpdate, final boolean descriptorIsUpToDate, final boolean updateChildren) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(41);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(42);
        }
        AbstractTreeStructure treeStructure = this.getTreeStructure();
        ActionCallback result2 = treeStructure.asyncCommit();
        result2.doWhenDone(new TreeRunnable("AbstractTreeUi.updateNodeChildren: on done"){

            @Override
            public void perform() {
                try {
                    AbstractTreeUi.this.removeFromCancelled(node);
                    AbstractTreeUi.this.execute(new TreeRunnable("AbstractTreeUi.updateNodeChildren: execute"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.doUpdateChildren(node, pass, loadedChildren, forcedNow, toSmartExpand, forceUpdate, descriptorIsUpToDate, updateChildren);
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    AbstractTreeUi.this.addToCancelled(node);
                    throw e;
                }
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(43);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateChildren(final @NotNull DefaultMutableTreeNode node, final @NotNull TreeUpdatePass pass, @Nullable LoadedChildren loadedChildren, boolean forcedNow, final boolean toSmartExpand, boolean forceUpdate, boolean descriptorIsUpToDate, final boolean updateChildren) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(44);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(45);
        }
        try {
            boolean requiredToUpdateChildren;
            NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
            if (descriptor2 == null) {
                this.removeFromUnbuilt(node);
                this.removeLoading(node, true);
                return;
            }
            boolean descriptorIsReady = descriptorIsUpToDate || pass.isUpdated(descriptor2);
            final boolean wasExpanded = this.myTree.isExpanded(new TreePath(node.getPath())) || this.isAutoExpand(node);
            boolean wasLeaf = node.getChildCount() == 0;
            boolean bgBuild = this.isToBuildInBackground(descriptor2);
            boolean bl = requiredToUpdateChildren = forcedNow || wasExpanded;
            if (!requiredToUpdateChildren && forceUpdate) {
                boolean alwaysPlus = this.getBuilder().isAlwaysShowPlus(descriptor2);
                if (alwaysPlus && wasLeaf) {
                    requiredToUpdateChildren = true;
                } else {
                    boolean bl2 = requiredToUpdateChildren = !alwaysPlus;
                    if (!requiredToUpdateChildren && !this.myUnbuiltNodes.contains(node)) {
                        this.removeChildren(node);
                    }
                }
            }
            final AtomicReference<LoadedChildren> preloaded = new AtomicReference<LoadedChildren>(loadedChildren);
            if (!requiredToUpdateChildren) {
                if (this.myUnbuiltNodes.contains(node) && node.getChildCount() == 0) {
                    this.insertLoadingNode(node, true);
                }
                if (!descriptorIsReady) {
                    this.update(descriptor2, false);
                }
                return;
            }
            if (!forcedNow && !bgBuild && this.myUnbuiltNodes.contains(node)) {
                if (!descriptorIsReady) {
                    this.update(descriptor2, true);
                    descriptorIsReady = true;
                }
                if (this.processAlwaysLeaf(node) || !updateChildren) {
                    return;
                }
                Pair<Boolean, LoadedChildren> unbuilt = this.processUnbuilt(node, descriptor2, pass, wasExpanded, null);
                if (unbuilt.getFirst().booleanValue()) {
                    return;
                }
                preloaded.set(unbuilt.getSecond());
            }
            final boolean childForceUpdate = this.isChildNodeForceUpdate(node, forceUpdate, wasExpanded);
            if (!forcedNow && this.isToBuildInBackground(descriptor2)) {
                boolean alwaysLeaf = this.processAlwaysLeaf(node);
                this.queueBackgroundUpdate(new UpdateInfo(descriptor2, pass, this.canSmartExpand(node, toSmartExpand), wasExpanded, childForceUpdate, descriptorIsReady, !alwaysLeaf && updateChildren), node);
            } else if (!descriptorIsReady) {
                this.update(descriptor2, false).onSuccess((Consumer<Boolean>)new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.doUpdateChildren"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.processAlwaysLeaf(node) || !updateChildren) {
                            return;
                        }
                        AbstractTreeUi.this.updateNodeChildrenNow(node, pass, (LoadedChildren)preloaded.get(), toSmartExpand, wasExpanded, childForceUpdate);
                    }
                });
            } else {
                if (this.processAlwaysLeaf(node) || !updateChildren) {
                    return;
                }
                this.updateNodeChildrenNow(node, pass, preloaded.get(), toSmartExpand, wasExpanded, childForceUpdate);
            }
        }
        finally {
            if (!this.isReleased()) {
                this.processNodeActionsIfReady(node);
            }
        }
    }

    private boolean processAlwaysLeaf(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(46);
        }
        Object element2 = this.getElementFor(node);
        NodeDescriptor desc = AbstractTreeUi.getDescriptorFrom(node);
        if (desc == null) {
            return false;
        }
        if (element2 != null && this.getTreeStructure().isAlwaysLeaf(element2)) {
            this.removeFromUnbuilt(node);
            this.removeLoading(node, true);
            if (node.getChildCount() > 0) {
                final TreeNode[] children2 = new TreeNode[node.getChildCount()];
                for (int i = 0; i < node.getChildCount(); ++i) {
                    children2[i] = node.getChildAt(i);
                }
                if (this.isSelectionInside(node)) {
                    this.addSelectionPath(AbstractTreeUi.getPathFor(node), true, Conditions.alwaysTrue(), null);
                }
                this.processInnerChange(new TreeRunnable("AbstractTreeUi.processAlwaysLeaf"){

                    @Override
                    public void perform() {
                        for (TreeNode each : children2) {
                            AbstractTreeUi.this.removeNodeFromParent((MutableTreeNode)each, true);
                            AbstractTreeUi.this.disposeNode((DefaultMutableTreeNode)each);
                        }
                    }
                });
            }
            this.removeFromUnbuilt(node);
            desc.setWasDeclaredAlwaysLeaf(true);
            this.processNodeActionsIfReady(node);
            return true;
        }
        boolean wasLeaf = desc.isWasDeclaredAlwaysLeaf();
        desc.setWasDeclaredAlwaysLeaf(false);
        if (wasLeaf) {
            this.insertLoadingNode(node, true);
        }
        return false;
    }

    private boolean isChildNodeForceUpdate(@NotNull DefaultMutableTreeNode node, boolean parentForceUpdate, boolean parentExpanded) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(47);
        }
        TreePath path2 = AbstractTreeUi.getPathFor(node);
        return parentForceUpdate && (parentExpanded || this.myTree.isExpanded(path2));
    }

    private void updateNodeChildrenNow(final @NotNull DefaultMutableTreeNode node, final @NotNull TreeUpdatePass pass, @Nullable LoadedChildren preloadedChildren, boolean toSmartExpand, final boolean wasExpanded, final boolean forceUpdate) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(48);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(49);
        }
        if (this.isUpdatingChildrenNow(node)) {
            return;
        }
        if (!this.canInitiateNewActivity()) {
            throw new ProcessCanceledException();
        }
        final NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        final MutualMap<Object, Integer> elementToIndexMap = this.loadElementsFromStructure(descriptor2, preloadedChildren);
        final LoadedChildren loadedChildren = preloadedChildren != null ? preloadedChildren : new LoadedChildren(elementToIndexMap.getKeys().toArray());
        this.addToUpdatingChildren(node);
        pass.setCurrentNode(node);
        final boolean canSmartExpand = this.canSmartExpand(node, toSmartExpand);
        this.removeFromUnbuilt(node);
        this.processExistingNodes(node, elementToIndexMap, pass, this.canSmartExpand(node, toSmartExpand), forceUpdate, wasExpanded, preloadedChildren).onSuccess(new TreeRunnable.TreeConsumer("AbstractTreeUi.updateNodeChildrenNow: on done processExistingNodes"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.isDisposed(node)) {
                    AbstractTreeUi.this.removeFromUpdatingChildren(node);
                    return;
                }
                AbstractTreeUi.this.removeLoading(node, false);
                final boolean expanded = AbstractTreeUi.this.isExpanded(node, wasExpanded);
                if (expanded) {
                    AbstractTreeUi.this.myWillBeExpanded.add(node);
                } else {
                    AbstractTreeUi.this.myWillBeExpanded.remove(node);
                }
                AbstractTreeUi.this.collectNodesToInsert(descriptor2, elementToIndexMap, node, expanded, loadedChildren).doWhenDone(nodesToInsert -> {
                    AbstractTreeUi.this.insertNodesInto(nodesToInsert, node);
                    ActionCallback callback2 = AbstractTreeUi.this.updateNodesToInsert(nodesToInsert, pass, canSmartExpand, AbstractTreeUi.this.isChildNodeForceUpdate(node, forceUpdate, expanded));
                    callback2.doWhenDone(new TreeRunnable("AbstractTreeUi.updateNodeChildrenNow: on done updateNodesToInsert"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.removeLoading(node, false);
                            AbstractTreeUi.this.removeFromUpdatingChildren(node);
                            if (node.getChildCount() > 0 && expanded) {
                                AbstractTreeUi.this.expand(node, canSmartExpand);
                            }
                            if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                throw new ProcessCanceledException();
                            }
                            Object element2 = AbstractTreeUi.this.getElementFor(node);
                            AbstractTreeUi.this.addNodeAction(element2, false, node1 -> AbstractTreeUi.this.removeLoading(node1, false));
                            AbstractTreeUi.this.processNodeActionsIfReady(node);
                        }
                    });
                }).doWhenProcessed((Runnable)new TreeRunnable("AbstractTreeUi.updateNodeChildrenNow: on processed collectNodesToInsert"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.myWillBeExpanded.remove(node);
                        AbstractTreeUi.this.removeFromUpdatingChildren(node);
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                });
            }
        }).onError((Consumer<Throwable>)new TreeRunnable.TreeConsumer<Throwable>("AbstractTreeUi.updateNodeChildrenNow: on reject processExistingNodes"){

            @Override
            public void perform() {
                AbstractTreeUi.this.removeFromUpdatingChildren(node);
                AbstractTreeUi.this.processNodeActionsIfReady(node);
            }
        });
    }

    private boolean isDisposed(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(50);
        }
        return !node.isNodeAncestor((DefaultMutableTreeNode)this.myTree.getModel().getRoot());
    }

    private void expandSilently(TreePath path2) {
        this.assertIsDispatchThread();
        try {
            this.mySilentExpand = path2;
            this.getTree().expandPath(path2);
        }
        finally {
            this.mySilentExpand = null;
        }
    }

    private void addSelectionSilently(TreePath path2) {
        this.assertIsDispatchThread();
        try {
            this.mySilentSelect = path2;
            this.getTree().getSelectionModel().addSelectionPath(path2);
        }
        finally {
            this.mySilentSelect = null;
        }
    }

    private void expand(@NotNull DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(51);
        }
        this.expand(new TreePath(node.getPath()), canSmartExpand);
    }

    private void expand(@NotNull TreePath path2, boolean canSmartExpand) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(52);
        }
        Object last = path2.getLastPathComponent();
        boolean isLeaf = this.myTree.getModel().isLeaf(path2.getLastPathComponent());
        boolean isRoot = last == this.myTree.getModel().getRoot();
        TreePath parent = path2.getParentPath();
        if (isRoot && !this.myTree.isExpanded(path2)) {
            if (this.myTree.isRootVisible() || this.myUnbuiltNodes.contains(last)) {
                this.insertLoadingNode((DefaultMutableTreeNode)last, false);
            }
            this.expandPath(path2, canSmartExpand);
        } else if (this.myTree.isExpanded(path2) || isLeaf && parent != null && this.myTree.isExpanded(parent) && !this.myUnbuiltNodes.contains(last) && !this.isCancelled(last)) {
            if (last instanceof DefaultMutableTreeNode) {
                this.processNodeActionsIfReady((DefaultMutableTreeNode)last);
            }
        } else if (isLeaf && (this.myUnbuiltNodes.contains(last) || this.isCancelled(last))) {
            this.insertLoadingNode((DefaultMutableTreeNode)last, true);
            this.expandPath(path2, canSmartExpand);
        } else if (isLeaf && parent != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
            if (parentNode != null) {
                this.addToUnbuilt(parentNode);
            }
            this.expandPath(parent, canSmartExpand);
        } else {
            this.expandPath(path2, canSmartExpand);
        }
    }

    private void addToUnbuilt(DefaultMutableTreeNode node) {
        this.myUnbuiltNodes.add(node);
    }

    private void removeFromUnbuilt(DefaultMutableTreeNode node) {
        this.myUnbuiltNodes.remove(node);
    }

    private Pair<Boolean, LoadedChildren> processUnbuilt(final @NotNull DefaultMutableTreeNode node, final NodeDescriptor descriptor2, final @NotNull TreeUpdatePass pass, final boolean isExpanded, final @Nullable LoadedChildren loadedChildren) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(53);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(54);
        }
        final Ref result2 = new Ref();
        this.execute(new TreeRunnable("AbstractTreeUi.processUnbuilt"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                if (!isExpanded && AbstractTreeUi.this.getBuilder().isAlwaysShowPlus(descriptor2)) {
                    result2.set(new Pair<Boolean, Object>(true, null));
                    return;
                }
                Object element2 = AbstractTreeUi.this.getElementFor(node);
                if (element2 == null) {
                    this.trace("null element for node " + node);
                    result2.set(new Pair<Boolean, Object>(true, null));
                    return;
                }
                AbstractTreeUi.this.addToUpdatingChildren(node);
                try {
                    boolean processed2;
                    LoadedChildren children2;
                    LoadedChildren loadedChildren2 = children2 = loadedChildren != null ? loadedChildren : new LoadedChildren(AbstractTreeUi.this.getChildrenFor(element2));
                    if (children2.getElements().isEmpty()) {
                        AbstractTreeUi.this.removeFromUnbuilt(node);
                        AbstractTreeUi.this.removeLoading(node, true);
                        processed2 = true;
                    } else {
                        if (AbstractTreeUi.this.isAutoExpand(node)) {
                            AbstractTreeUi.this.addNodeAction(AbstractTreeUi.this.getElementFor(node), false, node1 -> {
                                TreePath path2 = new TreePath(node1.getPath());
                                if (AbstractTreeUi.this.getTree().isExpanded(path2) || children2.getElements().isEmpty()) {
                                    AbstractTreeUi.this.removeLoading(node1, false);
                                } else {
                                    AbstractTreeUi.this.maybeYield(() -> {
                                        AbstractTreeUi.this.expand(element2, null);
                                        return Promises.resolvedPromise();
                                    }, pass, node1);
                                }
                            });
                        }
                        processed2 = false;
                    }
                    AbstractTreeUi.this.removeFromUpdatingChildren(node);
                    AbstractTreeUi.this.processNodeActionsIfReady(node);
                    result2.set(new Pair<Boolean, LoadedChildren>(processed2, children2));
                }
                finally {
                    AbstractTreeUi.this.removeFromUpdatingChildren(node);
                }
            }
        });
        return (Pair)result2.get();
    }

    private boolean removeIfLoading(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(55);
        }
        if (AbstractTreeUi.isLoadingNode(node)) {
            this.moveSelectionToParentIfNeeded(node);
            this.removeNodeFromParent((MutableTreeNode)node, false);
            return true;
        }
        return false;
    }

    private void moveSelectionToParentIfNeeded(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(56);
        }
        TreePath path2 = AbstractTreeUi.getPathFor(node);
        if (this.myTree.getSelectionModel().isPathSelected(path2)) {
            TreePath parentPath = path2.getParentPath();
            this.myTree.getSelectionModel().removeSelectionPath(path2);
            if (parentPath != null) {
                this.myTree.getSelectionModel().addSelectionPath(parentPath);
            }
        }
    }

    private Object[] getChildrenFor(final Object element2) {
        final Ref passOne = new Ref();
        try (LockToken ignored = this.acquireLock();){
            this.execute(new TreeRunnable("AbstractTreeUi.getChildrenFor"){

                @Override
                public void perform() {
                    passOne.set(AbstractTreeUi.this.getTreeStructure().getChildElements(element2));
                }
            });
        }
        catch (IndexNotReadyException e) {
            this.warnOnIndexNotReady(e);
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        if (!Registry.is("ide.tree.checkStructure")) {
            return (Object[])passOne.get();
        }
        Object[] passTwo = this.getTreeStructure().getChildElements(element2);
        Set<Object> two = ContainerUtil.set(passTwo);
        if (((Object[])passOne.get()).length != passTwo.length) {
            LOG.error("AbstractTreeStructure.getChildren() must either provide same objects or new objects but with correct hashCode() and equals() methods. Wrong parent element=" + element2);
        } else {
            for (Object eachInOne : (Object[])passOne.get()) {
                if (two.contains(eachInOne)) continue;
                LOG.error("AbstractTreeStructure.getChildren() must either provide same objects or new objects but with correct hashCode() and equals() methods. Wrong parent element=" + element2);
                break;
            }
        }
        return (Object[])passOne.get();
    }

    private void warnOnIndexNotReady(IndexNotReadyException e) {
        if (!this.myWasEverIndexNotReady) {
            this.myWasEverIndexNotReady = true;
            LOG.error("Tree is not dumb-mode-aware; treeBuilder=" + this.getBuilder() + " treeStructure=" + this.getTreeStructure(), e);
        }
    }

    @NotNull
    private ActionCallback updateNodesToInsert(@NotNull List<? extends TreeNode> nodesToInsert, @NotNull TreeUpdatePass pass, boolean canSmartExpand, boolean forceUpdate) {
        if (nodesToInsert == null) {
            AbstractTreeUi.$$$reportNull$$$0(57);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(58);
        }
        ActionCallback.Chunk chunk = new ActionCallback.Chunk();
        for (TreeNode treeNode : nodesToInsert) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)treeNode;
            ActionCallback callback2 = this.updateNodeChildren(childNode, pass, null, false, canSmartExpand, forceUpdate, true, true);
            if (callback2.isDone()) continue;
            chunk.add(callback2);
        }
        ActionCallback actionCallback = chunk.getWhenProcessed();
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(59);
        }
        return actionCallback;
    }

    @NotNull
    private Promise<?> processExistingNodes(@NotNull DefaultMutableTreeNode node, @NotNull MutualMap<Object, Integer> elementToIndexMap, @NotNull TreeUpdatePass pass, boolean canSmartExpand, boolean forceUpdate, boolean wasExpanded, @Nullable LoadedChildren preloaded) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(60);
        }
        if (elementToIndexMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(61);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(62);
        }
        List<TreeNode> childNodes = TreeUtil.listChildren(node);
        return this.maybeYield(() -> {
            if (pass.isExpired()) {
                return Promises.rejectedPromise();
            }
            if (childNodes.isEmpty()) {
                return Promises.resolvedPromise();
            }
            SmartList promises = new SmartList();
            for (TreeNode each : childNodes) {
                DefaultMutableTreeNode eachChild = (DefaultMutableTreeNode)each;
                if (AbstractTreeUi.isLoadingNode(eachChild)) continue;
                boolean childForceUpdate = this.isChildNodeForceUpdate(eachChild, forceUpdate, wasExpanded);
                promises.add(this.maybeYield(() -> {
                    NodeDescriptor descriptor2 = preloaded != null ? preloaded.getDescriptor(this.getElementFor(eachChild)) : null;
                    NodeDescriptor descriptorFromNode = AbstractTreeUi.getDescriptorFrom(eachChild);
                    if (this.isValid(descriptor2)) {
                        eachChild.setUserObject(descriptor2);
                        if (descriptorFromNode != null) {
                            descriptor2.setChildrenSortingStamp(descriptorFromNode.getChildrenSortingStamp());
                        }
                    } else {
                        descriptor2 = descriptorFromNode;
                    }
                    return this.processExistingNode(eachChild, descriptor2, node, elementToIndexMap, pass, canSmartExpand, childForceUpdate, preloaded);
                }, pass, node));
                for (Promise promise2 : promises) {
                    if (promise2.getState() != Promise.State.REJECTED) continue;
                    return Promises.rejectedPromise();
                }
            }
            return Promises.all(promises);
        }, pass, node);
    }

    private boolean isRerunNeeded(@NotNull TreeUpdatePass pass) {
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(63);
        }
        if (pass.isExpired() || !this.canInitiateNewActivity()) {
            return false;
        }
        boolean rerunBecauseTreeIsHidden = !pass.isExpired() && !this.isTreeShowing() && this.getUpdater().isInPostponeMode();
        return rerunBecauseTreeIsHidden || this.getUpdater().isRerunNeededFor(pass);
    }

    public static <T> T calculateYieldingToWriteAction(@NotNull Supplier<? extends T> producer) throws ProcessCanceledException {
        if (producer == null) {
            AbstractTreeUi.$$$reportNull$$$0(64);
        }
        if (!Registry.is("ide.abstractTreeUi.BuildChildrenInBackgroundYieldingToWriteAction") || ApplicationManager.getApplication().isDispatchThread()) {
            return producer.get();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && indicator.isRunning()) {
            return producer.get();
        }
        Ref result2 = new Ref();
        boolean succeeded = ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> result2.set(producer.get()), indicator);
        if (!succeeded || indicator != null && indicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
        return result2.get();
    }

    @NotNull
    private Promise<?> maybeYield(final @NotNull AsyncRunnable processRunnable, final @NotNull TreeUpdatePass pass, final DefaultMutableTreeNode node) {
        if (processRunnable == null) {
            AbstractTreeUi.$$$reportNull$$$0(65);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(66);
        }
        if (this.isRerunNeeded(pass)) {
            this.getUpdater().requeue(pass);
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(67);
            }
            return promise2;
        }
        if (this.canYield()) {
            final AsyncPromise result2 = new AsyncPromise();
            pass.setCurrentNode(node);
            boolean wasRun = this.yieldAndRun(new TreeRunnable("AbstractTreeUi.maybeYeild"){

                @Override
                public void perform() {
                    if (pass.isExpired()) {
                        result2.setError("expired");
                        return;
                    }
                    if (AbstractTreeUi.this.isRerunNeeded(pass)) {
                        AbstractTreeUi.this.runDone(new TreeRunnable("AbstractTreeUi.maybeYeild: rerun"){

                            @Override
                            public void perform() {
                                if (!pass.isExpired()) {
                                    AbstractTreeUi.this.queueUpdate(AbstractTreeUi.this.getElementFor(node));
                                }
                            }
                        });
                        result2.setError("requeue");
                    } else {
                        try {
                            AbstractTreeUi.this.execute(processRunnable).processed(result2);
                        }
                        catch (ProcessCanceledException e) {
                            pass.expire();
                            AbstractTreeUi.this.cancelUpdate();
                            result2.setError("rejected");
                        }
                    }
                }
            }, pass);
            if (!wasRun) {
                result2.setError("rejected");
            }
            AsyncPromise asyncPromise = result2;
            if (asyncPromise == null) {
                AbstractTreeUi.$$$reportNull$$$0(68);
            }
            return asyncPromise;
        }
        try {
            return this.execute(processRunnable);
        }
        catch (ProcessCanceledException e) {
            pass.expire();
            this.cancelUpdate();
            Promise promise3 = Promises.rejectedPromise();
            if (promise3 == null) {
                AbstractTreeUi.$$$reportNull$$$0(69);
            }
            return promise3;
        }
    }

    @NotNull
    private Promise<?> execute(@NotNull AsyncRunnable runnable2) throws ProcessCanceledException {
        Promise<?> promise2;
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(70);
        }
        try {
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            Promise<?> promise3 = runnable2.run();
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            promise2 = promise3;
        }
        catch (ProcessCanceledException e) {
            if (!this.isReleased()) {
                this.setCancelRequested(true);
                this.resetToReady();
            }
            throw e;
        }
        if (promise2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(71);
        }
        return promise2;
    }

    private void execute(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(72);
        }
        try {
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
            runnable2.run();
            if (!this.canInitiateNewActivity()) {
                throw new ProcessCanceledException();
            }
        }
        catch (ProcessCanceledException e) {
            if (!this.isReleased()) {
                this.setCancelRequested(true);
                this.resetToReady();
            }
            throw e;
        }
    }

    private boolean canInitiateNewActivity() {
        return !this.isCancelProcessed() && !this.myReleaseRequested && !this.isReleased();
    }

    private void resetToReady() {
        if (this.isReady()) {
            return;
        }
        if (this.myResettingToReadyNow.get()) {
            this._getReady();
            return;
        }
        this.myResettingToReadyNow.set(true);
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.resetToReady: later"){

            @Override
            public void perform() {
                Progressive[] progressives;
                if (!AbstractTreeUi.this.myResettingToReadyNow.get()) {
                    return;
                }
                for (Progressive each : progressives = AbstractTreeUi.this.myBatchIndicators.keySet().toArray(new Progressive[0])) {
                    ((ProgressIndicator)AbstractTreeUi.this.myBatchIndicators.remove(each)).cancel();
                    ((ActionCallback)AbstractTreeUi.this.myBatchCallbacks.remove(each)).setRejected();
                }
                AbstractTreeUi.this.resetToReadyNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ActionCallback resetToReadyNow() {
        if (this.isReleased()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractTreeUi.$$$reportNull$$$0(73);
            }
            return actionCallback;
        }
        this.assertIsDispatchThread();
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = this.myUpdatingChildren;
        synchronized (this.myUpdatingChildren) {
            Object[] bg;
            DefaultMutableTreeNode[] uc = this.myUpdatingChildren.toArray(new DefaultMutableTreeNode[0]);
            // ** MonitorExit[defaultMutableTreeNodeArray] (shouldn't be in output)
            for (DefaultMutableTreeNode each : uc) {
                this.resetIncompleteNode(each);
            }
            for (Object each : bg = ArrayUtil.toObjectArray(this.myLoadedInBackground.keySet())) {
                DefaultMutableTreeNode node = this.getNodeForElement(each, false);
                if (node == null) continue;
                this.resetIncompleteNode(node);
            }
            this.myUpdaterState = null;
            this.getUpdater().reset();
            this.myYieldingNow = false;
            this.myYieldingPasses.clear();
            this.myYieldingDoneRunnables.clear();
            this.myNodeActions.clear();
            this.myNodeChildrenActions.clear();
            Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
            synchronized (set) {
                this.myUpdatingChildren.clear();
            }
            this.myLoadedInBackground.clear();
            this.myDeferredExpansions.clear();
            this.myDeferredSelections.clear();
            ActionCallback actionCallback = this._getReady();
            actionCallback.doWhenDone(new TreeRunnable("AbstractTreeUi.resetToReadyNow: on done"){

                @Override
                public void perform() {
                    AbstractTreeUi.this.myResettingToReadyNow.set(false);
                    AbstractTreeUi.this.setCancelRequested(false);
                }
            });
            this.maybeReady();
            ActionCallback actionCallback2 = actionCallback;
            if (actionCallback2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(74);
            }
            return actionCallback2;
        }
    }

    void addToCancelled(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(75);
        }
        this.myCancelledBuild.put(node, node);
    }

    private void removeFromCancelled(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(76);
        }
        this.myCancelledBuild.remove(node);
    }

    public boolean isCancelled(@NotNull Object node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(77);
        }
        return node instanceof DefaultMutableTreeNode && this.myCancelledBuild.containsKey(node);
    }

    private void resetIncompleteNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(78);
        }
        if (this.myReleaseRequested) {
            return;
        }
        this.addToCancelled(node);
        if (!this.isExpanded(node, false)) {
            node.removeAllChildren();
            Object element2 = this.getElementFor(node);
            if (element2 != null && !this.getTreeStructure().isAlwaysLeaf(element2)) {
                this.insertLoadingNode(node, true);
            }
        } else {
            this.removeFromUnbuilt(node);
            this.removeLoading(node, true);
        }
    }

    private boolean yieldAndRun(final @NotNull Runnable runnable2, final @NotNull TreeUpdatePass pass) {
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(79);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(80);
        }
        this.myYieldingPasses.add(pass);
        this.myYieldingNow = true;
        this.yield(new TreeRunnable("AbstractTreeUi.yieldAndRun"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.isReleased()) {
                    return;
                }
                AbstractTreeUi.this.runOnYieldingDone(new TreeRunnable("AbstractTreeUi.yieldAndRun: inner"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isReleased()) {
                            return;
                        }
                        AbstractTreeUi.this.executeYieldingRequest(runnable2, pass);
                    }
                });
            }
        });
        return true;
    }

    private boolean isYeildingNow() {
        return this.myYieldingNow;
    }

    private boolean hasScheduledUpdates() {
        return this.getUpdater().hasNodesToUpdate();
    }

    public boolean isReady() {
        return this.isReady(false);
    }

    boolean isCancelledReady() {
        return this.isReady(false) && !this.myCancelledBuild.isEmpty();
    }

    public boolean isReady(boolean attempt) {
        if (attempt && this.myStateLock.isLocked()) {
            return false;
        }
        Boolean ready = this.checkValue(() -> this.isIdle() && !this.hasPendingWork() && !this.isNodeActionsPending(), attempt);
        return ready != null && ready != false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Boolean checkValue(@NotNull Computable<Boolean> computable, boolean attempt) {
        if (computable == null) {
            AbstractTreeUi.$$$reportNull$$$0(81);
        }
        try (LockToken ignored = attempt ? this.attemptLock() : this.acquireLock();){
            Boolean bl = computable.compute();
            return bl;
        }
        catch (InterruptedException e) {
            LOG.info(e);
            return null;
        }
    }

    @NotNull
    @NonNls
    public String getStatus() {
        String string = "isReady=" + this.isReady() + "\n isIdle=" + this.isIdle() + "\n  isYeildingNow=" + this.isYeildingNow() + "\n  isWorkerBusy=" + this.isWorkerBusy() + "\n  hasUpdatingChildrenNow=" + this.hasUpdatingChildrenNow() + "\n  isLoadingInBackgroundNow=" + this.isLoadingInBackgroundNow() + "\n hasPendingWork=" + this.hasPendingWork() + "\n  hasNodesToUpdate=" + this.hasNodesToUpdate() + "\n  updaterState=" + this.myUpdaterState + "\n  hasScheduledUpdates=" + this.hasScheduledUpdates() + "\n  isPostponedMode=" + this.getUpdater().isInPostponeMode() + "\n nodeActions=" + this.myNodeActions.keySet() + "\n nodeChildrenActions=" + this.myNodeChildrenActions.keySet() + "\nisReleased=" + this.isReleased() + "\n isReleaseRequested=" + this.isReleaseRequested() + "\nisCancelProcessed=" + this.isCancelProcessed() + "\n isCancelRequested=" + this.myCancelRequest + "\n isResettingToReadyNow=" + this.myResettingToReadyNow + "\ncanInitiateNewActivity=" + this.canInitiateNewActivity() + "\nbatchIndicators=" + this.myBatchIndicators;
        if (string == null) {
            AbstractTreeUi.$$$reportNull$$$0(82);
        }
        return string;
    }

    public boolean hasPendingWork() {
        return this.hasNodesToUpdate() || this.myUpdaterState != null && this.myUpdaterState.isProcessingNow() || this.hasScheduledUpdates() && !this.getUpdater().isInPostponeMode();
    }

    public boolean isIdle() {
        return !this.isYeildingNow() && !this.isWorkerBusy() && !this.hasUpdatingChildrenNow() && !this.isLoadingInBackgroundNow();
    }

    private void executeYieldingRequest(@NotNull Runnable runnable2, @NotNull TreeUpdatePass pass) {
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(83);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(84);
        }
        try {
            try {
                this.myYieldingPasses.remove(pass);
                if (!this.canInitiateNewActivity()) {
                    throw new ProcessCanceledException();
                }
                runnable2.run();
            }
            finally {
                if (!this.isReleased()) {
                    this.maybeYieldingFinished();
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.resetToReady();
        }
    }

    private void maybeYieldingFinished() {
        if (this.myYieldingPasses.isEmpty()) {
            this.myYieldingNow = false;
            this.flushPendingNodeActions();
        }
    }

    void maybeReady() {
        this.assertIsDispatchThread();
        if (this.isReleased()) {
            return;
        }
        boolean ready = this.isReady(true);
        if (!ready) {
            return;
        }
        this.myRevalidatedObjects.clear();
        this.setCancelRequested(false);
        this.myResettingToReadyNow.set(false);
        this.myInitialized.setDone();
        if (this.canInitiateNewActivity() && this.myUpdaterState != null && !this.myUpdaterState.isProcessingNow()) {
            UpdaterTreeState oldState = this.myUpdaterState;
            if (!this.myUpdaterState.restore(null)) {
                this.setUpdaterState(oldState);
            }
            if (!this.isReady(true)) {
                return;
            }
        }
        this.setHoldSize(false);
        if (this.myTree.isShowing() && this.getBuilder().isToEnsureSelectionOnFocusGained() && Registry.is("ide.tree.ensureSelectionOnFocusGained")) {
            TreeUtil.ensureSelection(this.myTree);
        }
        if (this.myInitialized.isDone()) {
            if (this.isReleaseRequested() || this.isCancelProcessed()) {
                this.myBusyObject.onReady((Object)this);
            } else {
                this.myBusyObject.onReady();
            }
        }
        if (this.canInitiateNewActivity()) {
            TreePath[] selection = this.getTree().getSelectionPaths();
            Rectangle visible = this.getTree().getVisibleRect();
            if (selection != null) {
                for (TreePath each : selection) {
                    Rectangle bounds2 = this.getTree().getPathBounds(each);
                    if (bounds2 == null || !visible.contains(bounds2) && !visible.intersects(bounds2)) continue;
                    this.getTree().repaint(bounds2);
                }
            }
        }
    }

    private void flushPendingNodeActions() {
        Runnable[] actions;
        DefaultMutableTreeNode[] nodes = this.myPendingNodeActions.toArray(new DefaultMutableTreeNode[0]);
        this.myPendingNodeActions.clear();
        for (DefaultMutableTreeNode each : nodes) {
            this.processNodeActionsIfReady(each);
        }
        for (Runnable each : actions = this.myYieldingDoneRunnables.toArray(new Runnable[0])) {
            if (this.isYeildingNow()) continue;
            this.myYieldingDoneRunnables.remove(each);
            each.run();
        }
        this.maybeReady();
    }

    protected void runOnYieldingDone(@NotNull Runnable onDone) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(85);
        }
        this.getBuilder().runOnYieldingDone(onDone);
    }

    protected void yield(Runnable runnable2) {
        this.getBuilder().yield(runnable2);
    }

    @NotNull
    private MutualMap<Object, Integer> loadElementsFromStructure(NodeDescriptor descriptor2, @Nullable LoadedChildren preloadedChildren) {
        MutualMap<Object, Integer> elementToIndexMap = new MutualMap<Object, Integer>(true);
        Object element2 = this.getElementFromDescriptor(descriptor2);
        if (!this.isValid(element2)) {
            MutualMap<Object, Integer> mutualMap = elementToIndexMap;
            if (mutualMap == null) {
                AbstractTreeUi.$$$reportNull$$$0(86);
            }
            return mutualMap;
        }
        List<Object> children2 = preloadedChildren != null ? preloadedChildren.getElements() : Arrays.asList(this.getChildrenFor(element2));
        int index = 0;
        for (Object child2 : children2) {
            if (!this.isValid(child2)) continue;
            elementToIndexMap.put(child2, index);
            ++index;
        }
        MutualMap<Object, Integer> mutualMap = elementToIndexMap;
        if (mutualMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(87);
        }
        return mutualMap;
    }

    public static boolean isLoadingNode(Object node) {
        return node instanceof LoadingNode;
    }

    @NotNull
    private AsyncResult<List<TreeNode>> collectNodesToInsert(NodeDescriptor descriptor2, @NotNull MutualMap<Object, Integer> elementToIndexMap, final DefaultMutableTreeNode parent, final boolean addLoadingNode, @NotNull LoadedChildren loadedChildren) {
        if (elementToIndexMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(88);
        }
        if (loadedChildren == null) {
            AbstractTreeUi.$$$reportNull$$$0(89);
        }
        final AsyncResult result2 = new AsyncResult();
        final ArrayList nodesToInsert = new ArrayList();
        Collection<Object> allElements = elementToIndexMap.getKeys();
        final ActionCallback processingDone = allElements.isEmpty() ? ActionCallback.DONE : new ActionCallback(allElements.size());
        for (Object child2 : allElements) {
            NodeDescriptor childDescr;
            Integer index = elementToIndexMap.getValue(child2);
            boolean needToUpdate = false;
            NodeDescriptor loadedDesc = loadedChildren.getDescriptor(child2);
            if (!this.isValid(loadedDesc, descriptor2)) {
                childDescr = this.getTreeStructure().createDescriptor(child2, descriptor2);
                needToUpdate = true;
            } else {
                childDescr = loadedDesc;
            }
            if (index == null) {
                index = Integer.MAX_VALUE;
                needToUpdate = true;
            }
            childDescr.setIndex(index);
            ActionCallback update2 = new ActionCallback();
            if (needToUpdate) {
                this.update(childDescr, false).onSuccess(changes -> {
                    loadedChildren.putDescriptor(child2, childDescr, (boolean)changes);
                    update2.setDone();
                });
            } else {
                update2.setDone();
            }
            update2.doWhenDone(new TreeRunnable("AbstractTreeUi.collectNodesToInsert: on done update"){

                @Override
                public void perform() {
                    DefaultMutableTreeNode node;
                    Object element2 = AbstractTreeUi.this.getElementFromDescriptor(childDescr);
                    if (!(AbstractTreeUi.isNodeNull(element2) || (node = AbstractTreeUi.this.getNodeForElement(element2, false)) != null && node.getParent() == parent)) {
                        DefaultMutableTreeNode childNode = AbstractTreeUi.this.createChildNode(childDescr);
                        if (addLoadingNode || AbstractTreeUi.this.getBuilder().isAlwaysShowPlus(childDescr)) {
                            AbstractTreeUi.this.insertLoadingNode(childNode, true);
                        } else {
                            AbstractTreeUi.this.addToUnbuilt(childNode);
                        }
                        nodesToInsert.add(childNode);
                        AbstractTreeUi.this.createMapping(element2, childNode);
                    }
                    processingDone.setDone();
                }
            });
        }
        processingDone.doWhenDone(new TreeRunnable("AbstractTreeUi.collectNodesToInsert: on done processing"){

            @Override
            public void perform() {
                result2.setDone((Object)nodesToInsert);
            }
        });
        AsyncResult asyncResult = result2;
        if (asyncResult == null) {
            AbstractTreeUi.$$$reportNull$$$0(90);
        }
        return asyncResult;
    }

    @NotNull
    protected DefaultMutableTreeNode createChildNode(NodeDescriptor descriptor2) {
        return new ElementNode(this, descriptor2);
    }

    protected boolean canYield() {
        return this.myCanYield && this.myYieldingUpdate.asBoolean();
    }

    private long getClearOnHideDelay() {
        return this.myClearOnHideDelay;
    }

    @NotNull
    public ActionCallback getInitialized() {
        ActionCallback actionCallback = this.myInitialized;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(91);
        }
        return actionCallback;
    }

    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            AbstractTreeUi.$$$reportNull$$$0(92);
        }
        return this.myBusyObject.getReady(requestor);
    }

    private ActionCallback _getReady() {
        return this.getReady(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUpdatingChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(93);
        }
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            this.myUpdatingChildren.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromUpdatingChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(94);
        }
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            this.myUpdatingChildren.remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUpdatingChildrenNow(DefaultMutableTreeNode node) {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            return this.myUpdatingChildren.contains(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isParentUpdatingChildrenNow(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(95);
        }
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            for (DefaultMutableTreeNode eachParent = (DefaultMutableTreeNode)node.getParent(); eachParent != null; eachParent = (DefaultMutableTreeNode)eachParent.getParent()) {
                if (!this.myUpdatingChildren.contains(eachParent)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUpdatingChildrenNow() {
        Set<DefaultMutableTreeNode> set = this.myUpdatingChildren;
        synchronized (set) {
            return !this.myUpdatingChildren.isEmpty();
        }
    }

    @NotNull
    Map<Object, List<NodeAction>> getNodeActions() {
        Map<Object, List<NodeAction>> map2 = this.myNodeActions;
        if (map2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(96);
        }
        return map2;
    }

    @NotNull
    List<Object> getLoadedChildrenFor(@NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(97);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        DefaultMutableTreeNode node = this.getNodeForElement(element2, false);
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode each = node.getChildAt(i);
                if (AbstractTreeUi.isLoadingNode(each)) continue;
                result2.add(this.getElementFor(each));
            }
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            AbstractTreeUi.$$$reportNull$$$0(98);
        }
        return arrayList;
    }

    boolean hasNodesToUpdate() {
        return this.getUpdater().hasNodesToUpdate();
    }

    @NotNull
    public List<Object> getExpandedElements() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (this.isReleased()) {
            ArrayList<Object> arrayList = result2;
            if (arrayList == null) {
                AbstractTreeUi.$$$reportNull$$$0(99);
            }
            return arrayList;
        }
        Enumeration<TreePath> enumeration = this.myTree.getExpandedDescendants(AbstractTreeUi.getPathFor(this.getRootNode()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath each = enumeration.nextElement();
                Object eachElement = this.getElementFor(each.getLastPathComponent());
                if (eachElement == null) continue;
                result2.add(eachElement);
            }
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            AbstractTreeUi.$$$reportNull$$$0(100);
        }
        return arrayList;
    }

    @NotNull
    public ActionCallback cancelUpdate() {
        if (this.isReleased()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractTreeUi.$$$reportNull$$$0(101);
            }
            return actionCallback;
        }
        this.setCancelRequested(true);
        final ActionCallback done = new ActionCallback();
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.cancelUpdate"){

            @Override
            public void perform() {
                if (AbstractTreeUi.this.isReleased()) {
                    done.setRejected();
                    return;
                }
                if (AbstractTreeUi.this.myResettingToReadyNow.get()) {
                    AbstractTreeUi.this._getReady().notify(done);
                } else if (AbstractTreeUi.this.isReady()) {
                    AbstractTreeUi.this.resetToReadyNow();
                    done.setDone();
                } else if (AbstractTreeUi.this.isIdle() && AbstractTreeUi.this.hasPendingWork()) {
                    AbstractTreeUi.this.resetToReadyNow();
                    done.setDone();
                } else {
                    AbstractTreeUi.this._getReady().notify(done);
                }
                AbstractTreeUi.this.maybeReady();
            }
        });
        if (AbstractTreeUi.isEdt() || this.isPassthroughMode()) {
            this.maybeReady();
        }
        ActionCallback actionCallback = done;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(102);
        }
        return actionCallback;
    }

    private void setCancelRequested(boolean requested) {
        try (LockToken ignored = AbstractTreeUi.isUnitTestingMode() ? this.acquireLock() : this.attemptLock();){
            this.myCancelRequest.set(requested);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Nullable
    private LockToken attemptLock() throws InterruptedException {
        return LockToken.attemptLock((Lock)this.myStateLock, (long)Registry.intValue("ide.tree.uiLockAttempt"));
    }

    @NotNull
    private LockToken acquireLock() {
        LockToken lockToken = LockToken.acquireLock((Lock)this.myStateLock);
        if (lockToken == null) {
            AbstractTreeUi.$$$reportNull$$$0(103);
        }
        return lockToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ActionCallback batch(@NotNull Progressive progressive) {
        if (progressive == null) {
            AbstractTreeUi.$$$reportNull$$$0(104);
        }
        this.assertIsDispatchThread();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        final ActionCallback callback2 = new ActionCallback();
        this.myBatchIndicators.put(progressive, indicator);
        this.myBatchCallbacks.put(progressive, callback2);
        try {
            progressive.run(indicator);
        }
        catch (ProcessCanceledException e) {
            ActionCallback actionCallback;
            block12: {
                ActionCallback actionCallback2;
                try {
                    this.resetToReadyNow().doWhenProcessed(new TreeRunnable("AbstractTreeUi.batch: catch"){

                        @Override
                        public void perform() {
                            callback2.setRejected();
                        }
                    });
                    actionCallback = callback2;
                    if (!this.isReleased()) break block12;
                    actionCallback2 = ActionCallback.REJECTED;
                }
                catch (Throwable throwable) {
                    if (this.isReleased()) {
                        ActionCallback actionCallback3 = ActionCallback.REJECTED;
                        if (actionCallback3 == null) {
                            AbstractTreeUi.$$$reportNull$$$0(108);
                        }
                        return actionCallback3;
                    }
                    this._getReady().doWhenDone(new TreeRunnable("AbstractTreeUi.batch: finally", progressive, callback2){
                        final /* synthetic */ Progressive val$progressive;
                        final /* synthetic */ ActionCallback val$callback;
                        {
                            this.val$progressive = progressive;
                            this.val$callback = actionCallback;
                            super(name);
                        }

                        @Override
                        public void perform() {
                            if (AbstractTreeUi.this.myBatchIndicators.containsKey(this.val$progressive)) {
                                ProgressIndicator indicator = (ProgressIndicator)AbstractTreeUi.this.myBatchIndicators.remove(this.val$progressive);
                                AbstractTreeUi.this.myBatchCallbacks.remove(this.val$progressive);
                                if (indicator.isCanceled()) {
                                    this.val$callback.setRejected();
                                } else {
                                    this.val$callback.setDone();
                                }
                            } else {
                                this.val$callback.setRejected();
                            }
                        }
                    });
                    this.maybeReady();
                    throw throwable;
                }
                if (actionCallback2 == null) {
                    AbstractTreeUi.$$$reportNull$$$0(106);
                }
                return actionCallback2;
            }
            this._getReady().doWhenDone(new /* invalid duplicate definition of identical inner class */);
            this.maybeReady();
            ActionCallback actionCallback4 = actionCallback;
            if (actionCallback4 == null) {
                AbstractTreeUi.$$$reportNull$$$0(107);
            }
            return actionCallback4;
        }
        if (this.isReleased()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractTreeUi.$$$reportNull$$$0(105);
            }
            return actionCallback;
        }
        this._getReady().doWhenDone(new /* invalid duplicate definition of identical inner class */);
        this.maybeReady();
        ActionCallback actionCallback = callback2;
        if (actionCallback == null) {
            AbstractTreeUi.$$$reportNull$$$0(109);
        }
        return actionCallback;
    }

    boolean isCancelProcessed() {
        return this.myCancelRequest.get() || this.myResettingToReadyNow.get();
    }

    boolean isToPaintSelection() {
        return this.isReady(true) || !this.mySelectionIsAdjusted;
    }

    boolean isReleaseRequested() {
        return this.myReleaseRequested;
    }

    public void executeUserRunnable(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(110);
        }
        try {
            this.myUserRunnables.add(runnable2);
            runnable2.run();
        }
        finally {
            this.myUserRunnables.remove(runnable2);
        }
    }

    private boolean isUpdatingParent(DefaultMutableTreeNode kid) {
        return this.getUpdatingParent(kid) != null;
    }

    @Nullable
    private DefaultMutableTreeNode getUpdatingParent(DefaultMutableTreeNode kid) {
        for (DefaultMutableTreeNode eachParent = kid; eachParent != null; eachParent = (DefaultMutableTreeNode)eachParent.getParent()) {
            if (!this.isUpdatingChildrenNow(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    private boolean isLoadedInBackground(Object element2) {
        return this.getLoadedInBackground(element2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateInfo getLoadedInBackground(Object element2) {
        Map<Object, UpdateInfo> map2 = this.myLoadedInBackground;
        synchronized (map2) {
            return AbstractTreeUi.isNodeNull(element2) ? null : this.myLoadedInBackground.get(element2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoadedInBackground(Object element2, UpdateInfo info) {
        if (AbstractTreeUi.isNodeNull(element2)) {
            return;
        }
        Map<Object, UpdateInfo> map2 = this.myLoadedInBackground;
        synchronized (map2) {
            this.warnMap("put into myLoadedInBackground: ", this.myLoadedInBackground);
            this.myLoadedInBackground.put(element2, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLoadedInBackground(Object element2) {
        if (AbstractTreeUi.isNodeNull(element2)) {
            return;
        }
        Map<Object, UpdateInfo> map2 = this.myLoadedInBackground;
        synchronized (map2) {
            this.warnMap("remove from myLoadedInBackground: ", this.myLoadedInBackground);
            this.myLoadedInBackground.remove(element2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoadingInBackgroundNow() {
        Map<Object, UpdateInfo> map2 = this.myLoadedInBackground;
        synchronized (map2) {
            return !this.myLoadedInBackground.isEmpty();
        }
    }

    private void queueBackgroundUpdate(final @NotNull UpdateInfo updateInfo2, final @NotNull DefaultMutableTreeNode node) {
        if (updateInfo2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(111);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(112);
        }
        this.assertIsDispatchThread();
        final Object oldElementFromDescriptor = this.getElementFromDescriptor(updateInfo2.getDescriptor());
        if (AbstractTreeUi.isNodeNull(oldElementFromDescriptor)) {
            return;
        }
        UpdateInfo loaded = this.getLoadedInBackground(oldElementFromDescriptor);
        if (loaded != null) {
            loaded.apply(updateInfo2);
            return;
        }
        this.addToLoadedInBackground(oldElementFromDescriptor, updateInfo2);
        this.maybeSetBusyAndScheduleWaiterForReady(true, oldElementFromDescriptor);
        if (!this.isNodeBeingBuilt(node)) {
            LoadingNode loadingNode = new LoadingNode(AbstractTreeUi.getLoadingNodeText());
            this.myTreeModel.insertNodeInto(loadingNode, node, node.getChildCount());
        }
        this.removeFromUnbuilt(node);
        final Ref children2 = new Ref();
        final Ref elementFromDescriptor = new Ref();
        final DefaultMutableTreeNode[] nodeToProcessActions = new DefaultMutableTreeNode[1];
        final TreeRunnable.TreeConsumer<Void> finalizeRunnable = new TreeRunnable.TreeConsumer<Void>("AbstractTreeUi.queueBackgroundUpdate: finalize"){

            @Override
            public void perform() {
                AbstractTreeUi.this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: finalize later"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isReleased()) {
                            return;
                        }
                        AbstractTreeUi.this.removeLoading(node, false);
                        AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                        AbstractTreeUi.this.removeFromLoadedInBackground(oldElementFromDescriptor);
                        if (nodeToProcessActions[0] != null) {
                            AbstractTreeUi.this.processNodeActionsIfReady(nodeToProcessActions[0]);
                        }
                    }
                });
            }
        };
        TreeRunnable buildRunnable = new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: build"){

            @Override
            public void perform() {
                if (updateInfo2.getPass().isExpired()) {
                    finalizeRunnable.run();
                    return;
                }
                if (!updateInfo2.isDescriptorIsUpToDate()) {
                    AbstractTreeUi.this.update(updateInfo2.getDescriptor(), true);
                }
                if (!updateInfo2.isUpdateChildren()) {
                    nodeToProcessActions[0] = node;
                    return;
                }
                Object element2 = AbstractTreeUi.this.getElementFromDescriptor(updateInfo2.getDescriptor());
                if (element2 == null) {
                    AbstractTreeUi.this.removeFromLoadedInBackground(oldElementFromDescriptor);
                    finalizeRunnable.run();
                    return;
                }
                elementFromDescriptor.set(element2);
                Object[] loadedElements = AbstractTreeUi.this.getChildrenFor(element2);
                final LoadedChildren loaded = new LoadedChildren(loadedElements);
                for (final Object each : loadedElements) {
                    NodeDescriptor existingDesc = AbstractTreeUi.getDescriptorFrom(AbstractTreeUi.this.getNodeForElement(each, true));
                    final NodeDescriptor eachChildDescriptor = AbstractTreeUi.this.isValid(existingDesc, updateInfo2.getDescriptor()) ? existingDesc : AbstractTreeUi.this.getTreeStructure().createDescriptor(each, updateInfo2.getDescriptor());
                    AbstractTreeUi.this.execute(new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate"){

                        @Override
                        public void perform() {
                            try {
                                loaded.putDescriptor(each, eachChildDescriptor, (Boolean)AbstractTreeUi.this.update(eachChildDescriptor, true).blockingGet(0));
                            }
                            catch (ExecutionException | TimeoutException e) {
                                LOG.error(e);
                            }
                        }
                    });
                }
                children2.set(loaded);
            }

            @Override
            @NotNull
            @NonNls
            public String toString() {
                String string = "runnable=" + oldElementFromDescriptor;
                if (string == null) {
                    40.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeUi$40", "toString"));
            }
        };
        TreeRunnable updateRunnable = new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: update"){

            @Override
            public void perform() {
                Pair unbuilt;
                if (updateInfo2.getPass().isExpired()) {
                    finalizeRunnable.run();
                    return;
                }
                if (children2.get() == null) {
                    finalizeRunnable.run();
                    return;
                }
                if (AbstractTreeUi.this.isRerunNeeded(updateInfo2.getPass())) {
                    AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                    AbstractTreeUi.this.getUpdater().requeue(updateInfo2.getPass());
                    return;
                }
                AbstractTreeUi.this.removeFromLoadedInBackground(elementFromDescriptor.get());
                if (AbstractTreeUi.this.myUnbuiltNodes.contains(node) && ((Boolean)(unbuilt = AbstractTreeUi.this.processUnbuilt(node, updateInfo2.getDescriptor(), updateInfo2.getPass(), AbstractTreeUi.this.isExpanded(node, updateInfo2.isWasExpanded()), (LoadedChildren)children2.get())).getFirst()).booleanValue()) {
                    nodeToProcessActions[0] = node;
                    return;
                }
                ActionCallback callback2 = AbstractTreeUi.this.updateNodeChildren(node, updateInfo2.getPass(), (LoadedChildren)children2.get(), true, updateInfo2.isCanSmartExpand(), updateInfo2.isForceUpdate(), true, true);
                callback2.doWhenDone(new TreeRunnable("AbstractTreeUi.queueBackgroundUpdate: on done updateNodeChildren"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isRerunNeeded(updateInfo2.getPass())) {
                            AbstractTreeUi.this.getUpdater().requeue(updateInfo2.getPass());
                            return;
                        }
                        Object element2 = elementFromDescriptor.get();
                        if (element2 != null) {
                            AbstractTreeUi.this.removeLoading(node, false);
                            nodeToProcessActions[0] = node;
                        }
                    }
                });
            }
        };
        this.queueToBackground(buildRunnable, updateRunnable).onSuccess((Consumer<Void>)finalizeRunnable).onError((Consumer<Throwable>)new TreeRunnable.TreeConsumer<Throwable>("AbstractTreeUi.queueBackgroundUpdate: on rejected"){

            @Override
            public void perform() {
                updateInfo2.getPass().expire();
            }
        });
    }

    private boolean isExpanded(@NotNull DefaultMutableTreeNode node, boolean isExpanded) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(113);
        }
        return isExpanded || this.myTree.isExpanded(AbstractTreeUi.getPathFor(node));
    }

    private void removeLoading(@NotNull DefaultMutableTreeNode parent, boolean forced) {
        if (parent == null) {
            AbstractTreeUi.$$$reportNull$$$0(114);
        }
        if (!forced && this.myUnbuiltNodes.contains(parent) && !this.myCancelledBuild.containsKey(parent)) {
            return;
        }
        boolean reallyRemoved = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeNode child2 = parent.getChildAt(i);
            if (!this.removeIfLoading(child2)) continue;
            reallyRemoved = true;
            --i;
        }
        this.maybeReady();
        if (reallyRemoved) {
            this.nodeStructureChanged(parent);
        }
    }

    private void processNodeActionsIfReady(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(115);
        }
        this.assertIsDispatchThread();
        if (this.isNodeBeingBuilt(node)) {
            return;
        }
        NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor2 == null) {
            return;
        }
        if (this.isYeildingNow()) {
            this.myPendingNodeActions.add(node);
            return;
        }
        Object element2 = this.getElementFromDescriptor(descriptor2);
        boolean childrenReady = !this.isLoadedInBackground(element2) && !this.isUpdatingChildrenNow(node);
        AbstractTreeUi.processActions(node, element2, this.myNodeActions, childrenReady ? this.myNodeChildrenActions : null);
        if (childrenReady) {
            AbstractTreeUi.processActions(node, element2, this.myNodeChildrenActions, null);
        }
        this.warnMap("myNodeActions: processNodeActionsIfReady: ", this.myNodeActions);
        this.warnMap("myNodeChildrenActions: processNodeActionsIfReady: ", this.myNodeChildrenActions);
        if (!this.isUpdatingParent(node) && !this.isWorkerBusy()) {
            UpdaterTreeState state = this.myUpdaterState;
            if (this.myNodeActions.isEmpty() && state != null && !state.isProcessingNow() && this.canInitiateNewActivity() && !state.restore(childrenReady ? node : null)) {
                this.setUpdaterState(state);
            }
        }
        this.maybeReady();
    }

    private static void processActions(@NotNull DefaultMutableTreeNode node, Object element2, @NotNull Map<Object, List<NodeAction>> nodeActions, @Nullable Map<Object, List<NodeAction>> secondaryNodeAction) {
        List<NodeAction> actions;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(116);
        }
        if (nodeActions == null) {
            AbstractTreeUi.$$$reportNull$$$0(117);
        }
        if ((actions = nodeActions.get(element2)) != null) {
            nodeActions.remove(element2);
            List<NodeAction> secondary = secondaryNodeAction != null ? secondaryNodeAction.get(element2) : null;
            for (NodeAction each : actions) {
                if (secondary != null) {
                    secondary.remove(each);
                }
                each.onReady(node);
            }
        }
    }

    private boolean canSmartExpand(DefaultMutableTreeNode node, boolean canSmartExpand) {
        if (!this.canInitiateNewActivity()) {
            return false;
        }
        if (!this.getBuilder().isSmartExpand()) {
            return false;
        }
        boolean smartExpand = canSmartExpand && !this.myNotForSmartExpand.contains(node);
        Object element2 = this.getElementFor(node);
        return smartExpand && element2 != null && this.validateAutoExpand(true, element2);
    }

    private void processSmartExpand(@NotNull DefaultMutableTreeNode node, boolean canSmartExpand, boolean forced) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(118);
        }
        if (!this.canInitiateNewActivity()) {
            return;
        }
        if (!this.getBuilder().isSmartExpand()) {
            return;
        }
        boolean can = this.canSmartExpand(node, canSmartExpand);
        if (!can && !forced) {
            return;
        }
        if (this.isNodeBeingBuilt(node) && !forced) {
            this.addNodeAction(this.getElementFor(node), true, node1 -> this.processSmartExpand(node1, canSmartExpand, true));
        } else {
            TreeNode child2 = AbstractTreeUi.getChildForSmartExpand(node);
            if (child2 != null) {
                final TreePath childPath = new TreePath(node.getPath()).pathByAddingChild(child2);
                this.processInnerChange(new TreeRunnable("AbstractTreeUi.processSmartExpand"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.myTree.expandPath(childPath);
                    }
                });
            }
        }
    }

    @Nullable
    private static TreeNode getChildForSmartExpand(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(119);
        }
        int realChildCount = 0;
        TreeNode nodeToExpand = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode eachChild = node.getChildAt(i);
            if (!AbstractTreeUi.isLoadingNode(eachChild)) {
                ++realChildCount;
                if (nodeToExpand == null) {
                    nodeToExpand = eachChild;
                }
            }
            if (realChildCount <= 1) continue;
            nodeToExpand = null;
            break;
        }
        return nodeToExpand;
    }

    public static boolean isLoadingChildrenFor(Object nodeObject) {
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        int loadingNodes = 0;
        for (int i = 0; i < Math.min(node.getChildCount(), 2); ++i) {
            TreeNode child2 = node.getChildAt(i);
            if (!AbstractTreeUi.isLoadingNode(child2)) continue;
            ++loadingNodes;
        }
        return loadingNodes > 0 && loadingNodes == node.getChildCount();
    }

    boolean isParentLoadingInBackground(@NotNull Object nodeObject) {
        if (nodeObject == null) {
            AbstractTreeUi.$$$reportNull$$$0(120);
        }
        return this.getParentLoadingInBackground(nodeObject) != null;
    }

    @Nullable
    private DefaultMutableTreeNode getParentLoadingInBackground(@NotNull Object nodeObject) {
        if (nodeObject == null) {
            AbstractTreeUi.$$$reportNull$$$0(121);
        }
        if (!(nodeObject instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        TreeNode eachParent = node.getParent();
        while (eachParent != null) {
            Object eachElement;
            if (!((eachParent = eachParent.getParent()) instanceof DefaultMutableTreeNode) || !this.isLoadedInBackground(eachElement = this.getElementFor(eachParent))) continue;
            return (DefaultMutableTreeNode)eachParent;
        }
        return null;
    }

    private static String getLoadingNodeText() {
        return IdeBundle.message("progress.searching", new Object[0]);
    }

    @NotNull
    private Promise<?> processExistingNode(final @NotNull DefaultMutableTreeNode childNode, NodeDescriptor childDescriptor, final @NotNull DefaultMutableTreeNode parentNode, final @NotNull MutualMap<Object, Integer> elementToIndexMap, final @NotNull TreeUpdatePass pass, final boolean canSmartExpand, final boolean forceUpdate, @Nullable LoadedChildren parentPreloadedChildren) {
        if (childNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(122);
        }
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(123);
        }
        if (elementToIndexMap == null) {
            AbstractTreeUi.$$$reportNull$$$0(124);
        }
        if (pass == null) {
            AbstractTreeUi.$$$reportNull$$$0(125);
        }
        if (pass.isExpired()) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(126);
            }
            return promise2;
        }
        if (childDescriptor == null) {
            pass.expire();
            Promise promise3 = Promises.rejectedPromise();
            if (promise3 == null) {
                AbstractTreeUi.$$$reportNull$$$0(127);
            }
            return promise3;
        }
        final Object oldElement = this.getElementFromDescriptor(childDescriptor);
        if (AbstractTreeUi.isNodeNull(oldElement)) {
            this.removeNodeFromParent(childNode, true);
            this.doUpdateNode(parentNode);
            Promise promise4 = Promises.resolvedPromise();
            if (promise4 == null) {
                AbstractTreeUi.$$$reportNull$$$0(128);
            }
            return promise4;
        }
        Promise update2 = parentPreloadedChildren != null && parentPreloadedChildren.getDescriptor(oldElement) == childDescriptor ? Promises.resolvedPromise((Object)parentPreloadedChildren.isUpdated(oldElement)) : this.update(childDescriptor, false);
        final AsyncPromise result2 = new AsyncPromise();
        final Ref<NodeDescriptor> childDesc = new Ref<NodeDescriptor>(childDescriptor);
        update2.onSuccess(isChanged -> {
            Promise promise2;
            Integer index;
            final AtomicBoolean changes = new AtomicBoolean((boolean)isChanged);
            final AtomicBoolean forceRemapping = new AtomicBoolean();
            final Ref<Object> newElement = new Ref<Object>(this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
            Integer n = index = newElement.get() == null ? null : (Integer)elementToIndexMap.getValue(this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
            if (index == null) {
                promise2 = Promises.resolvedPromise((Object)false);
            } else {
                Object elementFromMap = elementToIndexMap.getKey(index);
                if (elementFromMap != newElement.get() && elementFromMap.equals(newElement.get())) {
                    if (this.isInStructure(elementFromMap) && this.isInStructure(newElement.get())) {
                        AsyncPromise updateIndexDone = new AsyncPromise();
                        promise2 = updateIndexDone;
                        NodeDescriptor parentDescriptor = AbstractTreeUi.getDescriptorFrom(parentNode);
                        if (parentDescriptor != null) {
                            childDesc.set(this.getTreeStructure().createDescriptor(elementFromMap, parentDescriptor));
                            NodeDescriptor oldDesc = AbstractTreeUi.getDescriptorFrom(childNode);
                            if (this.isValid(oldDesc)) {
                                ((NodeDescriptor)childDesc.get()).applyFrom(oldDesc);
                            }
                            childNode.setUserObject(childDesc.get());
                            newElement.set(elementFromMap);
                            forceRemapping.set(true);
                            this.update((NodeDescriptor)childDesc.get(), false).onSuccess(isChanged1 -> {
                                changes.set((boolean)isChanged1);
                                updateIndexDone.setResult(isChanged1);
                            });
                        }
                    } else {
                        promise2 = Promises.resolvedPromise((Object)changes.get());
                    }
                } else {
                    promise2 = Promises.resolvedPromise((Object)changes.get());
                }
                promise2.onSuccess(new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.processExistingNode: on done index updating after update"){

                    @Override
                    public void perform() {
                        if (((NodeDescriptor)childDesc.get()).getIndex() != index.intValue()) {
                            changes.set(true);
                        }
                        ((NodeDescriptor)childDesc.get()).setIndex(index);
                    }
                });
            }
            promise2.onSuccess(new TreeRunnable.TreeConsumer<Boolean>("AbstractTreeUi.processExistingNode: on done index updating"){

                @Override
                public void perform() {
                    if (!oldElement.equals(newElement.get()) || forceRemapping.get()) {
                        NodeDescriptor parentDescriptor;
                        AbstractTreeUi.this.removeMapping(oldElement, childNode, newElement.get());
                        Object newE = newElement.get();
                        if (!AbstractTreeUi.isNodeNull(newE)) {
                            AbstractTreeUi.this.createMapping(newE, childNode);
                        }
                        if ((parentDescriptor = AbstractTreeUi.getDescriptorFrom(parentNode)) != null) {
                            parentDescriptor.setChildrenSortingStamp(-1L);
                        }
                    }
                    if (index == null) {
                        DefaultMutableTreeNode parent;
                        int selectedIndex = -1;
                        if (TreeBuilderUtil.isNodeOrChildSelected(AbstractTreeUi.this.myTree, childNode)) {
                            selectedIndex = parentNode.getIndex(childNode);
                        }
                        if (childNode.getParent() instanceof DefaultMutableTreeNode && AbstractTreeUi.this.myTree.isExpanded(new TreePath((parent = (DefaultMutableTreeNode)childNode.getParent()).getPath())) && parent.getChildCount() == 1 && parent.getChildAt(0) == childNode) {
                            AbstractTreeUi.this.insertLoadingNode(parent, false);
                        }
                        Object disposedElement = AbstractTreeUi.this.getElementFor(childNode);
                        AbstractTreeUi.this.removeNodeFromParent(childNode, selectedIndex >= 0);
                        AbstractTreeUi.this.disposeNode(childNode);
                        AbstractTreeUi.this.adjustSelectionOnChildRemove(parentNode, selectedIndex, disposedElement);
                        result2.setResult(null);
                    } else {
                        elementToIndexMap.remove(AbstractTreeUi.this.getElementFromDescriptor((NodeDescriptor)childDesc.get()));
                        AbstractTreeUi.this.updateNodeChildren(childNode, pass, null, false, canSmartExpand, forceUpdate, true, true).doWhenDone(() -> result2.setResult(null));
                    }
                }
            });
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            AbstractTreeUi.$$$reportNull$$$0(129);
        }
        return asyncPromise;
    }

    private void adjustSelectionOnChildRemove(@NotNull DefaultMutableTreeNode parentNode, int selectedIndex, Object disposedElement) {
        DefaultMutableTreeNode node;
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(130);
        }
        if (selectedIndex >= 0 && !this.getSelectedElements().isEmpty()) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node = disposedElement == null ? null : this.getNodeForElement(disposedElement, false);
        if (node != null && this.isValidForSelectionAdjusting(node)) {
            Object newElement = this.getElementFor(node);
            this.addSelectionPath(AbstractTreeUi.getPathFor(node), true, this.getExpiredElementCondition(newElement), disposedElement);
            return;
        }
        if (selectedIndex >= 0) {
            if (parentNode.getChildCount() > 0) {
                if (parentNode.getChildCount() > selectedIndex) {
                    TreeNode newChildNode = parentNode.getChildAt(selectedIndex);
                    if (this.isValidForSelectionAdjusting(newChildNode)) {
                        this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChildNode)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
                    }
                } else {
                    TreeNode newChild = parentNode.getChildAt(parentNode.getChildCount() - 1);
                    if (this.isValidForSelectionAdjusting(newChild)) {
                        this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(newChild)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
                    }
                }
            } else {
                this.addSelectionPath(new TreePath(this.myTreeModel.getPathToRoot(parentNode)), true, this.getExpiredElementCondition(disposedElement), disposedElement);
            }
        }
    }

    private boolean isValidForSelectionAdjusting(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(131);
        }
        if (!this.myTree.isRootVisible() && this.getRootNode() == node) {
            return false;
        }
        if (AbstractTreeUi.isLoadingNode(node)) {
            return true;
        }
        Object elementInTree = this.getElementFor(node);
        if (elementInTree == null) {
            return false;
        }
        TreeNode parentNode = node.getParent();
        Object parentElementInTree = this.getElementFor(parentNode);
        if (parentElementInTree == null) {
            return false;
        }
        Object parentElement = this.getTreeStructure().getParentElement(elementInTree);
        return parentElementInTree.equals(parentElement);
    }

    @NotNull
    private Condition getExpiredElementCondition(Object element2) {
        Condition<Object> condition2 = o -> this.isInStructure(element2);
        if (condition2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(132);
        }
        return condition2;
    }

    private void addSelectionPath(final @NotNull TreePath path2, final boolean isAdjustedSelection, final Condition isExpiredAdjustment, final @Nullable Object adjustmentCause) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(133);
        }
        this.processInnerChange(new TreeRunnable("AbstractTreeUi.addSelectionPath"){

            @Override
            public void perform() {
                TreePath toSelect2 = null;
                if (AbstractTreeUi.isLoadingNode(path2.getLastPathComponent())) {
                    TreePath parentPath = path2.getParentPath();
                    if (parentPath != null && AbstractTreeUi.this.isValidForSelectionAdjusting((TreeNode)parentPath.getLastPathComponent())) {
                        toSelect2 = parentPath;
                    }
                } else {
                    toSelect2 = path2;
                }
                if (toSelect2 != null) {
                    AbstractTreeUi.this.mySelectionIsAdjusted = isAdjustedSelection;
                    AbstractTreeUi.this.myTree.addSelectionPath(toSelect2);
                    if (isAdjustedSelection && AbstractTreeUi.this.myUpdaterState != null) {
                        Object toSelectElement = AbstractTreeUi.this.getElementFor(toSelect2.getLastPathComponent());
                        AbstractTreeUi.this.myUpdaterState.addAdjustedSelection(toSelectElement, isExpiredAdjustment, adjustmentCause);
                    }
                }
            }
        });
    }

    @NotNull
    private static TreePath getPathFor(@NotNull TreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(134);
        }
        if (node instanceof DefaultMutableTreeNode) {
            return new TreePath(((DefaultMutableTreeNode)node).getPath());
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (TreeNode eachParent = node; eachParent != null; eachParent = eachParent.getParent()) {
            nodes.add(eachParent);
        }
        return new TreePath(ArrayUtil.toObjectArray(nodes));
    }

    private void removeNodeFromParent(final @NotNull MutableTreeNode node, final boolean willAdjustSelection) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(135);
        }
        this.processInnerChange(new TreeRunnable("AbstractTreeUi.removeNodeFromParent"){

            @Override
            public void perform() {
                TreePath path2;
                if (willAdjustSelection && AbstractTreeUi.this.myTree.isPathSelected(path2 = AbstractTreeUi.getPathFor(node))) {
                    AbstractTreeUi.this.myTree.removeSelectionPath(path2);
                }
                if (node.getParent() != null) {
                    AbstractTreeUi.this.myTreeModel.removeNodeFromParent(node);
                }
            }
        });
    }

    private void expandPath(final @NotNull TreePath path2, final boolean canSmartExpand) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(136);
        }
        this.processInnerChange(new TreeRunnable("AbstractTreeUi.expandPath"){

            @Override
            public void perform() {
                if (path2.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
                    if (node.getChildCount() > 0 && !AbstractTreeUi.this.myTree.isExpanded(path2)) {
                        if (!canSmartExpand) {
                            AbstractTreeUi.this.myNotForSmartExpand.add(node);
                        }
                        try {
                            AbstractTreeUi.this.myRequestedExpand = path2;
                            AbstractTreeUi.this.myTree.expandPath(path2);
                            AbstractTreeUi.this.processSmartExpand(node, canSmartExpand, false);
                        }
                        finally {
                            AbstractTreeUi.this.myNotForSmartExpand.remove(node);
                            AbstractTreeUi.this.myRequestedExpand = null;
                        }
                    } else {
                        AbstractTreeUi.this.processNodeActionsIfReady(node);
                    }
                }
            }
        });
    }

    private void processInnerChange(Runnable runnable2) {
        if (this.myUpdaterState == null) {
            this.setUpdaterState(new UpdaterTreeState(this));
        }
        this.myUpdaterState.process(runnable2);
    }

    private boolean isInnerChange() {
        return this.myUpdaterState != null && this.myUpdaterState.isProcessingNow() && this.myUserRunnables.isEmpty();
    }

    private void makeLoadingOrLeafIfNoChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(137);
        }
        TreePath path2 = AbstractTreeUi.getPathFor(node);
        this.insertLoadingNode(node, true);
        NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor2 == null) {
            return;
        }
        descriptor2.setChildrenSortingStamp(-1L);
        if (this.getBuilder().isAlwaysShowPlus(descriptor2)) {
            return;
        }
        TreePath parentPath = path2.getParentPath();
        if (this.myTree.isVisible(path2) || parentPath != null && this.myTree.isExpanded(parentPath)) {
            if (this.myTree.isExpanded(path2)) {
                this.addSubtreeToUpdate(node);
            } else {
                this.insertLoadingNode(node, false);
            }
        }
    }

    private boolean isValid(NodeDescriptor descriptor2, NodeDescriptor parent) {
        if (descriptor2 == null) {
            return false;
        }
        if (parent != null && parent != descriptor2.getParentDescriptor()) {
            return false;
        }
        return this.isValid(this.getElementFromDescriptor(descriptor2));
    }

    private boolean isValid(@Nullable NodeDescriptor descriptor2) {
        return descriptor2 != null && this.isValid(this.getElementFromDescriptor(descriptor2));
    }

    private boolean isValid(Object element2) {
        if (AbstractTreeUi.isNodeNull(element2)) {
            return false;
        }
        if (element2 instanceof ValidateableNode && !((ValidateableNode)element2).isValid()) {
            return false;
        }
        return this.getBuilder().validateNode(element2);
    }

    private void insertLoadingNode(DefaultMutableTreeNode node, boolean addToUnbuilt) {
        if (!AbstractTreeUi.isLoadingChildrenFor(node)) {
            this.myTreeModel.insertNodeInto(new LoadingNode(), node, 0);
        }
        if (addToUnbuilt) {
            this.addToUnbuilt(node);
        }
    }

    @NotNull
    private Promise<Void> queueToBackground(final @NotNull Runnable bgBuildAction, final @Nullable Runnable edtPostRunnable) {
        if (bgBuildAction == null) {
            AbstractTreeUi.$$$reportNull$$$0(138);
        }
        if (!this.canInitiateNewActivity()) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AbstractTreeUi.$$$reportNull$$$0(139);
            }
            return promise2;
        }
        final AsyncPromise result2 = new AsyncPromise();
        final AtomicReference fail = new AtomicReference();
        final TreeRunnable finalizer = new TreeRunnable("AbstractTreeUi.queueToBackground: finalizer"){

            @Override
            public void perform() {
                ProcessCanceledException exception = (ProcessCanceledException)fail.get();
                if (exception == null) {
                    result2.setResult(null);
                } else {
                    result2.setError((Throwable)exception);
                }
            }
        };
        this.registerWorkerTask(bgBuildAction);
        final TreeRunnable pooledThreadWithProgressRunnable = new TreeRunnable("AbstractTreeUi.queueToBackground: progress"){

            @Override
            public void perform() {
                try {
                    final AbstractTreeBuilder builder2 = AbstractTreeUi.this.getBuilder();
                    if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                        throw new ProcessCanceledException();
                    }
                    builder2.runBackgroundLoading(new TreeRunnable("AbstractTreeUi.queueToBackground: background"){

                        @Override
                        public void perform() {
                            AbstractTreeUi.this.assertNotDispatchThread();
                            try {
                                if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                    throw new ProcessCanceledException();
                                }
                                AbstractTreeUi.this.execute(bgBuildAction);
                                if (edtPostRunnable != null) {
                                    builder2.updateAfterLoadedInBackground(new TreeRunnable("AbstractTreeUi.queueToBackground: update after"){

                                        @Override
                                        public void perform() {
                                            try {
                                                AbstractTreeUi.this.assertIsDispatchThread();
                                                if (!AbstractTreeUi.this.canInitiateNewActivity()) {
                                                    throw new ProcessCanceledException();
                                                }
                                                AbstractTreeUi.this.execute(edtPostRunnable);
                                            }
                                            catch (ProcessCanceledException e) {
                                                fail.set(e);
                                                AbstractTreeUi.this.cancelUpdate();
                                            }
                                            finally {
                                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                            }
                                        }
                                    });
                                } else {
                                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                }
                            }
                            catch (ProcessCanceledException e) {
                                fail.set(e);
                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                AbstractTreeUi.this.cancelUpdate();
                            }
                            catch (Throwable t) {
                                AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                                throw new RuntimeException(t);
                            }
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                    AbstractTreeUi.this.cancelUpdate();
                }
            }
        };
        TreeRunnable pooledThreadRunnable = new TreeRunnable("AbstractTreeUi.queueToBackground"){

            @Override
            public void perform() {
                try {
                    if (AbstractTreeUi.this.myProgress != null) {
                        ProgressManager.getInstance().runProcess(pooledThreadWithProgressRunnable, AbstractTreeUi.this.myProgress);
                    } else {
                        AbstractTreeUi.this.execute(pooledThreadWithProgressRunnable);
                    }
                }
                catch (ProcessCanceledException e) {
                    fail.set(e);
                    AbstractTreeUi.this.unregisterWorkerTask(bgBuildAction, finalizer);
                    AbstractTreeUi.this.cancelUpdate();
                }
            }
        };
        if (this.isPassthroughMode()) {
            this.execute(pooledThreadRunnable);
        } else {
            this.myWorker.addFirst((Object)pooledThreadRunnable);
        }
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            AbstractTreeUi.$$$reportNull$$$0(140);
        }
        return asyncPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkerTask(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(141);
        }
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            this.myActiveWorkerTasks.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWorkerTask(@NotNull Runnable runnable2, @Nullable Runnable finalizeRunnable) {
        boolean wasRemoved;
        if (runnable2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(142);
        }
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            wasRemoved = this.myActiveWorkerTasks.remove(runnable2);
        }
        if (wasRemoved && finalizeRunnable != null) {
            finalizeRunnable.run();
        }
        this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.unregisterWorkerTask"){

            @Override
            public void perform() {
                AbstractTreeUi.this.maybeReady();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorkerBusy() {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            return !this.myActiveWorkerTasks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWorkerTasks() {
        Set<Runnable> set = this.myActiveWorkerTasks;
        synchronized (set) {
            this.myActiveWorkerTasks.clear();
        }
    }

    private void updateNodeImageAndPosition(@NotNull DefaultMutableTreeNode node) {
        NodeDescriptor descriptor2;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(143);
        }
        if ((descriptor2 = AbstractTreeUi.getDescriptorFrom(node)) == null) {
            return;
        }
        if (this.getElementFromDescriptor(descriptor2) == null) {
            return;
        }
        this.nodeChanged(node);
    }

    private void nodeChanged(final DefaultMutableTreeNode node) {
        this.invokeLaterIfNeeded(true, new TreeRunnable("AbstractTreeUi.nodeChanged"){

            @Override
            public void perform() {
                AbstractTreeUi.this.myTreeModel.nodeChanged(node);
            }
        });
    }

    private void nodeStructureChanged(final DefaultMutableTreeNode node) {
        this.invokeLaterIfNeeded(true, new TreeRunnable("AbstractTreeUi.nodeStructureChanged"){

            @Override
            public void perform() {
                AbstractTreeUi.this.myTreeModel.nodeStructureChanged(node);
            }
        });
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    private void insertNodesInto(@NotNull List<? extends TreeNode> toInsert, final @NotNull DefaultMutableTreeNode parentNode) {
        if (toInsert == null) {
            AbstractTreeUi.$$$reportNull$$$0(144);
        }
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(145);
        }
        this.sortChildren(parentNode, toInsert, false, true);
        final ArrayList<? extends TreeNode> all = new ArrayList<TreeNode>(toInsert.size() + parentNode.getChildCount());
        all.addAll(toInsert);
        all.addAll(TreeUtil.listChildren(parentNode));
        if (!toInsert.isEmpty()) {
            this.sortChildren(parentNode, all, true, true);
            int[] newNodeIndices = new int[toInsert.size()];
            int eachNewNodeIndex = 0;
            TreeMap<Integer, TreeNode> insertSet = new TreeMap<Integer, TreeNode>();
            for (int i = 0; i < toInsert.size(); ++i) {
                TreeNode eachNewNode = toInsert.get(i);
                while (all.get(eachNewNodeIndex) != eachNewNode) {
                    ++eachNewNodeIndex;
                }
                newNodeIndices[i] = eachNewNodeIndex;
                insertSet.put(eachNewNodeIndex, eachNewNode);
            }
            for (Map.Entry entry : insertSet.entrySet()) {
                TreeNode eachNode = (TreeNode)entry.getValue();
                Integer index = (Integer)entry.getKey();
                parentNode.insert((MutableTreeNode)eachNode, index);
            }
            this.myTreeModel.nodesWereInserted(parentNode, newNodeIndices);
        } else {
            ArrayList before = new ArrayList(all);
            this.sortChildren(parentNode, all, true, false);
            if (!before.equals(all)) {
                this.processInnerChange(new TreeRunnable("AbstractTreeUi.insertNodesInto"){

                    @Override
                    public void perform() {
                        Enumeration<TreePath> expanded = AbstractTreeUi.this.getTree().getExpandedDescendants(AbstractTreeUi.getPathFor(parentNode));
                        TreePath[] selected2 = AbstractTreeUi.this.getTree().getSelectionModel().getSelectionPaths();
                        parentNode.removeAllChildren();
                        for (TreeNode each : all) {
                            parentNode.add((MutableTreeNode)each);
                        }
                        AbstractTreeUi.this.nodeStructureChanged(parentNode);
                        if (expanded != null) {
                            while (expanded.hasMoreElements()) {
                                AbstractTreeUi.this.expandSilently(expanded.nextElement());
                            }
                        }
                        if (selected2 != null) {
                            for (TreePath each : selected2) {
                                if (AbstractTreeUi.this.getTree().getSelectionModel().isPathSelected(each)) continue;
                                AbstractTreeUi.this.addSelectionSilently(each);
                            }
                        }
                    }
                });
            }
        }
    }

    private void sortChildren(@NotNull DefaultMutableTreeNode node, @NotNull List<? extends TreeNode> children2, boolean updateStamp, boolean forceSort) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(146);
        }
        if (children2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(147);
        }
        NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        assert (descriptor2 != null);
        if (descriptor2.getChildrenSortingStamp() >= this.getComparatorStamp() && !forceSort) {
            return;
        }
        if (!children2.isEmpty()) {
            try {
                this.getBuilder().sortChildren(this.myNodeComparator, node, children2);
            }
            catch (IllegalArgumentException exception) {
                StringBuilder sb = new StringBuilder("cannot sort children in ").append(this.toString());
                children2.forEach(child2 -> sb.append('\n').append(child2));
                throw new IllegalArgumentException(sb.toString(), exception);
            }
        }
        if (updateStamp) {
            descriptor2.setChildrenSortingStamp(this.getComparatorStamp());
        }
    }

    private void disposeNode(@NotNull DefaultMutableTreeNode node) {
        TreeNode parent;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(148);
        }
        if ((parent = node.getParent()) instanceof DefaultMutableTreeNode) {
            this.addToUnbuilt((DefaultMutableTreeNode)parent);
        }
        if (node.getChildCount() > 0) {
            for (DefaultMutableTreeNode _node = (DefaultMutableTreeNode)node.getFirstChild(); _node != null; _node = _node.getNextSibling()) {
                this.disposeNode(_node);
            }
        }
        this.removeFromUpdatingChildren(node);
        this.removeFromUnbuilt(node);
        this.removeFromCancelled(node);
        if (AbstractTreeUi.isLoadingNode(node)) {
            return;
        }
        NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        if (descriptor2 == null) {
            return;
        }
        Object element2 = this.getElementFromDescriptor(descriptor2);
        if (!AbstractTreeUi.isNodeNull(element2)) {
            this.removeMapping(element2, node, null);
        }
        this.myAutoExpandRoots.remove(element2);
        node.setUserObject(null);
        node.removeAllChildren();
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(149);
        }
        return this.addSubtreeToUpdate(root, true);
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root, boolean updateStructure) {
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(150);
        }
        return this.addSubtreeToUpdate(root, null, updateStructure);
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root, Runnable runAfterUpdate) {
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(151);
        }
        return this.addSubtreeToUpdate(root, runAfterUpdate, true);
    }

    public boolean addSubtreeToUpdate(@NotNull DefaultMutableTreeNode root, @Nullable Runnable runAfterUpdate, boolean updateStructure) {
        TreeUpdatePass updatePass;
        Object element2;
        boolean alwaysLeaf;
        if (root == null) {
            AbstractTreeUi.$$$reportNull$$$0(152);
        }
        boolean bl = alwaysLeaf = (element2 = this.getElementFor(root)) != null && this.getTreeStructure().isAlwaysLeaf(element2);
        if (alwaysLeaf) {
            this.removeFromUnbuilt(root);
            this.removeLoading(root, true);
            updatePass = new TreeUpdatePass(root).setUpdateChildren(false);
        } else {
            updatePass = new TreeUpdatePass(root).setUpdateStructure(updateStructure).setUpdateStamp(-1L);
        }
        AbstractTreeUpdater updater2 = this.getUpdater();
        updater2.runAfterUpdate(runAfterUpdate);
        updater2.addSubtreeToUpdate(updatePass);
        return !alwaysLeaf;
    }

    boolean wasRootNodeInitialized() {
        return this.myRootNodeWasQueuedToInitialize && this.myRootNodeInitialized;
    }

    public void select(Object @NotNull [] elements2, @Nullable Runnable onDone) {
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(153);
        }
        this.select(elements2, onDone, false);
    }

    public void select(Object @NotNull [] elements2, @Nullable Runnable onDone, boolean addToSelection) {
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(154);
        }
        this.select(elements2, onDone, addToSelection, false);
    }

    public void select(Object @NotNull [] elements2, @Nullable Runnable onDone, boolean addToSelection, boolean deferred) {
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(155);
        }
        this._select(elements2, onDone, addToSelection, true, false, true, deferred, false, false);
    }

    void _select(Object @NotNull [] elements2, Runnable onDone, boolean addToSelection, boolean checkIfInStructure) {
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(156);
        }
        this._select(elements2, onDone, addToSelection, true, checkIfInStructure, true, false, false, false);
    }

    void _select(Object @NotNull [] elements2, @NotNull Runnable onDone) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(157);
        }
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(158);
        }
        this._select(elements2, onDone, false, true, true, false, false, false, false);
    }

    public void userSelect(Object @NotNull [] elements2, Runnable onDone, boolean addToSelection, boolean scroll) {
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(159);
        }
        this._select(elements2, onDone, addToSelection, true, false, scroll, false, true, true);
    }

    void _select(final Object @NotNull [] elements2, final Runnable onDone, final boolean addToSelection, final boolean checkCurrentSelection, final boolean checkIfInStructure, final boolean scrollToVisible, final boolean deferred, final boolean canSmartExpand, boolean mayQueue) {
        boolean willAffectSelection;
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(160);
        }
        this.assertIsDispatchThread();
        AbstractTreeUpdater updater2 = this.getUpdater();
        if (mayQueue && updater2 != null) {
            updater2.queueSelection(new SelectionRequest(elements2, onDone, addToSelection, checkCurrentSelection, checkIfInStructure, scrollToVisible, deferred, canSmartExpand));
            return;
        }
        boolean bl = willAffectSelection = elements2.length > 0 || addToSelection;
        if (!willAffectSelection) {
            this.runDone(onDone);
            this.maybeReady();
            return;
        }
        boolean oldCanProcessDeferredSelection = this.myCanProcessDeferredSelections;
        if (!deferred && this.wasRootNodeInitialized()) {
            this._getReady().doWhenDone(new TreeRunnable("AbstractTreeUi._select: on done getReady"){

                @Override
                public void perform() {
                    AbstractTreeUi.this.myCanProcessDeferredSelections = false;
                }
            });
        }
        if (!this.checkDeferred(deferred, onDone)) {
            return;
        }
        if (!deferred && oldCanProcessDeferredSelection && !this.myCanProcessDeferredSelections && !addToSelection) {
            this.getTree().clearSelection();
        }
        this.runDone(new TreeRunnable("AbstractTreeUi._select"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                        return;
                    }
                    final Set<Object> currentElements = AbstractTreeUi.this.getSelectedElements();
                    if (checkCurrentSelection && !currentElements.isEmpty() && elements2.length == currentElements.size()) {
                        boolean runSelection = false;
                        for (Object eachToSelect : elements2) {
                            if (currentElements.contains(eachToSelect)) continue;
                            runSelection = true;
                            break;
                        }
                        if (!runSelection) {
                            AbstractTreeUi.this.selectVisible(elements2[0], onDone, false, false, scrollToVisible);
                            return;
                        }
                    }
                    AbstractTreeUi.this.clearSelection();
                    THashSet<Object> toSelect2 = new THashSet<Object>();
                    ContainerUtil.addAllNotNull(toSelect2, elements2);
                    if (addToSelection) {
                        ContainerUtil.addAllNotNull(toSelect2, currentElements);
                    }
                    if (checkIfInStructure) {
                        toSelect2.removeIf(each -> !AbstractTreeUi.this.isInStructure(each));
                    }
                    Object[] elementsToSelect = ArrayUtil.toObjectArray(toSelect2);
                    if (AbstractTreeUi.this.wasRootNodeInitialized()) {
                        int[] originalRows = AbstractTreeUi.this.myTree.getSelectionRows();
                        if (!addToSelection) {
                            AbstractTreeUi.this.clearSelection();
                        }
                        AbstractTreeUi.this.addNext(elementsToSelect, 0, new TreeRunnable("AbstractTreeUi._select: addNext"){

                            @Override
                            public void perform() {
                                if (AbstractTreeUi.this.getTree().isSelectionEmpty()) {
                                    AbstractTreeUi.this.processInnerChange(new TreeRunnable("AbstractTreeUi._select: addNext: processInnerChange"){

                                        @Override
                                        public void perform() {
                                            AbstractTreeUi.this.restoreSelection(currentElements);
                                        }
                                    });
                                }
                                AbstractTreeUi.this.runDone(onDone);
                            }
                        }, originalRows, deferred, scrollToVisible, canSmartExpand);
                    } else {
                        AbstractTreeUi.this.addToDeferred(elementsToSelect, onDone, addToSelection);
                    }
                }
                finally {
                    AbstractTreeUi.this.maybeReady();
                }
            }
        });
    }

    private void clearSelection() {
        this.mySelectionIsBeingAdjusted = true;
        try {
            this.myTree.clearSelection();
        }
        finally {
            this.mySelectionIsBeingAdjusted = false;
        }
    }

    boolean isSelectionBeingAdjusted() {
        return this.mySelectionIsBeingAdjusted;
    }

    private void restoreSelection(@NotNull Set<Object> selection) {
        if (selection == null) {
            AbstractTreeUi.$$$reportNull$$$0(161);
        }
        for (Object each : selection) {
            DefaultMutableTreeNode node = this.getNodeForElement(each, false);
            if (node == null || !this.isValidForSelectionAdjusting(node)) continue;
            this.addSelectionPath(AbstractTreeUi.getPathFor(node), false, null, null);
        }
    }

    private void addToDeferred(final Object @NotNull [] elementsToSelect, final Runnable onDone, final boolean addToSelection) {
        if (elementsToSelect == null) {
            AbstractTreeUi.$$$reportNull$$$0(162);
        }
        if (!addToSelection) {
            this.myDeferredSelections.clear();
        }
        this.myDeferredSelections.add(new TreeRunnable("AbstractTreeUi.addToDeferred"){

            @Override
            public void perform() {
                AbstractTreeUi.this.select(elementsToSelect, onDone, addToSelection, true);
            }
        });
    }

    private boolean checkDeferred(boolean isDeferred, @Nullable Runnable onDone) {
        if (!isDeferred || this.myCanProcessDeferredSelections || !this.wasRootNodeInitialized()) {
            return true;
        }
        this.runDone(onDone);
        return false;
    }

    @NotNull
    final Set<Object> getSelectedElements() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        if (paths != null) {
            for (TreePath eachPath : paths) {
                Object eachElement;
                DefaultMutableTreeNode eachNode;
                if (!(eachPath.getLastPathComponent() instanceof DefaultMutableTreeNode) || (eachNode = (DefaultMutableTreeNode)eachPath.getLastPathComponent()) == this.myRootNode && !this.myTree.isRootVisible() || (eachElement = this.getElementFor(eachNode)) == null) continue;
                result2.add(eachElement);
            }
        }
        LinkedHashSet<Object> linkedHashSet = result2;
        if (linkedHashSet == null) {
            AbstractTreeUi.$$$reportNull$$$0(163);
        }
        return linkedHashSet;
    }

    private void addNext(final Object @NotNull [] elements2, final int i, final @Nullable Runnable onDone, final int[] originalRows, final boolean deferred, final boolean scrollToVisible, final boolean canSmartExpand) {
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(164);
        }
        if (i >= elements2.length) {
            if (this.myTree.isSelectionEmpty()) {
                this.myTree.setSelectionRows(originalRows);
            }
            this.runDone(onDone);
        } else {
            if (!this.checkDeferred(deferred, onDone)) {
                return;
            }
            this.doSelect(elements2[i], new TreeRunnable("AbstractTreeUi.addNext"){

                @Override
                public void perform() {
                    if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                        return;
                    }
                    AbstractTreeUi.this.addNext(elements2, i + 1, onDone, originalRows, deferred, scrollToVisible, canSmartExpand);
                }
            }, deferred, i == 0, scrollToVisible, canSmartExpand);
        }
    }

    public void select(@Nullable Object element2, @Nullable Runnable onDone) {
        this.select(element2, onDone, false);
    }

    public void select(@Nullable Object element2, @Nullable Runnable onDone, boolean addToSelection) {
        if (element2 == null) {
            return;
        }
        this._select(new Object[]{element2}, onDone, addToSelection, false);
    }

    private void doSelect(final @NotNull Object element2, final Runnable onDone, final boolean deferred, final boolean canBeCentered, final boolean scrollToVisible, final boolean canSmartExpand) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(165);
        }
        TreeRunnable _onDone = new TreeRunnable("AbstractTreeUi.doSelect"){

            @Override
            public void perform() {
                if (!AbstractTreeUi.this.checkDeferred(deferred, onDone)) {
                    return;
                }
                AbstractTreeUi.this.checkPathAndMaybeRevalidate(element2, new TreeRunnable("AbstractTreeUi.doSelect: checkPathAndMaybeRevalidate"){

                    @Override
                    public void perform() {
                        AbstractTreeUi.this.selectVisible(element2, onDone, true, canBeCentered, scrollToVisible);
                    }
                }, true, canSmartExpand);
            }
        };
        this._expand(element2, _onDone, true, false, canSmartExpand);
    }

    private void checkPathAndMaybeRevalidate(@NotNull Object element2, final @NotNull Runnable onDone, final boolean parentsOnly, final boolean canSmartExpand) {
        boolean toRevalidate;
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(166);
        }
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(167);
        }
        boolean bl = toRevalidate = this.isValid(element2) && !this.myRevalidatedObjects.contains(element2) && this.getNodeForElement(element2, false) == null && this.isInStructure(element2);
        if (!toRevalidate) {
            this.runDone(onDone);
            return;
        }
        this.myRevalidatedObjects.add(element2);
        this.getBuilder().revalidateElement(element2).onSuccess(o -> this.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeUi.checkPathAndMaybeRevalidate: on done revalidateElement"){

            @Override
            public void perform() {
                AbstractTreeUi.this._expand(o, onDone, parentsOnly, false, canSmartExpand);
            }
        })).onError(throwable -> this.wrapDone(onDone, "AbstractTreeUi.checkPathAndMaybeRevalidate: on rejected revalidateElement").run());
    }

    public void scrollSelectionToVisible(final @Nullable Runnable onDone, final boolean shouldBeCentered) {
        SwingUtilities.invokeLater(new TreeRunnable("AbstractTreeUi.scrollSelectionToVisible"){

            @Override
            public void perform() {
                int eachRow;
                TreePath path2;
                if (AbstractTreeUi.this.isReleased()) {
                    return;
                }
                int[] rows = AbstractTreeUi.this.myTree.getSelectionRows();
                if (rows == null || rows.length == 0) {
                    AbstractTreeUi.this.runDone(onDone);
                    return;
                }
                Object toSelect2 = null;
                int[] nArray = rows;
                int n = nArray.length;
                for (int i = 0; i < n && (toSelect2 = AbstractTreeUi.this.getElementFor((path2 = AbstractTreeUi.this.myTree.getPathForRow(eachRow = nArray[i])).getLastPathComponent())) == null; ++i) {
                }
                if (toSelect2 != null) {
                    AbstractTreeUi.this.selectVisible(toSelect2, onDone, true, shouldBeCentered, true);
                }
            }
        });
    }

    private void selectVisible(@NotNull Object element2, Runnable onDone, boolean addToSelection, boolean canBeCentered, boolean scroll) {
        DefaultMutableTreeNode toSelect2;
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(168);
        }
        if ((toSelect2 = this.getNodeToScroll(element2)) == null) {
            this.runDone(onDone);
            return;
        }
        if (this.myUpdaterState != null) {
            this.myUpdaterState.addSelection(element2);
        }
        this.setHoldSize(false);
        this.runDone(this.wrapScrollTo(onDone, element2, toSelect2, addToSelection, canBeCentered, scroll));
    }

    void userScrollTo(Object element2, Runnable onDone) {
        DefaultMutableTreeNode node = this.getNodeToScroll(element2);
        this.runDone(node == null ? onDone : this.wrapScrollTo(onDone, element2, node, false, true, true));
    }

    private DefaultMutableTreeNode getNodeToScroll(Object element2) {
        if (element2 == null) {
            return null;
        }
        DefaultMutableTreeNode node = this.getNodeForElement(element2, false);
        if (node == null) {
            return null;
        }
        return this.myTree.isRootVisible() || node != this.getRootNode() ? node : null;
    }

    @NotNull
    private Runnable wrapDone(final Runnable onDone, @NotNull String name) {
        if (name == null) {
            AbstractTreeUi.$$$reportNull$$$0(169);
        }
        return new TreeRunnable(name){

            @Override
            public void perform() {
                AbstractTreeUi.this.runDone(onDone);
            }
        };
    }

    @NotNull
    private Runnable wrapScrollTo(final Runnable onDone, final @NotNull Object element2, final @NotNull DefaultMutableTreeNode node, final boolean addToSelection, final boolean canBeCentered, final boolean scroll) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(170);
        }
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(171);
        }
        return new TreeRunnable("AbstractTreeUi.wrapScrollTo"){

            @Override
            public void perform() {
                int row = AbstractTreeUi.this.getRowIfUnderSelection(element2);
                if (row == -1) {
                    row = AbstractTreeUi.this.myTree.getRowForPath(new TreePath(node.getPath()));
                }
                int top = row - 2;
                int bottom = row + 2;
                if (canBeCentered && Registry.is("ide.tree.autoscrollToVCenter")) {
                    int count = TreeUtil.getVisibleRowCount(AbstractTreeUi.this.myTree) - 1;
                    top = count > 0 ? row - count / 2 : row;
                    bottom = count > 0 ? top + count : row;
                }
                TreeUtil.showAndSelect(AbstractTreeUi.this.myTree, top, bottom, row, -1, addToSelection, scroll).doWhenDone(AbstractTreeUi.this.wrapDone(onDone, "AbstractTreeUi.wrapScrollTo.onDone"));
            }
        };
    }

    private int getRowIfUnderSelection(@NotNull Object element2) {
        TreePath[] paths;
        Set<Object> selection;
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(172);
        }
        if ((selection = this.getSelectedElements()).contains(element2)) {
            TreePath[] paths2;
            for (TreePath each : paths2 = this.getTree().getSelectionPaths()) {
                if (!element2.equals(this.getElementFor(each.getLastPathComponent()))) continue;
                return this.getTree().getRowForPath(each);
            }
            return -1;
        }
        Object anchor2 = TreeAnchorizer.getService().createAnchor(element2);
        Object o = AbstractTreeUi.isNodeNull(anchor2) ? null : this.myElementToNodeMap.get(anchor2);
        TreeAnchorizer.getService().freeAnchor(anchor2);
        if (o instanceof List && (paths = this.getTree().getSelectionPaths()) != null && paths.length > 0) {
            HashSet<DefaultMutableTreeNode> selectedNodes = new HashSet<DefaultMutableTreeNode>();
            for (TreePath eachPAth : paths) {
                if (!(eachPAth.getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
                selectedNodes.add((DefaultMutableTreeNode)eachPAth.getLastPathComponent());
            }
            Iterator iterator2 = ((List)o).iterator();
            while (iterator2.hasNext()) {
                for (DefaultMutableTreeNode eachNode = (DefaultMutableTreeNode)iterator2.next(); eachNode != null; eachNode = (DefaultMutableTreeNode)eachNode.getParent()) {
                    if (!selectedNodes.contains(eachNode)) continue;
                    return this.getTree().getRowForPath(AbstractTreeUi.getPathFor(eachNode));
                }
            }
        }
        return -1;
    }

    public void expandAll(final @Nullable Runnable onDone) {
        final JTree tree = this.getTree();
        if (tree.getRowCount() > 0) {
            final int expandRecursionDepth = Math.max(2, Registry.intValue("ide.tree.expandRecursionDepth"));
            new TreeRunnable("AbstractTreeUi.expandAll"){
                private int myCurrentRow;
                private int myInvocationCount;

                @Override
                public void perform() {
                    int row;
                    if (++this.myInvocationCount > expandRecursionDepth) {
                        this.myInvocationCount = 0;
                        if (AbstractTreeUi.this.isPassthroughMode()) {
                            this.run();
                        } else {
                            SwingUtilities.invokeLater(this);
                        }
                    } else if ((row = this.myCurrentRow++) < tree.getRowCount()) {
                        TreePath path2 = tree.getPathForRow(row);
                        Object last = path2.getLastPathComponent();
                        Object elem = AbstractTreeUi.this.getElementFor(last);
                        AbstractTreeUi.this.expand(elem, (Runnable)this);
                    } else {
                        AbstractTreeUi.this.runDone(onDone);
                    }
                }
            }.run();
        } else {
            this.runDone(onDone);
        }
    }

    public void expand(Object element2, @Nullable Runnable onDone) {
        this.expand(new Object[]{element2}, onDone);
    }

    public void expand(Object @NotNull [] element2, @Nullable Runnable onDone) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(173);
        }
        this.expand(element2, onDone, false);
    }

    void expand(Object @NotNull [] element2, @Nullable Runnable onDone, boolean checkIfInStructure) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(174);
        }
        this._expand(element2, onDone == null ? new EmptyRunnable() : onDone, checkIfInStructure);
    }

    private void _expand(final Object @NotNull [] elements2, final @NotNull Runnable onDone, final boolean checkIfInStructure) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(175);
        }
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(176);
        }
        try {
            this.runDone(new TreeRunnable("AbstractTreeUi._expand"){

                @Override
                public void perform() {
                    if (elements2.length == 0) {
                        AbstractTreeUi.this.runDone(onDone);
                        return;
                    }
                    if (AbstractTreeUi.this.myUpdaterState != null) {
                        AbstractTreeUi.this.myUpdaterState.clearExpansion();
                    }
                    ActionCallback done = new ActionCallback(elements2.length);
                    done.doWhenDone(AbstractTreeUi.this.wrapDone(onDone, "AbstractTreeUi._expand: on done expandNext")).doWhenRejected(AbstractTreeUi.this.wrapDone(onDone, "AbstractTreeUi._expand: on rejected expandNext"));
                    AbstractTreeUi.this.expandNext(elements2, 0, false, checkIfInStructure, false, done, 0);
                }
            });
        }
        catch (ProcessCanceledException e) {
            try {
                this.runDone(onDone);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private void expandNext(final Object @NotNull [] elements2, final int index, final boolean parentsOnly, final boolean checkIfInStricture, final boolean canSmartExpand, final @NotNull ActionCallback done, int currentDepth) {
        if (done == null) {
            AbstractTreeUi.$$$reportNull$$$0(177);
        }
        if (elements2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(178);
        }
        if (elements2.length <= 0) {
            done.setDone();
            return;
        }
        if (index >= elements2.length) {
            return;
        }
        final int[] actualDepth = new int[]{currentDepth};
        boolean breakCallChain = false;
        if (actualDepth[0] > Registry.intValue("ide.tree.expandRecursionDepth")) {
            actualDepth[0] = 0;
            breakCallChain = true;
        }
        TreeRunnable expandRunnable = new TreeRunnable("AbstractTreeUi.expandNext"){

            @Override
            public void perform() {
                AbstractTreeUi.this._expand(elements2[index], new TreeRunnable("AbstractTreeUi.expandNext: on done"){

                    @Override
                    public void perform() {
                        done.setDone();
                        AbstractTreeUi.this.expandNext(elements2, index + 1, parentsOnly, checkIfInStricture, canSmartExpand, done, actualDepth[0] + 1);
                    }
                }, parentsOnly, checkIfInStricture, canSmartExpand);
            }
        };
        if (breakCallChain && !this.isPassthroughMode()) {
            SwingUtilities.invokeLater(expandRunnable);
        } else {
            expandRunnable.run();
        }
    }

    public void collapseChildren(final @NotNull Object element2, final @Nullable Runnable onDone) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(179);
        }
        this.runDone(new TreeRunnable("AbstractTreeUi.collapseChildren"){

            @Override
            public void perform() {
                DefaultMutableTreeNode node = AbstractTreeUi.this.getNodeForElement(element2, false);
                if (node != null) {
                    AbstractTreeUi.this.getTree().collapsePath(new TreePath(node.getPath()));
                    AbstractTreeUi.this.runDone(onDone);
                }
            }
        });
    }

    private void runDone(@Nullable Runnable done) {
        if (done == null) {
            return;
        }
        if (!this.canInitiateNewActivity() && done instanceof AbstractTreeBuilder.UserRunnable) {
            return;
        }
        if (this.isYeildingNow()) {
            this.myYieldingDoneRunnables.add(done);
        } else {
            try {
                this.execute(done);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private void _expand(Object element2, @NotNull Runnable onDone, boolean parentsOnly, boolean checkIfInStructure, boolean canSmartExpand) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(180);
        }
        if (checkIfInStructure && !this.isInStructure(element2)) {
            this.runDone(onDone);
            return;
        }
        if (this.wasRootNodeInitialized()) {
            ArrayList<Object> kidsToExpand = new ArrayList<Object>();
            Object eachElement = element2;
            DefaultMutableTreeNode firstVisible = null;
            while (eachElement != null && this.isValid(eachElement)) {
                int preselected = this.getRowIfUnderSelection(eachElement);
                firstVisible = preselected >= 0 ? (DefaultMutableTreeNode)this.getTree().getPathForRow(preselected).getLastPathComponent() : this.getNodeForElement(eachElement, true);
                if (eachElement != element2 || !parentsOnly) {
                    kidsToExpand.add(eachElement);
                }
                if (firstVisible != null || (eachElement = this.getTreeStructure().getParentElement(eachElement)) == null) break;
                int i = kidsToExpand.indexOf(eachElement);
                if (i == -1) continue;
                try {
                    Object existing = kidsToExpand.get(i);
                    LOG.error("Tree path contains equal elements at different levels:\n element: '" + eachElement + "'; " + eachElement.getClass() + " (" + System.identityHashCode(eachElement) + ");\nexisting: '" + existing + "'; " + existing.getClass() + " (" + System.identityHashCode(existing) + "); path='" + kidsToExpand + "'; tree structure=" + this.myTreeStructure);
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
                this.runDone(onDone);
                throw new ProcessCanceledException();
            }
            if (firstVisible == null) {
                this.runDone(onDone);
            } else if (kidsToExpand.isEmpty()) {
                TreePath parentPath;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)firstVisible.getParent();
                if (parentNode != null && !this.myTree.isExpanded(parentPath = new TreePath(parentNode.getPath()))) {
                    this.expand(parentPath, canSmartExpand);
                }
                this.runDone(onDone);
            } else {
                this.processExpand(firstVisible, kidsToExpand, kidsToExpand.size() - 1, onDone, canSmartExpand);
            }
        } else {
            this.deferExpansion(element2, onDone, parentsOnly, canSmartExpand);
        }
    }

    private void deferExpansion(final Object element2, final @NotNull Runnable onDone, final boolean parentsOnly, final boolean canSmartExpand) {
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(181);
        }
        this.myDeferredExpansions.add(new TreeRunnable("AbstractTreeUi.deferExpansion"){

            @Override
            public void perform() {
                AbstractTreeUi.this._expand(element2, onDone, parentsOnly, false, canSmartExpand);
            }
        });
    }

    private void processExpand(DefaultMutableTreeNode toExpand, final @NotNull List<Object> kidsToExpand, final int expandIndex, final @NotNull Runnable onDone, final boolean canSmartExpand) {
        Object element2;
        if (kidsToExpand == null) {
            AbstractTreeUi.$$$reportNull$$$0(182);
        }
        if (onDone == null) {
            AbstractTreeUi.$$$reportNull$$$0(183);
        }
        if ((element2 = this.getElementFor(toExpand)) == null) {
            this.runDone(onDone);
            return;
        }
        this.addNodeAction(element2, true, node -> {
            if (node.getChildCount() > 0 && !this.myTree.isExpanded(new TreePath(node.getPath())) && !this.isAutoExpand(node)) {
                this.expand(node, canSmartExpand);
            }
            if (expandIndex <= 0) {
                this.runDone(onDone);
                return;
            }
            this.checkPathAndMaybeRevalidate(kidsToExpand.get(expandIndex - 1), new TreeRunnable("AbstractTreeUi.processExpand"){

                @Override
                public void perform() {
                    DefaultMutableTreeNode nextNode = AbstractTreeUi.this.getNodeForElement(kidsToExpand.get(expandIndex - 1), false);
                    AbstractTreeUi.this.processExpand(nextNode, kidsToExpand, expandIndex - 1, onDone, canSmartExpand);
                }
            }, false, canSmartExpand);
        });
        boolean childrenToUpdate = this.areChildrenToBeUpdated(toExpand);
        boolean expanded = this.myTree.isExpanded(AbstractTreeUi.getPathFor(toExpand));
        boolean unbuilt = this.myUnbuiltNodes.contains(toExpand);
        if (expanded) {
            if (unbuilt || childrenToUpdate) {
                this.addSubtreeToUpdate(toExpand);
            }
        } else {
            this.expand(toExpand, canSmartExpand);
        }
        if (!unbuilt && !childrenToUpdate) {
            this.processNodeActionsIfReady(toExpand);
        }
    }

    private boolean areChildrenToBeUpdated(DefaultMutableTreeNode node) {
        return this.getUpdater().isEnqueuedToUpdate(node) || this.isUpdatingParent(node) || this.myCancelledBuild.containsKey(node);
    }

    @Nullable
    public Object getElementFor(Object node) {
        NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
        return descriptor2 == null ? null : this.getElementFromDescriptor(descriptor2);
    }

    final boolean isNodeBeingBuilt(@NotNull TreePath path2) {
        if (path2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(184);
        }
        return this.isNodeBeingBuilt(path2.getLastPathComponent());
    }

    private boolean isNodeBeingBuilt(@NotNull Object node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(185);
        }
        return this.getParentBuiltNode(node) != null || this.myRootNode == node && !this.wasRootNodeInitialized();
    }

    @Nullable
    private DefaultMutableTreeNode getParentBuiltNode(@NotNull Object node) {
        boolean childrenAreNoLoadedYet;
        DefaultMutableTreeNode parent;
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(186);
        }
        if ((parent = this.getParentLoadingInBackground(node)) != null) {
            return parent;
        }
        if (this.isLoadingParentInBackground(node)) {
            return (DefaultMutableTreeNode)node;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        boolean bl = childrenAreNoLoadedYet = this.myUnbuiltNodes.contains(treeNode) || this.isUpdatingChildrenNow(treeNode);
        if (childrenAreNoLoadedYet) {
            TreePath nodePath = new TreePath(treeNode.getPath());
            if (!this.myTree.isExpanded(nodePath)) {
                return null;
            }
            return (DefaultMutableTreeNode)node;
        }
        return null;
    }

    private boolean isLoadingParentInBackground(Object node) {
        return node instanceof DefaultMutableTreeNode && this.isLoadedInBackground(this.getElementFor(node));
    }

    public void setTreeStructure(@NotNull AbstractTreeStructure treeStructure) {
        if (treeStructure == null) {
            AbstractTreeUi.$$$reportNull$$$0(187);
        }
        this.myTreeStructure = treeStructure;
        this.clearUpdaterState();
    }

    public AbstractTreeUpdater getUpdater() {
        return this.myUpdater;
    }

    public void setUpdater(@Nullable AbstractTreeUpdater updater2) {
        this.myUpdater = updater2;
        if (updater2 != null && this.myUpdateIfInactive) {
            updater2.showNotify();
        }
        if (this.myUpdater != null) {
            this.myUpdater.setPassThroughMode(this.myPassThroughMode);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.myRootNode;
    }

    public void setRootNode(@NotNull DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(188);
        }
        this.myRootNode = rootNode;
    }

    private void dropUpdaterStateIfExternalChange() {
        if (!this.isInnerChange()) {
            this.clearUpdaterState();
            this.myAutoExpandRoots.clear();
            this.mySelectionIsAdjusted = false;
        }
    }

    void clearUpdaterState() {
        this.myUpdaterState = null;
    }

    private void createMapping(@NotNull Object element2, DefaultMutableTreeNode node) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(189);
        }
        element2 = TreeAnchorizer.getService().createAnchor(element2);
        this.warnMap("myElementToNodeMap: createMapping: ", this.myElementToNodeMap);
        if (!this.myElementToNodeMap.containsKey(element2)) {
            this.myElementToNodeMap.put(element2, node);
        } else {
            ArrayList<DefaultMutableTreeNode> nodes;
            Object value2 = this.myElementToNodeMap.get(element2);
            if (value2 instanceof DefaultMutableTreeNode) {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                nodes.add((DefaultMutableTreeNode)value2);
                this.myElementToNodeMap.put(element2, nodes);
            } else {
                nodes = (ArrayList<DefaultMutableTreeNode>)value2;
            }
            nodes.add(node);
        }
    }

    private void removeMapping(@NotNull Object element2, DefaultMutableTreeNode node, @Nullable Object elementToPutNodeActionsFor) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(190);
        }
        element2 = TreeAnchorizer.getService().createAnchor(element2);
        this.warnMap("myElementToNodeMap: removeMapping: ", this.myElementToNodeMap);
        Object value2 = this.myElementToNodeMap.get(element2);
        if (value2 != null) {
            if (value2 instanceof DefaultMutableTreeNode) {
                if (value2.equals(node)) {
                    this.myElementToNodeMap.remove(element2);
                }
            } else {
                List nodes = (List)value2;
                boolean reallyRemoved = nodes.remove(node);
                if (reallyRemoved && nodes.isEmpty()) {
                    this.myElementToNodeMap.remove(element2);
                }
            }
        }
        this.remapNodeActions(element2, elementToPutNodeActionsFor);
        TreeAnchorizer.getService().freeAnchor(element2);
    }

    private void remapNodeActions(Object element2, Object elementToPutNodeActionsFor) {
        AbstractTreeUi._remapNodeActions(element2, elementToPutNodeActionsFor, this.myNodeActions);
        AbstractTreeUi._remapNodeActions(element2, elementToPutNodeActionsFor, this.myNodeChildrenActions);
        this.warnMap("myNodeActions: remapNodeActions: ", this.myNodeActions);
        this.warnMap("myNodeChildrenActions: remapNodeActions: ", this.myNodeChildrenActions);
    }

    private static void _remapNodeActions(Object element2, @Nullable Object elementToPutNodeActionsFor, @NotNull Map<Object, List<NodeAction>> nodeActions) {
        if (nodeActions == null) {
            AbstractTreeUi.$$$reportNull$$$0(191);
        }
        List<NodeAction> actions = nodeActions.get(element2);
        nodeActions.remove(element2);
        if (elementToPutNodeActionsFor != null && actions != null) {
            nodeActions.put(elementToPutNodeActionsFor, actions);
        }
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNode(@NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(192);
        }
        return this.findNode(element2, 0);
    }

    @Nullable
    private DefaultMutableTreeNode findNode(@NotNull Object element2, int startIndex) {
        Object value2;
        if (element2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(193);
        }
        if ((value2 = this.getBuilder().findNodeByElement(element2)) == null) {
            return null;
        }
        if (value2 instanceof DefaultMutableTreeNode) {
            return startIndex == 0 ? (DefaultMutableTreeNode)value2 : null;
        }
        List nodes = (List)value2;
        return startIndex < nodes.size() ? (DefaultMutableTreeNode)nodes.get(startIndex) : null;
    }

    Object findNodeByElement(Object element2) {
        element2 = TreeAnchorizer.getService().createAnchor(element2);
        try {
            if (AbstractTreeUi.isNodeNull(element2)) {
                Object var2_2 = null;
                return var2_2;
            }
            if (this.myElementToNodeMap.containsKey(element2)) {
                Object object = this.myElementToNodeMap.get(element2);
                return object;
            }
            this.TREE_NODE_WRAPPER.setValue(element2);
            Object object = this.myElementToNodeMap.get(this.TREE_NODE_WRAPPER);
            return object;
        }
        finally {
            this.TREE_NODE_WRAPPER.setValue(null);
            TreeAnchorizer.getService().freeAnchor(element2);
        }
    }

    @Nullable
    private DefaultMutableTreeNode findNodeForChildElement(@NotNull DefaultMutableTreeNode parentNode, Object element2) {
        Object anchor2;
        if (parentNode == null) {
            AbstractTreeUi.$$$reportNull$$$0(194);
        }
        Object value2 = AbstractTreeUi.isNodeNull(anchor2 = TreeAnchorizer.getService().createAnchor(element2)) ? null : this.myElementToNodeMap.get(anchor2);
        TreeAnchorizer.getService().freeAnchor(anchor2);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode elementNode = (DefaultMutableTreeNode)value2;
            return parentNode.equals(elementNode.getParent()) ? elementNode : null;
        }
        List allNodesForElement = (List)value2;
        for (DefaultMutableTreeNode elementNode : allNodesForElement) {
            if (!parentNode.equals(elementNode.getParent())) continue;
            return elementNode;
        }
        return null;
    }

    private void addNodeAction(Object element2, boolean shouldChildrenBeReady, @NotNull NodeAction action2) {
        if (action2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(195);
        }
        this._addNodeAction(element2, action2, this.myNodeActions);
        if (shouldChildrenBeReady) {
            this._addNodeAction(element2, action2, this.myNodeChildrenActions);
        }
        this.warnMap("myNodeActions: addNodeAction: ", this.myNodeActions);
        this.warnMap("myNodeChildrenActions: addNodeAction: ", this.myNodeChildrenActions);
    }

    public void addActivity() {
        if (this.myActivityMonitor != null) {
            this.myActivityMonitor.addActivity(this.myActivityId, this.getUpdater().getModalityState());
        }
    }

    private void removeActivity() {
        if (this.myActivityMonitor != null) {
            this.myActivityMonitor.removeActivity(this.myActivityId);
        }
    }

    private void _addNodeAction(Object element2, NodeAction action2, @NotNull Map<Object, List<NodeAction>> map2) {
        if (map2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(196);
        }
        this.maybeSetBusyAndScheduleWaiterForReady(true, element2);
        map2.computeIfAbsent(element2, k -> new ArrayList()).add(action2);
        this.addActivity();
    }

    private void cleanUpNow() {
        if (!this.canInitiateNewActivity()) {
            return;
        }
        UpdaterTreeState state = new UpdaterTreeState(this);
        this.myTree.collapsePath(new TreePath(this.myTree.getModel().getRoot()));
        this.clearSelection();
        this.getRootNode().removeAllChildren();
        this.TREE_NODE_WRAPPER = AbstractTreeBuilder.createSearchingTreeNodeWrapper();
        this.myRootNodeWasQueuedToInitialize = false;
        this.myRootNodeInitialized = false;
        this.clearNodeActions();
        this.myElementToNodeMap.clear();
        this.myDeferredSelections.clear();
        this.myDeferredExpansions.clear();
        this.myLoadedInBackground.clear();
        this.myUnbuiltNodes.clear();
        this.myUpdateFromRootRequested = true;
        this.myWorker.clear();
        this.myTree.invalidate();
        state.restore(null);
    }

    public void setClearOnHideDelay(long clearOnHideDelay) {
        this.myClearOnHideDelay = clearOnHideDelay;
    }

    private void removeChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            AbstractTreeUi.$$$reportNull$$$0(197);
        }
        Enumeration<TreeNode> children2 = node.children();
        for (DefaultMutableTreeNode defaultMutableTreeNode : Collections.list(children2)) {
            this.disposeNode(defaultMutableTreeNode);
        }
        node.removeAllChildren();
        this.nodeStructureChanged(node);
    }

    private void maybeUpdateSubtreeToUpdate(@NotNull DefaultMutableTreeNode subtreeRoot) {
        if (subtreeRoot == null) {
            AbstractTreeUi.$$$reportNull$$$0(198);
        }
        if (!this.myUnbuiltNodes.contains(subtreeRoot)) {
            return;
        }
        TreePath path2 = AbstractTreeUi.getPathFor(subtreeRoot);
        if (this.myTree.getRowForPath(path2) == -1) {
            return;
        }
        DefaultMutableTreeNode parent = this.getParentBuiltNode(subtreeRoot);
        if (parent == null) {
            if (!this.getBuilder().isAlwaysShowPlus(AbstractTreeUi.getDescriptorFrom(subtreeRoot))) {
                this.addSubtreeToUpdate(subtreeRoot);
            }
        } else if (parent != subtreeRoot) {
            this.addNodeAction(this.getElementFor(subtreeRoot), true, parent1 -> this.maybeUpdateSubtreeToUpdate(subtreeRoot));
        }
    }

    private boolean isSelectionInside(@NotNull DefaultMutableTreeNode parent) {
        if (parent == null) {
            AbstractTreeUi.$$$reportNull$$$0(199);
        }
        TreePath path2 = new TreePath(this.myTreeModel.getPathToRoot(parent));
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path1 : paths) {
            if (!path2.isDescendant(path1)) continue;
            return true;
        }
        return false;
    }

    boolean isInStructure(@Nullable Object element2) {
        if (AbstractTreeUi.isNodeNull(element2)) {
            return false;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            return false;
        }
        Object rootElement = structure.getRootElement();
        Object eachParent = element2;
        while (eachParent != null) {
            if (Comparing.equal(rootElement, eachParent)) {
                return true;
            }
            eachParent = structure.getParentElement(eachParent);
        }
        return false;
    }

    void setCanYield(boolean canYield) {
        this.myCanYield = canYield;
    }

    @NotNull
    Collection<TreeUpdatePass> getYeildingPasses() {
        List<TreeUpdatePass> list2 = this.myYieldingPasses;
        if (list2 == null) {
            AbstractTreeUi.$$$reportNull$$$0(200);
        }
        return list2;
    }

    private long getComparatorStamp() {
        if (this.myNodeDescriptorComparator instanceof NodeDescriptor.NodeComparator) {
            long currentComparatorStamp = ((NodeDescriptor.NodeComparator)this.myNodeDescriptorComparator).getStamp();
            if (currentComparatorStamp > this.myLastComparatorStamp) {
                this.myOwnComparatorStamp = Math.max(this.myOwnComparatorStamp, currentComparatorStamp) + 1L;
            }
            this.myLastComparatorStamp = currentComparatorStamp;
            return Math.max(currentComparatorStamp, this.myOwnComparatorStamp);
        }
        return this.myOwnComparatorStamp;
    }

    void incComparatorStamp() {
        this.myOwnComparatorStamp = this.getComparatorStamp() + 1L;
    }

    void setPassthroughMode(boolean passthrough) {
        this.myPassThroughMode = passthrough;
        AbstractTreeUpdater updater2 = this.getUpdater();
        if (updater2 != null) {
            updater2.setPassThroughMode(this.myPassThroughMode);
        }
        if (AbstractTreeUi.isUnitTestingMode() || passthrough) {
            // empty if block
        }
    }

    boolean isPassthroughMode() {
        return this.myPassThroughMode;
    }

    private static boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    private void addModelListenerToDiagnoseAccessOutsideEdt() {
        this.myTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractTreeUi.this.assertIsDispatchThread();
            }
        });
    }

    private <V> void warnMap(String prefix, Map<Object, V> map2) {
        long count;
        if (!LOG.isDebugEnabled()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread() && !this.myPassThroughMode) {
            LOG.warn(prefix + "modified on wrong thread");
        }
        if ((count = map2.keySet().stream().filter(AbstractTreeUi::isNodeNull).count()) > 0L) {
            LOG.warn(prefix + "null keys: " + count + " / " + map2.size());
        }
    }

    private static boolean isNodeNull(Object element2) {
        if (element2 instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element2;
            element2 = node.getValue();
        }
        return element2 == null;
    }

    public final boolean isConsistent() {
        return this.myTree != null && this.myTreeModel != null && this.myTreeModel == this.myTree.getModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 59: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 82: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 200: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 59: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 82: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 200: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 3: 
            case 70: 
            case 72: 
            case 79: 
            case 83: 
            case 110: 
            case 141: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 23: 
            case 32: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 60: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 93: 
            case 94: 
            case 95: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 131: 
            case 134: 
            case 135: 
            case 137: 
            case 143: 
            case 146: 
            case 148: 
            case 171: 
            case 185: 
            case 186: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 97: 
            case 165: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 173: 
            case 174: 
            case 179: 
            case 189: 
            case 190: 
            case 192: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: 
            case 52: 
            case 133: 
            case 136: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 59: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 82: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeUi";
                break;
            }
            case 17: 
            case 33: 
            case 34: 
            case 35: 
            case 42: 
            case 45: 
            case 49: 
            case 54: 
            case 58: 
            case 62: 
            case 63: 
            case 66: 
            case 80: 
            case 84: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeDescriptor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesToInsert";
                break;
            }
            case 61: 
            case 88: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToIndexMap";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processRunnable";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 85: 
            case 157: 
            case 167: 
            case 175: 
            case 180: 
            case 181: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedChildren";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressive";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateInfo";
                break;
            }
            case 114: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 117: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeActions";
                break;
            }
            case 120: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 123: 
            case 130: 
            case 145: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgBuildAction";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 158: 
            case 159: 
            case 160: 
            case 164: 
            case 176: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSelect";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kidsToExpand";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtreeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUi";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "queueUpdate";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpdaterState";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNodeChildren";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNodesToInsert";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "maybeYield";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "resetToReadyNow";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "loadElementsFromStructure";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNodesToInsert";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialized";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActions";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildrenFor";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedElements";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelUpdate";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireLock";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "batch";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "processExistingNode";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpiredElementCondition";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "queueToBackground";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "getYeildingPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExpandNodeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNodeInStructure";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNodeValidForElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValidChildOfParent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSameHierarchy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildNodeForElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildNodeForPath";
                break;
            }
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 59: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 82: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 200: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "initRootNodeNowIfNeeded";
                break;
            }
            case 18: 
            case 19: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateAutoExpand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInVisibleAutoExpandChain";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDistanceToAutoExpandRoot";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processDeferredActions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateSubtree";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateSubtreeNow";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateRow";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setUpdaterState";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNode";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeChildren";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateChildren";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processAlwaysLeaf";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isChildNodeForceUpdate";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeChildrenNow";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 51: 
            case 52: 
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processUnbuilt";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "removeIfLoading";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectionToParentIfNeeded";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "updateNodesToInsert";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processExistingNodes";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isRerunNeeded";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "calculateYieldingToWriteAction";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "maybeYield";
                break;
            }
            case 70: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addToCancelled";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "removeFromCancelled";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resetIncompleteNode";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "yieldAndRun";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "checkValue";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "executeYieldingRequest";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "runOnYieldingDone";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToInsert";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addToUpdatingChildren";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "removeFromUpdatingChildren";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isParentUpdatingChildrenNow";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedChildrenFor";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "batch";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "executeUserRunnable";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "queueBackgroundUpdate";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isExpanded";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "removeLoading";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "processNodeActionsIfReady";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "processActions";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "processSmartExpand";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getChildForSmartExpand";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isParentLoadingInBackground";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getParentLoadingInBackground";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "processExistingNode";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectionOnChildRemove";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "isValidForSelectionAdjusting";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionPath";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getPathFor";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "removeNodeFromParent";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "makeLoadingOrLeafIfNoChildren";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "queueToBackground";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "registerWorkerTask";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "unregisterWorkerTask";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeImageAndPosition";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "insertNodesInto";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "disposeNode";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "addSubtreeToUpdate";
                break;
            }
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 156: 
            case 157: 
            case 158: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "_select";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "userSelect";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "restoreSelection";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "addToDeferred";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "addNext";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "doSelect";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "checkPathAndMaybeRevalidate";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "selectVisible";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "wrapDone";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "wrapScrollTo";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getRowIfUnderSelection";
                break;
            }
            case 175: 
            case 176: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "_expand";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "expandNext";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "collapseChildren";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "deferExpansion";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "processExpand";
                break;
            }
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "isNodeBeingBuilt";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "getParentBuiltNode";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "setTreeStructure";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "setRootNode";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "removeMapping";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "_remapNodeActions";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNode";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "findNodeForChildElement";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "addNodeAction";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "_addNodeAction";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "removeChildren";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "maybeUpdateSubtreeToUpdate";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionInside";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 59: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 82: 
            case 86: 
            case 87: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 200: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdateInfo {
        NodeDescriptor myDescriptor;
        TreeUpdatePass myPass;
        boolean myCanSmartExpand;
        boolean myWasExpanded;
        boolean myForceUpdate;
        boolean myDescriptorIsUpToDate;
        boolean myUpdateChildren;

        UpdateInfo(NodeDescriptor descriptor2, TreeUpdatePass pass, boolean canSmartExpand, boolean wasExpanded, boolean forceUpdate, boolean descriptorIsUpToDate, boolean updateChildren) {
            this.myDescriptor = descriptor2;
            this.myPass = pass;
            this.myCanSmartExpand = canSmartExpand;
            this.myWasExpanded = wasExpanded;
            this.myForceUpdate = forceUpdate;
            this.myDescriptorIsUpToDate = descriptorIsUpToDate;
            this.myUpdateChildren = updateChildren;
        }

        synchronized NodeDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        synchronized TreeUpdatePass getPass() {
            return this.myPass;
        }

        synchronized boolean isCanSmartExpand() {
            return this.myCanSmartExpand;
        }

        synchronized boolean isWasExpanded() {
            return this.myWasExpanded;
        }

        synchronized boolean isForceUpdate() {
            return this.myForceUpdate;
        }

        synchronized boolean isDescriptorIsUpToDate() {
            return this.myDescriptorIsUpToDate;
        }

        public synchronized void apply(@NotNull UpdateInfo updateInfo2) {
            if (updateInfo2 == null) {
                UpdateInfo.$$$reportNull$$$0(0);
            }
            this.myDescriptor = updateInfo2.myDescriptor;
            this.myPass = updateInfo2.myPass;
            this.myCanSmartExpand = updateInfo2.myCanSmartExpand;
            this.myWasExpanded = updateInfo2.myWasExpanded;
            this.myForceUpdate = updateInfo2.myForceUpdate;
            this.myDescriptorIsUpToDate = updateInfo2.myDescriptorIsUpToDate;
        }

        public synchronized boolean isUpdateChildren() {
            return this.myUpdateChildren;
        }

        @NotNull
        @NonNls
        public synchronized String toString() {
            String string = "UpdateInfo: desc=" + this.myDescriptor + " pass=" + this.myPass + " canSmartExpand=" + this.myCanSmartExpand + " wasExpanded=" + this.myWasExpanded + " forceUpdate=" + this.myForceUpdate + " descriptorUpToDate=" + this.myDescriptorIsUpToDate;
            if (string == null) {
                UpdateInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeUi$UpdateInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUi$UpdateInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LoadedChildren {
        @NotNull
        private final List<Object> myElements;
        private final Map<Object, NodeDescriptor> myDescriptors = new HashMap<Object, NodeDescriptor>();
        private final Map<NodeDescriptor, Boolean> myChanges = new HashMap<NodeDescriptor, Boolean>();

        LoadedChildren(Object @Nullable [] elements2) {
            this.myElements = Arrays.asList(elements2 != null ? elements2 : ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        }

        void putDescriptor(Object element2, NodeDescriptor descriptor2, boolean isChanged) {
            if (AbstractTreeUi.isUnitTestingMode()) assert (this.myElements.contains(element2));
            this.myDescriptors.put(element2, descriptor2);
            this.myChanges.put(descriptor2, isChanged);
        }

        @NotNull
        List<Object> getElements() {
            List<Object> list2 = this.myElements;
            if (list2 == null) {
                LoadedChildren.$$$reportNull$$$0(0);
            }
            return list2;
        }

        NodeDescriptor getDescriptor(Object element2) {
            return this.myDescriptors.get(element2);
        }

        @NotNull
        public String toString() {
            String string = this.myElements + "->" + this.myChanges;
            if (string == null) {
                LoadedChildren.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isUpdated(Object element2) {
            NodeDescriptor desc = this.getDescriptor(element2);
            return this.myChanges.get(desc);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/util/treeView/AbstractTreeUi$LoadedChildren";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    @FunctionalInterface
    static interface NodeAction {
        public void onReady(@NotNull DefaultMutableTreeNode var1);
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        @Override
        public void treeExpanded(@NotNull TreeExpansionEvent event) {
            if (event == null) {
                MyExpansionListener.$$$reportNull$$$0(0);
            }
            final TreePath path2 = event.getPath();
            if (AbstractTreeUi.this.mySilentExpand != null && AbstractTreeUi.this.mySilentExpand.equals(path2)) {
                return;
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
            if (AbstractTreeUi.this.myRequestedExpand != null && !AbstractTreeUi.this.myRequestedExpand.equals(path2)) {
                AbstractTreeUi.this._getReady().doWhenDone(new TreeRunnable("AbstractTreeUi.MyExpansionListener.treeExpanded"){

                    @Override
                    public void perform() {
                        Object element2 = AbstractTreeUi.this.getElementFor(path2.getLastPathComponent());
                        AbstractTreeUi.this.expand(element2, null);
                    }
                });
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
            if (!AbstractTreeUi.this.myUnbuiltNodes.contains(node)) {
                AbstractTreeUi.this.removeLoading(node, false);
                HashSet<DefaultMutableTreeNode> childrenToUpdate = new HashSet<DefaultMutableTreeNode>();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode each = (DefaultMutableTreeNode)node.getChildAt(i);
                    if (!AbstractTreeUi.this.myUnbuiltNodes.contains(each)) continue;
                    AbstractTreeUi.this.makeLoadingOrLeafIfNoChildren(each);
                    childrenToUpdate.add(each);
                }
                if (!childrenToUpdate.isEmpty()) {
                    for (DefaultMutableTreeNode each : childrenToUpdate) {
                        AbstractTreeUi.this.maybeUpdateSubtreeToUpdate(each);
                    }
                }
            } else {
                AbstractTreeUi.this.getBuilder().expandNodeChildren(node);
            }
            AbstractTreeUi.this.processSmartExpand(node, AbstractTreeUi.this.canSmartExpand(node, true), false);
            AbstractTreeUi.this.processNodeActionsIfReady(node);
        }

        @Override
        public void treeCollapsed(@NotNull TreeExpansionEvent e) {
            if (e == null) {
                MyExpansionListener.$$$reportNull$$$0(1);
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
            TreePath path2 = e.getPath();
            final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
            NodeDescriptor descriptor2 = AbstractTreeUi.getDescriptorFrom(node);
            if (descriptor2 == null) {
                return;
            }
            TreePath pathToSelect = null;
            if (AbstractTreeUi.this.isSelectionInside(node)) {
                pathToSelect = new TreePath(node.getPath());
            }
            if (AbstractTreeUi.this.getBuilder().isDisposeOnCollapsing(descriptor2)) {
                AbstractTreeUi.this.runDone(new TreeRunnable("AbstractTreeUi.MyExpansionListener.treeCollapsed"){

                    @Override
                    public void perform() {
                        if (AbstractTreeUi.this.isDisposed(node)) {
                            return;
                        }
                        TreePath nodePath = new TreePath(node.getPath());
                        if (AbstractTreeUi.this.myTree.isExpanded(nodePath)) {
                            return;
                        }
                        AbstractTreeUi.this.removeChildren(node);
                        AbstractTreeUi.this.makeLoadingOrLeafIfNoChildren(node);
                    }
                });
                if (node.equals(AbstractTreeUi.this.getRootNode())) {
                    if (AbstractTreeUi.this.myTree.isRootVisible()) {
                        // empty if block
                    }
                } else {
                    AbstractTreeUi.this.myTreeModel.reload(node);
                }
            }
            if (pathToSelect != null && AbstractTreeUi.this.myTree.isSelectionEmpty()) {
                AbstractTreeUi.this.addSelectionPath(pathToSelect, true, Conditions.alwaysFalse(), null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUi$MyExpansionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "treeExpanded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "treeCollapsed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySelectionListener
    implements TreeSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                MySelectionListener.$$$reportNull$$$0(0);
            }
            if (AbstractTreeUi.this.mySilentSelect != null && AbstractTreeUi.this.mySilentSelect.equals(e.getNewLeadSelectionPath())) {
                return;
            }
            AbstractTreeUi.this.dropUpdaterStateIfExternalChange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/treeView/AbstractTreeUi$MySelectionListener", "valueChanged"));
        }
    }

    static class ElementNode
    extends DefaultMutableTreeNode {
        Set<Object> myElements = new HashSet<Object>();
        AbstractTreeUi myUi;

        ElementNode(AbstractTreeUi ui, NodeDescriptor descriptor2) {
            super(descriptor2);
            this.myUi = ui;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            Object element2 = this.myUi.getElementFor(newChild);
            if (element2 != null) {
                this.myElements.add(element2);
            }
        }

        @Override
        public void remove(int childIndex) {
            TreeNode node = this.getChildAt(childIndex);
            super.remove(childIndex);
            Object element2 = this.myUi.getElementFor(node);
            if (element2 != null) {
                this.myElements.remove(element2);
            }
        }

        boolean isValidChild(Object childElement) {
            return this.myElements.contains(childElement);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getUserObject());
        }
    }

    @FunctionalInterface
    private static interface AsyncRunnable {
        @NotNull
        public Promise<?> run();
    }
}

