/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRenderer
extends ColoredTreeCellRenderer {
    protected Icon fixIconIfNeeded(Icon icon2, boolean selected2, boolean hasFocus) {
        if (icon2 != null && !StartupUiUtil.isUnderDarcula() && Registry.is("ide.project.view.change.icon.on.selection") && selected2 && hasFocus) {
            return IconLoader.getDarkIcon(icon2, true);
        }
        return icon2;
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ItemPresentation p0;
        Object node;
        if (tree == null) {
            NodeRenderer.$$$reportNull$$$0(0);
        }
        if ((node = TreeUtil.getUserObject(value2)) instanceof NodeDescriptor) {
            NodeDescriptor descriptor2 = (NodeDescriptor)node;
            Color color = descriptor2.getColor();
            this.setIcon(this.fixIconIfNeeded(descriptor2.getIcon(), selected2, hasFocus));
        }
        if ((p0 = this.getPresentation(node)) instanceof PresentationData) {
            PresentationData presentation = (PresentationData)p0;
            Color color = node instanceof NodeDescriptor ? ((NodeDescriptor)node).getColor() : null;
            this.setIcon(this.fixIconIfNeeded(presentation.getIcon(false), selected2, hasFocus));
            List<PresentableNodeDescriptor.ColoredFragment> coloredText = presentation.getColoredText();
            Color forcedForeground = presentation.getForcedTextForeground();
            if (coloredText.isEmpty()) {
                String text2 = presentation.getPresentableText();
                if (StringUtil.isEmpty(text2)) {
                    text2 = value2.toString();
                }
                text2 = tree.convertValueToText(text2, selected2, expanded, leaf, row, hasFocus);
                SimpleTextAttributes simpleTextAttributes = this.getSimpleTextAttributes(presentation, forcedForeground != null ? forcedForeground : color, node);
                this.append(text2, simpleTextAttributes);
                String location2 = presentation.getLocationString();
                if (!StringUtil.isEmpty(location2)) {
                    SimpleTextAttributes attributes = SimpleTextAttributes.merge((SimpleTextAttributes)simpleTextAttributes, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append(presentation.getLocationPrefix() + location2 + presentation.getLocationSuffix(), attributes, false);
                }
            } else {
                boolean first = true;
                boolean isMain = true;
                for (PresentableNodeDescriptor.ColoredFragment each : coloredText) {
                    SimpleTextAttributes simpleTextAttributes = each.getAttributes();
                    if (each.getAttributes().getFgColor() == null && forcedForeground != null) {
                        simpleTextAttributes = NodeRenderer.addColorToSimpleTextAttributes(each.getAttributes(), forcedForeground);
                    }
                    if (first) {
                        TextAttributes forcedAttributes;
                        TextAttributesKey textAttributesKey = presentation.getTextAttributesKey();
                        if (textAttributesKey != null && (forcedAttributes = NodeRenderer.getScheme().getAttributes(textAttributesKey)) != null) {
                            simpleTextAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)simpleTextAttributes, (SimpleTextAttributes)SimpleTextAttributes.fromTextAttributes((TextAttributes)forcedAttributes));
                        }
                        first = false;
                    }
                    isMain = isMain && !Comparing.equal(simpleTextAttributes.getFgColor(), SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                    this.append(each.getText(), simpleTextAttributes, isMain);
                }
                String location2 = presentation.getLocationString();
                if (!StringUtil.isEmpty(location2)) {
                    this.append(presentation.getLocationPrefix() + (String)location2 + presentation.getLocationSuffix(), SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
                }
            }
            this.setToolTipText(presentation.getTooltip());
        } else if (value2 != null) {
            String text3 = value2.toString();
            if (node instanceof NodeDescriptor) {
                text3 = node.toString();
            }
            if ((text3 = tree.convertValueToText(text3, selected2, expanded, leaf, row, hasFocus)) == null) {
                text3 = "";
            }
            this.append(text3);
            this.setToolTipText(null);
        }
    }

    @Nullable
    protected ItemPresentation getPresentation(Object node) {
        return node instanceof PresentableNodeDescriptor ? ((PresentableNodeDescriptor)node).getPresentation() : (node instanceof NavigationItem ? ((NavigationItem)node).getPresentation() : null);
    }

    @NotNull
    private static EditorColorsScheme getScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        if (editorColorsScheme == null) {
            NodeRenderer.$$$reportNull$$$0(1);
        }
        return editorColorsScheme;
    }

    @NotNull
    protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation, Color color, @NotNull Object node) {
        if (presentation == null) {
            NodeRenderer.$$$reportNull$$$0(2);
        }
        if (node == null) {
            NodeRenderer.$$$reportNull$$$0(3);
        }
        SimpleTextAttributes simpleTextAttributes = NodeRenderer.getSimpleTextAttributes(presentation, NodeRenderer.getScheme());
        SimpleTextAttributes simpleTextAttributes2 = NodeRenderer.addColorToSimpleTextAttributes(simpleTextAttributes, color);
        if (simpleTextAttributes2 == null) {
            NodeRenderer.$$$reportNull$$$0(4);
        }
        return simpleTextAttributes2;
    }

    private static SimpleTextAttributes addColorToSimpleTextAttributes(SimpleTextAttributes simpleTextAttributes, Color color) {
        if (color != null) {
            TextAttributes textAttributes = simpleTextAttributes.toTextAttributes();
            textAttributes.setForegroundColor(color);
            simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        }
        return simpleTextAttributes;
    }

    public static SimpleTextAttributes getSimpleTextAttributes(@Nullable ItemPresentation presentation) {
        return NodeRenderer.getSimpleTextAttributes(presentation, NodeRenderer.getScheme());
    }

    private static SimpleTextAttributes getSimpleTextAttributes(@Nullable ItemPresentation presentation, @NotNull EditorColorsScheme colorsScheme) {
        if (colorsScheme == null) {
            NodeRenderer.$$$reportNull$$$0(5);
        }
        if (presentation instanceof ColoredItemPresentation) {
            TextAttributesKey textAttributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
            if (textAttributesKey == null) {
                return SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            TextAttributes textAttributes = colorsScheme.getAttributes(textAttributesKey);
            return textAttributes == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/NodeRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/NodeRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleTextAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

