/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TreeUpdatePass {
    private final DefaultMutableTreeNode myNode;
    private long myUpdateStamp;
    private boolean myExpired;
    private DefaultMutableTreeNode myCurrentNode;
    private final long myAllocation;
    private boolean myUpdateChildren;
    private boolean myUpdateStructure;
    private final Set<NodeDescriptor> myUpdatedDescriptors;

    public TreeUpdatePass(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            TreeUpdatePass.$$$reportNull$$$0(0);
        }
        this.myUpdateChildren = true;
        this.myUpdateStructure = true;
        this.myUpdatedDescriptors = new HashSet<NodeDescriptor>();
        this.myNode = node;
        this.myAllocation = System.currentTimeMillis();
    }

    public TreeUpdatePass setUpdateChildren(boolean updateChildren) {
        this.myUpdateChildren = updateChildren;
        return this;
    }

    public boolean isUpdateChildren() {
        return this.myUpdateChildren;
    }

    @NotNull
    public DefaultMutableTreeNode getNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.myNode;
        if (defaultMutableTreeNode == null) {
            TreeUpdatePass.$$$reportNull$$$0(1);
        }
        return defaultMutableTreeNode;
    }

    public TreeUpdatePass setUpdateStamp(long updateCount) {
        this.myUpdateStamp = updateCount;
        return this;
    }

    public long getUpdateStamp() {
        return this.myUpdateStamp;
    }

    public void expire() {
        this.myExpired = true;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.myCurrentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.myCurrentNode = currentNode;
    }

    @NonNls
    public String toString() {
        return "TreeUpdatePass node=" + this.myNode + " structure=" + this.myUpdateStructure + " stamp=" + this.myUpdateStamp + " expired=" + this.myExpired + " currentNode=" + this.myCurrentNode + " allocation=" + this.myAllocation;
    }

    public boolean willUpdate(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            TreeUpdatePass.$$$reportNull$$$0(2);
        }
        @NotNull DefaultMutableTreeNode currentNode = this.myCurrentNode != null ? this.myCurrentNode : this.myNode;
        return node.isNodeAncestor(currentNode);
    }

    public TreeUpdatePass setUpdateStructure(boolean update2) {
        this.myUpdateStructure = update2;
        return this;
    }

    public boolean isUpdateStructure() {
        return this.myUpdateStructure;
    }

    public void addToUpdated(NodeDescriptor nodeDescriptor) {
        this.myUpdatedDescriptors.add(nodeDescriptor);
    }

    public boolean isUpdated(NodeDescriptor descriptor2) {
        return this.myUpdatedDescriptors.contains(descriptor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/TreeUpdatePass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeUpdatePass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "willUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

