/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdaterTreeState {
    private final AbstractTreeUi myUi;
    private final Map<Object, Object> myToSelect = new WeakHashMap<Object, Object>();
    private Map<Object, Condition> myAdjustedSelection = new WeakHashMap<Object, Condition>();
    private final Map<Object, Object> myToExpand = new WeakHashMap<Object, Object>();
    private int myProcessingCount;
    private boolean myCanRunRestore = true;
    private final WeakHashMap<Object, Object> myAdjustmentCause2Adjustment = new WeakHashMap();

    UpdaterTreeState(AbstractTreeUi ui) {
        this(ui, false);
    }

    private UpdaterTreeState(AbstractTreeUi ui, boolean isEmpty) {
        this.myUi = ui;
        if (!isEmpty) {
            JTree tree = this.myUi.getTree();
            UpdaterTreeState.putAll(this.addPaths(tree.getSelectionPaths()), this.myToSelect);
            UpdaterTreeState.putAll(this.addPaths(tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()))), this.myToExpand);
        }
    }

    private static void putAll(Set<Object> source, Map<Object, Object> target2) {
        for (Object o : source) {
            target2.put(o, o);
        }
    }

    private Set<Object> addPaths(Object[] elements2) {
        HashSet set = new HashSet();
        if (elements2 != null) {
            ContainerUtil.addAll(set, elements2);
        }
        return this.addPaths(set);
    }

    private Set<Object> addPaths(Enumeration elements2) {
        ArrayList elementArray = new ArrayList();
        if (elements2 != null) {
            while (elements2.hasMoreElements()) {
                Object each = elements2.nextElement();
                elementArray.add(each);
            }
        }
        return this.addPaths(elementArray);
    }

    private Set<Object> addPaths(Collection elements2) {
        HashSet<Object> target2 = new HashSet<Object>();
        if (elements2 != null) {
            for (Object each : elements2) {
                Object element2;
                Object descriptor2;
                Object node = ((TreePath)each).getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode) || !((descriptor2 = ((DefaultMutableTreeNode)node).getUserObject()) instanceof NodeDescriptor) || (element2 = this.myUi.getElementFromDescriptor((NodeDescriptor)descriptor2)) == null) continue;
                target2.add(element2);
            }
        }
        return target2;
    }

    public Object @NotNull [] getToSelect() {
        Object[] objectArray = ArrayUtil.toObjectArray(this.myToSelect.keySet());
        if (objectArray == null) {
            UpdaterTreeState.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public Object @NotNull [] getToExpand() {
        Object[] objectArray = ArrayUtil.toObjectArray(this.myToExpand.keySet());
        if (objectArray == null) {
            UpdaterTreeState.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public boolean process(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            UpdaterTreeState.$$$reportNull$$$0(2);
        }
        try {
            this.setProcessingNow(true);
            runnable2.run();
        }
        finally {
            this.setProcessingNow(false);
        }
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.myToExpand.isEmpty() && this.myToSelect.isEmpty() && this.myAdjustedSelection.isEmpty();
    }

    boolean isProcessingNow() {
        return this.myProcessingCount > 0;
    }

    public void addAll(@NotNull UpdaterTreeState state) {
        Object[] toSelect2;
        if (state == null) {
            UpdaterTreeState.$$$reportNull$$$0(3);
        }
        this.myToExpand.putAll(state.myToExpand);
        for (Object each : toSelect2 = state.getToSelect()) {
            if (this.myAdjustedSelection.containsKey(each)) continue;
            this.myToSelect.put(each, each);
        }
        this.myCanRunRestore = state.myCanRunRestore;
    }

    public boolean restore(@Nullable DefaultMutableTreeNode actionNode) {
        if (this.isProcessingNow() || !this.myCanRunRestore || this.myUi.hasNodesToUpdate()) {
            return false;
        }
        this.invalidateToSelectWithRefsToParent(actionNode);
        this.setProcessingNow(true);
        final Object[] toSelect2 = this.getToSelect();
        final Object[] toExpand = this.getToExpand();
        final WeakHashMap<Object, Condition> adjusted = new WeakHashMap<Object, Condition>(this.myAdjustedSelection);
        this.clearSelection();
        this.clearExpansion();
        final Set<Object> originallySelected = this.myUi.getSelectedElements();
        this.myUi._select(toSelect2, new TreeRunnable("UpdaterTreeState.restore"){

            @Override
            public void perform() {
                UpdaterTreeState.this.processUnsuccessfulSelections(toSelect2, o -> {
                    if (UpdaterTreeState.this.myUi.getTree().isRootVisible() || !UpdaterTreeState.this.myUi.getTreeStructure().getRootElement().equals(o)) {
                        UpdaterTreeState.this.addSelection(o);
                    }
                    return o;
                }, originallySelected);
                UpdaterTreeState.this.processAdjusted(adjusted, originallySelected).doWhenDone(new TreeRunnable("UpdaterTreeState.restore: on done"){

                    @Override
                    public void perform() {
                        UpdaterTreeState.this.myUi.expand(toExpand, new TreeRunnable("UpdaterTreeState.restore: after on done"){

                            @Override
                            public void perform() {
                                UpdaterTreeState.this.myUi.clearUpdaterState();
                                UpdaterTreeState.this.setProcessingNow(false);
                            }
                        }, true);
                    }
                });
            }
        });
        return true;
    }

    private void invalidateToSelectWithRefsToParent(DefaultMutableTreeNode actionNode) {
        Object readyElement;
        if (actionNode != null && (readyElement = this.myUi.getElementFor(actionNode)) != null) {
            Iterator<Object> toSelect2 = this.myToSelect.keySet().iterator();
            while (toSelect2.hasNext()) {
                List<Object> children2;
                Object eachToSelect = toSelect2.next();
                if (!readyElement.equals(this.myUi.getTreeStructure().getParentElement(eachToSelect)) || (children2 = this.myUi.getLoadedChildrenFor(readyElement)).contains(eachToSelect)) continue;
                toSelect2.remove();
                if (this.myToSelect.containsKey(readyElement) || this.myUi.getSelectedElements().contains(eachToSelect)) continue;
                this.addAdjustedSelection(eachToSelect, Conditions.alwaysFalse(), null);
            }
        }
    }

    void beforeSubtreeUpdate() {
        this.myCanRunRestore = true;
    }

    private void processUnsuccessfulSelections(Object[] toSelect2, Function<Object, Object> restore, Set<Object> originallySelected) {
        Set<Object> selected2 = this.myUi.getSelectedElements();
        boolean wasFullyRejected = false;
        if (toSelect2.length > 0 && !selected2.isEmpty() && !originallySelected.containsAll(selected2)) {
            HashSet successfulSelections = new HashSet();
            ContainerUtil.addAll(successfulSelections, toSelect2);
            successfulSelections.retainAll(selected2);
            wasFullyRejected = successfulSelections.isEmpty();
        } else if (selected2.isEmpty() && originallySelected.isEmpty()) {
            wasFullyRejected = true;
        }
        if (wasFullyRejected && !selected2.isEmpty()) {
            return;
        }
        for (Object eachToSelect : toSelect2) {
            if (selected2.contains(eachToSelect)) continue;
            restore.fun(eachToSelect);
        }
    }

    private ActionCallback processAdjusted(final Map<Object, Condition> adjusted, final Set<Object> originallySelected) {
        final ActionCallback result2 = new ActionCallback();
        Set<Object> allSelected = this.myUi.getSelectedElements();
        HashSet<Object> toSelect2 = new HashSet<Object>();
        for (Map.Entry<Object, Condition> entry : adjusted.entrySet()) {
            Object key;
            Condition condition2 = entry.getValue();
            if (condition2.value(key = entry.getKey())) continue;
            for (Object eachSelected : allSelected) {
                if (this.isParentOrSame(key, eachSelected)) continue;
                toSelect2.add(key);
            }
            if (!allSelected.isEmpty()) continue;
            toSelect2.add(key);
        }
        final Object[] newSelection = ArrayUtil.toObjectArray(toSelect2);
        if (newSelection.length > 0) {
            this.myUi._select(newSelection, new TreeRunnable("UpdaterTreeState.processAjusted"){

                @Override
                public void perform() {
                    HashSet hangByParent = new HashSet();
                    UpdaterTreeState.this.processUnsuccessfulSelections(newSelection, o -> {
                        if (UpdaterTreeState.this.myUi.isInStructure(o) && !((Condition)adjusted.get(o)).value(o)) {
                            hangByParent.add(o);
                        } else {
                            UpdaterTreeState.this.addAdjustedSelection(o, (Condition)adjusted.get(o), null);
                        }
                        return null;
                    }, originallySelected);
                    UpdaterTreeState.this.processHangByParent(hangByParent).notify(result2);
                }
            }, false, true);
        } else {
            result2.setDone();
        }
        return result2;
    }

    private ActionCallback processHangByParent(Set<Object> elements2) {
        if (elements2.isEmpty()) {
            return ActionCallback.DONE;
        }
        ActionCallback result2 = new ActionCallback(elements2.size());
        for (Object hangElement : elements2) {
            if (!this.myAdjustmentCause2Adjustment.containsKey(hangElement)) {
                this.processHangByParent(hangElement).notify(result2);
                continue;
            }
            result2.setDone();
        }
        return result2;
    }

    private ActionCallback processHangByParent(Object each) {
        ActionCallback result2 = new ActionCallback();
        this.processNextHang(each, result2);
        return result2;
    }

    private void processNextHang(Object element2, final ActionCallback callback2) {
        if (element2 == null || this.myUi.getSelectedElements().contains(element2)) {
            callback2.setDone();
        } else {
            final Object nextElement = this.myUi.getTreeStructure().getParentElement(element2);
            if (nextElement == null) {
                callback2.setDone();
            } else {
                this.myUi.select(nextElement, (Runnable)new TreeRunnable("UpdaterTreeState.processNextHang"){

                    @Override
                    public void perform() {
                        UpdaterTreeState.this.processNextHang(nextElement, callback2);
                    }
                }, true);
            }
        }
    }

    private boolean isParentOrSame(Object parent, Object child2) {
        Object eachParent = child2;
        while (eachParent != null) {
            if (parent.equals(eachParent)) {
                return true;
            }
            eachParent = this.myUi.getTreeStructure().getParentElement(eachParent);
        }
        return false;
    }

    void clearExpansion() {
        this.myToExpand.clear();
    }

    public void clearSelection() {
        this.myToSelect.clear();
        this.myAdjustedSelection = new WeakHashMap<Object, Condition>();
    }

    public void addSelection(Object element2) {
        this.myToSelect.put(element2, element2);
    }

    void addAdjustedSelection(Object element2, Condition isExpired, @Nullable Object adjustmentCause) {
        this.myAdjustedSelection.put(element2, isExpired);
        if (adjustmentCause != null) {
            this.myAdjustmentCause2Adjustment.put(adjustmentCause, element2);
        }
    }

    @NonNls
    public String toString() {
        return "UpdaterState toSelect " + this.myToSelect + " toExpand=" + this.myToExpand + " processingNow=" + this.isProcessingNow() + " canRun=" + this.myCanRunRestore;
    }

    private void setProcessingNow(boolean processingNow) {
        this.myProcessingCount = processingNow ? ++this.myProcessingCount : --this.myProcessingCount;
        if (!this.isProcessingNow()) {
            this.myUi.maybeReady();
        }
    }

    public void removeFromSelection(Object element2) {
        this.myToSelect.remove(element2);
        this.myAdjustedSelection.remove(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/UpdaterTreeState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToSelect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToExpand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/UpdaterTreeState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

