/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.ide.wizard.StepListener;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWizard<T extends Step>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AbstractWizard.class);
    protected int myCurrentStep;
    protected final ArrayList<T> mySteps;
    private JButton myPreviousButton;
    private JButton myNextButton;
    private JButton myCancelButton;
    private JButton myHelpButton;
    protected JPanel myContentPanel;
    protected TallImageComponent myIcon;
    private Component myCurrentStepComponent;
    private JBCardLayout.SwipeDirection myTransitionDirection = JBCardLayout.SwipeDirection.AUTO;
    private final Map<Component, String> myComponentToIdMap = new HashMap<Component, String>();
    private final StepListener myStepListener = new StepListener(){

        @Override
        public void stateChanged() {
            AbstractWizard.this.updateStep();
        }
    };

    public AbstractWizard(String title, Component dialogParent) {
        super(dialogParent, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    public AbstractWizard(String title, @Nullable Project project2) {
        super(project2, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    private void initWizard(String title) {
        this.setTitle(title);
        this.myCurrentStep = 0;
        this.myPreviousButton = new JButton(IdeBundle.message("button.wizard.previous", new Object[0]));
        this.myNextButton = new JButton(IdeBundle.message("button.wizard.next", new Object[0]));
        this.myCancelButton = new JButton(CommonBundle.getCancelButtonText());
        this.myHelpButton = new JButton(CommonBundle.getHelpButtonText());
        this.myContentPanel = new JPanel(new JBCardLayout());
        this.myIcon = new TallImageComponent(null);
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            }, KeyStroke.getKeyStroke(112, 0), 2);
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            }, KeyStroke.getKeyStroke(156, 0), 2);
        }
    }

    @Override
    protected JComponent createSouthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JPanel buttonPanel = new JPanel();
        if (SystemInfo.isMac) {
            panel2.add((Component)buttonPanel, "East");
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            if (!StartupUiUtil.isUnderDarcula()) {
                this.myHelpButton.putClientProperty("JButton.buttonType", "help");
            }
            int index = 0;
            JPanel leftPanel = new JPanel();
            if (ApplicationInfo.contextHelpAvailable()) {
                leftPanel.add(this.myHelpButton);
                TouchbarDataKeys.putDialogButtonDescriptor(this.myHelpButton, index++);
            }
            leftPanel.add(this.myCancelButton);
            TouchbarDataKeys.putDialogButtonDescriptor(this.myCancelButton, index++);
            panel2.add((Component)leftPanel, "West");
            if (this.mySteps.size() > 1) {
                buttonPanel.add(Box.createHorizontalStrut(5));
                buttonPanel.add(this.myPreviousButton);
                TouchbarDataKeys.putDialogButtonDescriptor(this.myPreviousButton, index++).setMainGroup(true);
            }
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(this.myNextButton);
            TouchbarDataKeys.putDialogButtonDescriptor(this.myNextButton, index++).setMainGroup(true).setDefault(true);
        } else {
            panel2.add((Component)buttonPanel, "Center");
            GroupLayout layout = new GroupLayout(buttonPanel);
            buttonPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
            ArrayList buttons = new ArrayList(5);
            boolean helpAvailable = ApplicationInfo.contextHelpAvailable();
            AbstractWizard.add(hGroup, vGroup, null, Box.createHorizontalGlue());
            if (this.mySteps.size() > 1) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myPreviousButton);
            }
            AbstractWizard.add(hGroup, vGroup, buttons, this.myNextButton, this.myCancelButton);
            if (helpAvailable) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myHelpButton);
            }
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            layout.linkSize(buttons.toArray(new Component[0]));
        }
        this.myPreviousButton.setEnabled(false);
        this.myPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doPreviousAction();
            }
        });
        this.myNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractWizard.this.isLastStep()) {
                    Step currentStep = (Step)AbstractWizard.this.mySteps.get(AbstractWizard.this.myCurrentStep);
                    LOG.assertTrue(currentStep != null);
                    try {
                        currentStep._commit(true);
                        AbstractWizard.this.doOKAction();
                    }
                    catch (CommitStepException exc) {
                        String message = exc.getMessage();
                        if (message != null) {
                            Messages.showErrorDialog(AbstractWizard.this.myContentPanel, message);
                        }
                    }
                } else {
                    AbstractWizard.this.doNextAction();
                }
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doCancelAction();
            }
        });
        this.myHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.helpAction();
            }
        });
        return panel2;
    }

    public JPanel getContentComponent() {
        return this.myContentPanel;
    }

    private static void add(GroupLayout.Group hGroup, GroupLayout.Group vGroup, @Nullable Collection<? super Component> collection, Component ... components) {
        for (Component component2 : components) {
            hGroup.addComponent(component2);
            vGroup.addComponent(component2);
            if (collection == null) continue;
            collection.add(component2);
        }
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myIcon, "West");
        panel2.add((Component)this.myContentPanel, "Center");
        return panel2;
    }

    public int getCurrentStep() {
        return this.myCurrentStep;
    }

    public int getStepCount() {
        return this.mySteps.size();
    }

    public T getCurrentStepObject() {
        return (T)((Step)this.mySteps.get(this.myCurrentStep));
    }

    public void addStep(@NotNull T step) {
        if (step == null) {
            AbstractWizard.$$$reportNull$$$0(0);
        }
        this.addStep(step, this.mySteps.size());
    }

    public void addStep(@NotNull T step, int index) {
        JComponent component2;
        if (step == null) {
            AbstractWizard.$$$reportNull$$$0(1);
        }
        this.mySteps.add(index, step);
        if (step instanceof StepAdapter) {
            ((StepAdapter)step).registerStepListener(this.myStepListener);
        }
        if ((component2 = step.getComponent()) != null) {
            this.addStepComponent(component2);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.updateStep();
    }

    protected String addStepComponent(@NotNull Component component2) {
        String id2;
        if (component2 == null) {
            AbstractWizard.$$$reportNull$$$0(2);
        }
        if (component2 instanceof JPanel) {
            ((JPanel)component2).putClientProperty(DIALOG_CONTENT_PANEL_PROPERTY, true);
        }
        if ((id2 = this.myComponentToIdMap.get(component2)) == null) {
            id2 = Integer.toString(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component2, id2);
            this.myContentPanel.add(component2, id2);
        }
        return id2;
    }

    private void showStepComponent(Component component2) {
        String id2 = this.myComponentToIdMap.get(component2);
        if (id2 == null) {
            id2 = this.addStepComponent(component2);
            this.myContentPanel.revalidate();
            this.myContentPanel.repaint();
        }
        ((JBCardLayout)this.myContentPanel.getLayout()).swipe(this.myContentPanel, id2, this.myTransitionDirection);
    }

    protected void doPreviousAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getPreviousStep(this.myCurrentStep);
        this.updateStep(JBCardLayout.SwipeDirection.BACKWARD);
    }

    protected final void updateStep(JBCardLayout.SwipeDirection direction) {
        try {
            this.myTransitionDirection = direction;
            this.updateStep();
        }
        finally {
            this.myTransitionDirection = JBCardLayout.SwipeDirection.AUTO;
        }
    }

    protected void doNextAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        LOG.assertTrue(!this.isLastStep(), "steps: " + this.mySteps + " current: " + currentStep);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getNextStep(this.myCurrentStep);
        this.updateStep(JBCardLayout.SwipeDirection.FORWARD);
    }

    protected int getNextStep(int step) {
        int stepCount = this.mySteps.size();
        if (++step >= stepCount) {
            step = stepCount - 1;
        }
        return step;
    }

    protected final int getNextStep() {
        return this.getNextStep(this.getCurrentStep());
    }

    protected T getNextStepObject() {
        int step = this.getNextStep();
        return (T)((Step)this.mySteps.get(step));
    }

    protected int getPreviousStep(int step) {
        if (--step < 0) {
            step = 0;
        }
        return step;
    }

    protected final int getPreviousStep() {
        return this.getPreviousStep(this.getCurrentStep());
    }

    protected void updateStep() {
        if (this.mySteps.isEmpty()) {
            return;
        }
        Step step = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(step != null);
        step._init();
        this.myCurrentStepComponent = step.getComponent();
        LOG.assertTrue(this.myCurrentStepComponent != null);
        this.showStepComponent(this.myCurrentStepComponent);
        Icon icon2 = step.getIcon();
        if (icon2 != null) {
            this.myIcon.setIcon(icon2);
            this.myIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        this.updateButtons();
        JComponent component2 = ((Step)this.mySteps.get(this.getCurrentStep())).getPreferredFocusedComponent();
        AbstractWizard.requestFocusTo(component2 != null ? component2 : this.myNextButton);
    }

    private static void requestFocusTo(JComponent component2) {
        UiNotifyConnector.doWhenFirstShown(component2, () -> {
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(component2);
            focusManager.requestFocus(component2, false);
        });
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.getCurrentStepObject().getPreferredFocusedComponent();
        return component2 == null ? super.getPreferredFocusedComponent() : component2;
    }

    protected boolean canGoNext() {
        return true;
    }

    protected boolean canFinish() {
        return this.isLastStep() && this.canGoNext();
    }

    protected void updateButtons() {
        boolean lastStep;
        this.updateButtons(lastStep, (lastStep = this.isLastStep()) ? this.canFinish() : this.canGoNext(), this.isFirstStep());
    }

    public void updateWizardButtons() {
        if (!this.mySteps.isEmpty() && this.getRootPane() != null) {
            this.updateButtons();
        }
    }

    public void updateButtons(boolean lastStep, boolean canGoNext, boolean firstStep) {
        if (lastStep) {
            if (this.mySteps.size() > 1) {
                this.myNextButton.setText(UIUtil.removeMnemonic(IdeBundle.message("button.finish", new Object[0])));
                this.myNextButton.setMnemonic('F');
            } else {
                this.myNextButton.setText(IdeBundle.message("button.ok", new Object[0]));
            }
        } else {
            this.myNextButton.setText(UIUtil.removeMnemonic(IdeBundle.message("button.wizard.next", new Object[0])));
            this.myNextButton.setMnemonic('N');
        }
        this.myNextButton.setEnabled(canGoNext);
        if (this.myNextButton.isEnabled() && !ApplicationManager.getApplication().isUnitTestMode() && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.myNextButton);
        }
        this.myPreviousButton.setEnabled(!firstStep);
    }

    protected boolean isFirstStep() {
        return this.myCurrentStep == 0;
    }

    protected boolean isLastStep() {
        return this.myCurrentStep == this.mySteps.size() - 1 || this.getCurrentStep() == this.getNextStep(this.getCurrentStep());
    }

    protected JButton getNextButton() {
        return this.myNextButton;
    }

    protected JButton getPreviousButton() {
        return this.myPreviousButton;
    }

    protected JButton getHelpButton() {
        return this.myHelpButton;
    }

    public JButton getCancelButton() {
        return this.myCancelButton;
    }

    @Deprecated
    protected JButton getFinishButton() {
        return new JButton();
    }

    public Component getCurrentStepComponent() {
        return this.myCurrentStepComponent;
    }

    protected void helpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    @Override
    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    protected int getNumberOfSteps() {
        return this.mySteps.size();
    }

    @Nullable
    @NonNls
    protected abstract String getHelpID();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/wizard/AbstractWizard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStepComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TallImageComponent
    extends OpaquePanel {
        private Icon myIcon;

        private TallImageComponent(Icon icon2) {
            this.myIcon = icon2;
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            this.paintIcon(g);
        }

        public void paintIcon(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            BufferedImage image = ImageUtil.createImage(g, this.myIcon.getIconWidth(), this.myIcon.getIconHeight(), 2);
            Graphics2D gg = image.createGraphics();
            this.myIcon.paintIcon(this, gg, 0, 0);
            Rectangle bounds2 = g.getClipBounds();
            for (int y = this.myIcon.getIconHeight() - 1; y < bounds2.y + bounds2.height; ++y) {
                g.drawImage(image, bounds2.x, y, bounds2.x + bounds2.width, y + 1, 0, this.myIcon.getIconHeight() - 1, bounds2.width, this.myIcon.getIconHeight(), this);
            }
            g.drawImage(image, 0, 0, this);
        }

        public void setIcon(Icon icon2) {
            this.myIcon = icon2;
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }
    }
}

