/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurerKt;
import com.intellij.ide.CommandLineProcessor;
import com.intellij.ide.CommandLineProcessorResult;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeStarterKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.EventQueue;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\b\u0010\r\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"invokeLaterWithAnyModality", "", "name", "", "task", "Lkotlin/Function0;", "loadProjectFromExternalCommandLine", "Lcom/intellij/openapi/project/Project;", "commandLineArgs", "", "postOpenUiTasks", "app", "Lcom/intellij/openapi/application/Application;", "reportPluginError", "intellij.platform.ide.impl"})
public final class IdeStarterKt {
    private static final Project loadProjectFromExternalCommandLine(List<String> commandLineArgs) {
        String currentDirectory = System.getenv("IDEA_INITIAL_DIRECTORY");
        Logger.getInstance("#com.intellij.idea.ApplicationLoader").info("ApplicationLoader.loadProject (cwd=" + currentDirectory + ')');
        CommandLineProcessorResult commandLineProcessorResult = CommandLineProcessor.processExternalCommandLine(commandLineArgs, currentDirectory);
        Intrinsics.checkExpressionValueIsNotNull((Object)commandLineProcessorResult, (String)"CommandLineProcessor.pro\u2026neArgs, currentDirectory)");
        CommandLineProcessorResult result2 = commandLineProcessorResult;
        if (result2.getHasError()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(result2){
                final /* synthetic */ CommandLineProcessorResult $result;

                public final void run() {
                    this.$result.showErrorIfFailed();
                }
                {
                    this.$result = commandLineProcessorResult;
                }
            });
        }
        return result2.getProject();
    }

    private static final void postOpenUiTasks(Application app) {
        if (SystemInfo.isMac) {
            NonUrgentExecutor.getInstance().execute((Runnable)postOpenUiTasks.1.INSTANCE);
        } else if (SystemInfo.isXWindow && SystemInfo.isJetBrainsJvm) {
            NonUrgentExecutor.getInstance().execute((Runnable)postOpenUiTasks.2.INSTANCE);
        }
        IdeStarterKt.invokeLaterWithAnyModality("system dock menu", (Function0<Unit>)((Function0)postOpenUiTasks.3.INSTANCE));
        IdeStarterKt.invokeLaterWithAnyModality("ScreenReader", (Function0<Unit>)((Function0)new Function0<Unit>(app){
            final /* synthetic */ Application $app;

            public final void invoke() {
                GeneralSettings generalSettings = GeneralSettings.getInstance();
                generalSettings.addPropertyChangeListener("supportScreenReaders", this.$app, postOpenUiTasks.1.INSTANCE);
                GeneralSettings generalSettings2 = generalSettings;
                Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings2, (String)"generalSettings");
                ScreenReader.setActive(generalSettings2.isSupportScreenReaders());
            }
            {
                this.$app = application;
                super(0);
            }
        }));
    }

    private static final void invokeLaterWithAnyModality(String name, Function0<Unit> task2) {
        EventQueue.invokeLater(new Runnable(name, task2){
            final /* synthetic */ String $name;
            final /* synthetic */ Function0 $task;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void name$iv;
                String string = this.$name;
                Function0 task$iv = this.$task;
                ActivityCategory category$iv = ActivityCategory.APP_INIT;
                boolean $i$f$runActivity = false;
                Activity activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
                Object result$iv = task$iv.invoke();
                activity$iv.end();
            }
            {
                this.$name = string;
                this.$task = function0;
            }
        });
    }

    private static final void reportPluginError() {
        String string = PluginManagerCore.ourPluginError;
        if (string == null) {
            return;
        }
        String pluginError = string;
        PluginManagerCore.ourPluginError = null;
        ApplicationManager.getApplication().invokeLater(new Runnable(pluginError){
            final /* synthetic */ String $pluginError;

            public final void run() {
                String title;
                String string = title = IdeBundle.message("title.plugin.error", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"title");
                new Notification(NotificationGroup.Companion.createIdWithTitle("Plugin Error", string), title, this.$pluginError, NotificationType.ERROR, reportPluginError.1.INSTANCE).notify(null);
            }
            {
                this.$pluginError = string;
            }
        }, ModalityState.NON_MODAL);
    }

    public static final /* synthetic */ Project access$loadProjectFromExternalCommandLine(List commandLineArgs) {
        return IdeStarterKt.loadProjectFromExternalCommandLine(commandLineArgs);
    }

    public static final /* synthetic */ void access$reportPluginError() {
        IdeStarterKt.reportPluginError();
    }

    public static final /* synthetic */ void access$postOpenUiTasks(Application app) {
        IdeStarterKt.postOpenUiTasks(app);
    }
}

