/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SLRUMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RareLogger
extends Logger {
    private final SLRUMap<Object, Long> myCache;
    private final List<LogFilter> myConverters = new LinkedList<LogFilter>();
    private final LogFilter myProxy;
    private final Logger myLogger;

    private RareLogger(final Logger logger, final boolean fairSync) {
        this.myLogger = logger;
        final Object lock = new Object();
        this.myCache = new SLRUMap<Object, Long>(64, 32){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long get(Object key) {
                if (fairSync) {
                    Object object = lock;
                    synchronized (object) {
                        return (Long)super.get(key);
                    }
                }
                return (Long)super.get(key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(Object key, @NotNull Long value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fairSync) {
                    Object object = lock;
                    synchronized (object) {
                        super.put(key, value2);
                        return;
                    }
                }
                super.put(key, value2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean remove(Object key) {
                if (fairSync) {
                    Object object = lock;
                    synchronized (object) {
                        return super.remove(key);
                    }
                }
                return super.remove(key);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/idea/RareLogger$1", "put"));
            }
        };
        this.myProxy = new LogFilter(){

            @Override
            @NotNull
            public Integer getAllowedLoggingInterval(Level level, String message, Throwable t, String[] details) {
                Integer n = -1;
                if (n == null) {
                    2.$$$reportNull$$$0(0);
                }
                return n;
            }

            @Override
            public Object getKey(@NotNull Level level, @NonNls String message, @Nullable Throwable t, String ... details) {
                if (level == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (Level.DEBUG.equals((Object)level)) {
                    logger.debug(message, t);
                } else if (Level.INFO.equals((Object)level)) {
                    logger.info(message, t);
                } else if (Level.WARN.equals((Object)level)) {
                    logger.warn(message, t);
                } else if (Level.ERROR.equals((Object)level)) {
                    logger.error(message, t, details);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/idea/RareLogger$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "level";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllowedLoggingInterval";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/idea/RareLogger$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getKey";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void addFilter(LogFilter logFilter) {
        this.myConverters.add(logFilter);
    }

    public static Logger wrap(Logger logger, boolean fairSync) {
        return new RareLogger(logger, fairSync);
    }

    public static Logger wrap(Logger logger, boolean fairSync, LogFilter ... filters) {
        RareLogger rareLogger = new RareLogger(logger, fairSync);
        for (LogFilter filter2 : filters) {
            rareLogger.addFilter(filter2);
        }
        return rareLogger;
    }

    @Override
    public void debug(@NonNls String message) {
        this.process(Level.DEBUG, message, null, new String[0]);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    @Override
    public void debug(Throwable t) {
        this.process(Level.DEBUG, null, t, new String[0]);
    }

    @Override
    public void debug(@NonNls String message, Throwable t) {
        this.process(Level.DEBUG, message, t, new String[0]);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLogger.isTraceEnabled();
    }

    @Override
    public void trace(String message) {
        this.process(Level.TRACE, message, null, new String[0]);
    }

    @Override
    public void trace(@Nullable Throwable t) {
        this.process(Level.TRACE, null, t, new String[0]);
    }

    @Override
    public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            RareLogger.$$$reportNull$$$0(0);
        }
        this.process(Level.ERROR, message, t, details);
    }

    @Override
    public void info(@NonNls String message) {
        this.process(Level.INFO, message, null, new String[0]);
    }

    @Override
    public void info(@NonNls String message, Throwable t) {
        this.process(Level.INFO, message, t, new String[0]);
    }

    @Override
    public void warn(@NonNls String message, Throwable t) {
        this.process(Level.WARN, message, t, new String[0]);
    }

    @Override
    public void setLevel(Level level) {
        this.myLogger.setLevel(level);
    }

    private void process(@NotNull Level level, @NonNls @Nullable String message, @Nullable Throwable t, String ... details) {
        if (level == null) {
            RareLogger.$$$reportNull$$$0(1);
        }
        if (!Level.ERROR.equals((Object)level)) {
            for (LogFilter convertor : this.myConverters) {
                Object key = convertor.getKey(level, message, t, details);
                if (key == null) continue;
                Long latestMoment = this.myCache.get(key);
                if (latestMoment != null && System.currentTimeMillis() - latestMoment < (long)convertor.getAllowedLoggingInterval(level, message, t, details).intValue()) {
                    return;
                }
                this.myCache.put(key, System.currentTimeMillis());
                break;
            }
        }
        this.myProxy.getKey(level, message, t, details);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/idea/RareLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface LogFilter {
        @Nullable
        public Object getKey(@NotNull Level var1, @NonNls String var2, @Nullable Throwable var3, String ... var4);

        @NotNull
        public Integer getAllowedLoggingInterval(Level var1, String var2, Throwable var3, String[] var4);
    }
}

