/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.Patches;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.AssertiveRepaintManager;
import com.intellij.ide.CliResult;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeRepaintManager;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.ide.instrument.WriteIntentLockInstrumenter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.PrintStreamLogger;
import com.intellij.idea.SocketLock;
import com.intellij.idea.SplashManager;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;

public final class StartupUtil {
    public static final String IDEA_CLASS_BEFORE_APPLICATION_PROPERTY = "idea.class.before.app";
    public static final String USE_SEPARATE_WRITE_THREAD_PROPERTY = "idea.use.separate.write.thread";
    private static final String MAGIC_MAC_PATH = "/AppTranslocation/";
    private static SocketLock ourSocketLock;
    private static final AtomicBoolean ourSystemPatched;

    private StartupUtil() {
    }

    public static boolean isUsingSeparateWriteThread() {
        return Boolean.getBoolean(USE_SEPARATE_WRITE_THREAD_PROPERTY);
    }

    public static synchronized void addExternalInstanceListener(@Nullable Function<List<String>, Future<CliResult>> processor2) {
        if (ourSocketLock == null) {
            throw new AssertionError((Object)"Not initialized yet");
        }
        ourSocketLock.setCommandProcessor(processor2);
    }

    @Deprecated
    @Nullable
    public static synchronized BuiltInServer getServer() {
        return ourSocketLock == null ? null : ourSocketLock.getServer();
    }

    @NotNull
    public static synchronized CompletableFuture<BuiltInServer> getServerFuture() {
        CompletableFuture<BuiltInServer> serverFuture = ourSocketLock == null ? null : ourSocketLock.getServerFuture();
        CompletableFuture<Object> completableFuture = serverFuture == null ? CompletableFuture.completedFuture(null) : serverFuture;
        if (completableFuture == null) {
            StartupUtil.$$$reportNull$$$0(0);
        }
        return completableFuture;
    }

    @Nullable
    private static Object loadEuaDocument() {
        if (!ApplicationInfoImpl.getShadowInstance().isVendorJetBrains()) {
            return null;
        }
        Activity euaActivity = StartUpMeasurer.startActivity("eua getting");
        EndUserAgreement.Document result2 = EndUserAgreement.getLatestDocument();
        euaActivity.end();
        return result2;
    }

    private static void runPreAppClass(@NotNull Logger log) {
        String classBeforeAppProperty;
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(1);
        }
        if ((classBeforeAppProperty = System.getProperty(IDEA_CLASS_BEFORE_APPLICATION_PROPERTY)) != null) {
            try {
                Class<?> clazz = Class.forName(classBeforeAppProperty);
                Method invokeMethod = clazz.getDeclaredMethod("invoke", new Class[0]);
                invokeMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                log.error("Failed pre-app class init for class " + classBeforeAppProperty, e);
            }
        }
    }

    public static void prepareApp(@NotNull @NotNull String @NotNull [] args, @NotNull String mainClass) throws Exception {
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(2);
        }
        if (mainClass == null) {
            StartupUtil.$$$reportNull$$$0(3);
        }
        LoadingState.setStrictMode();
        Activity activity = StartUpMeasurer.startMainActivity("ForkJoin CommonPool configuration");
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)Main.isHeadless((String[])args));
        activity = activity.endAndStart("main class loading scheduling");
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Future<AppStarter> appStarterFuture = executorService.submit(() -> {
            Activity subActivity = StartUpMeasurer.startActivity("main class loading");
            Class<?> aClass = Class.forName(mainClass);
            subActivity.end();
            return (AppStarter)aClass.newInstance();
        });
        activity = activity.endAndStart("log4j configuration");
        StartupUtil.configureLog4j();
        activity = activity.endAndStart("LaF init scheduling");
        Future<Object> euaDocument = Main.isHeadless() ? null : executorService.submit(StartupUtil::loadEuaDocument);
        CompletableFuture<?> initUiTask = StartupUtil.scheduleInitUi(args, executorService, euaDocument);
        activity.end();
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        activity = StartUpMeasurer.startMainActivity("config path computing");
        Path configPath = PathManager.getConfigDir();
        activity = activity.endAndStart("config path existence check");
        boolean configImportNeeded = !Main.isHeadless() && (!Files.exists(configPath, new LinkOption[0]) || Files.exists(configPath.resolve("migrate.config"), new LinkOption[0]));
        activity = activity.endAndStart("system dirs checking");
        if (!StartupUtil.checkSystemDirs()) {
            System.exit(5);
        }
        activity = activity.endAndStart("system dirs locking");
        StartupUtil.lockSystemDirs(args);
        activity = activity.endAndStart("file logger configuration");
        Logger log = StartupUtil.setupLogger();
        activity.end();
        if (!configImportNeeded) {
            PluginManagerCore.scheduleDescriptorLoading();
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            Activity subActivity = StartUpMeasurer.startActivity("essential IDE info logging");
            StartupUtil.logEssentialInfoAboutIde(log, appInfo);
            subActivity.end();
        });
        Future<?> extraTaskFuture = executorService.submit(StartupUtil::setupSystemLibraries);
        StartupUtil.scheduleProcessEnvironmentFixing();
        if (!configImportNeeded) {
            StartupUtil.runPreAppClass(log);
        }
        NonUrgentExecutor.getInstance().execute(() -> StartupUtil.loadSystemLibraries(log));
        activity = StartUpMeasurer.startMainActivity("tasks waiting");
        extraTaskFuture.get();
        activity.end();
        StartupUtil.startApp(args, initUiTask, log, configImportNeeded, appStarterFuture, euaDocument);
    }

    @NotNull
    private static AppStarter getAppStarter(@NotNull Future<AppStarter> mainStartFuture) throws InterruptedException, ExecutionException {
        if (mainStartFuture == null) {
            StartupUtil.$$$reportNull$$$0(4);
        }
        Activity activity = mainStartFuture.isDone() ? null : StartUpMeasurer.startMainActivity("main class loading waiting");
        AppStarter result2 = mainStartFuture.get();
        if (activity != null) {
            activity.end();
        }
        AppStarter appStarter = result2;
        if (appStarter == null) {
            StartupUtil.$$$reportNull$$$0(5);
        }
        return appStarter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startApp(String @NotNull [] args, final @NotNull CompletableFuture<?> initUiTask, final @NotNull Logger log, boolean configImportNeeded, @NotNull Future<AppStarter> appStarterFuture, @Nullable Future<Object> euaDocument) throws Exception {
        if (initUiTask == null) {
            StartupUtil.$$$reportNull$$$0(6);
        }
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(7);
        }
        if (appStarterFuture == null) {
            StartupUtil.$$$reportNull$$$0(8);
        }
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(9);
        }
        if (!Main.isHeadless()) {
            boolean agreementDialogWasShown;
            Activity activity = StartUpMeasurer.startMainActivity("eua showing");
            boolean bl = agreementDialogWasShown = euaDocument != null && StartupUtil.showUserAgreementAndConsentsIfNeeded(log, initUiTask, euaDocument);
            if (configImportNeeded) {
                activity = activity.endAndStart("config importing");
                AppStarter appStarter = StartupUtil.getAppStarter(appStarterFuture);
                appStarter.beforeImportConfigs();
                Path newConfigDir = PathManager.getConfigDir();
                StartupUtil.runInEdtAndWait(log, () -> ConfigImportHelper.importConfigsTo(agreementDialogWasShown, newConfigDir, log), initUiTask);
                appStarter.importFinished(newConfigDir);
                if (!ConfigImportHelper.isConfigImported()) {
                    EventQueue.invokeAndWait(() -> {
                        StartupUtil.runStartupWizard(appStarter);
                        PluginManagerCore.scheduleDescriptorLoading();
                    });
                } else {
                    PluginManagerCore.scheduleDescriptorLoading();
                }
                activity.end();
            } else {
                activity.end();
            }
        }
        EdtInvocationManager oldEdtInvocationManager = null;
        EdtInvocationManager.SwingEdtInvocationManager edtInvocationManager = new EdtInvocationManager.SwingEdtInvocationManager(){

            @Override
            public void invokeAndWait(@NotNull Runnable task2) {
                if (task2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                StartupUtil.runInEdtAndWait(log, task2, initUiTask);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/idea/StartupUtil$1", "invokeAndWait"));
            }
        };
        try {
            oldEdtInvocationManager = EdtInvocationManager.setEdtInvocationManager(edtInvocationManager);
            StartupUtil.getAppStarter(appStarterFuture).start(Arrays.asList(args), initUiTask);
        }
        finally {
            EdtInvocationManager.restoreEdtInvocationManager(edtInvocationManager, oldEdtInvocationManager);
        }
    }

    @NotNull
    private static CompletableFuture<?> scheduleInitUi(@NotNull @NotNull String @NotNull [] args, @NotNull ExecutorService executor, @Nullable Future<Object> eulaDocument) {
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(10);
        }
        if (executor == null) {
            StartupUtil.$$$reportNull$$$0(11);
        }
        CompletableFuture initUiFuture = new CompletableFuture();
        executor.execute(() -> {
            try {
                StartupUtil.checkHiDPISettings();
                System.setProperty("sun.awt.noerasebackground", "true");
                if (System.getProperty("com.jetbrains.suppressWindowRaise") == null) {
                    System.setProperty("com.jetbrains.suppressWindowRaise", "true");
                }
                EventQueue.invokeLater(() -> {
                    try {
                        StartupUiUtil.initDefaultLaF();
                    }
                    catch (Throwable e) {
                        initUiFuture.completeExceptionally(e);
                        return;
                    }
                    initUiFuture.complete(null);
                    StartUpMeasurer.setCurrentState(LoadingState.LAF_INITIALIZED);
                    if (Main.isHeadless()) {
                        return;
                    }
                    Activity activity = StartUpMeasurer.startActivity("system font data initialization");
                    JBUIScale.getSystemFontData();
                    activity = activity.endAndStart("init JBUIScale");
                    JBUIScale.scale(1.0f);
                    if (!Main.isLightEdit() && !Boolean.getBoolean("nosplash")) {
                        Activity prepareSplashActivity = activity.endAndStart("splash preparation");
                        EventQueue.invokeLater(() -> {
                            boolean isEulaAccepted;
                            Activity eulaActivity = prepareSplashActivity.startChild("splash eula isAccepted");
                            try {
                                isEulaAccepted = eulaDocument == null || ((EndUserAgreement.Document)eulaDocument.get()).isAccepted();
                            }
                            catch (InterruptedException | ExecutionException ignore) {
                                isEulaAccepted = true;
                            }
                            eulaActivity.end();
                            SplashManager.show(args, isEulaAccepted);
                            prepareSplashActivity.end();
                        });
                        return;
                    }
                    EventQueue.invokeLater(StartupUiUtil::configureHtmlKitStylesheet);
                });
            }
            catch (Throwable e) {
                initUiFuture.completeExceptionally(e);
            }
        });
        if (!Main.isHeadless()) {
            initUiFuture.thenRunAsync(StartupUtil::updateFrameClassAndWindowIcon, executor);
        }
        CompletableFuture<Object> instrumentationFuture = new CompletableFuture<Object>();
        if (StartupUtil.isUsingSeparateWriteThread()) {
            executor.execute(() -> {
                Activity activity = StartUpMeasurer.startActivity("Write Intent Lock UI class transformer loading");
                try {
                    WriteIntentLockInstrumenter.instrument();
                }
                finally {
                    activity.end();
                    instrumentationFuture.complete(null);
                }
            });
        } else {
            instrumentationFuture.complete(null);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(initUiFuture, instrumentationFuture);
        if (completableFuture == null) {
            StartupUtil.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    private static void updateFrameClassAndWindowIcon() {
        Activity activity = StartUpMeasurer.startActivity("frame class updating");
        AppUIUtil.updateFrameClass(Toolkit.getDefaultToolkit());
        activity = activity.endAndStart("update window icon");
        if (!PluginManagerCore.isRunningFromSources() && !AppUIUtil.isWindowIconAlreadyExternallySet()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
        }
        activity.end();
    }

    private static void configureLog4j() {
        Activity activity = StartUpMeasurer.startMainActivity("console logger configuration");
        System.setProperty("log4j.defaultInitOverride", "true");
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        if (!root.getAllAppenders().hasMoreElements()) {
            root.setLevel(Level.WARN);
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        }
        activity.end();
    }

    private static boolean checkJdkVersion() {
        if ("true".equals(System.getProperty("idea.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException | LinkageError e) {
                String message = "Cannot load a JDK class: " + e.getMessage() + "\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
        }
        if ("true".equals(System.getProperty("idea.64bit.check")) && PlatformUtils.isCidr() && !SystemInfo.is64Bit) {
            String message = "32-bit JVM is not supported. Please use a 64-bit version.";
            Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    public static void test_checkHiDPISettings() {
        StartupUtil.checkHiDPISettings();
    }

    private static void checkHiDPISettings() {
        if (!SystemProperties.getBooleanProperty("hidpi", true)) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
    }

    private static boolean checkSystemDirs() {
        String configPath = PathManager.getConfigPath();
        if (!StartupUtil.checkDirectory(configPath, "Config", "idea.config.path", true, true, false)) {
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!StartupUtil.checkDirectory(systemPath, "System", "idea.system.path", true, true, false)) {
            return false;
        }
        if (FileUtil.pathsEqual(configPath, systemPath)) {
            String message = "Config and system paths seem to be equal.\n\nIf you have modified 'idea.config.path' or 'idea.system.path' properties,\nplease make sure they point to different directories, otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config or System Path", (String)message, (boolean)true);
            return false;
        }
        String logPath = PathManager.getLogPath();
        String tempPath = PathManager.getTempPath();
        return StartupUtil.checkDirectory(logPath, "Log", "idea.log.path", !FileUtil.isAncestor(systemPath, logPath, true), false, false) && StartupUtil.checkDirectory(tempPath, "Temp", "idea.system.path", !FileUtil.isAncestor(systemPath, tempPath, true), false, SystemInfo.isXWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkDirectory(String path2, String kind, String property, boolean checkWrite, boolean checkLock, boolean checkExec) {
        boolean options222;
        Path tempFile;
        String reason;
        String problem;
        block42: {
            block41: {
                problem = null;
                reason = null;
                tempFile = null;
                problem = "cannot create the directory";
                reason = "path is incorrect";
                Path directory = Paths.get(path2, new String[0]);
                if (!Files.isDirectory(directory, new LinkOption[0])) {
                    problem = "cannot create the directory";
                    reason = "parent directory is read-only or the user lacks necessary permissions";
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                if (checkWrite || checkLock || checkExec) {
                    problem = "cannot create a temporary file in the directory";
                    reason = "the directory is read-only or the user lacks necessary permissions";
                    tempFile = directory.resolve("ij" + new Random().nextInt(Integer.MAX_VALUE) + ".tmp");
                    OpenOption[] options222 = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
                    Files.write(tempFile, "#!/bin/sh\nexit 0".getBytes(StandardCharsets.UTF_8), options222);
                    if (checkLock) {
                        problem = "cannot create a lock file in the directory";
                        reason = "the directory is located on a network disk";
                        try (FileChannel channel = FileChannel.open(tempFile, StandardOpenOption.WRITE);
                             FileLock lock = channel.tryLock();){
                            if (lock == null) {
                                throw new IOException("File is locked");
                            }
                            break block41;
                        }
                    }
                    if (checkExec) {
                        problem = "cannot execute a test script in the directory";
                        reason = "the partition is mounted with 'no exec' option";
                        Files.getFileAttributeView(tempFile, PosixFileAttributeView.class, new LinkOption[0]).setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                        int ec = new ProcessBuilder(tempFile.toAbsolutePath().toString()).start().waitFor();
                        if (ec != 0) {
                            throw new IOException("Unexpected exit value: " + ec);
                        }
                    }
                }
            }
            options222 = true;
            if (tempFile == null) break block42;
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (Exception ec) {
                // empty catch block
            }
        }
        return options222;
        catch (Exception e) {
            boolean bl;
            block43: {
                try {
                    String title = "Invalid " + kind + " Directory";
                    String advice = SystemInfo.isMac && PathManager.getSystemPath().contains(MAGIC_MAC_PATH) ? "The application seems to be trans-located by macOS and cannot be used in this state.\nPlease use Finder to move it to another location." : "If you have modified the '" + property + "' property, please make sure it is correct,\notherwise, please re-install the IDE.";
                    String message = "The IDE " + problem + ".\nPossible reason: " + reason + ".\n\n" + advice + "\n\n-----\nLocation: " + path2 + "\n" + e.getClass().getName() + ": " + e.getMessage();
                    Main.showMessage((String)title, (String)message, (boolean)true);
                    bl = false;
                    if (tempFile == null) break block43;
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
    }

    private static synchronized void lockSystemDirs(String[] args) throws Exception {
        if (ourSocketLock != null) {
            throw new AssertionError((Object)"Already initialized");
        }
        ourSocketLock = new SocketLock(PathManager.getConfigPath(), PathManager.getSystemPath());
        Pair<SocketLock.ActivationStatus, CliResult> status = ourSocketLock.lockAndTryActivate(args);
        switch ((SocketLock.ActivationStatus)((Object)status.first)) {
            case NO_INSTANCE: {
                ShutDownTracker.getInstance().registerShutdownTask(() -> {
                    Class<StartupUtil> clazz = StartupUtil.class;
                    synchronized (StartupUtil.class) {
                        ourSocketLock.dispose();
                        ourSocketLock = null;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                });
                break;
            }
            case ACTIVATED: {
                CliResult result2 = (CliResult)status.second;
                String message = result2.message;
                if (message == null) {
                    message = "Already running";
                }
                System.out.println(message);
                System.exit(result2.exitCode);
            }
            case CANNOT_ACTIVATE: {
                String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
                Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
                System.exit(6);
            }
        }
    }

    @NotNull
    private static Logger setupLogger() {
        Logger.setFactory(new LoggerFactory());
        Logger log = Logger.getInstance(Main.class);
        log.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ShutDownTracker.getInstance().registerShutdownTask(() -> log.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------"));
        if (SystemProperties.getBooleanProperty("intellij.log.stdout", true)) {
            System.setOut(new PrintStreamLogger("STDOUT", System.out));
            System.setErr(new PrintStreamLogger("STDERR", System.err));
        }
        Logger logger = log;
        if (logger == null) {
            StartupUtil.$$$reportNull$$$0(13);
        }
        return logger;
    }

    private static void scheduleProcessEnvironmentFixing() {
        Activity subActivity = StartUpMeasurer.startActivity("process env fixing");
        EnvironmentUtil.loadEnv(true).thenRun(subActivity::end);
    }

    private static void setupSystemLibraries() {
        Activity subActivity = StartUpMeasurer.startActivity("system libs setup");
        String ideTempPath = PathManager.getTempPath();
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempPath);
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        if (SystemInfoRt.isWindows && System.getProperty("winp.folder.preferred") == null) {
            System.setProperty("winp.folder.preferred", ideTempPath);
        }
        if (System.getProperty("pty4j.tmpdir") == null) {
            System.setProperty("pty4j.tmpdir", ideTempPath);
        }
        if (System.getProperty("pty4j.preferred.native.folder") == null) {
            System.setProperty("pty4j.preferred.native.folder", Paths.get(PathManager.getLibPath(), "pty4j-native").toAbsolutePath().toString());
        }
        subActivity.end();
    }

    private static void loadSystemLibraries(Logger log) {
        Activity activity = StartUpMeasurer.startActivity("system libs loading");
        JnaLoader.load(log);
        IdeaWin32.isAvailable();
        activity.end();
    }

    private static void logEssentialInfoAboutIde(@NotNull Logger log, @NotNull ApplicationInfo appInfo) {
        String extDirs;
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(14);
        }
        if (appInfo == null) {
            StartupUtil.$$$reportNull$$$0(15);
        }
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.US).format(appInfo.getBuildDate().getTime());
        log.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ", " + buildDate + ")");
        log.info("OS: " + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log.info("JVM Args: " + String.join((CharSequence)" ", arguments));
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            for (String dir : extDirs.split(File.pathSeparator)) {
                Object[] content2 = new File(dir).list();
                if (content2 == null || content2.length <= 0) continue;
                log.info("ext: " + dir + ": " + Arrays.toString(content2));
            }
        }
        log.info("Locale=" + Locale.getDefault() + " JNU=" + System.getProperty("sun.jnu.encoding") + " file.encoding=" + System.getProperty("file.encoding"));
    }

    private static void runStartupWizard(@NotNull AppStarter appStarter) {
        CustomizeIDEWizardStepsProvider provider;
        String stepsProviderName;
        if (appStarter == null) {
            StartupUtil.$$$reportNull$$$0(16);
        }
        if ((stepsProviderName = ApplicationInfoImpl.getShadowInstance().getCustomizeIDEWizardStepsProvider()) == null) {
            return;
        }
        try {
            Class<?> providerClass = Class.forName(stepsProviderName);
            provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
        }
        catch (Throwable e) {
            Main.showMessage((String)"Configuration Wizard Failed", (Throwable)e);
            return;
        }
        appStarter.beforeStartupWizard();
        new CustomizeIDEWizardDialog(provider, appStarter, true, false).showIfNeeded();
        PluginManagerCore.invalidatePlugins();
        appStarter.startupWizardFinished(provider);
    }

    public static boolean patchSystem(@NotNull Logger log) {
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(17);
        }
        if (!ourSystemPatched.compareAndSet(false, true)) {
            return false;
        }
        Activity activity = StartUpMeasurer.startActivity("event queue replacing");
        StartupUtil.replaceSystemEventQueue(log);
        if (!Main.isHeadless()) {
            StartupUtil.patchSystemForUi(log);
        }
        activity.end();
        return true;
    }

    @ApiStatus.Internal
    public static void replaceSystemEventQueue(@NotNull Logger log) {
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(18);
        }
        log.info("CPU cores: " + Runtime.getRuntime().availableProcessors() + "; ForkJoinPool.commonPool: " + ForkJoinPool.commonPool() + "; factory: " + ForkJoinPool.commonPool().getFactory());
        IdeEventQueue.getInstance();
    }

    private static void patchSystemForUi(@NotNull Logger log) {
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(19);
        }
        if (Patches.REPAINT_MANAGER_LEAK) {
            RepaintManager.setCurrentManager(new IdeRepaintManager());
        } else if ("true".equals(System.getProperty("idea.check.swing.threading"))) {
            RepaintManager.setCurrentManager(new AssertiveRepaintManager());
        }
        if (SystemInfo.isXWindow) {
            String wmName = X11UiUtil.getWmName();
            log.info("WM detected: " + wmName);
            if (wmName != null) {
                X11UiUtil.patchDetectedWm(wmName);
            }
        }
        IconManager.activate();
    }

    private static boolean showUserAgreementAndConsentsIfNeeded(@NotNull Logger log, @NotNull CompletableFuture<?> initUiTask, @NotNull Future<Object> euaDocument) throws ExecutionException, InterruptedException {
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(20);
        }
        if (initUiTask == null) {
            StartupUtil.$$$reportNull$$$0(21);
        }
        if (euaDocument == null) {
            StartupUtil.$$$reportNull$$$0(22);
        }
        boolean dialogWasShown = false;
        EndUserAgreement.updateCachedContentToLatestBundledVersion();
        EndUserAgreement.Document agreement = (EndUserAgreement.Document)euaDocument.get();
        if (!agreement.isAccepted()) {
            StartupUtil.runInEdtAndWait(log, () -> Agreements.INSTANCE.showEndUserAndDataSharingAgreements(agreement), initUiTask);
            dialogWasShown = true;
        }
        if (((Boolean)ConsentOptions.getInstance().getConsents().second).booleanValue()) {
            StartupUtil.runInEdtAndWait(log, Agreements.INSTANCE::showDataSharingAgreement, initUiTask);
        }
        return dialogWasShown;
    }

    private static void runInEdtAndWait(@NotNull Logger log, @NotNull Runnable runnable2, @NotNull CompletableFuture<?> initUiTask) {
        if (log == null) {
            StartupUtil.$$$reportNull$$$0(23);
        }
        if (runnable2 == null) {
            StartupUtil.$$$reportNull$$$0(24);
        }
        if (initUiTask == null) {
            StartupUtil.$$$reportNull$$$0(25);
        }
        try {
            initUiTask.join();
            if (!ourSystemPatched.get()) {
                EventQueue.invokeAndWait(() -> {
                    if (!StartupUtil.patchSystem(log)) {
                        return;
                    }
                    try {
                        UIManager.setLookAndFeel(IntelliJLaf.class.getName());
                        IconManager.activate();
                        IconLoader.activate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            EventQueue.invokeAndWait(runnable2);
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.warn(e);
        }
    }

    static {
        ourSystemPatched = new AtomicBoolean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/StartupUtil";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainStartFuture";
                break;
            }
            case 6: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initUiTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appStarterFuture";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appStarter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "euaDocument";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerFuture";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/StartupUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppStarter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleInitUi";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setupLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runPreAppClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareApp";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAppStarter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startApp";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scheduleInitUi";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logEssentialInfoAboutIde";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runStartupWizard";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "patchSystem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceSystemEventQueue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "patchSystemForUi";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showUserAgreementAndConsentsIfNeeded";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "runInEdtAndWait";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AppStarter {
        public void start(@NotNull List<String> var1, @NotNull CompletionStage<?> var2);

        default public void beforeImportConfigs() {
        }

        default public void beforeStartupWizard() {
        }

        default public void startupWizardFinished(@NotNull CustomizeIDEWizardStepsProvider provider) {
            if (provider == null) {
                AppStarter.$$$reportNull$$$0(0);
            }
        }

        default public void importFinished(@NotNull Path newConfigDir) {
            if (newConfigDir == null) {
                AppStarter.$$$reportNull$$$0(1);
            }
        }

        default public int customizeIdeWizardDialog(@NotNull List<AbstractCustomizeWizardStep> steps) {
            if (steps == null) {
                AppStarter.$$$reportNull$$$0(2);
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newConfigDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "steps";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/StartupUtil$AppStarter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startupWizardFinished";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importFinished";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeIdeWizardDialog";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

