/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.functions.Function0;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AddInlayInternalAction
extends AnAction
implements DumbAware {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            AddInlayInternalAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        EditorImpl editor = ObjectUtils.tryCast(e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        if (editor == null) {
            return;
        }
        List<Caret> carets = editor.getCaretModel().getAllCarets();
        if (carets.isEmpty()) {
            return;
        }
        String inlayText = Messages.showInputDialog("Inlay text:", carets.size() > 1 ? "Add Inlays" : "Add Inlay", Messages.getInformationIcon());
        if (inlayText == null) {
            return;
        }
        int[] offsets2 = StreamEx.of(carets).mapToInt(Caret::getOffset).toArray();
        InlayModelImpl model = editor.getInlayModel();
        for (int offset : offsets2) {
            final AtomicReference<Inlay<PresentationRenderer>> ref = new AtomicReference<Inlay<PresentationRenderer>>();
            MenuOnClickPresentation presentation = new MenuOnClickPresentation(new PresentationFactory(editor).text(inlayText), project2, (Function0<? extends List<? extends AnAction>>)((Function0)() -> Collections.singletonList(new AnAction(InternalActionsBundle.messagePointer("action.AddInlayInternalAction.Anonymous.text.remove", new Object[0]), InternalActionsBundle.messagePointer("action.AddInlayInternalAction.Anonymous.description.remove.this.inlay", new Object[0]), AllIcons.Actions.Cancel){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e1) {
                    Inlay inlay;
                    if (e1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((inlay = (Inlay)ref.get()) != null) {
                        Disposer.dispose(inlay);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/internal/AddInlayInternalAction$1", "actionPerformed"));
                }
            })));
            Inlay<PresentationRenderer> inlay = model.addInlineElement(offset, new PresentationRenderer(presentation));
            ref.set(inlay);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddInlayInternalAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        EditorImpl editor = ObjectUtils.tryCast(e.getData(CommonDataKeys.EDITOR), EditorImpl.class);
        presentation.setEnabled(project2 != null && editor != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/AddInlayInternalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

