/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComputeVirtualFileNameStatAction
extends AnAction
implements DumbAware {
    TObjectIntHashMap<String> suffixes = new TObjectIntHashMap();
    TObjectIntHashMap<String> nameCount = new TObjectIntHashMap();

    public ComputeVirtualFileNameStatAction() {
        super(ActionsBundle.messagePointer("action.ComputeVirtualFileNameStatAction.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] roots;
        if (e == null) {
            ComputeVirtualFileNameStatAction.$$$reportNull$$$0(0);
        }
        long start2 = System.currentTimeMillis();
        this.suffixes.clear();
        this.nameCount.clear();
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots(LocalFileSystem.getInstance())) {
            this.compute(root);
        }
        final ArrayList names2 = new ArrayList(this.nameCount.size());
        this.nameCount.forEachEntry(new TObjectIntProcedure<String>(){

            @Override
            public boolean execute(String name, int count) {
                names2.add(Pair.create(name, count));
                return true;
            }
        });
        Collections.sort(names2, (o1, o2) -> (Integer)o2.second - (Integer)o1.second);
        System.out.println("Most frequent names (" + names2.size() + " total):");
        int saveByIntern = 0;
        for (Pair pair : names2) {
            int count = (Integer)pair.second;
            String name = (String)pair.first;
            System.out.println(name + " -> " + count);
            saveByIntern += count * name.length();
            if (count != 1) continue;
            break;
        }
        System.out.println("Total save if names were interned: " + saveByIntern + "; ------------");
        System.out.println("Suffix counts:(" + this.suffixes.size() + " total)");
        ComputeVirtualFileNameStatAction.show(this.suffixes);
        final TObjectIntHashMap<String> save = new TObjectIntHashMap<String>();
        this.suffixes.forEachEntry(new TObjectIntProcedure<String>(){

            @Override
            public boolean execute(String s, int count) {
                save.put(s, count * s.length());
                return true;
            }
        });
        System.out.println("Supposed save by stripping suffixes: (" + save.size() + " total)");
        final List<Pair<String, Integer>> saveSorted = ComputeVirtualFileNameStatAction.show(save);
        final ArrayList<String> picked = new ArrayList<String>();
        while (picked.size() != 15) {
            Pair<String, Integer> cp = saveSorted.get(0);
            String candidate = (String)cp.first;
            picked.add(candidate);
            System.out.println("Candidate: '" + candidate + "', save = " + cp.second);
            Collections.sort(picked, (o1, o2) -> o2.length() - o1.length());
            saveSorted.clear();
            this.suffixes.forEachEntry(new TObjectIntProcedure<String>(){

                @Override
                public boolean execute(String s, int count) {
                    for (int i = picked.size() - 1; i >= 0; --i) {
                        String pick = (String)picked.get(i);
                        if (!pick.endsWith(s)) continue;
                        count -= ComputeVirtualFileNameStatAction.this.suffixes.get(pick);
                        break;
                    }
                    saveSorted.add(Pair.create(s, s.length() * count));
                    return true;
                }
            });
            Collections.sort(saveSorted, (o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        }
        System.out.println("Picked: " + StringUtil.join(picked, s -> "\"" + s + "\"", ","));
        Collections.sort(picked, (o1, o2) -> o2.length() - o1.length());
        int saved = 0;
        for (int i = 0; i < picked.size(); ++i) {
            String s2 = (String)picked.get(i);
            int count = this.suffixes.get(s2);
            for (int k = 0; k < i; ++k) {
                String prev = (String)picked.get(k);
                if (!prev.endsWith(s2)) continue;
                count -= this.suffixes.get(prev);
                break;
            }
            saved += count * s2.length();
        }
        System.out.println("total saved = " + saved);
        System.out.println("Time spent: " + (System.currentTimeMillis() - start2));
    }

    private static List<Pair<String, Integer>> show(TObjectIntHashMap<String> prefixes) {
        final ArrayList<Pair<String, Integer>> prefs = new ArrayList<Pair<String, Integer>>(prefixes.size());
        prefixes.forEachEntry(new TObjectIntProcedure<String>(){

            @Override
            public boolean execute(String s, int count) {
                prefs.add(Pair.create(s, count));
                return true;
            }
        });
        Collections.sort(prefs, (o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        int i = 0;
        for (Pair pair : prefs) {
            Integer count = (Integer)pair.second;
            System.out.printf("%60.60s : %d\n", pair.first, count);
            if (i++ <= 100) continue;
            System.out.println("\n.......<" + count + "...\n");
            break;
        }
        return prefs;
    }

    private void compute(VirtualFile root) {
        String name = root.getName();
        if (!this.nameCount.increment(name)) {
            this.nameCount.put(name, 1);
        }
        for (int i = 1; i <= name.length(); ++i) {
            String suffix = name.substring(name.length() - i);
            if (this.suffixes.increment(suffix)) continue;
            this.suffixes.put(suffix, 1);
        }
        Collection<VirtualFile> cachedChildren = ((VirtualFileSystemEntry)root).getCachedChildren();
        for (VirtualFile cachedChild : cachedChildren) {
            this.compute(cachedChild);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ComputeVirtualFileNameStatAction", "actionPerformed"));
    }
}

