/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class DumpDirectoryInfoAction
extends AnAction {
    public static final Logger LOG = Logger.getInstance(DumpDirectoryInfoAction.class);

    public DumpDirectoryInfoAction() {
        super(ActionsBundle.messagePointer("action.DumpDirectoryInfoAction.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpDirectoryInfoAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getData(CommonDataKeys.PROJECT);
        DirectoryIndex index = DirectoryIndex.getInstance(project2);
        if (project2 != null) {
            VirtualFile root = e.getData(CommonDataKeys.VIRTUAL_FILE);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ContentIterator contentIterator = fileOrDir -> {
                    LOG.info(fileOrDir.getPath());
                    LOG.info(index.getInfoForFile(fileOrDir).toString());
                    return true;
                };
                if (root != null) {
                    ProjectRootManager.getInstance(project2).getFileIndex().iterateContentUnderDirectory(root, contentIterator);
                } else {
                    ProjectRootManager.getInstance(project2).getFileIndex().iterateContent(contentIterator);
                }
            }, "Dumping directory index", true, project2);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpDirectoryInfoAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/DumpDirectoryInfoAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

