/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ResourceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class DumpInspectionDescriptionsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpInspectionDescriptionsAction.class);

    public DumpInspectionDescriptionsAction() {
        super(ActionsBundle.messagePointer("action.DumpInspectionDescriptionsAction.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        File groupsFile;
        boolean groupsOk;
        if (event == null) {
            DumpInspectionDescriptionsAction.$$$reportNull$$$0(0);
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance().getCurrentProfile();
        InspectionToolWrapper[] tools = profile.getInspectionTools(null);
        final TreeSet<String> classes = new TreeSet<String>();
        final TreeMap<String, TreeSet<String>> groups = new TreeMap<String, TreeSet<String>>();
        String tempDirectory = FileUtil.getTempDirectory();
        File descDirectory = new File(tempDirectory, "inspections");
        if (!descDirectory.mkdirs() && !descDirectory.isDirectory()) {
            LOG.error("Unable to create directory: " + descDirectory.getAbsolutePath());
            return;
        }
        for (InspectionToolWrapper toolWrapper : tools) {
            classes.add(DumpInspectionDescriptionsAction.getInspectionClass(toolWrapper).getName());
            String group = DumpInspectionDescriptionsAction.getGroupName(toolWrapper);
            TreeSet<String> names2 = (TreeSet<String>)groups.get(group);
            if (names2 == null) {
                names2 = new TreeSet<String>();
                groups.put(group, names2);
            }
            names2.add(toolWrapper.getShortName());
            final InputStream stream = DumpInspectionDescriptionsAction.getDescriptionStream(toolWrapper);
            if (stream == null) continue;
            DumpInspectionDescriptionsAction.doDump(new File(descDirectory, toolWrapper.getShortName() + ".html"), new Processor(){

                @Override
                public void process(BufferedWriter writer) throws Exception {
                    writer.write(ResourceUtil.loadText(stream));
                }
            });
        }
        DumpInspectionDescriptionsAction.doNotify("Inspection descriptions dumped to\n" + descDirectory.getAbsolutePath());
        File fqnListFile = new File(tempDirectory, "inspection_fqn_list.txt");
        boolean fqnOk = DumpInspectionDescriptionsAction.doDump(fqnListFile, new Processor(){

            @Override
            public void process(BufferedWriter writer) throws Exception {
                for (String name : classes) {
                    writer.write(name);
                    writer.newLine();
                }
            }
        });
        if (fqnOk) {
            DumpInspectionDescriptionsAction.doNotify("Inspection class names dumped to\n" + fqnListFile.getAbsolutePath());
        }
        if (groupsOk = DumpInspectionDescriptionsAction.doDump(groupsFile = new File(tempDirectory, "inspection_groups.txt"), new Processor(){

            @Override
            public void process(BufferedWriter writer) throws Exception {
                for (Map.Entry entry : groups.entrySet()) {
                    writer.write((String)entry.getKey());
                    writer.write(58);
                    writer.newLine();
                    for (String name : (Collection)entry.getValue()) {
                        writer.write("  ");
                        writer.write(name);
                        writer.newLine();
                    }
                }
            }
        })) {
            DumpInspectionDescriptionsAction.doNotify("Inspection groups dumped to\n" + fqnListFile.getAbsolutePath());
        }
    }

    private static Class getInspectionClass(InspectionToolWrapper toolWrapper) {
        return toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getClass() : toolWrapper.getClass();
    }

    private static String getGroupName(InspectionToolWrapper toolWrapper) {
        String name = toolWrapper.getGroupDisplayName();
        return StringUtil.isEmptyOrSpaces(name) ? "General" : name;
    }

    private static InputStream getDescriptionStream(InspectionToolWrapper toolWrapper) {
        Class aClass = DumpInspectionDescriptionsAction.getInspectionClass(toolWrapper);
        return ResourceUtil.getResourceAsStream(aClass, "/inspectionDescriptions", toolWrapper.getShortName() + ".html");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doDump(File file2, Processor processor2) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file2));){
            processor2.process(writer);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error(e);
            return false;
        }
    }

    private static void doNotify(String message) {
        Notifications.Bus.notify(new Notification("Actions", "Inspection descriptions dumped", message, NotificationType.INFORMATION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/DumpInspectionDescriptionsAction", "actionPerformed"));
    }

    private static interface Processor {
        public void process(BufferedWriter var1) throws Exception;
    }
}

